/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.name;

import cn.fudan.analysis.util.DexHelper;
import cn.fudan.common.CodeContainer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;

public class NameCollector
implements Serializable {
    static final long serialVersionUID = 197792367844872410L;
    private CodeContainer containter;
    private String containerHash;
    private String containerPath;
    private Set<String> classNames = new HashSet<String>();
    private Map<String, List<String>> classMethodNames = new HashMap<String, List<String>>();
    private Map<String, List<String>> classFieldNames = new HashMap<String, List<String>>();

    public NameCollector() {
    }

    public NameCollector(CodeContainer container) {
        this.containter = container;
        this.containerHash = container.codeHash();
        this.containerPath = container.codePath();
        this.init();
    }

    public String getContainerHash() {
        return this.containerHash;
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.containerHash);
        out.writeObject(this.containerPath);
        out.writeObject(this.classNames);
        out.writeObject(this.classMethodNames);
        out.writeObject(this.classFieldNames);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.containter = null;
        this.containerHash = (String)in.readObject();
        this.containerPath = (String)in.readObject();
        this.classNames = (Set)in.readObject();
        this.classMethodNames = (Map)in.readObject();
        this.classFieldNames = (Map)in.readObject();
    }

    private void init() {
        Set<? extends ClassDef> clazzes = this.containter.getClasses();
        for (ClassDef classDef : clazzes) {
            String className = DexHelper.classType2Name(classDef.getType());
            this.classNames.add(className);
            ArrayList<String> methodNames = new ArrayList<String>();
            for (Method method : classDef.getMethods()) {
                if (DexHelper.isCompilerGeneratedMethod(method)) continue;
                String string = method.getName();
                methodNames.add(string);
            }
            this.classMethodNames.put(className, methodNames);
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Field field : classDef.getFields()) {
                String fieldName = field.getName();
                fieldNames.add(fieldName);
            }
            this.classFieldNames.put(className, fieldNames);
        }
    }

    public Set<String> allPackageNames() {
        HashSet<String> pkgNames = new HashSet<String>();
        for (String clzName : this.classNames) {
            pkgNames.add(DexHelper.getPackageName(clzName));
        }
        return pkgNames;
    }

    public Set<String> allClassNames() {
        return this.classNames;
    }

    public Set<String> allFieldNames() {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String className : this.classFieldNames.keySet()) {
            List<String> names = this.classFieldNames.get(className);
            fieldNames.addAll(names);
        }
        return fieldNames;
    }

    public Set<String> allMethodNames() {
        HashSet<String> methodNames = new HashSet<String>();
        for (String className : this.classMethodNames.keySet()) {
            List<String> names = this.classMethodNames.get(className);
            methodNames.addAll(names);
        }
        return methodNames;
    }

    public Set<String> allClassNamesOfPackage(String pkgName) {
        if (pkgName == null) {
            pkgName = ".";
        }
        HashSet<String> hitClassName = new HashSet<String>();
        for (String clzName : this.classNames) {
            if (!pkgName.equals(DexHelper.getPackageName(clzName))) continue;
            hitClassName.add(clzName);
        }
        return hitClassName;
    }

    public List<String> allFieldNamesOfClass(String clzName) {
        return this.classFieldNames.get(clzName);
    }

    public List<String> allMethodNamesOfClass(String clzName) {
        return this.classMethodNames.get(clzName);
    }

    public void printPackages(OutputStream os) {
        PrintStream out = null;
        out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        Set<String> pkgs = this.allPackageNames();
        for (String pkg : pkgs) {
            out.println("[pkg] " + pkg);
        }
    }

    public void printClasses(OutputStream os) {
        PrintStream out = null;
        out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        Set<String> classes = this.allClassNames();
        for (String clz : classes) {
            out.println("[clz] " + clz);
        }
    }

    public void printMethods(OutputStream os) {
        PrintStream out = null;
        out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        Set<String> methods = this.allMethodNames();
        for (String m : methods) {
            out.println("[method] " + m);
        }
    }

    public void printFields(OutputStream os) {
        PrintStream out = null;
        out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        Set<String> fields = this.allFieldNames();
        for (String f : fields) {
            out.println("[field] " + f);
        }
    }
}

