/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.dep;

import cn.fudan.analysis.dep.ConcreteDepNode;
import cn.fudan.analysis.dep.DepEdge;
import cn.fudan.analysis.dep.DepNode;
import cn.fudan.analysis.profile.ClassNameProfile;
import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.profile.FieldProfile;
import cn.fudan.analysis.profile.MethodProfile;
import cn.fudan.analysis.profile.ProfileGenerator;
import cn.fudan.common.CodeContainer;
import cn.fudan.common.Sdk;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DepAnalysis {
    private CodeContainer codeContainer;
    public Set<ClassProfile> allClassProfiles;
    private Set<DepNode> depGraph;
    private Set<String> systemClassSet;
    public HashMap<String, ConcreteDepNode> ownNodeMap;
    public HashMap<String, DepNode> systemNodeMap;
    public HashMap<String, DepNode> lostOtherPackageNodeMap;
    public HashMap<String, DepNode> allNodeMap;

    public DepAnalysis(CodeContainer codeContainer, Set<String> systemClassSet) {
        this.codeContainer = codeContainer;
        this.systemClassSet = systemClassSet;
        this.allClassProfiles = ProfileGenerator.generate(codeContainer, systemClassSet);
        this.depGraph = new HashSet<DepNode>();
        this.ownNodeMap = new HashMap();
        for (ClassProfile cp : this.allClassProfiles) {
            ConcreteDepNode node = new ConcreteDepNode(cp);
            this.depGraph.add(node);
            this.ownNodeMap.put(cp.getClassName(), node);
        }
        this.systemNodeMap = new HashMap();
        this.lostOtherPackageNodeMap = new HashMap();
        this.allNodeMap = new HashMap();
        this.beginDepAnalysis();
        this.depGraph.addAll(this.systemNodeMap.values());
        this.allNodeMap.putAll(this.ownNodeMap);
        this.allNodeMap.putAll(this.systemNodeMap);
        this.allNodeMap.putAll(this.lostOtherPackageNodeMap);
    }

    public DepAnalysis(CodeContainer codeContainer) {
        this.codeContainer = codeContainer;
        this.systemClassSet = new HashSet<String>();
        this.systemClassSet.addAll(Sdk.loadDefaultSdk().getTargetSdkClassNameSet());
        this.allClassProfiles = ProfileGenerator.generate(codeContainer, this.systemClassSet);
        this.depGraph = new HashSet<DepNode>();
        this.ownNodeMap = new HashMap();
        for (ClassProfile cp : this.allClassProfiles) {
            ConcreteDepNode node = new ConcreteDepNode(cp);
            this.depGraph.add(node);
            this.ownNodeMap.put(cp.getClassName(), node);
        }
        this.lostOtherPackageNodeMap = new HashMap();
        this.systemNodeMap = new HashMap();
        this.beginDepAnalysis();
        this.depGraph.addAll(this.systemNodeMap.values());
    }

    public Set<String> getSystemClassSet() {
        return this.systemClassSet;
    }

    public ClassProfile getClassProfile(String className) {
        if (this.ownNodeMap.containsKey(className)) {
            return this.ownNodeMap.get((Object)className).classProfile;
        }
        return null;
    }

    public HashSet<String> getAllDependingClassName(String classname) {
        HashSet<String> set = new HashSet<String>();
        if (this.ownNodeMap.containsKey(classname)) {
            ConcreteDepNode node = this.ownNodeMap.get(classname);
            for (DepEdge de : node.edges) {
                set.add(de.getSink().classname);
            }
            return set;
        }
        return null;
    }

    public HashSet<ClassProfile> getAllDependingClassProfile(String classname) {
        HashSet<ClassProfile> set = new HashSet<ClassProfile>();
        if (this.ownNodeMap.containsKey(classname)) {
            ConcreteDepNode node = this.ownNodeMap.get(classname);
            for (DepEdge de : node.edges) {
                if (!(de.getSink() instanceof ConcreteDepNode)) continue;
                set.add(((ConcreteDepNode)de.getSink()).classProfile);
            }
            return set;
        }
        return null;
    }

    public HashSet<String> getAllDependedClassName(String classname) {
        HashSet<String> set = new HashSet<String>();
        if (this.ownNodeMap.containsKey(classname)) {
            ConcreteDepNode node = this.ownNodeMap.get(classname);
            for (DepEdge de : node.sinkedges) {
                set.add(de.getSource().classname);
            }
            return set;
        }
        return null;
    }

    public HashSet<ClassProfile> getAllDependedClassProfile(String classname) {
        HashSet<ClassProfile> set = new HashSet<ClassProfile>();
        if (this.ownNodeMap.containsKey(classname)) {
            ConcreteDepNode node = this.ownNodeMap.get(classname);
            for (DepEdge de : node.sinkedges) {
                if (!(de.getSource() instanceof ConcreteDepNode)) continue;
                set.add(((ConcreteDepNode)de.getSource()).classProfile);
            }
            return set;
        }
        return null;
    }

    private void beginDepAnalysis() {
        for (ConcreteDepNode dn : this.ownNodeMap.values()) {
            Object de;
            if (dn.classProfile.superClassProfile.type == ClassNameProfile.ClassType.SYS_LIB_CLASS) {
                DepNode sysdn;
                if (this.systemNodeMap.containsKey(dn.classProfile.superClassProfile.name)) {
                    sysdn = this.systemNodeMap.get(dn.classProfile.superClassProfile.name);
                } else {
                    sysdn = new DepNode(dn.classProfile.superClassProfile.name);
                    this.systemNodeMap.put(dn.classProfile.superClassProfile.name, sysdn);
                }
                DepEdge de2 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_EXTENDS, dn, sysdn);
                dn.addDepEdge(de2);
                dn.addTypecount(0, 0);
                de2.setClassType(ClassNameProfile.ClassType.SYS_LIB_CLASS);
                sysdn.addSinkEdge(de2);
            } else if (dn.classProfile.superClassProfile.type == ClassNameProfile.ClassType.SAME_PKG_CLASS) {
                de = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_EXTENDS, dn, this.ownNodeMap.get(dn.classProfile.superClassProfile.name));
                dn.addDepEdge((DepEdge)de);
                dn.addTypecount(0, 1);
                ((DepEdge)de).setClassType(ClassNameProfile.ClassType.SAME_PKG_CLASS);
                if (this.ownNodeMap.containsKey(dn.classProfile.superClassProfile.name)) {
                    this.ownNodeMap.get(dn.classProfile.superClassProfile.name).addSinkEdge((DepEdge)de);
                }
            } else if (dn.classProfile.superClassProfile.type == ClassNameProfile.ClassType.OTHER_PKG_CLASS) {
                if (this.ownNodeMap.containsKey(dn.classProfile.superClassProfile.name)) {
                    de = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_EXTENDS, dn, this.ownNodeMap.get(dn.classProfile.superClassProfile.name));
                    this.ownNodeMap.get(dn.classProfile.superClassProfile.name).addSinkEdge((DepEdge)de);
                } else {
                    DepNode node;
                    if (this.lostOtherPackageNodeMap.containsKey(dn.classProfile.superClassProfile.name)) {
                        node = this.lostOtherPackageNodeMap.get(dn.classProfile.superClassProfile.name);
                    } else {
                        node = new DepNode(dn.classProfile.superClassProfile.name);
                        this.lostOtherPackageNodeMap.put(dn.classProfile.superClassProfile.name, node);
                    }
                    de = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_EXTENDS, dn, node);
                    node.addSinkEdge((DepEdge)de);
                }
                dn.addDepEdge((DepEdge)de);
                dn.addTypecount(0, 2);
                ((DepEdge)de).setClassType(ClassNameProfile.ClassType.OTHER_PKG_CLASS);
            }
            for (ClassNameProfile cnp : dn.classProfile.interfaceProfileSet) {
                Object de3;
                if (cnp.type == ClassNameProfile.ClassType.SYS_LIB_CLASS) {
                    DepNode sysdn;
                    if (this.systemNodeMap.containsKey(cnp.name)) {
                        sysdn = this.systemNodeMap.get(cnp.name);
                    } else {
                        sysdn = new DepNode(cnp.name);
                        this.systemNodeMap.put(cnp.name, sysdn);
                    }
                    DepEdge de4 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_IMPLEMENTS, dn, sysdn);
                    dn.addDepEdge(de4);
                    dn.addTypecount(1, 0);
                    de4.setClassType(ClassNameProfile.ClassType.SYS_LIB_CLASS);
                    sysdn.addSinkEdge(de4);
                    continue;
                }
                if (cnp.type == ClassNameProfile.ClassType.SAME_PKG_CLASS) {
                    de3 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_IMPLEMENTS, dn, this.ownNodeMap.get(cnp.name));
                    dn.addDepEdge((DepEdge)de3);
                    dn.addTypecount(1, 1);
                    ((DepEdge)de3).setClassType(ClassNameProfile.ClassType.SAME_PKG_CLASS);
                    if (!this.ownNodeMap.containsKey(cnp.name)) continue;
                    this.ownNodeMap.get(cnp.name).addSinkEdge((DepEdge)de3);
                    continue;
                }
                if (cnp.type != ClassNameProfile.ClassType.OTHER_PKG_CLASS) continue;
                if (this.ownNodeMap.containsKey(cnp.name)) {
                    de3 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_IMPLEMENTS, dn, this.ownNodeMap.get(cnp.name));
                    this.ownNodeMap.get(cnp.name).addSinkEdge((DepEdge)de3);
                } else {
                    DepNode node;
                    if (this.lostOtherPackageNodeMap.containsKey(cnp.name)) {
                        node = this.lostOtherPackageNodeMap.get(cnp.name);
                    } else {
                        node = new DepNode(cnp.name);
                        this.lostOtherPackageNodeMap.put(cnp.name, node);
                    }
                    de3 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_IMPLEMENTS, dn, node);
                    node.addSinkEdge((DepEdge)de3);
                }
                dn.addDepEdge((DepEdge)de3);
                dn.addTypecount(1, 2);
                ((DepEdge)de3).setClassType(ClassNameProfile.ClassType.OTHER_PKG_CLASS);
            }
            HashMap<String, DepEdge> existFieldMap = new HashMap<String, DepEdge>();
            HashSet<FieldProfile> fieldProfileSet = new HashSet<FieldProfile>();
            fieldProfileSet.addAll(dn.classProfile.instanceFieldProfiles);
            fieldProfileSet.addAll(dn.classProfile.staticFieldProfiles);
            for (FieldProfile fp : fieldProfileSet) {
                DepEdge de5;
                if (existFieldMap.containsKey(fp.typeProfile.name)) {
                    ((DepEdge)existFieldMap.get(fp.typeProfile.name)).addWeight();
                    continue;
                }
                if (fp.typeProfile.type == ClassNameProfile.ClassType.SYS_LIB_CLASS) {
                    DepNode sysdn;
                    if (this.systemNodeMap.containsKey(fp.typeProfile.name)) {
                        sysdn = this.systemNodeMap.get(fp.typeProfile.name);
                    } else {
                        sysdn = new DepNode(fp.typeProfile.name);
                        this.systemNodeMap.put(fp.typeProfile.name, sysdn);
                    }
                    DepEdge de6 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_FIELD_IN, dn, sysdn);
                    dn.addDepEdge(de6);
                    dn.addTypecount(2, 0);
                    de6.setClassType(ClassNameProfile.ClassType.SYS_LIB_CLASS);
                    sysdn.addSinkEdge(de6);
                    existFieldMap.put(fp.typeProfile.name, de6);
                    continue;
                }
                if (fp.typeProfile.type == ClassNameProfile.ClassType.SAME_PKG_CLASS) {
                    de5 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_FIELD_IN, dn, this.ownNodeMap.get(fp.typeProfile.name));
                    dn.addDepEdge(de5);
                    dn.addTypecount(2, 1);
                    de5.setClassType(ClassNameProfile.ClassType.SAME_PKG_CLASS);
                    if (this.ownNodeMap.containsKey(fp.typeProfile.name)) {
                        this.ownNodeMap.get(fp.typeProfile.name).addSinkEdge(de5);
                    }
                    existFieldMap.put(fp.typeProfile.name, de5);
                    continue;
                }
                if (fp.typeProfile.type != ClassNameProfile.ClassType.OTHER_PKG_CLASS) continue;
                if (this.ownNodeMap.containsKey(fp.typeProfile.name)) {
                    de5 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_FIELD_IN, dn, this.ownNodeMap.get(fp.typeProfile.name));
                    this.ownNodeMap.get(fp.typeProfile.name).addSinkEdge(de5);
                } else {
                    DepNode node;
                    if (this.lostOtherPackageNodeMap.containsKey(fp.typeProfile.name)) {
                        node = this.lostOtherPackageNodeMap.get(fp.typeProfile.name);
                    } else {
                        node = new DepNode(fp.typeProfile.name);
                        this.lostOtherPackageNodeMap.put(fp.typeProfile.name, node);
                    }
                    de5 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_FIELD_IN, dn, node);
                    node.addSinkEdge(de5);
                }
                dn.addDepEdge(de5);
                dn.addTypecount(2, 2);
                de5.setClassType(ClassNameProfile.ClassType.OTHER_PKG_CLASS);
                existFieldMap.put(fp.typeProfile.name, de5);
            }
            HashMap<String, DepEdge> existParameterMap = new HashMap<String, DepEdge>();
            HashMap<String, DepEdge> existReturnMap = new HashMap<String, DepEdge>();
            HashMap<String, DepEdge> existExceptionMap = new HashMap<String, DepEdge>();
            HashSet<MethodProfile> allMethodProfile = new HashSet<MethodProfile>();
            allMethodProfile.addAll(dn.classProfile.staticMethodProfiles);
            allMethodProfile.addAll(dn.classProfile.instanceMethodProfiles);
            for (MethodProfile mp : allMethodProfile) {
                DepEdge de7;
                DepNode node;
                DepEdge de8;
                DepEdge de9;
                DepNode sysdn;
                for (ClassNameProfile cnp : mp.parameterTypeProfileList) {
                    if (existParameterMap.containsKey(cnp.name)) {
                        ((DepEdge)existParameterMap.get(cnp.name)).addWeight();
                        continue;
                    }
                    if (cnp.type == ClassNameProfile.ClassType.SYS_LIB_CLASS) {
                        if (this.systemNodeMap.containsKey(cnp.name)) {
                            sysdn = this.systemNodeMap.get(cnp.name);
                        } else {
                            sysdn = new DepNode(cnp.name);
                            this.systemNodeMap.put(cnp.name, sysdn);
                        }
                        de9 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_PARAMETER, dn, sysdn);
                        dn.addDepEdge(de9);
                        dn.addTypecount(3, 0);
                        de9.setClassType(ClassNameProfile.ClassType.SYS_LIB_CLASS);
                        sysdn.addSinkEdge(de9);
                        existParameterMap.put(cnp.name, de9);
                        continue;
                    }
                    if (cnp.type == ClassNameProfile.ClassType.SAME_PKG_CLASS) {
                        de8 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_PARAMETER, dn, this.ownNodeMap.get(cnp.name));
                        dn.addDepEdge(de8);
                        dn.addTypecount(3, 1);
                        de8.setClassType(ClassNameProfile.ClassType.SAME_PKG_CLASS);
                        if (this.ownNodeMap.containsKey(cnp.name)) {
                            this.ownNodeMap.get(cnp.name).addSinkEdge(de8);
                        }
                        existParameterMap.put(cnp.name, de8);
                        continue;
                    }
                    if (cnp.type != ClassNameProfile.ClassType.OTHER_PKG_CLASS) continue;
                    if (this.ownNodeMap.containsKey(cnp.name)) {
                        de8 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_PARAMETER, dn, this.ownNodeMap.get(cnp.name));
                        this.ownNodeMap.get(cnp.name).addSinkEdge(de8);
                    } else {
                        if (this.lostOtherPackageNodeMap.containsKey(cnp.name)) {
                            node = this.lostOtherPackageNodeMap.get(cnp.name);
                        } else {
                            node = new DepNode(cnp.name);
                            this.lostOtherPackageNodeMap.put(cnp.name, node);
                        }
                        de8 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_PARAMETER, dn, node);
                        node.addSinkEdge(de8);
                    }
                    dn.addDepEdge(de8);
                    dn.addTypecount(3, 2);
                    de8.setClassType(ClassNameProfile.ClassType.OTHER_PKG_CLASS);
                    existParameterMap.put(cnp.name, de8);
                }
                if (existReturnMap.containsKey(mp.returnTypeProfile.name)) {
                    ((DepEdge)existReturnMap.get(mp.returnTypeProfile.name)).addWeight();
                } else if (mp.returnTypeProfile.type == ClassNameProfile.ClassType.SYS_LIB_CLASS) {
                    DepNode sysdn2;
                    if (this.systemNodeMap.containsKey(mp.returnTypeProfile.name)) {
                        sysdn2 = this.systemNodeMap.get(mp.returnTypeProfile.name);
                    } else {
                        sysdn2 = new DepNode(mp.returnTypeProfile.name);
                        this.systemNodeMap.put(mp.returnTypeProfile.name, sysdn2);
                    }
                    DepEdge de10 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_RETURN, dn, sysdn2);
                    dn.addDepEdge(de10);
                    dn.addTypecount(4, 0);
                    de10.setClassType(ClassNameProfile.ClassType.SYS_LIB_CLASS);
                    sysdn2.addSinkEdge(de10);
                    existReturnMap.put(mp.returnTypeProfile.name, de10);
                } else if (mp.returnTypeProfile.type == ClassNameProfile.ClassType.SAME_PKG_CLASS) {
                    de7 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_RETURN, dn, this.ownNodeMap.get(mp.returnTypeProfile.name));
                    dn.addDepEdge(de7);
                    dn.addTypecount(4, 1);
                    de7.setClassType(ClassNameProfile.ClassType.SAME_PKG_CLASS);
                    if (this.ownNodeMap.containsKey(mp.returnTypeProfile.name)) {
                        this.ownNodeMap.get(mp.returnTypeProfile.name).addSinkEdge(de7);
                    }
                    existReturnMap.put(mp.returnTypeProfile.name, de7);
                } else if (mp.returnTypeProfile.type == ClassNameProfile.ClassType.OTHER_PKG_CLASS) {
                    if (this.ownNodeMap.containsKey(mp.returnTypeProfile.name)) {
                        de7 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_RETURN, dn, this.ownNodeMap.get(mp.returnTypeProfile.name));
                        this.ownNodeMap.get(mp.returnTypeProfile.name).addSinkEdge(de7);
                    } else {
                        DepNode node2;
                        if (this.lostOtherPackageNodeMap.containsKey(mp.returnTypeProfile.name)) {
                            node2 = this.lostOtherPackageNodeMap.get(mp.returnTypeProfile.name);
                        } else {
                            node2 = new DepNode(mp.returnTypeProfile.name);
                            this.lostOtherPackageNodeMap.put(mp.returnTypeProfile.name, node2);
                        }
                        de7 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_RETURN, dn, node2);
                        node2.addSinkEdge(de7);
                    }
                    dn.addDepEdge(de7);
                    dn.addTypecount(4, 2);
                    de7.setClassType(ClassNameProfile.ClassType.OTHER_PKG_CLASS);
                    existReturnMap.put(mp.returnTypeProfile.name, de7);
                }
                if (mp.throwExceptionClassNameProfileSet == null) continue;
                for (ClassNameProfile cnp : mp.throwExceptionClassNameProfileSet) {
                    if (existExceptionMap.containsKey(cnp.name)) {
                        ((DepEdge)existExceptionMap.get(cnp.name)).addWeight();
                        continue;
                    }
                    if (cnp.type == ClassNameProfile.ClassType.SYS_LIB_CLASS) {
                        if (this.systemNodeMap.containsKey(cnp.name)) {
                            sysdn = this.systemNodeMap.get(cnp.name);
                        } else {
                            sysdn = new DepNode(cnp.name);
                            this.systemNodeMap.put(cnp.name, sysdn);
                        }
                        de9 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_EXCEPTION, dn, sysdn);
                        sysdn.addSinkEdge(de9);
                        dn.addDepEdge(de9);
                        dn.addTypecount(5, 0);
                        de9.setClassType(ClassNameProfile.ClassType.SYS_LIB_CLASS);
                        existExceptionMap.put(cnp.name, de9);
                        continue;
                    }
                    if (cnp.type == ClassNameProfile.ClassType.SAME_PKG_CLASS) {
                        de8 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_EXCEPTION, dn, this.ownNodeMap.get(cnp.name));
                        if (this.ownNodeMap.containsKey(cnp.name)) {
                            this.ownNodeMap.get(cnp.name).addSinkEdge(de8);
                        }
                        dn.addDepEdge(de8);
                        dn.addTypecount(5, 1);
                        de8.setClassType(ClassNameProfile.ClassType.SAME_PKG_CLASS);
                        existExceptionMap.put(cnp.name, de8);
                        continue;
                    }
                    if (cnp.type != ClassNameProfile.ClassType.OTHER_PKG_CLASS) continue;
                    if (this.ownNodeMap.containsKey(cnp.name)) {
                        de8 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_EXCEPTION, dn, this.ownNodeMap.get(cnp.name));
                        this.ownNodeMap.get(cnp.name).addSinkEdge(de8);
                    } else {
                        if (this.lostOtherPackageNodeMap.containsKey(cnp.name)) {
                            node = this.lostOtherPackageNodeMap.get(cnp.name);
                        } else {
                            node = new DepNode(cnp.name);
                            this.lostOtherPackageNodeMap.put(cnp.name, node);
                        }
                        de8 = new DepEdge(DepEdge.DepEdgeType.DEP_EDGE_METHOD_EXCEPTION, dn, node);
                        node.addSinkEdge(de8);
                    }
                    dn.addDepEdge(de8);
                    dn.addTypecount(5, 2);
                    de8.setClassType(ClassNameProfile.ClassType.OTHER_PKG_CLASS);
                    existExceptionMap.put(cnp.name, de8);
                }
            }
        }
    }
}

