/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.cfg;

import cn.fudan.analysis.cfg.BasicBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jf.dexlib2.dexbacked.DexBackedExceptionHandler;
import org.jf.dexlib2.dexbacked.DexBackedTryBlock;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction10t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction20t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction30t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedPackedSwitchPayload;
import org.jf.dexlib2.dexbacked.instruction.DexBackedSparseSwitchPayload;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;

public class CFGAnalysis {
    /*
     * WARNING - void declaration
     */
    public static HashSet<BasicBlock> getBasicBlocks(MethodImplementation mp) {
        int firstInstuctionAddr = Integer.MAX_VALUE;
        int lastInstructionAddr = 0;
        BasicBlock entryBB = null;
        HashSet<BasicBlock> blocks = new HashSet<BasicBlock>();
        HashSet<BasicBlock> catchBlocks = new HashSet<BasicBlock>();
        ArrayList<Integer> leaders = new ArrayList<Integer>();
        HashMap<Integer, Integer> switchPayload2Instruction = new HashMap<Integer, Integer>();
        HashMap switchPayloadOffsets = new HashMap();
        Iterable<? extends Instruction> instructions = mp.getInstructions();
        boolean addNext = false;
        for (Instruction instruction : instructions) {
            DexBackedInstruction dexBackedInstruction = (DexBackedInstruction)instruction;
            if (addNext) {
                leaders.add(dexBackedInstruction.instructionStart);
                addNext = false;
            }
            switch (dexBackedInstruction.opcode) {
                case GOTO: {
                    leaders.add(((DexBackedInstruction10t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart);
                    addNext = true;
                    break;
                }
                case GOTO_16: {
                    leaders.add(((DexBackedInstruction20t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart);
                    addNext = true;
                    break;
                }
                case GOTO_32: {
                    leaders.add(((DexBackedInstruction30t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart);
                    addNext = true;
                    break;
                }
                case IF_EQ: 
                case IF_NE: 
                case IF_LT: 
                case IF_GE: 
                case IF_GT: 
                case IF_LE: {
                    leaders.add(((DexBackedInstruction22t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart);
                    addNext = true;
                    break;
                }
                case IF_EQZ: 
                case IF_NEZ: 
                case IF_LTZ: 
                case IF_GEZ: 
                case IF_GTZ: 
                case IF_LEZ: {
                    leaders.add(((DexBackedInstruction21t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart);
                    addNext = true;
                    break;
                }
                case PACKED_SWITCH: 
                case SPARSE_SWITCH: {
                    switchPayload2Instruction.put(((DexBackedInstruction31t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart, dexBackedInstruction.instructionStart);
                    addNext = true;
                    break;
                }
                case PACKED_SWITCH_PAYLOAD: 
                case SPARSE_SWITCH_PAYLOAD: {
                    int n = dexBackedInstruction.instructionStart;
                    List<? extends SwitchElement> switchElements = null;
                    switchElements = dexBackedInstruction instanceof DexBackedPackedSwitchPayload ? ((DexBackedPackedSwitchPayload)dexBackedInstruction).getSwitchElements() : ((DexBackedSparseSwitchPayload)dexBackedInstruction).getSwitchElements();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (SwitchElement switchElement : switchElements) {
                        leaders.add(switchElement.getOffset() * 2 + (Integer)switchPayload2Instruction.get(dexBackedInstruction.instructionStart));
                        arrayList.add(switchElement.getOffset() * 2 + (Integer)switchPayload2Instruction.get(dexBackedInstruction.instructionStart));
                    }
                    switchPayloadOffsets.put(n, arrayList);
                }
            }
            if (dexBackedInstruction.instructionStart > lastInstructionAddr) {
                lastInstructionAddr = dexBackedInstruction.instructionStart;
            }
            if (dexBackedInstruction.instructionStart >= firstInstuctionAddr) continue;
            firstInstuctionAddr = dexBackedInstruction.instructionStart;
        }
        leaders.add(firstInstuctionAddr);
        HashSet<Integer> catchBlockLeaders = new HashSet<Integer>();
        for (TryBlock<? extends ExceptionHandler> tryBlock : mp.getTryBlocks()) {
            DexBackedTryBlock dexBackedTryBlock = (DexBackedTryBlock)tryBlock;
            for (DexBackedExceptionHandler dexBackedExceptionHandler : dexBackedTryBlock.getExceptionHandlers()) {
                catchBlockLeaders.add(dexBackedExceptionHandler.getHandlerCodeAddress() * 2 + firstInstuctionAddr);
            }
        }
        Object var12_14 = null;
        for (Instruction instruction : instructions) {
            void var12_15;
            if (catchBlockLeaders.contains(((DexBackedInstruction)instruction).instructionStart)) {
                BasicBlock basicBlock = new BasicBlock(null);
                basicBlock.setStartAddress(((DexBackedInstruction)instruction).instructionStart);
                catchBlocks.add(basicBlock);
            } else if (leaders.contains(((DexBackedInstruction)instruction).instructionStart)) {
                BasicBlock basicBlock = new BasicBlock(mp);
                basicBlock.setStartAddress(((DexBackedInstruction)instruction).instructionStart);
                if (entryBB == null) {
                    entryBB = basicBlock;
                    entryBB.setEntryBlock(true);
                }
                blocks.add(basicBlock);
            }
            var12_15.addInstruction(instruction);
        }
        block23: for (BasicBlock basicBlock : blocks) {
            Instruction lastInstruction = basicBlock.getInstructions().get(basicBlock.getInstructions().size() - 1);
            DexBackedInstruction dexBackedInstruction = (DexBackedInstruction)lastInstruction;
            switch (dexBackedInstruction.opcode) {
                case GOTO: {
                    int offset = ((DexBackedInstruction10t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    break;
                }
                case GOTO_16: {
                    int offset = ((DexBackedInstruction20t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    break;
                }
                case GOTO_32: {
                    int offset = ((DexBackedInstruction30t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    break;
                }
                case IF_EQ: 
                case IF_NE: 
                case IF_LT: 
                case IF_GE: 
                case IF_GT: 
                case IF_LE: {
                    int offset = dexBackedInstruction.instructionStart + dexBackedInstruction.getOpcode().format.size;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    offset = ((DexBackedInstruction22t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    break;
                }
                case IF_EQZ: 
                case IF_NEZ: 
                case IF_LTZ: 
                case IF_GEZ: 
                case IF_GTZ: 
                case IF_LEZ: {
                    int offset = dexBackedInstruction.instructionStart + dexBackedInstruction.getOpcode().format.size;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    offset = ((DexBackedInstruction21t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    break;
                }
                case PACKED_SWITCH: 
                case SPARSE_SWITCH: {
                    int offset = dexBackedInstruction.instructionStart + dexBackedInstruction.getOpcode().format.size;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                    Iterator iterator = ((ArrayList)switchPayloadOffsets.get(((DexBackedInstruction31t)dexBackedInstruction).getCodeOffset() * 2 + dexBackedInstruction.instructionStart)).iterator();
                    while (iterator.hasNext()) {
                        int o = (Integer)iterator.next();
                        CFGAnalysis.linkBlock(blocks, basicBlock, o);
                    }
                    continue block23;
                }
                case RETURN_VOID: 
                case RETURN: 
                case RETURN_WIDE: 
                case RETURN_OBJECT: 
                case RETURN_VOID_BARRIER: 
                case THROW: {
                    break;
                }
                default: {
                    int offset = dexBackedInstruction.instructionStart + dexBackedInstruction.getOpcode().format.size;
                    if (dexBackedInstruction.getOpcode().format.size < 0 || offset > lastInstructionAddr) break;
                    CFGAnalysis.linkBlock(blocks, basicBlock, offset);
                }
            }
        }
        return blocks;
    }

    private static void linkBlock(HashSet<BasicBlock> blocks, BasicBlock bb, int offset) {
        for (BasicBlock basicBlock : blocks) {
            if (basicBlock.getStartAddress() != offset) continue;
            bb.getSuccessors().add(basicBlock);
            basicBlock.getPredecessors().add(bb);
            return;
        }
        throw new RuntimeException("basic block exception: " + offset);
    }
}

