/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.cfg;

import cn.fudan.analysis.cfg.InvokeInstruction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;

public class BasicBlock {
    private MethodImplementation mp;
    private ArrayList<Instruction> instructions = new ArrayList();
    private LinkedList<BasicBlock> successors = new LinkedList();
    private LinkedList<BasicBlock> predecessors = new LinkedList();
    private LinkedList<InvokeInstruction> invokeInstructions = null;
    private int startAddress;
    private boolean isEntry = false;

    public BasicBlock(MethodImplementation mp) {
        this.mp = mp;
    }

    public LinkedList<BasicBlock> getPredecessors() {
        return this.predecessors;
    }

    public LinkedList<BasicBlock> getSuccessors() {
        return this.successors;
    }

    public boolean isEntryBlock() {
        return this.isEntry;
    }

    public void setEntryBlock(boolean isEntry) {
        this.isEntry = isEntry;
    }

    public void setStartAddress(int startAddress) {
        this.startAddress = startAddress;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public ArrayList<Instruction> getInstructions() {
        return this.instructions;
    }

    public void addInstruction(Instruction i) {
        this.instructions.add(i);
    }

    public LinkedList<InvokeInstruction> getInvokeInstructions() {
        if (this.invokeInstructions != null) {
            return this.invokeInstructions;
        }
        this.invokeInstructions = new LinkedList();
        for (int i = 0; i < this.instructions.size(); ++i) {
            Instruction instruction = this.instructions.get(i);
            Opcode opcode = instruction.getOpcode();
            switch (opcode) {
                case INVOKE_VIRTUAL: 
                case INVOKE_SUPER: 
                case INVOKE_DIRECT: 
                case INVOKE_STATIC: 
                case INVOKE_INTERFACE: 
                case INVOKE_VIRTUAL_RANGE: 
                case INVOKE_SUPER_RANGE: 
                case INVOKE_DIRECT_RANGE: 
                case INVOKE_STATIC_RANGE: 
                case INVOKE_INTERFACE_RANGE: {
                    InvokeInstruction ii = new InvokeInstruction(this, instruction, i);
                    this.invokeInstructions.add(ii);
                }
            }
        }
        return this.invokeInstructions;
    }

    public HashSet<BasicBlock> getSuccessorSet() {
        HashSet<BasicBlock> result = new HashSet<BasicBlock>();
        HashSet<BasicBlock> visited = new HashSet<BasicBlock>();
        LinkedList<BasicBlock> testQueue = new LinkedList<BasicBlock>();
        testQueue.push(this);
        while (testQueue.size() > 0) {
            BasicBlock basicBlock = (BasicBlock)testQueue.pop();
            visited.add(basicBlock);
            for (BasicBlock successor : basicBlock.getSuccessors()) {
                if (visited.contains(successor)) continue;
                testQueue.push(successor);
            }
            result.add(basicBlock);
        }
        return result;
    }
}

