# generated by datamodel-codegen:
#   filename:  sources_v3.json

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import ConfigDict, Field

from dbt_artifacts_parser.parsers.base import BaseParserModel


class Metadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[str] = None
    dbt_version: Optional[str] = '1.9.0b2'
    generated_at: Optional[str] = None
    invocation_id: Optional[str] = None
    env: Optional[Dict[str, str]] = None


class Status(Enum):
    runtime_error = 'runtime error'


class Results(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unique_id: str
    error: Optional[Union[str, int]] = None
    status: Status


class Status1(Enum):
    pass_ = 'pass'
    warn = 'warn'
    error = 'error'
    runtime_error = 'runtime error'


class Period(Enum):
    minute = 'minute'
    hour = 'hour'
    day = 'day'


class WarnAfter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class ErrorAfter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class Criteria(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[WarnAfter] = None
    error_after: Optional[ErrorAfter] = None
    filter: Optional[str] = None


class TimingItem(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    started_at: Optional[str] = None
    completed_at: Optional[str] = None


class Results1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unique_id: str
    max_loaded_at: str
    snapshotted_at: str
    max_loaded_at_time_ago_in_s: float
    status: Status1
    criteria: Criteria = Field(..., title='FreshnessThreshold')
    adapter_response: Dict[str, Any]
    timing: List[TimingItem]
    thread_id: str
    execution_time: float


class SourcesV3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: Metadata = Field(..., title='FreshnessMetadata')
    results: List[Union[Results, Results1]]
    elapsed_time: float
