# generated by datamodel-codegen:
#   filename:  manifest_v3.json

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import AwareDatetime, ConfigDict, Field, constr

from dbt_artifacts_parser.parsers.base import BaseParserModel


class ManifestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[
        str
    ] = 'https://schemas.getdbt.com/dbt/manifest/v3.json'
    dbt_version: Optional[str] = '0.21.0rc1'
    generated_at: Optional[AwareDatetime] = '2021-09-24T13:29:14.317700Z'
    invocation_id: Optional[str] = None
    env: Optional[Dict[str, str]] = {}
    project_id: Optional[str] = Field(
        None, description='A unique identifier for the project'
    )
    user_id: Optional[
        constr(pattern=r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}')
    ] = Field(None, description='A unique identifier for the user')
    send_anonymous_usage_stats: Optional[bool] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[str] = Field(
        None, description='The type name of the adapter'
    )


class ResourceType(Enum):
    analysis = 'analysis'


class FileHash(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    checksum: str


class Hook(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class DependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = []
    nodes: Optional[List[str]] = []


class ColumnInfo(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    data_type: Optional[str] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = []


class Docs(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True


class InjectedCTE(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    sql: str


class ResourceType1(Enum):
    test = 'test'


class TestConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'test'
    severity: Optional[
        constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')
    ] = 'ERROR'
    store_failures: Optional[bool] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class ResourceType2(Enum):
    model = 'model'


class ResourceType3(Enum):
    operation = 'operation'


class ResourceType4(Enum):
    rpc = 'rpc'


class ResourceType5(Enum):
    test = 'test'


class TestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    kwargs: Optional[Dict[str, Any]] = {}
    namespace: Optional[str] = None


class ResourceType6(Enum):
    seed = 'seed'


class SeedConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'seed'
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    on_schema_change: Optional[str] = 'ignore'
    quote_columns: Optional[bool] = None


class ResourceType7(Enum):
    snapshot = 'snapshot'


class ResourceType8(Enum):
    analysis = 'analysis'


class ResourceType9(Enum):
    test = 'test'


class ParsedDataTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType9
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}


class ResourceType10(Enum):
    operation = 'operation'


class ResourceType11(Enum):
    model = 'model'


class ResourceType12(Enum):
    rpc = 'rpc'


class ResourceType13(Enum):
    test = 'test'


class ParsedSchemaTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    test_metadata: TestMetadata
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType13
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    column_name: Optional[str] = None


class ResourceType14(Enum):
    seed = 'seed'


class ParsedSeedNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType14
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = Field(
        default_factory=lambda: SeedConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'seed',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'quote_columns': None,
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}


class ResourceType15(Enum):
    snapshot = 'snapshot'


class SnapshotConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'snapshot'
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    on_schema_change: Optional[str] = 'ignore'
    strategy: Optional[str] = None
    unique_key: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None


class ResourceType16(Enum):
    source = 'source'


class Quoting(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[bool] = None
    schema_: Optional[bool] = Field(None, alias='schema')
    identifier: Optional[bool] = None
    column: Optional[bool] = None


class FreshnessMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[str] = 'https://schemas.getdbt.com/dbt/sources/v2.json'
    dbt_version: Optional[str] = '0.21.0rc1'
    generated_at: Optional[AwareDatetime] = '2021-09-24T13:29:14.312598Z'
    invocation_id: Optional[str] = None
    env: Optional[Dict[str, str]] = {}


class Status(Enum):
    runtime_error = 'runtime error'


class SourceFreshnessRuntimeError(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unique_id: str
    error: Optional[Union[str, int]] = None
    status: Status


class Status1(Enum):
    pass_ = 'pass'
    warn = 'warn'
    error = 'error'
    runtime_error = 'runtime error'


class Period(Enum):
    minute = 'minute'
    hour = 'hour'
    day = 'day'


class Time(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    period: Period


class TimingInfo(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    started_at: Optional[AwareDatetime] = None
    completed_at: Optional[AwareDatetime] = None


class ExternalPartition(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}


class SourceConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True


class ResourceType17(Enum):
    macro = 'macro'


class MacroDependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = []


class MacroArgument(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Optional[str] = None
    description: Optional[str] = ''


class ParsedDocumentation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    block_contents: str


class Type(Enum):
    dashboard = 'dashboard'
    notebook = 'notebook'
    analysis = 'analysis'
    ml = 'ml'
    application = 'application'


class ResourceType18(Enum):
    model = 'model'
    analysis = 'analysis'
    test = 'test'
    snapshot = 'snapshot'
    operation = 'operation'
    seed = 'seed'
    rpc = 'rpc'
    docs = 'docs'
    source = 'source'
    macro = 'macro'
    exposure = 'exposure'


class Maturity(Enum):
    low = 'low'
    medium = 'medium'
    high = 'high'


class ExposureOwner(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    email: str
    name: Optional[str] = None


class NodeConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'view'
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    on_schema_change: Optional[str] = 'ignore'


class CompiledDataTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType1
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None


class CompiledModelNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType2
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None


class CompiledHookNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType3
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None
    index: Optional[int] = None


class CompiledRPCNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType4
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None


class CompiledSchemaTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    test_metadata: TestMetadata
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType5
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None
    column_name: Optional[str] = None


class CompiledSeedNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType6
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = Field(
        default_factory=lambda: SeedConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'seed',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'quote_columns': None,
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None


class CompiledSnapshotNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType7
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None


class ParsedAnalysisNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType8
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedHookNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType10
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    index: Optional[int] = None


class ParsedModelNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType11
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedRPCNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType12
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedSnapshotNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType15
    alias: str
    checksum: FileHash
    config: SnapshotConfig
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}


class FreshnessThreshold(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[Time] = None
    error_after: Optional[Time] = None
    filter: Optional[str] = None


class SourceFreshnessOutput(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unique_id: str
    max_loaded_at: AwareDatetime
    snapshotted_at: AwareDatetime
    max_loaded_at_time_ago_in_s: float
    status: Status1
    criteria: FreshnessThreshold
    adapter_response: Dict[str, Any]
    timing: List[TimingInfo]
    thread_id: str
    execution_time: float


class ExternalTable(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[List[ExternalPartition]] = None


class ParsedMacro(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    macro_sql: str
    resource_type: ResourceType17
    tags: Optional[List[str]] = []
    depends_on: Optional[MacroDependsOn] = Field(
        default_factory=lambda: MacroDependsOn.model_validate({'macros': []})
    )
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    arguments: Optional[List[MacroArgument]] = []
    created_at: Optional[int] = 1632490154


class ParsedExposure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    type: Type
    owner: ExposureOwner
    resource_type: Optional[ResourceType18] = 'exposure'
    description: Optional[str] = ''
    maturity: Optional[Maturity] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    url: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    created_at: Optional[int] = 1632490154


class CompiledAnalysisNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    raw_sql: str
    compiled: bool
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: ResourceType
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'materialized': 'view',
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'on_schema_change': 'ignore',
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True})
    )
    patch_path: Optional[str] = None
    compiled_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[int] = 1632490154
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_sql: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[str] = None


class ParsedSourceDefinition(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fqn: List[str]
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    source_name: str
    source_description: str
    loader: str
    identifier: str
    resource_type: ResourceType16
    quoting: Optional[Quoting] = Field(
        default_factory=lambda: Quoting.model_validate(
            {'database': None, 'schema': None, 'identifier': None, 'column': None}
        )
    )
    loaded_at_field: Optional[str] = None
    freshness: Optional[FreshnessThreshold] = None
    external: Optional[ExternalTable] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    source_meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[SourceConfig] = Field(
        default_factory=lambda: SourceConfig.model_validate({'enabled': True})
    )
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    created_at: Optional[int] = 1632490154


class ManifestV3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: ManifestMetadata = Field(..., description='Metadata about the manifest')
    nodes: Dict[
        str,
        Union[
            CompiledAnalysisNode,
            CompiledDataTestNode,
            CompiledModelNode,
            CompiledHookNode,
            CompiledRPCNode,
            CompiledSchemaTestNode,
            CompiledSeedNode,
            CompiledSnapshotNode,
            ParsedAnalysisNode,
            ParsedDataTestNode,
            ParsedHookNode,
            ParsedModelNode,
            ParsedRPCNode,
            ParsedSchemaTestNode,
            ParsedSeedNode,
            ParsedSnapshotNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, ParsedSourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, ParsedMacro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, ParsedDocumentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, ParsedExposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        List[
            Union[
                CompiledAnalysisNode,
                CompiledDataTestNode,
                CompiledModelNode,
                CompiledHookNode,
                CompiledRPCNode,
                CompiledSchemaTestNode,
                CompiledSeedNode,
                CompiledSnapshotNode,
                ParsedAnalysisNode,
                ParsedDataTestNode,
                ParsedHookNode,
                ParsedModelNode,
                ParsedRPCNode,
                ParsedSchemaTestNode,
                ParsedSeedNode,
                ParsedSnapshotNode,
                ParsedSourceDefinition,
            ]
        ]
    ] = Field(None, description='A list of the disabled nodes in the target')
    parent_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from parent nodes to their dependents'
    )
