# generated by datamodel-codegen:
#   filename:  manifest_v12.json

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union
from uuid import UUID

from pydantic import ConfigDict, Field, constr

from dbt_artifacts_parser.parsers.base import BaseParserModel


class Metadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[str] = None
    dbt_version: Optional[str] = '1.9.0b4'
    generated_at: Optional[str] = None
    invocation_id: Optional[str] = None
    env: Optional[Dict[str, str]] = None
    project_name: Optional[str] = Field(None, description='Name of the root project')
    project_id: Optional[str] = Field(
        None,
        description='A unique identifier for the project, hashed from the project name',
    )
    user_id: Optional[UUID] = Field(
        None, description='A unique identifier for the user'
    )
    send_anonymous_usage_stats: Optional[bool] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[str] = Field(
        None, description='The type name of the adapter'
    )


class Checksum(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    checksum: str


class PostHookItem(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class PreHookItem(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class OnConfigurationChange(Enum):
    apply = 'apply'
    continue_ = 'continue'
    fail = 'fail'


class Docs(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True
    node_color: Optional[str] = None


class Contract(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None
    delimiter: Optional[str] = ','
    quote_columns: Optional[bool] = None


class Type(Enum):
    check = 'check'
    not_null = 'not_null'
    unique = 'unique'
    primary_key = 'primary_key'
    foreign_key = 'foreign_key'
    custom = 'custom'


class Constraint(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Granularity(Enum):
    nanosecond = 'nanosecond'
    microsecond = 'microsecond'
    millisecond = 'millisecond'
    second = 'second'
    minute = 'minute'
    hour = 'hour'
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class Columns(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class DependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None


class ResourceType(Enum):
    model = 'model'
    analysis = 'analysis'
    test = 'test'
    snapshot = 'snapshot'
    operation = 'operation'
    seed = 'seed'
    rpc = 'rpc'
    sql_operation = 'sql_operation'
    doc = 'doc'
    source = 'source'
    macro = 'macro'
    exposure = 'exposure'
    metric = 'metric'
    group = 'group'
    saved_query = 'saved_query'
    semantic_model = 'semantic_model'
    unit_test = 'unit_test'
    fixture = 'fixture'


class Config1(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class DeferRelation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None
    resource_type: ResourceType
    name: str
    description: str
    compiled_code: Optional[str] = None
    meta: Dict[str, Any]
    tags: List[str]
    config: Optional[Config1] = None


class Nodes(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['seed']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config] = Field(None, title='SeedConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(None, title='MacroDependsOn')
    defer_relation: Optional[DeferRelation] = None


class Config2(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class Constraint1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns1(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint1]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Ref(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    package: Optional[str] = None
    version: Optional[Union[str, float]] = None


class DependsOn1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None
    nodes: Optional[List[str]] = None


class ExtraCte(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    sql: str


class Contract3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Nodes1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['analysis']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config2] = Field(None, title='NodeConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns1]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract3] = Field(None, title='Contract')


class Config3(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')] = (
        'ERROR'
    )
    store_failures: Optional[bool] = None
    store_failures_as: Optional[str] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class Constraint2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns2(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint2]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Nodes2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config3] = Field(None, title='TestConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns2]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract3] = Field(None, title='Contract')


class Contract5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config4(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract5] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class Constraint3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns3(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint3]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract6(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Nodes3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config4] = Field(None, title='NodeConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns3]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract6] = Field(None, title='Contract')
    index: Optional[int] = None


class Contract7(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Access(Enum):
    private = 'private'
    protected = 'protected'
    public = 'public'


class Config5(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract7] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None
    access: Optional[Access] = 'protected'


class Constraint4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns4(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint4]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract8(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Constraint5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None
    columns: Optional[List[str]] = None


class Contract9(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config6(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract9] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class DeferRelation1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None
    resource_type: ResourceType
    name: str
    description: str
    compiled_code: Optional[str] = None
    meta: Dict[str, Any]
    tags: List[str]
    config: Optional[Config6] = None


class CustomGranularity(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    column_name: Optional[str] = None


class TimeSpine(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    standard_granularity_column: str
    custom_granularities: Optional[List[CustomGranularity]] = None


class Nodes4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['model']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config5] = Field(None, title='ModelConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns4]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract8] = Field(None, title='Contract')
    access: Optional[Access] = 'protected'
    constraints: Optional[List[Constraint5]] = None
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[str] = None
    defer_relation: Optional[DeferRelation1] = None
    primary_key: Optional[List[str]] = None
    time_spine: Optional[TimeSpine] = None


class Config7(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract9] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class Constraint6(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns5(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint6]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract11(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Nodes5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['sql_operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config7] = Field(None, title='NodeConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns5]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract11] = Field(None, title='Contract')


class Config8(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')] = (
        'ERROR'
    )
    store_failures: Optional[bool] = None
    store_failures_as: Optional[str] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class Constraint7(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns6(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint7]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class TestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[str] = 'test'
    kwargs: Optional[Dict[str, Any]] = None
    namespace: Optional[str] = None


class Nodes6(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config8] = Field(None, title='TestConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns6]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract11] = Field(None, title='Contract')
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None
    test_metadata: Optional[TestMetadata] = Field(None, title='TestMetadata')


class Contract13(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class SnapshotMetaColumnNames(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_valid_to: Optional[str] = None
    dbt_valid_from: Optional[str] = None
    dbt_scd_id: Optional[str] = None
    dbt_updated_at: Optional[str] = None
    dbt_is_deleted: Optional[str] = None


class Config9(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract13] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None
    strategy: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None
    snapshot_meta_column_names: Optional[SnapshotMetaColumnNames] = Field(
        None, title='SnapshotMetaColumnNames'
    )
    dbt_valid_to_current: Optional[str] = None


class Constraint8(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns7(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint8]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract14(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Contract15(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config10(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[Contract15] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class DeferRelation2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None
    resource_type: ResourceType
    name: str
    description: str
    compiled_code: Optional[str] = None
    meta: Dict[str, Any]
    tags: List[str]
    config: Optional[Config10] = None


class Nodes7(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['snapshot']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Config9 = Field(..., title='SnapshotConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns7]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn1] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract14] = Field(None, title='Contract')
    defer_relation: Optional[DeferRelation2] = None


class Quoting(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[bool] = None
    schema_: Optional[bool] = Field(None, alias='schema')
    identifier: Optional[bool] = None
    column: Optional[bool] = None


class Period(Enum):
    minute = 'minute'
    hour = 'hour'
    day = 'day'


class WarnAfter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class ErrorAfter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class Freshness(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[WarnAfter] = None
    error_after: Optional[ErrorAfter] = None
    filter: Optional[str] = None


class Partition(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None


class External(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[Union[List[str], List[Partition]]] = None


class Constraint9(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns8(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint9]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Config11(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    event_time: Optional[Any] = None


class Sources(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['source']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    quoting: Optional[Quoting] = Field(None, title='Quoting')
    loaded_at_field: Optional[str] = None
    freshness: Optional[Freshness] = None
    external: Optional[External] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns8]] = None
    meta: Optional[Dict[str, Any]] = None
    source_meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[Config11] = Field(None, title='SourceConfig')
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    created_at: Optional[float] = None
    unrendered_database: Optional[str] = None
    unrendered_schema: Optional[str] = None


class DependsOn8(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None


class Argument(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Optional[str] = None
    description: Optional[str] = ''


class SupportedLanguage(Enum):
    python = 'python'
    sql = 'sql'


class Macros(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['macro']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    macro_sql: str
    depends_on: Optional[DependsOn8] = Field(None, title='MacroDependsOn')
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    arguments: Optional[List[Argument]] = None
    created_at: Optional[float] = None
    supported_languages: Optional[List[SupportedLanguage]] = None


class Docs18(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['doc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    block_contents: str


class Type10(Enum):
    dashboard = 'dashboard'
    notebook = 'notebook'
    analysis = 'analysis'
    ml = 'ml'
    application = 'application'


class Owner(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    email: Optional[str] = None
    name: Optional[str] = None


class Maturity(Enum):
    low = 'low'
    medium = 'medium'
    high = 'high'


class Config12(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True


class DependsOn9(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None
    nodes: Optional[List[str]] = None


class Exposures(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['exposure']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    type: Type10
    owner: Owner = Field(..., title='Owner')
    description: Optional[str] = ''
    label: Optional[str] = None
    maturity: Optional[Maturity] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[Config12] = Field(None, title='ExposureConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    url: Optional[str] = None
    depends_on: Optional[DependsOn9] = Field(None, title='DependsOn')
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None


class Type11(Enum):
    simple = 'simple'
    ratio = 'ratio'
    cumulative = 'cumulative'
    derived = 'derived'
    conversion = 'conversion'


class WhereFilter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_sql_template: str


class Filter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Measure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Filter1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class InputMeasure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter1] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Filter2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class OffsetWindow(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: str


class Numerator(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter2] = None
    alias: Optional[str] = None
    offset_window: Optional[OffsetWindow] = None
    offset_to_grain: Optional[str] = None


class Filter3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Denominator(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter3] = None
    alias: Optional[str] = None
    offset_window: Optional[OffsetWindow] = None
    offset_to_grain: Optional[str] = None


class Window(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: Granularity


class GrainToDate(Enum):
    nanosecond = 'nanosecond'
    microsecond = 'microsecond'
    millisecond = 'millisecond'
    second = 'second'
    minute = 'minute'
    hour = 'hour'
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class Filter4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Metric(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter4] = None
    alias: Optional[str] = None
    offset_window: Optional[OffsetWindow] = None
    offset_to_grain: Optional[str] = None


class Filter5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class BaseMeasure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter5] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Filter6(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class ConversionMeasure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter6] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Calculation(Enum):
    conversions = 'conversions'
    conversion_rate = 'conversion_rate'


class Window1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: str


class ConstantProperty(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_property: str
    conversion_property: str


class ConversionTypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_measure: BaseMeasure = Field(..., title='MetricInputMeasure')
    conversion_measure: ConversionMeasure = Field(..., title='MetricInputMeasure')
    entity: str
    calculation: Optional[Calculation] = 'conversion_rate'
    window: Optional[Window1] = None
    constant_properties: Optional[List[ConstantProperty]] = None


class PeriodAgg(Enum):
    first = 'first'
    last = 'last'
    average = 'average'


class CumulativeTypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    window: Optional[Window1] = None
    grain_to_date: Optional[str] = None
    period_agg: Optional[PeriodAgg] = 'first'


class TypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[Measure] = None
    input_measures: Optional[List[InputMeasure]] = None
    numerator: Optional[Numerator] = None
    denominator: Optional[Denominator] = None
    expr: Optional[str] = None
    window: Optional[Window] = None
    grain_to_date: Optional[GrainToDate] = None
    metrics: Optional[List[Metric]] = None
    conversion_type_params: Optional[ConversionTypeParams] = None
    cumulative_type_params: Optional[CumulativeTypeParams] = None


class Filter7(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class FileSlice(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    filename: str
    content: str
    start_line_number: int
    end_line_number: int


class Metadata1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Config13(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class Metrics(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['metric']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Type11
    type_params: TypeParams = Field(..., title='MetricTypeParams')
    filter: Optional[Filter7] = None
    metadata: Optional[Metadata1] = None
    time_granularity: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[Config13] = Field(None, title='MetricConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    sources: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn9] = Field(None, title='DependsOn')
    refs: Optional[List[Ref]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None
    group: Optional[str] = None


class Groups(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['group']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    owner: Owner = Field(..., title='Owner')


class Docs19(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True
    node_color: Optional[str] = None


class Config14(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract15] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None
    delimiter: Optional[str] = ','
    quote_columns: Optional[bool] = None


class Type12(Enum):
    check = 'check'
    not_null = 'not_null'
    unique = 'unique'
    primary_key = 'primary_key'
    foreign_key = 'foreign_key'
    custom = 'custom'


class Constraint10(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns9(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint10]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class DependsOn11(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None


class Config15(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract15] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class DeferRelation3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None
    resource_type: ResourceType
    name: str
    description: str
    compiled_code: Optional[str] = None
    meta: Dict[str, Any]
    tags: List[str]
    config: Optional[Config15] = None


class Disabled(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['seed']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config14] = Field(None, title='SeedConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns9]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[DependsOn11] = Field(None, title='MacroDependsOn')
    defer_relation: Optional[DeferRelation3] = None


class Config16(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract15] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class Constraint11(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns10(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint11]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class DependsOn12(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None
    nodes: Optional[List[str]] = None


class Contract19(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Disabled1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['analysis']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config16] = Field(None, title='NodeConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns10]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract19] = Field(None, title='Contract')


class Config17(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')] = (
        'ERROR'
    )
    store_failures: Optional[bool] = None
    store_failures_as: Optional[str] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class Constraint12(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns11(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint12]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Disabled2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config17] = Field(None, title='TestConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns11]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract19] = Field(None, title='Contract')


class Contract21(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config18(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract21] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class Constraint13(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns12(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint13]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract22(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Disabled3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config18] = Field(None, title='NodeConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns12]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract22] = Field(None, title='Contract')
    index: Optional[int] = None


class Contract23(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config19(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract23] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None
    access: Optional[Access] = 'protected'


class Constraint14(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns13(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint14]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract24(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Constraint15(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None
    columns: Optional[List[str]] = None


class Contract25(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config20(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract25] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class DeferRelation4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None
    resource_type: ResourceType
    name: str
    description: str
    compiled_code: Optional[str] = None
    meta: Dict[str, Any]
    tags: List[str]
    config: Optional[Config20] = None


class TimeSpine1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    standard_granularity_column: str
    custom_granularities: Optional[List[CustomGranularity]] = None


class Disabled4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['model']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config19] = Field(None, title='ModelConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns13]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract24] = Field(None, title='Contract')
    access: Optional[Access] = 'protected'
    constraints: Optional[List[Constraint15]] = None
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[str] = None
    defer_relation: Optional[DeferRelation4] = None
    primary_key: Optional[List[str]] = None
    time_spine: Optional[TimeSpine1] = None


class Config21(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract25] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class Constraint16(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns14(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint16]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract27(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Disabled5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['sql_operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config21] = Field(None, title='NodeConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns14]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract27] = Field(None, title='Contract')


class Config22(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')] = (
        'ERROR'
    )
    store_failures: Optional[bool] = None
    store_failures_as: Optional[str] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class Constraint17(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns15(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint17]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Disabled6(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Optional[Config22] = Field(None, title='TestConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns15]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract27] = Field(None, title='Contract')
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None
    test_metadata: Optional[TestMetadata] = Field(None, title='TestMetadata')


class Contract29(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config23(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract29] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None
    strategy: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None
    snapshot_meta_column_names: Optional[SnapshotMetaColumnNames] = Field(
        None, title='SnapshotMetaColumnNames'
    )
    dbt_valid_to_current: Optional[str] = None


class Constraint18(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns16(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint18]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Contract30(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class Contract31(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class Config24(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    batch_size: Optional[Any] = None
    lookback: Optional[Any] = 1
    begin: Optional[Any] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[PostHookItem]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[PreHookItem]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    contract: Optional[Contract31] = Field(None, title='ContractConfig')
    event_time: Optional[Any] = None
    concurrent_batches: Optional[Any] = None


class DeferRelation5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None
    resource_type: ResourceType
    name: str
    description: str
    compiled_code: Optional[str] = None
    meta: Dict[str, Any]
    tags: List[str]
    config: Optional[Config24] = None


class Disabled7(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['snapshot']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: Checksum = Field(..., title='FileHash')
    config: Config23 = Field(..., title='SnapshotConfig')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns16]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs19] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    unrendered_config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[ExtraCte]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract30] = Field(None, title='Contract')
    defer_relation: Optional[DeferRelation5] = None


class WarnAfter1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class ErrorAfter1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class Freshness1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[WarnAfter1] = None
    error_after: Optional[ErrorAfter1] = None
    filter: Optional[str] = None


class External1(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[Union[List[str], List[Partition]]] = None


class Constraint19(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type12
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    to: Optional[str] = None
    to_columns: Optional[List[str]] = None


class Columns17(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[Constraint19]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    granularity: Optional[Granularity] = None


class Config25(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    event_time: Optional[Any] = None


class Disabled8(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['source']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    quoting: Optional[Quoting] = Field(None, title='Quoting')
    loaded_at_field: Optional[str] = None
    freshness: Optional[Freshness1] = None
    external: Optional[External1] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, Columns17]] = None
    meta: Optional[Dict[str, Any]] = None
    source_meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[Config25] = Field(None, title='SourceConfig')
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    created_at: Optional[float] = None
    unrendered_database: Optional[str] = None
    unrendered_schema: Optional[str] = None


class Type22(Enum):
    dashboard = 'dashboard'
    notebook = 'notebook'
    analysis = 'analysis'
    ml = 'ml'
    application = 'application'


class Config26(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True


class Disabled9(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['exposure']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    type: Type22
    owner: Owner = Field(..., title='Owner')
    description: Optional[str] = ''
    label: Optional[str] = None
    maturity: Optional[Maturity] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[Config26] = Field(None, title='ExposureConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    url: Optional[str] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    refs: Optional[List[Ref]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None


class Type23(Enum):
    simple = 'simple'
    ratio = 'ratio'
    cumulative = 'cumulative'
    derived = 'derived'
    conversion = 'conversion'


class Filter8(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Measure1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter8] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Filter9(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class InputMeasure1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter9] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Filter10(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Numerator1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter10] = None
    alias: Optional[str] = None
    offset_window: Optional[OffsetWindow] = None
    offset_to_grain: Optional[str] = None


class Filter11(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Denominator1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter11] = None
    alias: Optional[str] = None
    offset_window: Optional[OffsetWindow] = None
    offset_to_grain: Optional[str] = None


class Window3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: Granularity


class Filter12(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Metric1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter12] = None
    alias: Optional[str] = None
    offset_window: Optional[OffsetWindow] = None
    offset_to_grain: Optional[str] = None


class Filter13(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class BaseMeasure1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter13] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Filter14(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class ConversionMeasure1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[Filter14] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Window4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: str


class ConversionTypeParams1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_measure: BaseMeasure1 = Field(..., title='MetricInputMeasure')
    conversion_measure: ConversionMeasure1 = Field(..., title='MetricInputMeasure')
    entity: str
    calculation: Optional[Calculation] = 'conversion_rate'
    window: Optional[Window4] = None
    constant_properties: Optional[List[ConstantProperty]] = None


class CumulativeTypeParams1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    window: Optional[Window4] = None
    grain_to_date: Optional[str] = None
    period_agg: Optional[PeriodAgg] = 'first'


class TypeParams1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[Measure1] = None
    input_measures: Optional[List[InputMeasure1]] = None
    numerator: Optional[Numerator1] = None
    denominator: Optional[Denominator1] = None
    expr: Optional[str] = None
    window: Optional[Window3] = None
    grain_to_date: Optional[GrainToDate] = None
    metrics: Optional[List[Metric1]] = None
    conversion_type_params: Optional[ConversionTypeParams1] = None
    cumulative_type_params: Optional[CumulativeTypeParams1] = None


class Filter15(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class Metadata2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Config27(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class Disabled10(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['metric']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Type23
    type_params: TypeParams1 = Field(..., title='MetricTypeParams')
    filter: Optional[Filter15] = None
    metadata: Optional[Metadata2] = None
    time_granularity: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[Config27] = Field(None, title='MetricConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    sources: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    refs: Optional[List[Ref]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None
    group: Optional[str] = None


class Where(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class QueryParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metrics: List[str]
    group_by: List[str]
    where: Optional[Where] = None
    order_by: Optional[List[str]] = None
    limit: Optional[int] = None


class ExportAs(Enum):
    table = 'table'
    view = 'view'


class Config28(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    export_as: ExportAs
    schema_name: Optional[str] = None
    alias: Optional[str] = None
    database: Optional[str] = None


class Export(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    config: Config28 = Field(..., title='ExportConfig')
    unrendered_config: Optional[Dict[str, str]] = None


class Metadata3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Cache(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Optional[bool] = False


class Config29(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None
    export_as: Optional[ExportAs] = None
    schema_: Optional[str] = Field(None, alias='schema')
    cache: Optional[Cache] = Field(None, title='SavedQueryCache')


class Disabled11(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['saved_query']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    query_params: QueryParams = Field(..., title='QueryParams')
    exports: List[Export]
    description: Optional[str] = None
    label: Optional[str] = None
    metadata: Optional[Metadata3] = None
    config: Optional[Config29] = Field(None, title='SavedQueryConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    created_at: Optional[float] = None
    refs: Optional[List[Ref]] = None


class NodeRelation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    alias: str
    schema_name: str
    database: Optional[str] = None
    relation_name: Optional[str] = ''


class Defaults(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    agg_time_dimension: Optional[str] = None


class Type24(Enum):
    foreign = 'foreign'
    natural = 'natural'
    primary = 'primary'
    unique = 'unique'


class Entity(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type24
    description: Optional[str] = None
    label: Optional[str] = None
    role: Optional[str] = None
    expr: Optional[str] = None


class Agg(Enum):
    sum = 'sum'
    min = 'min'
    max = 'max'
    count_distinct = 'count_distinct'
    sum_boolean = 'sum_boolean'
    average = 'average'
    percentile = 'percentile'
    median = 'median'
    count = 'count'


class AggParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    percentile: Optional[float] = None
    use_discrete_percentile: Optional[bool] = False
    use_approximate_percentile: Optional[bool] = False


class WindowChoice(Enum):
    sum = 'sum'
    min = 'min'
    max = 'max'
    count_distinct = 'count_distinct'
    sum_boolean = 'sum_boolean'
    average = 'average'
    percentile = 'percentile'
    median = 'median'
    count = 'count'


class NonAdditiveDimension(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    window_choice: WindowChoice
    window_groupings: List[str]


class Measure2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    agg: Agg
    description: Optional[str] = None
    label: Optional[str] = None
    create_metric: Optional[bool] = False
    expr: Optional[str] = None
    agg_params: Optional[AggParams] = None
    non_additive_dimension: Optional[NonAdditiveDimension] = None
    agg_time_dimension: Optional[str] = None


class Type25(Enum):
    categorical = 'categorical'
    time = 'time'


class TimeGranularity(Enum):
    nanosecond = 'nanosecond'
    microsecond = 'microsecond'
    millisecond = 'millisecond'
    second = 'second'
    minute = 'minute'
    hour = 'hour'
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class ValidityParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    is_start: Optional[bool] = False
    is_end: Optional[bool] = False


class TypeParams2(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    time_granularity: TimeGranularity
    validity_params: Optional[ValidityParams] = None


class Metadata4(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Dimension(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type25
    description: Optional[str] = None
    label: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[TypeParams2] = None
    expr: Optional[str] = None
    metadata: Optional[Metadata4] = None


class Metadata5(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Config30(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class Disabled12(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    label: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity]] = None
    measures: Optional[List[Measure2]] = None
    dimensions: Optional[List[Dimension]] = None
    metadata: Optional[Metadata5] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    refs: Optional[List[Ref]] = None
    created_at: Optional[float] = None
    config: Optional[Config30] = Field(None, title='SemanticModelConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    primary_entity: Optional[str] = None
    group: Optional[str] = None


class Format(Enum):
    csv = 'csv'
    dict = 'dict'
    sql = 'sql'


class GivenItem(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    input: str
    rows: Optional[Union[str, List[Dict[str, Any]]]] = None
    format: Optional[Format] = 'dict'
    fixture: Optional[str] = None


class Expect(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    rows: Optional[Union[str, List[Dict[str, Any]]]] = None
    format: Optional[Format] = 'dict'
    fixture: Optional[str] = None


class Overrides(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[Dict[str, Any]] = None
    vars: Optional[Dict[str, Any]] = None
    env_vars: Optional[Dict[str, Any]] = None


class Config31(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    tags: Optional[Union[str, List[str]]] = None
    meta: Optional[Dict[str, Any]] = None
    enabled: Optional[bool] = True


class Versions(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    include: Optional[List[Union[str, float]]] = None
    exclude: Optional[List[Union[str, float]]] = None


class Disabled13(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    model: str
    given: List[GivenItem]
    expect: Expect = Field(..., title='UnitTestOutputFixture')
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: Optional[str] = ''
    overrides: Optional[Overrides] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    config: Optional[Config31] = Field(None, title='UnitTestConfig')
    checksum: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    created_at: Optional[float] = None
    versions: Optional[Versions] = None
    version: Optional[Union[str, float]] = None


class Where1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class QueryParams1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metrics: List[str]
    group_by: List[str]
    where: Optional[Where1] = None
    order_by: Optional[List[str]] = None
    limit: Optional[int] = None


class Config32(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    export_as: ExportAs
    schema_name: Optional[str] = None
    alias: Optional[str] = None
    database: Optional[str] = None


class Export1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    config: Config32 = Field(..., title='ExportConfig')
    unrendered_config: Optional[Dict[str, str]] = None


class Metadata6(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Config33(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None
    export_as: Optional[ExportAs] = None
    schema_: Optional[str] = Field(None, alias='schema')
    cache: Optional[Cache] = Field(None, title='SavedQueryCache')


class SavedQueries(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['saved_query']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    query_params: QueryParams1 = Field(..., title='QueryParams')
    exports: List[Export1]
    description: Optional[str] = None
    label: Optional[str] = None
    metadata: Optional[Metadata6] = None
    config: Optional[Config33] = Field(None, title='SavedQueryConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    created_at: Optional[float] = None
    refs: Optional[List[Ref]] = None


class Type26(Enum):
    foreign = 'foreign'
    natural = 'natural'
    primary = 'primary'
    unique = 'unique'


class Entity1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type26
    description: Optional[str] = None
    label: Optional[str] = None
    role: Optional[str] = None
    expr: Optional[str] = None


class NonAdditiveDimension1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    window_choice: WindowChoice
    window_groupings: List[str]


class Measure3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    agg: Agg
    description: Optional[str] = None
    label: Optional[str] = None
    create_metric: Optional[bool] = False
    expr: Optional[str] = None
    agg_params: Optional[AggParams] = None
    non_additive_dimension: Optional[NonAdditiveDimension1] = None
    agg_time_dimension: Optional[str] = None


class Type27(Enum):
    categorical = 'categorical'
    time = 'time'


class TypeParams3(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    time_granularity: TimeGranularity
    validity_params: Optional[ValidityParams] = None


class Metadata7(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Dimension1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type27
    description: Optional[str] = None
    label: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[TypeParams3] = None
    expr: Optional[str] = None
    metadata: Optional[Metadata7] = None


class Metadata8(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class Config34(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class SemanticModels(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    label: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity1]] = None
    measures: Optional[List[Measure3]] = None
    dimensions: Optional[List[Dimension1]] = None
    metadata: Optional[Metadata8] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    refs: Optional[List[Ref]] = None
    created_at: Optional[float] = None
    config: Optional[Config34] = Field(None, title='SemanticModelConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    primary_entity: Optional[str] = None
    group: Optional[str] = None


class GivenItem1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    input: str
    rows: Optional[Union[str, List[Dict[str, Any]]]] = None
    format: Optional[Format] = 'dict'
    fixture: Optional[str] = None


class Expect1(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    rows: Optional[Union[str, List[Dict[str, Any]]]] = None
    format: Optional[Format] = 'dict'
    fixture: Optional[str] = None


class Config35(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    tags: Optional[Union[str, List[str]]] = None
    meta: Optional[Dict[str, Any]] = None
    enabled: Optional[bool] = True


class UnitTests(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    model: str
    given: List[GivenItem1]
    expect: Expect1 = Field(..., title='UnitTestOutputFixture')
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: Optional[str] = ''
    overrides: Optional[Overrides] = None
    depends_on: Optional[DependsOn12] = Field(None, title='DependsOn')
    config: Optional[Config35] = Field(None, title='UnitTestConfig')
    checksum: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    created_at: Optional[float] = None
    versions: Optional[Versions] = None
    version: Optional[Union[str, float]] = None


class ManifestV12(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: Metadata = Field(
        ..., description='Metadata about the manifest', title='ManifestMetadata'
    )
    nodes: Dict[
        str, Union[Nodes, Nodes1, Nodes2, Nodes3, Nodes4, Nodes5, Nodes6, Nodes7]
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, Sources] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, Macros] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, Docs18] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, Exposures] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, Metrics] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    groups: Dict[str, Groups] = Field(
        ..., description='The groups defined in the dbt project'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Dict[
            str,
            List[
                Union[
                    Disabled,
                    Disabled1,
                    Disabled2,
                    Disabled3,
                    Disabled4,
                    Disabled5,
                    Disabled6,
                    Disabled7,
                    Disabled8,
                    Disabled9,
                    Disabled10,
                    Disabled11,
                    Disabled12,
                    Disabled13,
                ]
            ],
        ]
    ] = Field(..., description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from parent nodes to their dependents'
    )
    group_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from group names to their nodes'
    )
    saved_queries: Dict[str, SavedQueries] = Field(
        ..., description='The saved queries defined in the dbt project'
    )
    semantic_models: Dict[str, SemanticModels] = Field(
        ..., description='The semantic models defined in the dbt project'
    )
    unit_tests: Dict[str, UnitTests] = Field(
        ..., description='The unit tests defined in the project'
    )
