# generated by datamodel-codegen:
#   filename:  manifest_v11.json

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union
from uuid import UUID

from pydantic import ConfigDict, Field, constr

from dbt_artifacts_parser.parsers.base import BaseParserModel


class ManifestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[str] = None
    dbt_version: Optional[str] = '1.8.0a1'
    generated_at: Optional[str] = None
    invocation_id: Optional[str] = None
    env: Optional[Dict[str, str]] = None
    project_name: Optional[str] = Field(None, description='Name of the root project')
    project_id: Optional[str] = Field(
        None,
        description='A unique identifier for the project, hashed from the project name',
    )
    user_id: Optional[UUID] = Field(
        None, description='A unique identifier for the user'
    )
    send_anonymous_usage_stats: Optional[bool] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[str] = Field(
        None, description='The type name of the adapter'
    )


class FileHash(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    checksum: str


class Hook(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class Docs(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True
    node_color: Optional[str] = None


class ContractConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class OnConfigurationChange(Enum):
    apply = 'apply'
    continue_ = 'continue'
    fail = 'fail'


class NodeConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = None
    contract: Optional[ContractConfig] = None


class Type(Enum):
    check = 'check'
    not_null = 'not_null'
    unique = 'unique'
    primary_key = 'primary_key'
    foreign_key = 'foreign_key'
    custom = 'custom'


class ColumnLevelConstraint(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True


class ColumnInfo(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[ColumnLevelConstraint]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')


class RefArgs(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    package: Optional[str] = None
    version: Optional[Union[str, float]] = None


class DependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None
    nodes: Optional[List[str]] = None


class InjectedCTE(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    sql: str


class Contract(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class AnalysisNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['analysis']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None


class TestConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[
        constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')
    ] = 'ERROR'
    store_failures: Optional[bool] = None
    store_failures_as: Optional[str] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class SingularTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None


class HookNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None
    index: Optional[int] = None


class Access(Enum):
    private = 'private'
    protected = 'protected'
    public = 'public'


class ModelConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = None
    contract: Optional[ContractConfig] = None
    access: Optional[Access] = 'protected'


class ModelLevelConstraint(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    columns: Optional[List[str]] = None


class DeferRelation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None


class ModelNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['model']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[ModelConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None
    access: Optional[Access] = 'protected'
    constraints: Optional[List[ModelLevelConstraint]] = None
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[str] = None
    defer_relation: Optional[DeferRelation] = None


class RPCNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['rpc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None


class SqlNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['sql_operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None


class TestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    kwargs: Optional[Dict[str, Any]] = None
    namespace: Optional[str] = None


class GenericTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    test_metadata: TestMetadata
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None


class SnapshotConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[str] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = None
    contract: Optional[ContractConfig] = None
    strategy: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None


class SnapshotNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['snapshot']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: SnapshotConfig
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = None
    defer_relation: Optional[DeferRelation] = None


class SeedConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = None
    contract: Optional[ContractConfig] = None
    delimiter: Optional[str] = ','
    quote_columns: Optional[bool] = None


class MacroDependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None


class SeedNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['seed']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = None
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[MacroDependsOn] = None
    defer_relation: Optional[DeferRelation] = None


class Quoting(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[bool] = None
    schema_: Optional[bool] = Field(None, alias='schema')
    identifier: Optional[bool] = None
    column: Optional[bool] = None


class Period(Enum):
    minute = 'minute'
    hour = 'hour'
    day = 'day'


class Time(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class FreshnessThreshold(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[Time] = None
    error_after: Optional[Time] = None
    filter: Optional[str] = None


class ExternalPartition(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None


class ExternalTable(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[Union[List[str], List[ExternalPartition]]] = None


class SourceConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True


class SourceDefinition(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['source']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    quoting: Optional[Quoting] = None
    loaded_at_field: Optional[str] = None
    freshness: Optional[FreshnessThreshold] = None
    external: Optional[ExternalTable] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    source_meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[SourceConfig] = None
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    created_at: Optional[float] = None


class MacroArgument(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Optional[str] = None
    description: Optional[str] = ''


class SupportedLanguage(Enum):
    python = 'python'
    sql = 'sql'


class Macro(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['macro']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    macro_sql: str
    depends_on: Optional[MacroDependsOn] = None
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    docs: Optional[Docs] = None
    patch_path: Optional[str] = None
    arguments: Optional[List[MacroArgument]] = None
    created_at: Optional[float] = None
    supported_languages: Optional[List[SupportedLanguage]] = None


class Documentation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['doc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    block_contents: str


class Owner(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    email: Optional[str] = None
    name: Optional[str] = None


class ExposureConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True


class Type2(Enum):
    dashboard = 'dashboard'
    notebook = 'notebook'
    analysis = 'analysis'
    ml = 'ml'
    application = 'application'


class Maturity(Enum):
    low = 'low'
    medium = 'medium'
    high = 'high'


class Exposure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['exposure']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    type: Type2
    owner: Owner
    description: Optional[str] = ''
    label: Optional[str] = None
    maturity: Optional[Maturity] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[ExposureConfig] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    url: Optional[str] = None
    depends_on: Optional[DependsOn] = None
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None


class WhereFilter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_sql_template: str


class WhereFilterIntersection(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class MetricInputMeasure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class Granularity(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class MetricTimeWindow(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: Granularity


class OffsetToGrain(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class MetricInput(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[OffsetToGrain] = None


class GrainToDate(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class MetricTypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[MetricInputMeasure] = None
    input_measures: Optional[List[MetricInputMeasure]] = None
    numerator: Optional[MetricInput] = None
    denominator: Optional[MetricInput] = None
    expr: Optional[str] = None
    window: Optional[MetricTimeWindow] = None
    grain_to_date: Optional[GrainToDate] = None
    metrics: Optional[List[MetricInput]] = None


class FileSlice(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    filename: str
    content: str
    start_line_number: int
    end_line_number: int


class SourceFileMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice


class MetricConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None


class Type3(Enum):
    simple = 'simple'
    ratio = 'ratio'
    cumulative = 'cumulative'
    derived = 'derived'


class Metric(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['metric']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Type3
    type_params: MetricTypeParams
    filter: Optional[WhereFilterIntersection] = None
    metadata: Optional[SourceFileMetadata] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[MetricConfig] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    sources: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = None
    refs: Optional[List[RefArgs]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None
    group: Optional[str] = None


class Group(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['group']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    owner: Owner


class QueryParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metrics: List[str]
    group_by: List[str]
    where: Optional[WhereFilterIntersection] = None


class ExportAs(Enum):
    table = 'table'
    view = 'view'


class ExportConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    export_as: ExportAs
    schema_name: Optional[str] = None
    alias: Optional[str] = None


class Export(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    config: ExportConfig


class SavedQueryConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class ResourceType(Enum):
    model = 'model'
    analysis = 'analysis'
    test = 'test'
    snapshot = 'snapshot'
    operation = 'operation'
    seed = 'seed'
    rpc = 'rpc'
    sql_operation = 'sql_operation'
    doc = 'doc'
    source = 'source'
    macro = 'macro'
    exposure = 'exposure'
    metric = 'metric'
    group = 'group'
    saved_query = 'saved_query'
    semantic_model = 'semantic_model'


class SavedQuery(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    query_params: QueryParams
    exports: List[Export]
    description: Optional[str] = None
    label: Optional[str] = None
    metadata: Optional[SourceFileMetadata] = None
    config: Optional[SavedQueryConfig] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    depends_on: Optional[DependsOn] = None
    created_at: Optional[float] = None
    refs: Optional[List[RefArgs]] = None


class NodeRelation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    alias: str
    schema_name: str
    database: Optional[str] = None
    relation_name: Optional[str] = None


class Defaults(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    agg_time_dimension: Optional[str] = None


class Type4(Enum):
    foreign = 'foreign'
    natural = 'natural'
    primary = 'primary'
    unique = 'unique'


class Entity(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type4
    description: Optional[str] = None
    label: Optional[str] = None
    role: Optional[str] = None
    expr: Optional[str] = None


class MeasureAggregationParameters(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    percentile: Optional[float] = None
    use_discrete_percentile: Optional[bool] = False
    use_approximate_percentile: Optional[bool] = False


class WindowChoice(Enum):
    sum = 'sum'
    min = 'min'
    max = 'max'
    count_distinct = 'count_distinct'
    sum_boolean = 'sum_boolean'
    average = 'average'
    percentile = 'percentile'
    median = 'median'
    count = 'count'


class NonAdditiveDimension(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    window_choice: WindowChoice
    window_groupings: List[str]


class Agg(Enum):
    sum = 'sum'
    min = 'min'
    max = 'max'
    count_distinct = 'count_distinct'
    sum_boolean = 'sum_boolean'
    average = 'average'
    percentile = 'percentile'
    median = 'median'
    count = 'count'


class Measure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    agg: Agg
    description: Optional[str] = None
    label: Optional[str] = None
    create_metric: Optional[bool] = False
    expr: Optional[str] = None
    agg_params: Optional[MeasureAggregationParameters] = None
    non_additive_dimension: Optional[NonAdditiveDimension] = None
    agg_time_dimension: Optional[str] = None


class DimensionValidityParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    is_start: Optional[bool] = False
    is_end: Optional[bool] = False


class TimeGranularity(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class DimensionTypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    time_granularity: TimeGranularity
    validity_params: Optional[DimensionValidityParams] = None


class Type5(Enum):
    categorical = 'categorical'
    time = 'time'


class Dimension(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type5
    description: Optional[str] = None
    label: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[DimensionTypeParams] = None
    expr: Optional[str] = None
    metadata: Optional[SourceFileMetadata] = None


class SemanticModelConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class SemanticModel(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    label: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity]] = None
    measures: Optional[List[Measure]] = None
    dimensions: Optional[List[Dimension]] = None
    metadata: Optional[SourceFileMetadata] = None
    depends_on: Optional[DependsOn] = None
    refs: Optional[List[RefArgs]] = None
    created_at: Optional[float] = None
    config: Optional[SemanticModelConfig] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    primary_entity: Optional[str] = None
    group: Optional[str] = None


class ManifestV11(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: ManifestMetadata = Field(..., description='Metadata about the manifest')
    nodes: Dict[
        str,
        Union[
            AnalysisNode,
            SingularTestNode,
            HookNode,
            ModelNode,
            RPCNode,
            SqlNode,
            GenericTestNode,
            SnapshotNode,
            SeedNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, SourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, Macro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, Documentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, Exposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, Metric] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    groups: Dict[str, Group] = Field(
        ..., description='The groups defined in the dbt project'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Dict[
            str,
            List[
                Union[
                    AnalysisNode,
                    SingularTestNode,
                    HookNode,
                    ModelNode,
                    RPCNode,
                    SqlNode,
                    GenericTestNode,
                    SnapshotNode,
                    SeedNode,
                    SourceDefinition,
                    Exposure,
                    Metric,
                    SavedQuery,
                    SemanticModel,
                ]
            ],
        ]
    ] = Field(..., description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from parent nodes to their dependents'
    )
    group_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from group names to their nodes'
    )
    saved_queries: Dict[str, SavedQuery] = Field(
        ..., description='The saved queries defined in the dbt project'
    )
    semantic_models: Dict[str, SemanticModel] = Field(
        ..., description='The semantic models defined in the dbt project'
    )


# NOTE: We manually change the class, as the generated code is not correct.
# class ManifestV11(RootModel[WritableManifest]):
#     root: WritableManifest
