# generated by datamodel-codegen:
#   filename:  manifest_v10.json

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import AwareDatetime, ConfigDict, Field, constr

from dbt_artifacts_parser.parsers.base import BaseParserModel


class ManifestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[
        str
    ] = 'https://schemas.getdbt.com/dbt/manifest/v10.json'
    dbt_version: Optional[str] = '1.6.0'
    generated_at: Optional[AwareDatetime] = '2023-08-07T20:10:03.381822Z'
    invocation_id: Optional[str] = '03dee192-ff77-43cc-bc3f-5eeaf6d36344'
    env: Optional[Dict[str, str]] = {}
    project_name: Optional[str] = Field(None, description='Name of the root project')
    project_id: Optional[str] = Field(
        None,
        description='A unique identifier for the project, hashed from the project name',
    )
    user_id: Optional[
        constr(pattern=r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}')
    ] = Field(None, description='A unique identifier for the user')
    send_anonymous_usage_stats: Optional[bool] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[str] = Field(
        None, description='The type name of the adapter'
    )


class ResourceType(Enum):
    analysis = 'analysis'


class FileHash(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    checksum: str


class OnConfigurationChange(Enum):
    apply = 'apply'
    continue_ = 'continue'
    fail = 'fail'


class Hook(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class Docs(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True
    node_color: Optional[str] = None


class ContractConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False


class Type(Enum):
    check = 'check'
    not_null = 'not_null'
    unique = 'unique'
    primary_key = 'primary_key'
    foreign_key = 'foreign_key'
    custom = 'custom'


class ColumnLevelConstraint(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True


class RefArgs(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    package: Optional[str] = None
    version: Optional[Union[str, float]] = None


class DependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = []
    nodes: Optional[List[str]] = []


class InjectedCTE(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    sql: str


class Contract(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    checksum: Optional[str] = None


class ResourceType1(Enum):
    test = 'test'


class TestConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[
        constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')
    ] = 'ERROR'
    store_failures: Optional[bool] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class ResourceType2(Enum):
    operation = 'operation'


class ResourceType3(Enum):
    model = 'model'


class Access(Enum):
    protected = 'protected'
    private = 'private'
    public = 'public'


class ModelLevelConstraint(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    columns: Optional[List[str]] = []


class DeferRelation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None


class ResourceType4(Enum):
    rpc = 'rpc'


class ResourceType5(Enum):
    sql_operation = 'sql_operation'


class ResourceType6(Enum):
    test = 'test'


class TestMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    kwargs: Optional[Dict[str, Any]] = {}
    namespace: Optional[str] = None


class ResourceType7(Enum):
    snapshot = 'snapshot'


class SnapshotConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    unique_key: Optional[str] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = 'apply'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    contract: Optional[ContractConfig] = Field(
        default_factory=lambda: ContractConfig.model_validate({'enforced': False})
    )
    strategy: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None


class ResourceType8(Enum):
    seed = 'seed'


class SeedConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = 'apply'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    contract: Optional[ContractConfig] = Field(
        default_factory=lambda: ContractConfig.model_validate({'enforced': False})
    )
    quote_columns: Optional[bool] = None


class MacroDependsOn(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = []


class ResourceType9(Enum):
    source = 'source'


class Quoting(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[bool] = None
    schema_: Optional[bool] = Field(None, alias='schema')
    identifier: Optional[bool] = None
    column: Optional[bool] = None


class Period(Enum):
    minute = 'minute'
    hour = 'hour'
    day = 'day'


class Time(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Period] = None


class ExternalPartition(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}


class SourceConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True


class ResourceType10(Enum):
    macro = 'macro'


class SupportedLanguage(Enum):
    python = 'python'
    sql = 'sql'


class MacroArgument(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Optional[str] = None
    description: Optional[str] = ''


class ResourceType11(Enum):
    doc = 'doc'


class Documentation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType11
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    block_contents: str


class ResourceType12(Enum):
    exposure = 'exposure'


class Type2(Enum):
    dashboard = 'dashboard'
    notebook = 'notebook'
    analysis = 'analysis'
    ml = 'ml'
    application = 'application'


class Maturity(Enum):
    low = 'low'
    medium = 'medium'
    high = 'high'


class Owner(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    email: Optional[str] = None
    name: Optional[str] = None


class ExposureConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True


class ResourceType13(Enum):
    metric = 'metric'


class Type3(Enum):
    simple = 'simple'
    ratio = 'ratio'
    cumulative = 'cumulative'
    derived = 'derived'


class GrainToDate(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class WhereFilter(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_sql_template: str


class OffsetToGrain(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class Granularity(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class MetricTimeWindow(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: Granularity


class FileSlice(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    filename: str
    content: str
    start_line_number: int
    end_line_number: int


class MetricConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    group: Optional[str] = None


class ResourceType14(Enum):
    group = 'group'


class Group(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType14
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    owner: Owner


class ResourceType15(Enum):
    model = 'model'
    analysis = 'analysis'
    test = 'test'
    snapshot = 'snapshot'
    operation = 'operation'
    seed = 'seed'
    rpc = 'rpc'
    sql_operation = 'sql_operation'
    doc = 'doc'
    source = 'source'
    macro = 'macro'
    exposure = 'exposure'
    metric = 'metric'
    group = 'group'
    semantic_model = 'semantic_model'


class NodeRelation(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    alias: str
    schema_name: str
    database: Optional[str] = None
    relation_name: Optional[str] = None


class Defaults(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    agg_time_dimension: Optional[str] = None


class Type4(Enum):
    foreign = 'foreign'
    natural = 'natural'
    primary = 'primary'
    unique = 'unique'


class Entity(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type4
    description: Optional[str] = None
    role: Optional[str] = None
    expr: Optional[str] = None


class Agg(Enum):
    sum = 'sum'
    min = 'min'
    max = 'max'
    count_distinct = 'count_distinct'
    sum_boolean = 'sum_boolean'
    average = 'average'
    percentile = 'percentile'
    median = 'median'
    count = 'count'


class MeasureAggregationParameters(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    percentile: Optional[float] = None
    use_discrete_percentile: Optional[bool] = False
    use_approximate_percentile: Optional[bool] = False


class WindowChoice(Enum):
    sum = 'sum'
    min = 'min'
    max = 'max'
    count_distinct = 'count_distinct'
    sum_boolean = 'sum_boolean'
    average = 'average'
    percentile = 'percentile'
    median = 'median'
    count = 'count'


class NonAdditiveDimension(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    window_choice: WindowChoice
    window_groupings: List[str]


class Type5(Enum):
    categorical = 'categorical'
    time = 'time'


class TimeGranularity(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class DimensionValidityParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    is_start: Optional[bool] = False
    is_end: Optional[bool] = False


class SemanticModelConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True


class NodeConfig(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[OnConfigurationChange] = 'apply'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    contract: Optional[ContractConfig] = Field(
        default_factory=lambda: ContractConfig.model_validate({'enforced': False})
    )


class ColumnInfo(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    data_type: Optional[str] = None
    constraints: Optional[List[ColumnLevelConstraint]] = []
    quote: Optional[bool] = None
    tags: Optional[List[str]] = []


class SingularTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType1
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.389955
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class HookNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType2
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.3916101
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    index: Optional[int] = None


class ModelNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType3
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.393298
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    access: Optional[Access] = 'protected'
    constraints: Optional[List[ModelLevelConstraint]] = []
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[AwareDatetime] = None
    defer_relation: Optional[DeferRelation] = None


class RPCNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType4
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.39583
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class SqlNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType5
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.3974268
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class GenericTestNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    test_metadata: TestMetadata
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType6
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.399393
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None


class SnapshotNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType7
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: SnapshotConfig
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.4026701
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    defer_relation: Optional[DeferRelation] = None


class SeedNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType8
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = Field(
        default_factory=lambda: SeedConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'seed',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'quote_columns': None,
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.4056058
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[MacroDependsOn] = Field(
        default_factory=lambda: MacroDependsOn.model_validate({'macros': []})
    )
    defer_relation: Optional[DeferRelation] = None


class FreshnessThreshold(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[Time] = {'count': None, 'period': None}
    error_after: Optional[Time] = {'count': None, 'period': None}
    filter: Optional[str] = None


class ExternalTable(BaseParserModel):
    model_config = ConfigDict(
        extra='allow',
    )
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[Union[List[str], List[ExternalPartition]]] = None


class Macro(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType10
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    macro_sql: str
    depends_on: Optional[MacroDependsOn] = Field(
        default_factory=lambda: MacroDependsOn.model_validate({'macros': []})
    )
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    arguments: Optional[List[MacroArgument]] = []
    created_at: Optional[float] = 1691439003.409885
    supported_languages: Optional[List[SupportedLanguage]] = None


class Exposure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType12
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    type: Type2
    owner: Owner
    description: Optional[str] = ''
    label: Optional[str] = None
    maturity: Optional[Maturity] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[ExposureConfig] = Field(
        default_factory=lambda: ExposureConfig.model_validate({'enabled': True})
    )
    unrendered_config: Optional[Dict[str, Any]] = {}
    url: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1691439003.411563


class MetricInputMeasure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilter] = None
    alias: Optional[str] = None


class MetricInput(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilter] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[OffsetToGrain] = None


class SourceFileMetadata(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice


class Measure(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    agg: Agg
    description: Optional[str] = None
    create_metric: Optional[bool] = False
    expr: Optional[str] = None
    agg_params: Optional[MeasureAggregationParameters] = None
    non_additive_dimension: Optional[NonAdditiveDimension] = None
    agg_time_dimension: Optional[str] = None


class DimensionTypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    time_granularity: TimeGranularity
    validity_params: Optional[DimensionValidityParams] = None


class AnalysisNode(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1691439003.386713
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class SourceDefinition(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: ResourceType9
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    quoting: Optional[Quoting] = Field(
        default_factory=lambda: Quoting.model_validate(
            {'database': None, 'schema': None, 'identifier': None, 'column': None}
        )
    )
    loaded_at_field: Optional[str] = None
    freshness: Optional[FreshnessThreshold] = None
    external: Optional[ExternalTable] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    source_meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[SourceConfig] = Field(
        default_factory=lambda: SourceConfig.model_validate({'enabled': True})
    )
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    created_at: Optional[float] = 1691439003.408927


class MetricTypeParams(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[MetricInputMeasure] = None
    input_measures: Optional[List[MetricInputMeasure]] = []
    numerator: Optional[MetricInput] = None
    denominator: Optional[MetricInput] = None
    expr: Optional[str] = None
    window: Optional[MetricTimeWindow] = None
    grain_to_date: Optional[GrainToDate] = None
    metrics: Optional[List[MetricInput]] = None


class Dimension(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Type5
    description: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[DimensionTypeParams] = None
    expr: Optional[str] = None
    metadata: Optional[SourceFileMetadata] = None


class Metric(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType13
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Type3
    type_params: MetricTypeParams
    filter: Optional[WhereFilter] = None
    metadata: Optional[SourceFileMetadata] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[MetricConfig] = Field(
        default_factory=lambda: MetricConfig.model_validate(
            {'enabled': True, 'group': None}
        )
    )
    unrendered_config: Optional[Dict[str, Any]] = {}
    sources: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[RefArgs]] = []
    metrics: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1691439003.41419
    group: Optional[str] = None


class SemanticModel(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: ResourceType15
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity]] = []
    measures: Optional[List[Measure]] = []
    dimensions: Optional[List[Dimension]] = []
    metadata: Optional[SourceFileMetadata] = None
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[RefArgs]] = []
    created_at: Optional[float] = 1691439003.4182558
    config: Optional[SemanticModelConfig] = Field(
        default_factory=lambda: SemanticModelConfig.model_validate({'enabled': True})
    )
    primary_entity: Optional[str] = None


class ManifestV10(BaseParserModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: ManifestMetadata = Field(..., description='Metadata about the manifest')
    nodes: Dict[
        str,
        Union[
            AnalysisNode,
            SingularTestNode,
            HookNode,
            ModelNode,
            RPCNode,
            SqlNode,
            GenericTestNode,
            SnapshotNode,
            SeedNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, SourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, Macro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, Documentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, Exposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, Metric] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    groups: Dict[str, Group] = Field(
        ..., description='The groups defined in the dbt project'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Dict[
            str,
            List[
                Union[
                    AnalysisNode,
                    SingularTestNode,
                    HookNode,
                    ModelNode,
                    RPCNode,
                    SqlNode,
                    GenericTestNode,
                    SnapshotNode,
                    SeedNode,
                    SourceDefinition,
                    Exposure,
                    Metric,
                    SemanticModel,
                ]
            ],
        ]
    ] = Field(None, description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from parent nodes to their dependents'
    )
    group_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from group names to their nodes'
    )
    semantic_models: Dict[str, SemanticModel] = Field(
        ..., description='The semantic models defined in the dbt project'
    )
