/*
 * Copyright (c) 2015, 2016, Yutaka Tsutano
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef JITANA_OPCODE_HPP
#define JITANA_OPCODE_HPP

#include <cstdint>

namespace jitana {
    // clang-format off
    enum class opcode : uint8_t {
        op_nop                         = 0x00,
        op_move                        = 0x01,
        op_move_from16                 = 0x02,
        op_move_16                     = 0x03,
        op_move_wide                   = 0x04,
        op_move_wide_from16            = 0x05,
        op_move_wide_16                = 0x06,
        op_move_object                 = 0x07,
        op_move_object_from16          = 0x08,
        op_move_object_16              = 0x09,
        op_move_result                 = 0x0a,
        op_move_result_wide            = 0x0b,
        op_move_result_object          = 0x0c,
        op_move_exception              = 0x0d,
        op_return_void                 = 0x0e,
        op_return                      = 0x0f,
        op_return_wide                 = 0x10,
        op_return_object               = 0x11,
        op_const_4                     = 0x12,
        op_const_16                    = 0x13,
        op_const                       = 0x14,
        op_const_high16                = 0x15,
        op_const_wide_16               = 0x16,
        op_const_wide_32               = 0x17,
        op_const_wide                  = 0x18,
        op_const_wide_high16           = 0x19,
        op_const_string                = 0x1a,
        op_const_string_jumbo          = 0x1b,
        op_const_class                 = 0x1c,
        op_monitor_enter               = 0x1d,
        op_monitor_exit                = 0x1e,
        op_check_cast                  = 0x1f,
        op_instance_of                 = 0x20,
        op_array_length                = 0x21,
        op_new_instance                = 0x22,
        op_new_array                   = 0x23,
        op_filled_new_array            = 0x24,
        op_filled_new_array_range      = 0x25,
        op_fill_array_data             = 0x26,
        op_throw                       = 0x27,
        op_goto                        = 0x28,
        op_goto_16                     = 0x29,
        op_goto_32                     = 0x2a,
        op_packed_switch               = 0x2b,
        op_sparse_switch               = 0x2c,
        op_cmpl_float                  = 0x2d,
        op_cmpg_float                  = 0x2e,
        op_cmpl_double                 = 0x2f,
        op_cmpg_double                 = 0x30,
        op_cmp_long                    = 0x31,
        op_if_eq                       = 0x32,
        op_if_ne                       = 0x33,
        op_if_lt                       = 0x34,
        op_if_ge                       = 0x35,
        op_if_gt                       = 0x36,
        op_if_le                       = 0x37,
        op_if_eqz                      = 0x38,
        op_if_nez                      = 0x39,
        op_if_ltz                      = 0x3a,
        op_if_gez                      = 0x3b,
        op_if_gtz                      = 0x3c,
        op_if_lez                      = 0x3d,
        op_3e                          = 0x3e,
        op_3f                          = 0x3f,
        op_40                          = 0x40,
        op_41                          = 0x41,
        op_42                          = 0x42,
        op_43                          = 0x43,
        op_aget                        = 0x44,
        op_aget_wide                   = 0x45,
        op_aget_object                 = 0x46,
        op_aget_boolean                = 0x47,
        op_aget_byte                   = 0x48,
        op_aget_char                   = 0x49,
        op_aget_short                  = 0x4a,
        op_aput                        = 0x4b,
        op_aput_wide                   = 0x4c,
        op_aput_object                 = 0x4d,
        op_aput_boolean                = 0x4e,
        op_aput_byte                   = 0x4f,
        op_aput_char                   = 0x50,
        op_aput_short                  = 0x51,
        op_iget                        = 0x52,
        op_iget_wide                   = 0x53,
        op_iget_object                 = 0x54,
        op_iget_boolean                = 0x55,
        op_iget_byte                   = 0x56,
        op_iget_char                   = 0x57,
        op_iget_short                  = 0x58,
        op_iput                        = 0x59,
        op_iput_wide                   = 0x5a,
        op_iput_object                 = 0x5b,
        op_iput_boolean                = 0x5c,
        op_iput_byte                   = 0x5d,
        op_iput_char                   = 0x5e,
        op_iput_short                  = 0x5f,
        op_sget                        = 0x60,
        op_sget_wide                   = 0x61,
        op_sget_object                 = 0x62,
        op_sget_boolean                = 0x63,
        op_sget_byte                   = 0x64,
        op_sget_char                   = 0x65,
        op_sget_short                  = 0x66,
        op_sput                        = 0x67,
        op_sput_wide                   = 0x68,
        op_sput_object                 = 0x69,
        op_sput_boolean                = 0x6a,
        op_sput_byte                   = 0x6b,
        op_sput_char                   = 0x6c,
        op_sput_short                  = 0x6d,
        op_invoke_virtual              = 0x6e,
        op_invoke_super                = 0x6f,
        op_invoke_direct               = 0x70,
        op_invoke_static               = 0x71,
        op_invoke_interface            = 0x72,
        op_73                          = 0x73,
        op_invoke_virtual_range        = 0x74,
        op_invoke_super_range          = 0x75,
        op_invoke_direct_range         = 0x76,
        op_invoke_static_range         = 0x77,
        op_invoke_interface_range      = 0x78,
        op_79                          = 0x79,
        op_7a                          = 0x7a,
        op_neg_int                     = 0x7b,
        op_not_int                     = 0x7c,
        op_neg_long                    = 0x7d,
        op_not_long                    = 0x7e,
        op_neg_float                   = 0x7f,
        op_neg_double                  = 0x80,
        op_int_to_long                 = 0x81,
        op_int_to_float                = 0x82,
        op_int_to_double               = 0x83,
        op_long_to_int                 = 0x84,
        op_long_to_float               = 0x85,
        op_long_to_double              = 0x86,
        op_float_to_int                = 0x87,
        op_float_to_long               = 0x88,
        op_float_to_double             = 0x89,
        op_double_to_int               = 0x8a,
        op_double_to_long              = 0x8b,
        op_double_to_float             = 0x8c,
        op_int_to_byte                 = 0x8d,
        op_int_to_char                 = 0x8e,
        op_int_to_short                = 0x8f,
        op_add_int                     = 0x90,
        op_sub_int                     = 0x91,
        op_mul_int                     = 0x92,
        op_div_int                     = 0x93,
        op_rem_int                     = 0x94,
        op_and_int                     = 0x95,
        op_or_int                      = 0x96,
        op_xor_int                     = 0x97,
        op_shl_int                     = 0x98,
        op_shr_int                     = 0x99,
        op_ushr_int                    = 0x9a,
        op_add_long                    = 0x9b,
        op_sub_long                    = 0x9c,
        op_mul_long                    = 0x9d,
        op_div_long                    = 0x9e,
        op_rem_long                    = 0x9f,
        op_and_long                    = 0xa0,
        op_or_long                     = 0xa1,
        op_xor_long                    = 0xa2,
        op_shl_long                    = 0xa3,
        op_shr_long                    = 0xa4,
        op_ushr_long                   = 0xa5,
        op_add_float                   = 0xa6,
        op_sub_float                   = 0xa7,
        op_mul_float                   = 0xa8,
        op_div_float                   = 0xa9,
        op_rem_float                   = 0xaa,
        op_add_double                  = 0xab,
        op_sub_double                  = 0xac,
        op_mul_double                  = 0xad,
        op_div_double                  = 0xae,
        op_rem_double                  = 0xaf,
        op_add_int_2addr               = 0xb0,
        op_sub_int_2addr               = 0xb1,
        op_mul_int_2addr               = 0xb2,
        op_div_int_2addr               = 0xb3,
        op_rem_int_2addr               = 0xb4,
        op_and_int_2addr               = 0xb5,
        op_or_int_2addr                = 0xb6,
        op_xor_int_2addr               = 0xb7,
        op_shl_int_2addr               = 0xb8,
        op_shr_int_2addr               = 0xb9,
        op_ushr_int_2addr              = 0xba,
        op_add_long_2addr              = 0xbb,
        op_sub_long_2addr              = 0xbc,
        op_mul_long_2addr              = 0xbd,
        op_div_long_2addr              = 0xbe,
        op_rem_long_2addr              = 0xbf,
        op_and_long_2addr              = 0xc0,
        op_or_long_2addr               = 0xc1,
        op_xor_long_2addr              = 0xc2,
        op_shl_long_2addr              = 0xc3,
        op_shr_long_2addr              = 0xc4,
        op_ushr_long_2addr             = 0xc5,
        op_add_float_2addr             = 0xc6,
        op_sub_float_2addr             = 0xc7,
        op_mul_float_2addr             = 0xc8,
        op_div_float_2addr             = 0xc9,
        op_rem_float_2addr             = 0xca,
        op_add_double_2addr            = 0xcb,
        op_sub_double_2addr            = 0xcc,
        op_mul_double_2addr            = 0xcd,
        op_div_double_2addr            = 0xce,
        op_rem_double_2addr            = 0xcf,
        op_add_int_lit16               = 0xd0,
        op_rsub_int                    = 0xd1,
        op_mul_int_lit16               = 0xd2,
        op_div_int_lit16               = 0xd3,
        op_rem_int_lit16               = 0xd4,
        op_and_int_lit16               = 0xd5,
        op_or_int_lit16                = 0xd6,
        op_xor_int_lit16               = 0xd7,
        op_add_int_lit8                = 0xd8,
        op_rsub_int_lit8               = 0xd9,
        op_mul_int_lit8                = 0xda,
        op_div_int_lit8                = 0xdb,
        op_rem_int_lit8                = 0xdc,
        op_and_int_lit8                = 0xdd,
        op_or_int_lit8                 = 0xde,
        op_xor_int_lit8                = 0xdf,
        op_shl_int_lit8                = 0xe0,
        op_shr_int_lit8                = 0xe1,
        op_ushr_int_lit8               = 0xe2,
        op_iget_volatile               = 0xe3,
        op_iput_volatile               = 0xe4,
        op_sget_volatile               = 0xe5,
        op_sput_volatile               = 0xe6,
        op_iget_object_volatile        = 0xe7,
        op_iget_wide_volatile          = 0xe8,
        op_iput_wide_volatile          = 0xe9,
        op_sget_wide_volatile          = 0xea,
        op_sput_wide_volatile          = 0xeb,
        op_ec                          = 0xec,
        op_throw_verification_error    = 0xed,
        op_execute_inline              = 0xee,
        op_execute_inline_range        = 0xef,
        op_invoke_object_init_range    = 0xf0,
        op_return_void_barrier         = 0xf1,
        op_iget_quick                  = 0xf2,
        op_iget_wide_quick             = 0xf3,
        op_iget_object_quick           = 0xf4,
        op_iput_quick                  = 0xf5,
        op_iput_wide_quick             = 0xf6,
        op_iput_object_quick           = 0xf7,
        op_invoke_virtual_quick        = 0xf8,
        op_invoke_virtual_quick_range  = 0xf9,
        op_invoke_super_quick          = 0xfa,
        op_invoke_super_quick_range    = 0xfb,
        op_iput_object_volatile        = 0xfc,
        op_sget_object_volatile        = 0xfd,
        op_sput_object_volatile        = 0xfe,
        op_ff                          = 0xff,
    };
    // clang-format on
}

#endif
