# 在 ImageNet 上表现出色的经典模型

ImageNet 是由李飞飞主导建立的一个超大的计算机视觉数据集。基于此数据集，自 2010 年至 2017 年举办 ImageNet 挑战赛，即 ImageNet Large Scale Visual Recognition Challenge (ILSVRC)。这篇文章以时间顺序记录了在 ImageNet 上表现出色的模型，很多也是 ILSVRC 上的冠军。

## 预训练模型使用方法

### TensorFlow

* [https://www.tensorflow.org/tutorials/images/transfer_learning](https://www.tensorflow.org/tutorials/images/transfer_learning)
* [https://keras.io/api/applications/](https://keras.io/api/applications/)

### PyTorch

* [https://pytorch.org/vision/stable/models.html](https://pytorch.org/vision/stable/models.html)
* [https://github.com/rwightman/pytorch-image-models](https://github.com/rwightman/pytorch-image-models)
* [https://pytorch.org/hub](https://pytorch.org/hub)
* [https://pytorch.org/tutorials/beginner/transfer_learning_tutorial.html](https://pytorch.org/tutorials/beginner/transfer_learning_tutorial.html)

## 模型论文

参考链接：[https://paperswithcode.com/sota/image-classification-on-imagenet](https://paperswithcode.com/sota/image-classification-on-imagenet)

### VGG <a id="VGG"></a>

**Very Deep Convolutional Networks for Large-Scale Image Recognition**  
[https://arxiv.org/abs/1409.1556](https://arxiv.org/abs/1409.1556)  
Submitted on 4 Sep 2014

### ResNet <a id="ResNet"></a>

**Deep Residual Learning for Image Recognition**  
[https://arxiv.org/abs/1512.03385](https://arxiv.org/abs/1512.03385)  
Submitted on 10 Dec 2015

### InceptionV3 <a id="InceptionV3"></a>

**Rethinking the Inception Architecture for Computer Vision**  
[https://arxiv.org/abs/1512.00567](https://arxiv.org/abs/1512.00567)  
Submitted on 2 Dec 2015

### InceptionResNetV2 <a id="InceptionResNetV2"></a>

**Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning**  
[https://arxiv.org/abs/1602.07261](https://arxiv.org/abs/1602.07261)  
Submitted on 23 Feb 2016

### DenseNet <a id="DenseNet"></a>

**Densely Connected Convolutional Networks**  
[https://arxiv.org/abs/1608.06993](https://arxiv.org/abs/1608.06993)  
Submitted on 25 Aug 2016

### Xception <a id="Xception"></a>

**Xception: Deep Learning with Depthwise Separable Convolutions**  
[https://arxiv.org/abs/1610.02357](https://arxiv.org/abs/1610.02357)  
Submitted on 7 Oct 2016

### NASNet <a id="NASNet"></a>

**Neural Architecture Search with Reinforcement Learning**  
[https://arxiv.org/abs/1611.01578](https://arxiv.org/abs/1611.01578)  
Submitted on 5 Nov 2016

### EfficientNet

**EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks**  
[https://arxiv.org/abs/1905.11946](https://arxiv.org/abs/1905.11946)  
Submitted on 28 May 2019

