---
search:
  exclude: true
---

# 深度学习工程师生存指南

![](https://github.com/ypwhs/dl-engineer-guidebook/actions/workflows/build.yml/badge.svg)
 ![Size](https://img.shields.io/github/repo-size/ypwhs/dl-engineer-guidebook.svg)  ![Stars](https://img.shields.io/github/stars/ypwhs/dl-engineer-guidebook.svg)

在线阅读：[https://dl.ypw.io](https://dl.ypw.io)  
在线阅读：[https://ypwhs.github.io/dl-engineer-guidebook/](https://ypwhs.github.io/dl-engineer-guidebook/)  
项目地址：[https://github.com/ypwhs/dl-engineer-guidebook](https://github.com/ypwhs/dl-engineer-guidebook)  

* 持续关注请点 <a class="github-button" href="https://github.com/ypwhs/dl-engineer-guidebook/subscription" data-icon="octicon-eye" data-show-count="true" aria-label="Watch ypwhs/dl-engineer-guidebook on GitHub">Watch</a>
* 收藏项目请点 <a class="github-button" href="https://github.com/ypwhs/dl-engineer-guidebook" data-icon="octicon-star" data data-show-count="true" aria-label="Star ypwhs/dl-engineer-guidebook on GitHub">Star</a>
* 贡献内容请点 <a class="github-button" href="https://github.com/ypwhs/dl-engineer-guidebook/fork" data-icon="octicon-repo-forked" data-show-count="true" aria-label="Fork ypwhs/dl-engineer-guidebook on GitHub">Fork</a>
* 提问或建议请点 <a class="github-button" href="https://github.com/ypwhs/dl-engineer-guidebook/issues" data-icon="octicon-issue-opened" data-show-count="true" aria-label="Issue ypwhs/dl-engineer-guidebook on GitHub">Issue</a>

本书会讲述一个深度学习工程师所需的所有东西：

* [如何配置一台深度学习工作站?](how-to-build-deep-learning-workstation.md)
    * CPU
    * 主板
    * 显卡
    * 硬盘
    * 内存
    * 电源
    * 网卡
    * 机箱
    * 显示器
    * 键盘鼠标
* 本地设备
    * [Windows、Linux 还是 macOS？](windows-linux-or-macos.md)
    * [Mac 对比](mac-compare.md)
    * 其他
        * 触控板
        * 机械键盘
        * iPad Pro
        * 路由器
        * NAS
        * 移动硬盘
        * U盘
* [macOS 软件](macos-software.md)
    * 终端
    * 编辑器
    * 浏览器
    * 开发软件
    * 实用工具
    * 虚拟机
* [macOS 环境](macos-environment.md)
    * Homebrew
    * oh my zsh
    * 必备软件
        * 终端
        * 编辑器
        * 浏览器
        * 开发软件
        * 实用工具
        * 日常应用
    * 必备命令
* [Python 环境](python-environment.md)
    * Anaconda
    * Python 库
* [Ubuntu 装机步骤](ubuntu-install-guide.md)
    * 安装 Ubuntu
    * 配置 ssh
    * 配置 sudo 免密码 和 apt 源（推荐）
    * 安装 oh my zsh 以及常用命令（推荐）
    * 安装 NVIDIA 驱动、CUDA 和 cuDNN（分为 apt 和 run 两种安装方式）
    * 安装 Anaconda 和 Python 库
* [Ubuntu 环境](ubuntu-environment.md)
    * CUDA
    * cuDNN
    * TensorFlow
    * PyTorch
    * 必备命令
        * curl
        * tmux 与 iTerm2 结合使用
        * screen 后台运行命令
* [常用 Linux 命令](linux-command.md)
    * 文件查看
    * 文件读写
    * 打包压缩
    * 权限管理
    * 进程管理
    * 磁盘管理
    * 系统管理
    * 系统监测
    * 网络通信
* [CV 学习资源](cv-resources.md)
    * 公开课
    * 网站
    * 书籍
* [常用 CV 数据集](cv-dataset.md)
    * 数据集使用方法
    * MNIST
    * CIFAR
    * ImageNet
    * VOC
    * COCO
    * CelebA
* [在 ImageNet 上表现出色的经典模型](best-models-on-imagenet.md)
    * 预训练模型使用方法
        * TensorFlow
        * PyTorch
    * 模型论文
* [如何使用 TensorBoard](how-to-use-tensorboard.md)
    * 安装
    * 使用
        * 创建文件对象（writer）
        * 打开 TensorBoard 服务
        * 可视化模型结构
        * 记录标量（scalar）
        * 记录多个标量（scalars）
        * 记录图像（images）
        * 完整代码
    * 总结
* [离线 Python 环境](offline-python-environment.md)


<script async defer src="https://buttons.github.io/buttons.js"></script>
