import {Component, Renderer2} from '@angular/core';
import {FileUploader} from 'ng2-file-upload';
import {HttpClient} from '@angular/common/http';
import {apiService} from '../../common/service/api.service';
import {alertService} from '../../common/service/alert.service';

@Component({
  selector: 'form-page',
  templateUrl: './form.page.html',
  styleUrls: ['./form.page.css']
})

export class FormPage {
  // todo 按照表单顺序整理代码
  changeEditor: (event: any) => void;
  initEditor: (event) => any;
  user: any;
  sexList: any = [
    {
      sex: 'female',
      title: '女'
    },
    {
      sex: 'male',
      title: '男'
    }
  ];
  hobbyList: any;
  schoolList = [
    {
      name: '蓝翔'
    },
    {
      name: '新东方'
    }
  ];
  rules: any = {
    name: [
      {
        required: true,
        message: '请输入姓名'
      },
      {
        validator: function (value) {
          if (value.length > 3) {
            return '名字不能太长哦';
          }
        }
      }
    ],
    age: [
      {
        required: true,
        message: '请输入年龄'
      },
      {
        validator: function (value) {
          if (value < 0) {
            return '虽然你年轻得像逆生长，但年龄必须是正数哦';
          }
        }
      }
    ]
  };
  richContent = '';
  editor: any;
  editorConfig: any = {
    buttons: '|,bold,strikethrough,underline,italic,|,superscript,subscript,|,ul,ol,|,outdent,indent,|,font,fontsize,brush,paragraph,|,table,link,|,align,undo,redo,\n,cut,hr,eraser,copyformat,|,symbol,fullsize,selectall'
  };
  cropUploader: any;
// 图片裁剪
  imageChangedEvent: any = '';
  croppedImage: any = '';
  cropperReady = false;
  cropperFile: any;
  // 文件上传操作
  uploader: any;

  // 省市区列表
  cityList = [];

  // 提交表单
  submitForm(res) {
    console.log('表单校验结果', res);
    if (res.status) {
      console.log('提交数据', this.user, this.hobbyList);
    } else {
      this.alert.warning(res.msg ? res.msg : '表单校验失败');
    }
  }

  // 改变性别
  changeSex(data) {
    // 单选框需要在这里手动修改值
    console.log('改变性别', data);
    this.user.sex = data.item.sex;
  }

  // 充值表单
  resetForm() {
    this.user = {
      name: '',
      age: 24,
      sex: 'female',
      school: '',
      tagList: [
        '宇宙第一懒宅', '颜控', '很无聊'
      ]
    };
    this.hobbyList = [
      {
        desc: '看书',
        checkStatus: true
      },
      {
        desc: '听歌',
        checkStatus: true
      },
      {
        desc: '敲代码',
        checkStatus: true
      },
      {
        desc: '跑步',
        checkStatus: true
      },
      {
        desc: '骑行',
        checkStatus: true
      },
      {
        desc: '吃鸡'
      },
      {
        desc: '诗词'
      },
      {
        desc: '游泳'
      },
      {
        desc: '做手工'
      },
      {
        desc: '动漫'
      },
      {
        desc: 'cosplay'
      }
    ];
  }

  // 选择兴趣爱好
  changeStatus(data, i) {
    // 复选框需要在这里手动修改列表状态值
    console.log('选择兴趣', data, i);
    this.hobbyList[i].checkStatus = data;
  }

  constructor(private http: HttpClient, render2: Renderer2, public alert: alertService, public  api: apiService) {
    const vm = this;
    this.uploader = new FileUploader({
      url: api.upload,
      method: 'POST',
      itemAlias: 'file' // 后端设定的字段名成
    });
    // 如果跨域，试试下面这段
    /*this.uploader.onAfterAddingFile = (item => {
     item.withCredentials = false;
     });
     * */
    this.resetForm();

    this.changeEditor = function (event) {
      // console.log('富文本', event.editor.value);
      this.richContent = event.editor.value;
      render2.selectRootElement('#richContent').innerHTML = event.editor.value;
    };

    this.initEditor = function (event) {
      // 初始化富文本内容
      // console.log('初始化富文本内容', event);
      event.editor.value = '<section style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="display: inline-block; width: 80%; vertical-align: top; box-sizing: border-box;"><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="text-align: center; margin-top: 10px; margin-bottom: 10px; position: static; box-sizing: border-box;"><section class="" style="max-width: 100%; vertical-align: middle; display: inline-block; overflow: hidden !important; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><img style="vertical-align: middle; max-width: 100%; box-sizing: border-box;" src="https://timgsa.baidu.com/timg?image&amp;quality=80&amp;size=b9999_10000&amp;sec=1530788613359&amp;di=1401fb316a55bbb8d1e0417469e33d7c&amp;imgtype=0&amp;src=http%3A%2F%2Fwww.qingpingshan.com%2Fuploads%2Fallimg%2F161211%2F1126443626-0.jpg" data-ratio="0.5626667" data-w="750"></section></section></section> </section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="text-align: right; margin: -60px 0% 20px; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="max-width: 100%; vertical-align: middle; display: inline-block; overflow: hidden !important; box-sizing: border-box;"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 149.2 69.5" style="vertical-align: middle; max-width: 100%; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" width="149.2"><path style="box-sizing: border-box;" d="M147,18.1c0-0.1,0-0.1,0.1-0.2c0,0,0,0-0.1,0C147,17.9,147,18.1,147,18.1z M148.8,9.4  c0,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2  c-0.1,0.1-0.1,0.3-0.2,0.4c0.1,0,0.2,0,0.2,0C148.8,9.2,148.8,9.4,148.8,9.4z M131.7,17.4c1.9-0.4,3.9-0.8,5.8-0.9l-0.1-1.8  c-9.8,0.8-19.7,5.8-28.5,8.5h0v0.7c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.1,0-0.1c-3,0.8-5.8,1.4-8.5,1.4C80,24.9,63.7,8.7,40.9,8.6c-7.3,0-11.8,1.4-17.2,3.4c-3.7,1.3-7.8,2.9-13.6,4.5  c0,0.1,0,0.1,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0.1,0,0.2,0,0.2v0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c-0.1,0-0.1,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v-0.1  C6.8,17.3,3.7,18,0,18.8l0.1,0.7h0.3V19c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0v0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h0l0.1,0.6v0c6.9-1.3,12-2.8,16.2-4.1  c0-0.1,0-0.1,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0,0,0.1c2.9-0.9,5.3-1.8,7.5-2.6c5.5-2,9.6-3.3,16.6-3.3C62.8,10.3,79,26.5,99.3,26.6  c3.9,0,7.9-1,12-2.4V24c0,0-0.2,0-0.2,0v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2V23  h0.2c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0h0.4c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-0.2v0.2  c0,0,0,0.1,0,0.2c6-2,12.3-4.8,18.5-6.4c0,0,0-0.1,0-0.1c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0.1,0,0.2,0,0.2v0.4c0.1,0,0.3-0.1,0.4-0.1c0,0,0-0.1,0-0.1c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  L131.7,17.4C131.7,17.3,131.7,17.3,131.7,17.4z M66,15.6c0,0-0.2,0-0.2,0h-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0h0.2v0.2c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0C66,15.4,66.1,15.6,66,15.6z M127,8.8c0,0.1,0,0.2,0,0.2h0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0,0,0  c0.1,0,0.1,0,0.2-0.1c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.1,0,0.1,0  c0,0,0,0,0.1,0c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0h0.4v0.4c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0,0,0.1c2.7-0.7,5.3-1.3,8-1.5  l-0.1-1.8c-2.2,0.2-4.4,0.6-6.5,1.1c0,0.1,0,0.1,0,0.1c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2h-1.3c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0h-0.2V8c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0V7.5c0,0,0.2,0,0.2,0c0,0,0,0,0-0.1c-0.8,0.2-1.6,0.4-2.4,0.7  c0,0,0,0.1,0,0.1c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2C127,8.7,127,8.8,127,8.8z M124.6,10.8  c0,0,0,0.1,0,0.1c0.1,0,0.2-0.1,0.3-0.1c-0.1,0-0.1,0-0.1,0c0,0,0-0.2,0-0.2c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  C124.4,10.8,124.6,10.8,124.6,10.8z M130.4,7.5c0,0,0.2,0,0.2,0V7.3c0,0,0,0,0-0.1c-0.1,0-0.2,0.1-0.3,0.1c0,0,0.1,0,0.1,0  C130.5,7.3,130.4,7.5,130.4,7.5z M107.7,59.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0C107.7,59.4,107.7,59.2,107.7,59.2z   M24.1,47.9c0,0,0,0.1,0,0.1c0,0,0.1,0,0.1,0c0.1,0,0.1,0,0.2-0.1c0,0-0.1,0-0.1,0C24.3,47.9,24.2,48,24.1,47.9z M24.1,46.2  C24.1,46.2,24.1,46.2,24.1,46.2c0,0-0.1,0-0.2,0C24,46.2,24.1,46.2,24.1,46.2z M24.8,45.9c-0.1,0-0.1,0-0.2,0.1  C24.6,46,24.8,46,24.8,45.9C24.8,46,24.8,45.9,24.8,45.9z M46.3,36.4C46.3,36.4,46.3,36.4,46.3,36.4c0,0-0.1,0-0.1,0  C46.2,36.4,46.2,36.4,46.3,36.4z M45.8,36.2V36c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0.1,0,0.1,0,0.2,0c0.1,0,0.1,0,0.2,0h0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2v0.1c15.2,2,27.9,11,41.9,14.5h0.5c0,0,0,0.1,0,0.1c0.4,0.1,0.7,0.2,1.1,0.3c0-0.1,0-0.1,0-0.2  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0.1,0,0.1,0,0.2,0c-15.9-3.4-30.7-15.3-50.1-15.4c-3.3,0-6,0.3-8.5,0.8c0,0,0,0,0,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0v0.2  c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2h0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0h0.4v0.3c2.2-0.4,4.7-0.7,7.6-0.7c1.7,0,3.4,0.1,5,0.3C45.8,36.3,45.9,36.2,45.8,36.2z M93,59.9  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.4v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0H91  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0-0.1,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.1,0-0.2c0,0-0.1,0-0.1,0h-0.3c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2h-0.2c-0.1,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.1c-0.1,0-0.1,0-0.2-0.1v0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2  v-0.2c0,0,0-0.1,0-0.1c-0.1,0-0.3-0.1-0.4-0.1c0,0,0,0,0,0c0,0.1,0,0.1,0,0.2h-0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2v-0.1c-0.1,0-0.2,0-0.2-0.1c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c-0.1,0-0.2,0-0.2,0  c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0,0,0-0.1C72,52.4,58.7,43.4,41.9,42.9v0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2v0.4c0,0,0,0,0,0c18.9,0.4,33.6,12.7,50.6,15.6v-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  C92.8,59.9,92.9,59.9,93,59.9z M27.8,46.6c0,0,0,0.1,0,0.1c3.9-1.3,7.6-2.1,13-2.1c0.2,0,0.4,0,0.7,0c0,0,0,0,0,0c0-0.1,0-0.2,0-0.2  c0-0.1,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0-0.1,0-0.1,0-0.2c0-0.1,0-0.1,0-0.2  c0-0.1,0-0.1,0-0.2c0-0.1,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0,0,0c-0.1,0-0.3,0-0.4,0c-6,0-10.1,1-14.4,2.4c0,0,0,0,0,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2v0.4c0,0.1,0,0.1,0,0.2  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0v0.1c0.3-0.1,0.5-0.2,0.8-0.3c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2h-0.4c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v-0.4  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2v0.7c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0v-0.2c0-0.1,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0h0.4c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2  C28,46.7,27.8,46.6,27.8,46.6z M26.3,45.5c0,0,0-0.1,0-0.2c-0.1,0-0.1,0-0.2,0.1c0,0,0,0.1,0,0.1C26.1,45.5,26.3,45.6,26.3,45.5z   M25.7,47.5L25.7,47.5c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0H25c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0.1,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2  c0,0,0,0.1,0,0.2C24.9,47.8,25.3,47.6,25.7,47.5z M24.3,46.6c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c-0.1,0-0.2,0.1-0.2,0.1c0,0,0,0.1,0,0.1c0,0-0.2,0-0.2,0c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0.1,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0C24.3,46.8,24.3,46.7,24.3,46.6z M93.8,60.3h-0.4  c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.1,0,0.1c0.3,0,0.6,0.1,0.9,0.1V60.3z M23.4,46.4c0.1,0,0.1,0,0.1,0c0,0,0,0,0,0  C23.4,46.4,23.4,46.4,23.4,46.4z M107.5,57.9c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.1,0-0.2  c-0.2,0.1-0.4,0.1-0.6,0.2C107.4,57.9,107.5,57.9,107.5,57.9z M115.8,48.4C115.8,48.4,115.8,48.4,115.8,48.4c0.1,0.1,0.1,0,0.2,0  c0,0,0,0,0,0C116,48.4,115.8,48.4,115.8,48.4z M116,46.5c-0.2,0.1-0.3,0.1-0.5,0.2c0,0,0,0,0,0c0,0,0.2,0,0.2,0s0.2,0,0.2,0  C116,46.6,116,46.5,116,46.5z M117.5,46.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0C117.5,46.4,117.5,46.2,117.5,46.2z   M116.9,47.1c0,0,0,0.2,0,0.2h0.2c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0h0.4c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2v-0.4c0-0.1,0-0.2,0-0.2  c0,0,0-0.2,0-0.2c0,0-0.1,0-0.1,0c-0.1,0-0.2,0.1-0.3,0.1c0,0,0,0.1,0,0.1c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0.1,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2h-0.2C117.1,47.1,116.9,47,116.9,47.1z   M112.3,49.7C112.3,49.7,112.4,49.7,112.3,49.7C112.3,49.7,112.3,49.7,112.3,49.7C112.3,49.7,112.3,49.7,112.3,49.7z M112.5,48.8  h0.2v0.4c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c0.1,0,0.1,0,0.2-0.1c0,0,0,0,0,0c0,0,0,0,0.1,0  c0.5-0.2,1-0.3,1.5-0.5c0-0.1,0-0.1,0-0.1c0-0.1,0-0.2,0-0.2v-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0-0.1,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0v-0.4c-0.4,0.2-0.9,0.3-1.3,0.5c0,0.1,0,0.1,0,0.1  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0.1,0,0.1,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2v0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2C112.3,48.8,112.5,48.8,112.5,48.8z M111.4,49.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0h0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  C111.4,49.1,111.4,49.2,111.4,49.2z M113.8,47.5c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2h0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2v0.7c0,0,0,0,0,0.1c0.2-0.1,0.5-0.2,0.7-0.3h-0.5v-1.1  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0h0.2v-0.4h-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0,0,0-0.1  c-0.1,0.1-0.3,0.1-0.4,0.2v0.3c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.1,0-0.1,0c-0.1,0-0.2,0.1-0.3,0.1c0,0,0,0.1,0,0.1  c0,0-0.2,0-0.2,0C113.8,47.3,113.8,47.5,113.8,47.5z M113.7,47.3C113.8,47.3,113.8,47.3,113.7,47.3  C113.8,47.3,113.8,47.3,113.7,47.3C113.8,47.3,113.8,47.3,113.7,47.3z M118.2,46c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2h0.4v0.4h0.4V47c5.9-2.2,11.9-4.4,17.8-4.8l-0.1-1.8c-6.5,0.5-13,2.9-19.2,5.2V46z   M121,54.9c0,0,0,0.2,0,0.2c0.1,0,0.1-0.1,0.2-0.1c0-0.1,0-0.1,0-0.1C121.2,54.9,121,54.9,121,54.9z M121.4,54.9  C121.4,54.9,121.4,54.9,121.4,54.9c0.1,0,0.1,0,0.2,0v-0.2c0,0-0.2,0-0.2,0C121.4,54.7,121.4,54.9,121.4,54.9z M120.5,53.4  C120.5,53.4,120.5,53.4,120.5,53.4C120.5,53.4,120.6,53.3,120.5,53.4C120.5,53.3,120.5,53.4,120.5,53.4z M121.6,52.9  c0,0.1,0,0.1,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0,0,0-0.1C121.8,52.9,121.7,52.9,121.6,52.9z M120.8,55.1  C120.8,55.1,120.8,55.1,120.8,55.1c0.1,0.1,0.1,0,0.2,0C120.9,55.1,120.8,55.1,120.8,55.1z M120.8,54.9c0,0,0-0.2,0-0.2h-0.4v0.7  c0.1,0,0.1-0.1,0.2-0.1c0-0.1,0-0.1,0-0.2c0-0.1,0-0.2,0-0.2C120.6,54.9,120.7,54.9,120.8,54.9z M101.2,60.5c0.1,0,0.1,0,0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2v-0.9h-0.2c0,0-0.2,0-0.2,0c0,0,0,0,0-0.1c-0.3,0-0.7,0-1,0  c-0.3,0-0.6,0-0.9,0c0,0,0,0.1,0,0.1c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0v0.4H98c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0.1,0,0.1,0,0.2c0,0,0,0.1,0,0.2c0.5,0,1.1,0,1.6,0  c0.1,0,0.1,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0v0.2c0.4,0,0.7,0,1.1-0.1c0-0.1,0-0.1,0-0.1c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  C101,60.5,101.2,60.5,101.2,60.5z M130.1,50.3C130.1,50.3,130.1,50.3,130.1,50.3c-0.1,0-0.2,0-0.2,0c0,0,0,0,0,0  C129.9,50.3,130.1,50.3,130.1,50.3z M123.4,35.6c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2C123.6,35.6,123.4,35.5,123.4,35.6  z M118.2,47.3c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.1,0,0.2c0.1-0.1,0.3-0.1,0.4-0.2c0-0.1,0-0.2,0-0.2  C118.3,47.3,118.2,47.2,118.2,47.3z M124.5,36.7c4.4-1.5,8.7-2.8,13.1-3.1l-0.1-1.8c-5.1,0.4-10.2,2-15.1,3.7h0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2h0.7c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v0.2c0,0.1,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0V36c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2V36.7z M108.6,66.6c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0-0.1,0-0.1  c-0.2,0.1-0.4,0.1-0.6,0.2c0,0,0,0.1,0,0.1c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0C108.6,66.4,108.6,66.6,108.6,66.6z M93.3,15.8  C93.3,15.8,93.3,15.8,93.3,15.8C93.3,15.8,93.3,15.8,93.3,15.8C93.4,15.8,93.3,15.8,93.3,15.8z M109.5,50.6L109.5,50.6  c0,0,0.2-0.1,0.2-0.1c0,0,0,0,0,0c0.5-0.1,0.9-0.3,1.4-0.4H111c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0v0.4c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2v-0.6h0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0v-0.4c0-0.1,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0,0-0.1  c-0.3,0.1-0.6,0.2-0.9,0.3c0,0,0,0,0,0c0,0-0.1,0-0.1,0c-0.1,0-0.2,0.1-0.3,0.1c0,0,0,0.1,0,0.1c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c-2.9,0.8-5.8,1.4-8.4,1.3c-1.6,0-3.2-0.1-4.8-0.3c0,0,0,0,0,0c0,0-0.2,0-0.2,0c0,0,0,0,0-0.1  c-0.1,0-0.1,0-0.2,0c0,0,0,0.1,0,0.1c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0v0.7c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0h0.2v0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0v-0.4c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0,0.1,0,0.1c1.2,0.1,2.3,0.2,3.5,0.2c1.7,0,3.4-0.2,5.2-0.5v0v-0.2h0.4c0,0,0,0.1,0,0.1C106.4,51.5,107.9,51.1,109.5,50.6z   M119.7,62.2C119.7,62.2,119.7,62.3,119.7,62.2c0,0.1,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0-0.1,0-0.1,0-0.2C120,62.1,119.8,62.2,119.7,62.2z M101.9,59.7c0.1,0,0.1,0,0.2,0v-0.4h-0.2c-0.1,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2  c-0.1,0-0.3,0-0.4,0c0,0.1,0,0.1,0,0.1c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  C101.7,59.7,101.8,59.7,101.9,59.7z M119,62.5C119,62.5,119,62.5,119,62.5L119,62.5L119,62.5z M116.2,30.8c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0,0,0.1c0.4-0.1,0.7-0.3,1.1-0.4c0,0,0-0.1,0-0.1h-0.2c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2C116.4,30.8,116.2,30.8,116.2,30.8z M120.1,54.9  c0-0.1,0-0.2,0-0.2v-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v-0.4h-0.7V54  c-0.3,0.1-0.6,0.2-0.9,0.3c0,0.1,0,0.1,0,0.1v0.7c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c-0.1,0-0.2,0-0.2,0h-0.4c-0.1,0-0.1,0-0.2,0c-0.1,0-0.1,0-0.2,0V56c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2v-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0h0.2v-0.4c0,0-0.2,0-0.2,0c0,0,0,0,0-0.1c-0.8,0.3-1.6,0.6-2.4,0.9c0,0,0,0,0,0.1h1.1v0.9c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c1.5-0.6,3-1.1,4.6-1.7v-0.4c0,0,0.2,0,0.2,0  C120.1,55.1,120.1,54.9,120.1,54.9z M114.7,57.1h-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c-0.1,0-0.1,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.1c-1.1,0.4-2.2,0.8-3.3,1.1v0.1c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0.1,0,0.2,0,0.2v0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0H109v0c-0.1,0-0.3,0.1-0.4,0.1v0.3  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0,0,0.1c2.4-0.6,4.9-1.5,7.4-2.4v-0.1c0,0,0-0.2,0-0.2C114.9,57,114.7,57.1,114.7,57.1z   M117.1,55.1c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0v-0.2c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c-0.4,0.1-0.7,0.3-1.1,0.4c0,0,0,0,0,0c0,0,0,0,0,0c-0.1,0-0.1,0-0.2,0.1c0,0.1,0,0.1,0,0.1h0.7  C116.9,55.1,117,55.1,117.1,55.1z M118.6,62.6c-0.1,0-0.1,0-0.2,0.1C118.5,62.7,118.6,62.7,118.6,62.6  C118.6,62.7,118.6,62.7,118.6,62.6z M122.3,61.4c0,0,0-0.1,0-0.1c-0.5,0.2-1,0.4-1.5,0.5c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0.1,0,0.2,0,0.2,0c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2C122.5,61.4,122.3,61.4,122.3,61.4z   M122.9,52.5h0.5c0,0,0-0.1,0-0.2C123.2,52.4,123.1,52.4,122.9,52.5z M117.5,30.3c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  C117.5,30.2,117.5,30.3,117.5,30.3z M131.2,50c0,0.1,0,0.1,0,0.1c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2c-0.1,0-0.3,0.1-0.4,0.1  c0,0,0,0,0,0c0,0-0.1,0-0.2,0c-1.2,0.3-2.3,0.7-3.5,1.1v0.2c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2v0.7  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0h0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c3.6-1.1,7.1-2,10.7-2.3  l-0.1-1.8C135.3,49.2,133.3,49.5,131.2,50z M130.3,50.2c0,0.1,0,0.1,0,0.1c0,0,0.2,0,0.2,0c0,0,0-0.1,0-0.2  C130.5,50.2,130.4,50.2,130.3,50.2z M124.9,51.8c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0v-0.2c0,0,0-0.1,0-0.1c-0.1,0-0.2,0.1-0.3,0.1  C124.8,51.8,124.9,51.8,124.9,51.8z M118.2,62.9c0,0,0-0.1,0-0.1c-0.1,0-0.1,0.1-0.2,0.1c0,0,0,0,0,0C118,62.9,118.1,63,118.2,62.9z   M120.8,62c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2C121,62,120.8,62,120.8,62z M102.1,69.2c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0.1,0,0.2,0,0.2,0c0,0,0-0.1,0-0.1c-0.9,0.1-1.9,0.2-2.8,0.2  c-0.2,0-0.3,0-0.5,0v0.2h-0.4c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.1,0-0.2  c-18.7-0.6-34.8-16.2-57.1-16.2c-1.2,0-2.2,0-3.3,0.1c0,0,0,0,0,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2c0,0.1,0,0.1,0,0.2c0,0.1,0,0.1,0,0.2c0,0.1,0,0.1,0,0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0.1,0,0.1,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2v0.2c0.8,0,1.6-0.1,2.4-0.1c2.4,0,4.7,0.2,7,0.5v0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c1.1,0.2,2.2,0.4,3.2,0.7c0-0.1,0-0.1,0-0.1c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.1,0,0.2c0,0,0.1,0,0.1,0c0,0,0.1,0,0.1,0  c0,0,0.2,0,0.2,0c0,0,0,0,0,0.1c0.1,0,0.1,0,0.2,0.1c0-0.1,0-0.1,0-0.1c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0H55c0.1,0,0.1,0,0.2,0  c0.1,0,0.1,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2v0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0v0.1c0.1,0,0.2,0.1,0.3,0.1h0.1c0.1,0,0.2,0,0.2,0  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0.1,0,0.2,0,0.2,0H57c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c0.1,0,0.1,0,0.2,0.1v-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2h-0.6v0.4c13.8,4.7,26.2,12.9,40.6,13  c1,0,2-0.1,3-0.2v-0.1C102.3,69.2,102.1,69.3,102.1,69.2z M70.2,59.9c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0v0.4h-0.4c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0v-0.4h0.4c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0H70c0,0,0.2,0,0.2,0  C70.2,59.7,70.2,59.9,70.2,59.9z M120.8,61.8c-0.1,0-0.1,0.1-0.2,0.1c0,0,0,0.1,0,0.1c0,0,0.2,0,0.2,0  C120.8,62,120.8,61.9,120.8,61.8z M120.6,63.8c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  v-0.4c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.1,0,0.2h-0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2h-0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0,0-0.1,0  c-0.1,0-0.2,0.1-0.4,0.1v0.1c0,0.1,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-1c-0.5,0.2-1,0.4-1.4,0.5  c0,0,0,0.1,0,0.1c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2  c-0.1,0-0.1,0.1-0.2,0.1c0,0,0,0.1,0,0.1c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2c-1.5,0.5-2.9,1-4.4,1.5  v0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0V67h-0.4c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0.1,0,0.1,0,0.2,0c0.1,0,0.1,0,0.2,0h0.2v-0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.1  c-1,0.3-2,0.5-3,0.7c0,0,0,0.1,0,0.1c0,0-0.2,0-0.2,0v0c-0.7,0.1-1.3,0.2-1.9,0.3c0,0.1,0,0.1,0,0.1c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2h0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0.1,0,0.1,0,0.2,0c0,0,0,0,0,0.1c0.1,0,0.3,0,0.4-0.1c0,0,0,0,0,0c0,0,0,0,0,0c0.1,0,0.1,0,0.2,0c0-0.1,0-0.2,0-0.2v-0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.1,0,0.2c0.8-0.1,1.6-0.3,2.4-0.5c0-0.1,0-0.1,0-0.1c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0.1,0,0.1,0,0.2,0h0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0,0,0c3.5-0.8,7-2.1,10.6-3.4c0,0,0,0,0,0c0-0.1,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2h-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2h-0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2h0.4c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0h0.2v0.2c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.2c0.9-0.3,1.8-0.7,2.8-1C120.7,63.8,120.6,63.8,120.6,63.8z   M123.9,11.1c0-0.1,0-0.1,0-0.1c0-0.1,0-0.1,0-0.2c0-0.1,0-0.1,0-0.2c0-0.1,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0-0.1,0-0.2,0-0.2h-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c-0.1,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0c-0.1,0-0.1,0-0.2,0v0.4  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-0.2v0.2c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0V12C122.3,11.7,123.1,11.4,123.9,11.1z   M117.7,54.4C117.7,54.4,117.7,54.4,117.7,54.4c-0.1,0-0.1,0-0.2,0C117.6,54.5,117.7,54.5,117.7,54.4z M53.5,54.9c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0C53.5,54.7,53.5,54.9,53.5,54.9z M74.2,9.7c0,0,0-0.2,0-0.2c0,0,0.1,0,0.2,0  c-0.1-0.1-0.3-0.1-0.4-0.2v0.2c0,0,0,0.2,0,0.2C74,9.7,74.2,9.7,74.2,9.7z M74.8,9.9c0,0,0,0.2,0,0.2v0.4c0.1,0,0.1,0,0.2,0  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0-0.1,0-0.2,0-0.2c0,0,0-0.2,0-0.2C75,10,74.9,9.9,74.8,9.9z M5.7,34.7  c-0.1,0-0.1,0-0.2,0c0,0.1,0,0.1,0,0.1c0,0,0.2,0,0.2,0C5.6,34.9,5.7,34.8,5.7,34.7z M135,24.7C135,24.7,135,24.7,135,24.7  c0,0,0.1,0,0.1,0c0,0,0-0.2,0-0.2v0c0,0-0.1,0-0.1,0C135,24.5,135,24.7,135,24.7z M135.5,23.5c0,0.1,0,0.1,0,0.1c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2v0.4c0.1,0,0.1,0,0.1,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0.1,0,0.1,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2v0.2h-0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.1,0,0.1c0.7-0.1,1.4-0.2,2.1-0.2l-0.1-1.8C136.8,23.3,136.2,23.4,135.5,23.5z M134.9,24.5  c0-0.1,0-0.1,0-0.2h-0.7v-0.4h0.4v-0.2c0,0,0,0,0,0c-0.7,0.1-1.4,0.2-2.1,0.4V24c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0,0,0,0-0.1c-0.1,0-0.3,0.1-0.4,0.1c0,0.1,0,0.1,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c-0.1,0-0.1,0-0.2,0v-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0-0.1,0-0.2,0-0.2v0c-2,0.5-4,1.1-6,1.8c0.1,0,0.1,0,0.1,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2  c-0.1,0-0.3,0.1-0.4,0.1c0,0,0,0,0,0c0,0-0.1,0-0.1,0c-8.8,3-17.2,7-24.5,7C87.6,33.5,77,27.5,65.4,22.8c0,0.1,0,0.1,0,0.1  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0c0,0.1,0,0.1,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0,0-0.2,0-0.2c0,0,0.1,0,0.1,0c-7.3-2.9-15.1-5.3-23.8-5.4c-7.3,0-11.8,1.4-17.2,3.4c-5.5,2-12,4.5-23.6,6.8l0.3,1.8  c11.8-2.3,18.4-4.9,23.9-6.8c5.5-2,9.6-3.3,16.6-3.3c15.6-0.1,28.3,8.1,41.6,12.9c0,0,0.1,0,0.1,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0h0.7c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0v0.9c0,0-0.2,0-0.2,0  c0,0,0,0,0,0c4.4,1.5,8.8,2.6,13.5,2.8v0c0-0.1,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2h0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0,0,0.1c0.4,0,0.8,0,1.1,0c5.3,0,10.9-1.9,16.7-4c0,0,0,0,0,0c0,0,0-0.2,0-0.2  c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2v-0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0v-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0.1,0,0.2,0,0.2,0v0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0h0.2c0-0.1,0-0.2,0-0.2v-0.2h0.9  v0.6c0.1-0.1,0.3-0.1,0.4-0.2v0h0.1c0.2-0.1,0.4-0.1,0.5-0.2c0,0,0,0,0,0c0,0,0,0,0.1,0c5.1-1.9,10.3-3.8,15.5-4.6v-0.4  c0-0.1,0-0.1,0-0.2c-0.1,0-0.1,0-0.1,0C134.9,24.7,134.9,24.5,134.9,24.5z M37.8,18c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-0.2c-0.1,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2h-0.4c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2v-0.2h0.4c0.1,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0.1,0,0.2,0,0.2,0h0.2  c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0.1,0,0.1,0,0.2,0h0.7C37.8,17.8,37.8,17.9,37.8,18z M51.7,19c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0h-0.4V19h-0.2v-0.4h1.3V19z M0,35.9l0.3,1.8v0c11.8-2.3,18.4-4.9,23.9-6.8  c0.3-0.1,0.5-0.2,0.8-0.3h-0.3c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0-0.1,0-0.2,0-0.2h-0.7v-0.4c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0H25v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0h0.2c0.1,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.1,0-0.2,0v0.2c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0h-0.2v0.2c0,0,0,0.1,0,0.1c4.7-1.6,8.7-2.7,15-2.7  C62.8,27.5,79,43.7,99.3,43.8c1.8,0,3.7-0.2,5.6-0.6c0,0,0,0,0,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0.1,0,0.1,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c-0.1,0-0.1,0-0.2,0v0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c4.8-1,9.9-3,15-4.9c0,0,0,0,0,0c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2v-0.9  c-6.2,2.3-12.1,4.7-17.5,5.3c0,0,0.1,0,0.1,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0.1,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2c-0.1,0-0.2,0-0.2,0c0,0,0-0.1,0-0.1  c-0.6,0-1.1,0.1-1.7,0.1c-0.2,0-0.3,0-0.5,0v0.1c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0v-0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.1,0-0.1c-18.9-0.4-35.1-16.2-57.5-16.2  c-7.3,0-11.8,1.4-17.2,3.4c-4.5,1.6-9.6,3.6-17.7,5.5c0,0,0,0,0,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2H4.6v-0.4c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.1,0-0.1c-0.2,0-0.4,0.1-0.7,0.1c0,0.1,0,0.1,0,0.2c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c-0.1,0-0.2,0-0.2,0H3.5c0,0,0-0.1,0-0.1c-0.1,0-0.3,0.1-0.4,0.1c0,0,0,0,0,0c0,0-0.2,0-0.2,0  c0,0,0,0,0,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.1,0-0.1  C1.6,35.6,0.8,35.8,0,35.9z M74.3,36.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2v0.7h-0.4c0-0.1,0-0.1,0-0.2c0-0.1,0-0.1,0-0.2v-0.2C74.3,36.4,74.3,36.3,74.3,36.2z M97.8,35.1  c0,0-0.2,0-0.2,0c0,0,0,0,0,0.1c0.1,0,0.3,0,0.4,0v-0.1H97.8z M24.2,5.1c5.5-2,9.6-3.3,16.6-3.3C62.8,1.7,79,18,99.3,18.1  c6.9,0,14.4-3.2,22-6c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0-0.1,0-0.1,0-0.2c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c0,0,0,0,0-0.1  c-1.4,0.5-2.8,1-4.1,1.5c0,0,0,0.1,0,0.1c0,0-0.1,0-0.2,0c-6.4,2.4-12.5,4.6-17.9,4.6c-1.9,0-3.7-0.1-5.6-0.4c0,0.1,0,0.1,0,0.1  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2h0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0  c-0.1,0-0.1,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0,0,0,0c-6.1-1-12-3.4-18-6c0,0.1,0,0.1,0,0.1c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2v0.4c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0h-0.2c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2H74c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.4V9.7c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0,0,0,0c-9.9-4.3-20.3-9-32.5-9c-7.3,0-11.8,1.4-17.2,3.4  c-5.5,2-12,4.5-23.6,6.8l0.3,1.8C12.1,9.6,18.8,7.1,24.2,5.1z M79.4,12.7h0.2c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0.1,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0h-0.4V12.7z M14.5,51.3C14.5,51.3,14.5,51.3,14.5,51.3L14.5,51.3  C14.5,51.4,14.5,51.4,14.5,51.3z M13.6,51.4c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c-0.1,0-0.2,0-0.2,0v0.4h-0.4v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2c-0.5,0.1-0.9,0.3-1.4,0.4v0.3h-0.4v-0.2  c-0.8,0.2-1.7,0.5-2.6,0.7c0,0.1,0,0.1,0,0.1c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2v0.2H7.4v-0.4C5.2,52,2.7,52.5,0,53.1l0.3,1.8v0  c5.4-1.1,9.8-2.2,13.4-3.3c0,0,0,0,0,0h-0.2V51.4z M9.6,52.3H9.4c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2H8.3c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v-0.7  h0.4c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0C9.6,52.1,9.5,52.2,9.6,52.3z M14.2,51.4c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0,0,0.1,0,0.2h0c0.2-0.1,0.4-0.1,0.5-0.2C14.3,51.4,14.2,51.4,14.2,51.4z M13.7,58.4c0,0,0.2,0,0.2,0c0,0,0-0.1,0-0.1  c-0.1,0-0.3,0.1-0.4,0.1C13.5,58.4,13.7,58.4,13.7,58.4z M14.4,58.1c-0.1,0-0.1,0-0.2,0C14.3,58.1,14.3,58.2,14.4,58.1  C14.4,58.1,14.4,58.1,14.4,58.1z M13.8,59.9c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0,0,0c-3.5,1-7.7,2.1-12.9,3.1l0.3,1.8  C6,62.3,10.5,61.2,14.2,60c0-0.1,0-0.1,0-0.1H14C13.9,59.9,13.8,59.9,13.8,59.9z M14.9,51.1C14.9,51.2,14.9,51.2,14.9,51.1  c0.1,0.1,0.2,0,0.2,0c0,0,0,0,0,0C15.1,51.1,15,51.2,14.9,51.1z M3.9,45.5c0-0.1,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1  c0.1,0,0.3-0.1,0.4-0.1c0,0,0,0,0-0.1c0.1,0,0.2,0,0.2,0c0,0,0,0,0,0c0.1,0,0.1,0,0.2,0c0-0.1,0-0.1,0-0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2v0.2c2.2-0.5,4.2-1,6.1-1.6c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c1.6-0.5,3.2-0.9,4.6-1.4v-0.3c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2h0.4  c0,0,0.1,0,0.2,0c2.6-0.9,4.8-1.7,6.9-2.4c2.9-1,5.4-1.9,8.2-2.5c0,0,0-0.1,0-0.1c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0v-0.2  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.1,0-0.2c-3,0.6-5.6,1.5-8.5,2.6  c-3.9,1.4-8.4,3.1-14.9,4.8c0,0.1,0,0.1,0,0.2v0.2H8.5c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0v0.4h0.4v0.2  c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2H8.5c-0.1,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0H7.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2v-0.7c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0h0.7v-0.4c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0,0-0.1C5.2,43.4,2.7,44,0,44.5l0.3,1.8  C1.6,46,2.8,45.8,3.9,45.5z M9.4,43.4c0,0,0.2,0,0.2,0v-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2h-0.2c-0.1,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c-0.1,0-0.1,0-0.2,0H9.8c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0C9.4,43.6,9.4,43.4,9.4,43.4z M53.7,54.4  c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0C53.7,54.2,53.7,54.4,53.7,54.4z M22.8,46.8c0,0,0.2,0,0.2,0v-0.2c0,0,0-0.1,0-0.1  c-0.1,0-0.2,0.1-0.3,0.1c0,0,0,0,0.1,0C22.9,46.7,22.8,46.8,22.8,46.8z M116.6,46.4c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0.2,0,0.2,0v-0.6c-0.1,0.1-0.3,0.1-0.4,0.2C116.6,46.3,116.6,46.4,116.6,46.4z M36.3,52.5c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2  c0,0-0.2,0-0.2,0c0,0,0,0,0-0.1c-4.5,0.5-8,1.7-12,3.1c-0.2,0.1-0.5,0.2-0.7,0.3v0.1c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0  c0,0.1,0,0.2,0,0.2V56c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  c0-0.1,0-0.1,0-0.2h0.4v0.4c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2h0.2c0.1,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0h0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.1,0,0.1c0.1,0,0.2-0.1,0.3-0.1c0,0,0,0,0,0c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2h0.9  c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0.1,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0.1,0,0.2,0,0.2,0h0.4v0.4c0,0,0,0,0.1,0c0.2-0.1,0.4-0.1,0.6-0.2c0,0,0,0,0,0  c0,0,0,0,0.1,0c0,0,0.1,0,0.1,0c0-0.1,0-0.1,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.1,0,0.1c2.1-0.6,4.3-1.1,6.7-1.4c0,0,0-0.2,0-0.2  c0,0,0.2,0,0.2,0c0.1,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2h0.4  C36.3,52.7,36.3,52.5,36.3,52.5z M16.3,58.8c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0-0.1,0-0.1,0-0.2v-0.2c-0.3,0.1-0.6,0.2-0.9,0.3c0,0.1,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0.1,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0.1,0,0.1,0,0.2c0,0,0,0.2,0,0.2  c0,0,0.2,0,0.2,0V59c0,0.1,0,0.2,0,0.2c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2h0.6c0.2-0.1,0.4-0.1,0.5-0.2c0,0,0,0,0-0.1  v-0.2c0-0.1,0-0.1,0-0.2c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2  C16.5,58.8,16.3,58.8,16.3,58.8z M36.7,52.9c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2C36.9,52.9,36.7,53,36.7,52.9z   M52.2,54.4c0,0,0,0.1,0,0.2c0.1,0,0.1,0,0.2,0c0,0,0,0,0,0c0-0.1,0-0.2,0-0.2C52.4,54.5,52.2,54.4,52.2,54.4z M117.5,64.9  c0,0,0,0.1,0,0.1c0.1,0,0.2-0.1,0.3-0.1c0,0,0,0-0.1,0C117.7,64.9,117.5,64.8,117.5,64.9z M36.7,52.7c0,0-0.2,0-0.2,0  c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0C36.7,52.9,36.7,52.7,36.7,52.7z M17.5,50.3c0,0,0,0.1,0,0.1  c2.2-0.7,4.2-1.5,6-2.1c0-0.1,0-0.1,0-0.1c0,0-0.2,0-0.2,0H23c0,0-0.2,0-0.2,0c0,0,0,0.2,0,0.2c0,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0  H22c0,0,0-0.2,0-0.2c0,0,0.2,0,0.2,0c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0c0,0,0-0.2,0-0.2c0-0.1,0-0.2,0-0.2c0,0-0.2,0-0.2,0  c0,0,0-0.2,0-0.2c0,0-0.2,0-0.2,0h-0.2c0,0-0.2,0-0.2,0c0,0,0,0,0,0c-0.4,0.2-0.9,0.3-1.3,0.5c0,0,0,0,0,0c0,0,0,0.2,0,0.2  c0,0-0.2,0-0.2,0c0,0,0-0.1,0-0.2c-1.3,0.5-2.7,0.9-4.2,1.4c0,0.1,0,0.2,0,0.2c0,0,0.2,0,0.2,0h0.7V49c0,0,0.2,0,0.2,0  c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2v0.4c0,0,0.2,0,0.2,0c0,0,0,0.2,0,0.2c0,0,0.2,0,0.2,0  c0,0,0-0.2,0-0.2h0.4V50c0,0.1,0,0.2,0,0.2C17.7,50.3,17.5,50.2,17.5,50.3z M15.3,51.1C15.4,51.1,15.4,51.1,15.3,51.1  C15.4,50.9,15.4,50.9,15.3,51.1z M36.1,53.5c0.1,0,0.3,0,0.4,0c0-0.1,0-0.1,0-0.1c0,0-0.2,0-0.2,0c0,0-0.2,0-0.2,0  C36.1,53.4,36.1,53.5,36.1,53.5z M27.7,55.4c0.1,0,0.1,0,0.2-0.1c0,0,0,0,0,0C27.8,55.3,27.7,55.3,27.7,55.4  C27.7,55.3,27.7,55.4,27.7,55.4z" fill="rgb(185, 135, 56)"></path></svg></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="display: inline-block; width: 100%; vertical-align: top; background-image: url(&quot;//statics.xiumi.us/stc/images/templates-assets/tpl-paper/image/a9e61c889c8828ad7d9f74ddf2b76e9b-sz_6849.png&quot;); background-position: 0% 0%; background-repeat: repeat; background-size: 167.836% auto; background-attachment: scroll; padding: 15px; box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box;"><section class="" style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><p style="margin: 0px; padding: 0px; box-sizing: border-box;">时尚通常是丑陋的一种形式，以至于人们忍无可忍地每六个月便要把它修改一下。</p><p style="text-align: right; margin: 0px; padding: 0px; box-sizing: border-box;">——王尔德</p></section></section></section> </section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="display: inline-block; width: 100%; vertical-align: top; background-image: url(&quot;//statics.xiumi.us/stc/images/templates-assets/tpl-paper/image/72aa529003c8cbc61adb182956223227-sz_309590.png&quot;); background-position: 0% 0%; background-repeat: repeat; background-size: 99.6088% auto; background-attachment: scroll; letter-spacing: 0px; padding: 15px; box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box;"><section class="" style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><p style="margin: 0px; padding: 0px; box-sizing: border-box;">时光向来刻薄，像吹散一朵蒲公英似的，把我们吹往不同的地方。大抵人生总是这样，充满一场场盛大的邂逅与别离。</p><p style="margin: 0px; padding: 0px; box-sizing: border-box;"><br style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"></p><p style="text-align: right; margin: 0px; padding: 0px; box-sizing: border-box;">——苑子文《我们都一样，年轻又彷徨》</p></section></section></section> </section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="display: inline-block; width: 100%; vertical-align: top; background-image: url(&quot;//statics.xiumi.us/stc/images/templates-assets/tpl-paper/image/b4226223335e88031dca37a81ac157b9-sz_12617.png&quot;); background-position: 0% 0%; background-repeat: repeat; background-size: 99.0957% auto; background-attachment: scroll; letter-spacing: 0px; padding: 15px; box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box;"><section class="" style="box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><p style="margin: 0px; padding: 0px; box-sizing: border-box;">身处一个科技爆炸、沟通无限的世界，我们感受到的，却是史无前例的孤独无助。在全世界都可以社交起来的时候，我们却无法用最原始的方式获得真正有效的沟通。</p><p style="text-align: right; margin: 0px; padding: 0px; box-sizing: border-box;">——石黑一雄《无可慰籍》</p></section></section></section> </section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="display: inline-table; border-collapse: collapse; table-layout: fixed; width: 100%; box-sizing: border-box;"><section class="Powered-by-XIUMI V5" style="position: static; display: table-row-group; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="display: table-row; width: 100%; position: static; box-sizing: border-box;"><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-width: 1px; border-radius: 0px; border-style: solid; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">1  </p></section><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">1  </p></section><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">1  </p></section><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">1  </p></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; display: table-row-group; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="display: table-row; width: 100%; position: static; box-sizing: border-box;"><section class="" style="display: table-cell; vertical-align: middle; width: 25%; border-width: 1px; border-radius: 0px; border-style: solid; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: center; color: rgb(0, 0, 0); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">向下<span style="letter-spacing: 0px; box-sizing: border-box;">添加行</span></p></section></section></section> </section><section class="" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="color: rgb(0, 0, 0); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="text-align: center; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">删除当前行</p></section></section></section> </section><section class="" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="color: rgb(0, 0, 0); padding: 0px 5px; font-size: 12px; box-sizing: border-box;"><p style="text-align: center; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">向右添加列</p></section></section></section> </section><section class="" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="color: rgb(0, 0, 0); padding: 0px 5px; font-size: 12px; box-sizing: border-box;"><p style="text-align: center; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">删除当前列</p></section></section></section> </section></section></section><section class="Powered-by-XIUMI V5" style="position: static; display: table-row-group; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="display: table-row; width: 100%; position: static; box-sizing: border-box;"><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-width: 1px; border-radius: 0px; border-style: solid; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">2</p></section><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">2  </p></section><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">2  </p></section><section class="group-empty" style="display: table-cell; vertical-align: middle; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(129, 203, 205); box-sizing: border-box;"><p style="text-align: center;">2  </p></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; display: table-row-group; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);" powered-by="xiumi.us"><section class="" style="display: table-row; width: 100%; position: static; box-sizing: border-box;"><section class="" style="display: table-cell; vertical-align: top; width: 25%; border-width: 1px; border-radius: 0px; border-style: solid; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: center; color: rgb(0, 0, 0); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">向右应用格式</p></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: center; color: rgb(102, 103, 103); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="text-align: justify; white-space: normal; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">在一行里面，可以复制当前单元格的格式到右边的所有单元。这里没有让它复制到一整行，是避免把左边单元格的格式覆盖。</p></section></section></section> </section><section class="" style="display: table-cell; vertical-align: top; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: center; color: rgb(0, 0, 0); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">向下应用格式</p></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: justify; color: rgb(102, 103, 103); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="white-space: normal; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">在一列里面，可以复制当前单元格的格式到下面的所有单元。</p></section></section></section> </section><section class="" style="display: table-cell; vertical-align: top; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: center; color: rgb(0, 0, 0); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">向下逐行应用</p></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: justify; color: rgb(102, 103, 103); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="white-space: normal; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">可以把一行的格式，复制到下面的所有行 。</p></section></section></section> </section><section class="" style="display: table-cell; vertical-align: top; width: 25%; border-style: solid; border-width: 1px; border-radius: 0px; border-color: rgb(255, 255, 255); background-color: rgb(236, 236, 236); box-sizing: border-box;"> <section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: center; color: rgb(0, 0, 0); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">向下隔行应用</p></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="margin: 10px 0%; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="text-align: justify; color: rgb(102, 103, 103); font-size: 12px; padding: 0px 5px; box-sizing: border-box;"><p style="white-space: normal; margin: 0px; padding: 0px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">可以把一行的格式，隔行复制到下面的行</p></section></section></section> </section></section></section></section></section></section><section class="Powered-by-XIUMI V5" style="position: static; box-sizing: border-box;" powered-by="xiumi.us"><section class="" style="text-align: center; margin-top: 10px; margin-bottom: 10px; font-size: 32px; position: static; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);"><section class="" style="width: 5em; height: 5em; margin: auto; display: inline-block; vertical-align: bottom; border-radius: 100%; background-color: rgb(249, 110, 87); box-sizing: border-box;"> <section style="display: table; width: 100%; height: 5em; box-sizing: border-box;"> <section class="" style="display: table-cell; vertical-align: middle; width: 100%; line-height: 1.2; color: rgb(255, 255, 255); font-size: 20px; padding: 10px; box-sizing: border-box; background-color: rgba(1, 0, 0, 0);">嘿嘿嘿</section> </section> </section></section></section></section>';
      render2.selectRootElement('#richContent').innerHTML = event.editor.value;
      this.editor = event.editor;
    };

    // 获取省市区json数据
    this.http.get(api.cities).subscribe(res => {
      const result: any = res;
      if (result.country) {
        for (let i = 0; i < result.country.length; i++) {
          vm.cityList.push(result.country[i].province);
        }
      }
    });
  }

  imageCropped(image: string) {
    this.croppedImage = image;
    // 将文件格式转换成file
    const formData = new FormData();   // 这里连带form里的其他参数也一起提交了,如果不需要提交其他参数可以直接FormData无参数的构造函数
    // convertBase64UrlToBlob函数是将base64编码转换为Blob
    const vm = this;
    formData.append('cropper', vm.convertBase64UrlToBlob(image));
    // append函数的第一个参数是后台获取数据的参数名,和html标签的input的name属性功能相同
    console.log('查看这个DOM节点', formData.get('cropper'), vm.convertBase64UrlToBlob(image));
    vm.cropperFile = formData.get('cropper');
  }

  imageLoaded() {
    this.cropperReady = true;
  }

  imageLoadFailed() {
    console.log('Load failed');
  }

  selectedFileOnChanged(event?: any) {
    if (event) {
      this.imageChangedEvent = event; // 通知裁剪插件
    }
  }

  jodiEditorUpload() { // 富文本的上传图片操作
    // 这里是文件选择完成后的操作处理
    const vm = this;
    for (let i = 0; i < vm.uploader.queue.length; i++) {
      vm.uploader.queue[i].onSuccess = (response, status, headers) => {
        // 上传文件成功
        if (status == 200) { // 上传文件后获取服务器返回的数据
          console.log(i + '上传成功', JSON.parse(response).file.url);
          this.editor.value += '<img style="max-width:100%;" src="' + JSON.parse(response).file.url + '">';
        }
        else { // 上传文件后获取服务器返回的数据错误
        }
      };
      this.uploader.queue[i].upload(); // 开始上传
    }
  }

  submitUpload() {
    console.log('裁剪图', this.croppedImage);
    console.log('cropperFile', this.cropperFile);
    const vm = this;
    if (this.cropperFile) {
      this.cropUploader = new FileUploader({
        url: vm.api.upload,
        method: 'POST',
        itemAlias: 'file' // 后端设定的字段名成
      });
      this.cropUploader.addToQueue([this.cropperFile]);
      this.cropUploader.uploadAll();
      for (let i = 0; i < this.cropUploader.queue.length; i++) {
        this.cropUploader.queue[i].onSuccess = (response, status, headers) => {
          // 上传文件成功
          if (status == 200) { // 上传文件后获取服务器返回的数据
            console.log(i + '上传成功', JSON.parse(response));
          }
          else { // 上传文件后获取服务器返回的数据错误
          }
        };
        this.cropUploader.queue[i].upload(); // 开始上传
      }
    }
  }

  convertBase64UrlToBlob(urlData) { // 将文件的base64转换成file
    const bytes = window.atob(urlData.split(',')[1]); // 去掉url的头，并转换为byte
    // 处理异常,将ascii码小于0的转换为大于0
    const ab = new ArrayBuffer(bytes.length);
    const ia = new Uint8Array(ab);
    for (let i = 0; i < bytes.length; i++) {
      ia[i] = bytes.charCodeAt(i);
    }
    return new Blob([ab], {type: 'image/png'});
  }

  selectSchool(data) {
    console.log('选择的学校', data);
    this.user.school = data.value;
  }

  selectCity(data) {
    console.log('选择地址', data);
  }

  selectHobby(data) {
    console.log('选择兴趣', data);
  }

  waning() {
    this.alert.warning('警告');
  }

  success() {
    this.alert.success('成功');
  }

  danger() {
    this.alert.error('危险');
  }

}
