import {Component} from '@angular/core';
import {globalService} from './common/service/global.service';
import {TranslateService} from '@ngx-translate/core';
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  globalData = {
    loadStatus: false
  };
  reloadStatus = true;
  userInfo = {
    nickname: '管理员',
    avatar: 'data:image/png;base64,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'
  };

  constructor(global: globalService, translate: TranslateService) {
    this.globalData = global;
    // 添加语言支持
    translate.addLangs(['zh-CN', 'en']);
    // this language will be used as a fallback when a translation isn't found in the current language
    translate.setDefaultLang('zh-CN');
    // the lang to use, if the lang isn't available, it will use the current loader to get them
    translate.use('zh-CN');
  }


  // todo 点击左侧菜单刷新右侧视图，这个方法能实现效果，但不是很优雅
  // 点击左侧菜单后会重新渲染右侧router-outlet组件
  reload() {
    this.reloadStatus = false;
    const vm = this;
    setTimeout(function () {
      vm.reloadStatus = true;
    }, 1);
  }
}
