<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Rivista</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

        <!-- Styles -->
        <style>
            /*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%}body{margin:0}a{background-color:transparent}[hidden]{display:none}html{font-family:system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;line-height:1.5}*,:after,:before{box-sizing:border-box;border:0 solid #e2e8f0}a{color:inherit;text-decoration:inherit}svg,video{display:block;vertical-align:middle}video{max-width:100%;height:auto}.bg-white{--bg-opacity:1;background-color:#fff;background-color:rgba(255,255,255,var(--bg-opacity))}.bg-gray-100{--bg-opacity:1;background-color:#f7fafc;background-color:rgba(247,250,252,var(--bg-opacity))}.border-gray-200{--border-opacity:1;border-color:#edf2f7;border-color:rgba(237,242,247,var(--border-opacity))}.border-t{border-top-width:1px}.flex{display:flex}.grid{display:grid}.hidden{display:none}.items-center{align-items:center}.justify-center{justify-content:center}.font-semibold{font-weight:600}.h-5{height:1.25rem}.h-8{height:2rem}.h-16{height:4rem}.text-sm{font-size:.875rem}.text-lg{font-size:1.125rem}.leading-7{line-height:1.75rem}.mx-auto{margin-left:auto;margin-right:auto}.ml-1{margin-left:.25rem}.mt-2{margin-top:.5rem}.mr-2{margin-right:.5rem}.ml-2{margin-left:.5rem}.mt-4{margin-top:1rem}.ml-4{margin-left:1rem}.mt-8{margin-top:2rem}.ml-12{margin-left:3rem}.-mt-px{margin-top:-1px}.max-w-6xl{max-width:72rem}.min-h-screen{min-height:100vh}.overflow-hidden{overflow:hidden}.p-6{padding:1.5rem}.py-4{padding-top:1rem;padding-bottom:1rem}.px-6{padding-left:1.5rem;padding-right:1.5rem}.pt-8{padding-top:2rem}.fixed{position:fixed}.relative{position:relative}.top-0{top:0}.right-0{right:0}.shadow{box-shadow:0 1px 3px 0 rgba(0,0,0,.1),0 1px 2px 0 rgba(0,0,0,.06)}.text-center{text-align:center}.text-gray-200{--text-opacity:1;color:#edf2f7;color:rgba(237,242,247,var(--text-opacity))}.text-gray-300{--text-opacity:1;color:#e2e8f0;color:rgba(226,232,240,var(--text-opacity))}.text-gray-400{--text-opacity:1;color:#cbd5e0;color:rgba(203,213,224,var(--text-opacity))}.text-gray-500{--text-opacity:1;color:#a0aec0;color:rgba(160,174,192,var(--text-opacity))}.text-gray-600{--text-opacity:1;color:#718096;color:rgba(113,128,150,var(--text-opacity))}.text-gray-700{--text-opacity:1;color:#4a5568;color:rgba(74,85,104,var(--text-opacity))}.text-gray-900{--text-opacity:1;color:#1a202c;color:rgba(26,32,44,var(--text-opacity))}.underline{text-decoration:underline}.antialiased{-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.w-5{width:1.25rem}.w-8{width:2rem}.w-auto{width:auto}.grid-cols-1{grid-template-columns:repeat(1,minmax(0,1fr))}@media (min-width:640px){.sm\:rounded-lg{border-radius:.5rem}.sm\:block{display:block}.sm\:items-center{align-items:center}.sm\:justify-start{justify-content:flex-start}.sm\:justify-between{justify-content:space-between}.sm\:h-20{height:5rem}.sm\:ml-0{margin-left:0}.sm\:px-6{padding-left:1.5rem;padding-right:1.5rem}.sm\:pt-0{padding-top:0}.sm\:text-left{text-align:left}.sm\:text-right{text-align:right}}@media (min-width:768px){.md\:border-t-0{border-top-width:0}.md\:border-l{border-left-width:1px}.md\:grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}}@media (min-width:1024px){.lg\:px-8{padding-left:2rem;padding-right:2rem}}@media (prefers-color-scheme:dark){.dark\:bg-gray-800{--bg-opacity:1;background-color:#2d3748;background-color:rgba(45,55,72,var(--bg-opacity))}.dark\:bg-gray-900{--bg-opacity:1;background-color:#1a202c;background-color:rgba(26,32,44,var(--bg-opacity))}.dark\:border-gray-700{--border-opacity:1;border-color:#4a5568;border-color:rgba(74,85,104,var(--border-opacity))}.dark\:text-white{--text-opacity:1;color:#fff;color:rgba(255,255,255,var(--text-opacity))}.dark\:text-gray-400{--text-opacity:1;color:#cbd5e0;color:rgba(203,213,224,var(--text-opacity))}.dark\:text-gray-500{--tw-text-opacity:1;color:#6b7280;color:rgba(107,114,128,var(--tw-text-opacity))}}
        </style>

        <style>
            body {
                font-family: 'Nunito', sans-serif;
            }
        </style>
    </head>
    <body class="antialiased">
        <div class="relative flex items-top justify-center min-h-screen bg-gray-100 dark:bg-gray-900 sm:items-center py-4 sm:pt-0">
            @if (Route::has('login'))
                <div class="hidden fixed top-0 right-0 px-6 py-4 sm:block">
                    @auth
                        <a href="{{ url('/home') }}" class="text-sm text-gray-700 dark:text-gray-500 underline">Home</a>
                    @else
                        <a href="{{ route('login') }}" class="text-sm text-gray-700 dark:text-gray-500 underline">Log in</a>

                        @if (Route::has('register'))
                            <a href="{{ route('register') }}" class="ml-4 text-sm text-gray-700 dark:text-gray-500 underline">Register</a>
                        @endif
                    @endauth
                </div>
            @endif

            <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
                <div class="flex justify-center pt-8 sm:justify-start sm:pt-0">
                    <svg width="240.154" height="77.5" viewBox="0 0 240.154 77.5" xmlns="http://www.w3.org/2000/svg"><g id="svgGroup" stroke-linecap="round" fill-rule="evenodd" font-size="9pt" stroke="#000" stroke-width="0.25mm" fill="#000" style="stroke:#000;stroke-width:0.25mm;fill:#000"><path d="M 68.501 77.5 Q 67.501 77.5 66.501 77.4 Q 65.501 77.3 64.401 77.1 A 40.132 40.132 0 0 1 55.298 74.25 A 35.823 35.823 0 0 1 52.101 72.6 Q 46.601 69.4 42.251 65.15 Q 37.901 60.9 34.351 56.2 A 202.278 202.278 0 0 1 30.167 50.462 A 169.018 169.018 0 0 1 27.901 47.15 A 188.211 188.211 0 0 0 25.27 43.303 Q 23.829 41.253 22.501 39.5 A 1.468 1.468 0 0 0 22.444 39.374 Q 22.27 39.036 22.061 39.192 A 0.38 0.38 0 0 0 22.051 39.2 L 21.801 39.4 Q 19.601 43.6 17.751 47.25 Q 16.226 50.258 15.347 52.282 A 41.064 41.064 0 0 0 15.001 53.1 Q 14.201 55.3 14.201 56.2 A 2.614 2.614 0 0 0 14.246 56.711 Q 14.407 57.513 15.136 57.591 A 1.541 1.541 0 0 0 15.301 57.6 A 2.484 2.484 0 0 0 16.402 57.322 Q 17.189 56.934 18.032 56.007 A 10.623 10.623 0 0 0 18.301 55.7 Q 19.401 54.4 20.351 53.25 A 5.292 5.292 0 0 1 20.696 52.868 Q 21.431 52.137 22.001 52.3 Q 22.084 52.383 22.098 52.534 A 0.703 0.703 0 0 1 22.101 52.6 A 1.013 1.013 0 0 1 22.04 52.925 Q 21.936 53.229 21.655 53.621 A 6.226 6.226 0 0 1 21.401 53.95 A 150.218 150.218 0 0 1 21.235 54.151 Q 20.689 54.813 20.601 54.9 A 116.03 116.03 0 0 0 20.223 55.444 Q 19.614 56.325 18.751 57.6 A 26.903 26.903 0 0 1 17.127 59.766 A 22.853 22.853 0 0 1 16.351 60.65 A 5.256 5.256 0 0 1 15.535 61.376 Q 14.977 61.771 14.39 61.916 A 2.862 2.862 0 0 1 13.701 62 A 0.978 0.978 0 0 1 13.6 61.993 Q 13.323 61.963 12.551 61.8 A 14.483 14.483 0 0 1 11.073 61.409 A 12.985 12.985 0 0 1 10.751 61.3 A 3.665 3.665 0 0 1 10.415 61.164 Q 10.082 61.008 9.926 60.828 A 0.553 0.553 0 0 1 9.801 60.6 Q 9.601 58.7 10.751 55.25 A 55.907 55.907 0 0 1 12.016 51.851 Q 12.633 50.336 13.385 48.702 A 92.988 92.988 0 0 1 13.901 47.6 Q 15.901 43.4 18.001 39.4 Q 16.401 39 15.701 38.7 A 2.418 2.418 0 0 1 15.044 38.035 Q 14.722 37.536 14.702 36.887 A 2.816 2.816 0 0 1 14.701 36.8 A 2.381 2.381 0 0 1 15.229 35.307 A 3.272 3.272 0 0 1 15.501 35 Q 16.164 34.338 17.375 34.224 A 5.627 5.627 0 0 1 17.901 34.2 Q 18.401 34.2 19.101 34.4 A 2.393 2.393 0 0 1 19.691 34.653 A 1.937 1.937 0 0 1 20.201 35.1 Q 21.901 32.1 23.251 29.6 Q 24.601 27.1 25.201 25.7 A 14.108 14.108 0 0 0 25.537 25.047 Q 25.853 24.388 25.992 23.883 A 4.141 4.141 0 0 0 26.001 23.85 A 9.379 9.379 0 0 0 26.098 23.456 Q 26.177 23.097 26.195 22.845 A 1.983 1.983 0 0 0 26.201 22.7 Q 26.201 22.1 26.001 21.7 A 4.627 4.627 0 0 1 26.212 20.917 Q 26.492 20.131 27.085 19.107 A 21.039 21.039 0 0 1 27.451 18.5 A 23.088 23.088 0 0 1 29.165 16.125 A 29.266 29.266 0 0 1 30.601 14.5 A 20.58 20.58 0 0 1 34.088 11.543 A 18.885 18.885 0 0 1 34.701 11.15 A 10.987 10.987 0 0 1 36.244 10.354 Q 37.584 9.8 38.801 9.8 A 3.125 3.125 0 0 1 39.178 9.826 Q 39.586 9.876 40.174 10.023 A 17.524 17.524 0 0 1 40.651 10.15 Q 41.901 10.5 43.051 11.2 A 3.117 3.117 0 0 1 44.137 12.276 A 3.216 3.216 0 0 1 44.501 13.2 A 1.89 1.89 0 0 1 44.601 13.791 A 1.801 1.801 0 0 1 44.601 13.8 A 0.666 0.666 0 0 1 44.593 13.906 Q 44.563 14.091 44.416 14.1 A 0.253 0.253 0 0 1 44.401 14.1 A 0.749 0.749 0 0 1 44.265 14.086 Q 44.132 14.061 43.956 13.993 A 3.256 3.256 0 0 1 43.851 13.95 Q 43.563 13.826 43.376 13.805 A 0.649 0.649 0 0 0 43.301 13.8 A 5.737 5.737 0 0 0 41.11 14.271 Q 39.397 14.978 37.478 16.746 A 22.449 22.449 0 0 0 37.051 17.15 A 44.216 44.216 0 0 0 34.013 20.435 Q 32.539 22.19 31.047 24.274 A 78.252 78.252 0 0 0 30.051 25.7 Q 26.501 30.9 23.401 36.5 A 32.208 32.208 0 0 1 23.867 36.597 Q 24.185 36.666 24.551 36.75 A 5.38 5.38 0 0 0 25.156 36.851 Q 25.466 36.886 25.819 36.896 A 10.096 10.096 0 0 0 26.101 36.9 L 26.851 36.9 A 2.785 2.785 0 0 0 27.261 36.868 A 3.572 3.572 0 0 0 27.601 36.8 A 84.437 84.437 0 0 0 38.992 34.733 A 93.909 93.909 0 0 0 40.651 34.3 A 67.222 67.222 0 0 0 52.19 30.046 A 61.963 61.963 0 0 0 53.101 29.6 Q 58.901 26.7 62.701 22.8 Q 65.457 19.887 66.043 16.85 A 8.688 8.688 0 0 0 66.201 15.2 A 7.595 7.595 0 0 0 64.911 10.994 A 10.31 10.31 0 0 0 64.001 9.8 Q 62.318 7.887 59.171 6.677 A 22.415 22.415 0 0 0 57.101 6 Q 54.301 5.2 50.751 4.8 A 63.381 63.381 0 0 0 46.099 4.456 A 77.902 77.902 0 0 0 43.101 4.4 A 80.681 80.681 0 0 0 31.633 5.242 A 89.593 89.593 0 0 0 29.951 5.5 A 66.262 66.262 0 0 0 19.923 7.921 A 59.117 59.117 0 0 0 17.301 8.85 A 38.926 38.926 0 0 0 11.915 11.365 A 29.369 29.369 0 0 0 7.401 14.5 Q 3.401 17.9 2.601 22.6 Q 2.444 23.858 2.699 24.841 A 3.839 3.839 0 0 0 3.501 26.4 Q 4.701 27.8 6.451 28.55 A 38.016 38.016 0 0 1 7.472 29.004 Q 8.444 29.455 9.108 29.845 A 11.023 11.023 0 0 1 9.201 29.9 A 4.385 4.385 0 0 1 9.474 30.153 Q 9.737 30.42 9.838 30.642 A 0.625 0.625 0 0 1 9.901 30.9 A 0.506 0.506 0 0 1 9.817 31.198 Q 9.57 31.549 8.601 31.4 Q 7.208 31.102 5.172 30.011 A 26.971 26.971 0 0 1 5.151 30 A 11.445 11.445 0 0 1 1.846 27.308 A 13.224 13.224 0 0 1 1.551 26.95 Q 0.001 25 0.001 22.4 Q 0.001 22 0.051 21.6 Q 0.101 21.2 0.201 20.8 Q 0.201 20.715 0.165 20.301 A 55.963 55.963 0 0 0 0.151 20.15 A 14.333 14.333 0 0 1 0.121 19.759 Q 0.101 19.45 0.101 19.2 Q 0.701 16.1 3.151 13.35 Q 5.601 10.6 8.751 8.45 A 55.873 55.873 0 0 1 11.421 6.731 Q 12.771 5.919 14.026 5.284 A 32.781 32.781 0 0 1 14.601 5 Q 18.833 2.929 24.605 1.628 A 66.683 66.683 0 0 1 25.901 1.35 A 67.845 67.845 0 0 1 37.91 0.021 A 75.623 75.623 0 0 1 39.701 0 Q 44.101 0 48.451 0.6 Q 52.801 1.2 56.901 2.5 A 21.91 21.91 0 0 1 61.4 4.555 A 16.475 16.475 0 0 1 65.751 8.35 A 14.455 14.455 0 0 1 67.613 11.328 Q 68.627 13.54 68.627 15.855 A 10.704 10.704 0 0 1 68.601 16.6 Q 68.301 20.7 65.751 24 Q 63.201 27.3 59.251 29.75 A 46.607 46.607 0 0 1 52.376 33.24 A 53.336 53.336 0 0 1 50.551 33.95 Q 45.801 35.7 41.001 36.8 Q 37.101 37.6 32.801 38.1 A 138.764 138.764 0 0 1 27.621 38.608 A 114.252 114.252 0 0 1 24.701 38.8 Q 29.001 44.1 33.251 49.45 Q 37.501 54.8 42.351 59.5 Q 47.201 64.2 53.001 67.55 A 40.034 40.034 0 0 0 62.545 71.478 A 47.643 47.643 0 0 0 66.101 72.3 Q 67.601 72.6 69.201 72.6 Q 71.801 72.6 74.351 71.8 A 11.014 11.014 0 0 0 77.015 70.574 A 9.448 9.448 0 0 0 78.601 69.3 A 5.704 5.704 0 0 0 80.201 66.092 A 8.049 8.049 0 0 0 80.301 64.8 Q 80.301 64.3 80.251 63.8 Q 80.201 63.3 80.101 62.8 A 1.287 1.287 0 0 0 80.097 62.695 Q 80.087 62.572 80.051 62.5 A 0.482 0.482 0 0 1 80.011 62.388 A 0.408 0.408 0 0 1 80.001 62.3 Q 80.001 61.4 80.701 61.4 A 1.08 1.08 0 0 1 81.66 61.957 Q 81.793 62.169 81.888 62.461 A 3.864 3.864 0 0 1 82.001 62.9 A 15.985 15.985 0 0 1 82.242 64.503 A 12.514 12.514 0 0 1 82.301 65.7 A 15.919 15.919 0 0 1 82.203 67.497 A 13.208 13.208 0 0 1 82.051 68.5 Q 81.801 69.8 81.401 70.9 A 6.608 6.608 0 0 1 79.778 73.512 Q 78.648 74.665 76.851 75.6 A 16.786 16.786 0 0 1 71.13 77.341 A 21.203 21.203 0 0 1 68.501 77.5 Z M 211.301 60.3 Q 209.601 60.3 208.151 59.5 Q 206.933 58.828 206.244 57.169 A 8.343 8.343 0 0 1 206.001 56.5 A 3.597 3.597 0 0 1 205.994 56.479 Q 205.701 55.581 205.701 54 A 19.112 19.112 0 0 1 205.846 51.713 Q 205.996 50.471 206.301 49.1 A 48.149 48.149 0 0 1 206.765 47.188 Q 207.164 45.688 207.601 44.5 A 1.274 1.274 0 0 0 207.342 44.652 Q 206.806 45.039 205.751 46.25 Q 204.401 47.8 202.451 49.95 Q 200.501 52.1 198.151 54.25 A 27.481 27.481 0 0 1 194.887 56.826 A 23.533 23.533 0 0 1 193.301 57.8 A 11.787 11.787 0 0 1 191.056 58.781 A 8.881 8.881 0 0 1 188.401 59.2 A 6.173 6.173 0 0 1 186.658 58.936 Q 185.953 58.729 185.213 58.359 A 10.8 10.8 0 0 1 185.001 58.25 A 8.845 8.845 0 0 1 183.024 56.848 A 7.818 7.818 0 0 1 182.101 55.8 A 8.194 8.194 0 0 1 181.109 54.111 A 6.081 6.081 0 0 1 180.601 51.7 A 8.858 8.858 0 0 1 181.154 48.687 Q 181.613 47.414 182.451 46.1 A 26.725 26.725 0 0 1 185.036 42.709 A 34.071 34.071 0 0 1 187.251 40.45 Q 190.201 37.7 193.551 35.45 A 68.72 68.72 0 0 1 197.225 33.14 A 53.606 53.606 0 0 1 199.951 31.65 Q 203.001 30.1 204.901 29.6 A 13.902 13.902 0 0 1 207.309 29.115 A 18.306 18.306 0 0 1 209.401 29 A 12.297 12.297 0 0 1 211.557 29.197 A 14.299 14.299 0 0 1 212.301 29.35 A 7.272 7.272 0 0 1 213.597 29.777 A 5.45 5.45 0 0 1 214.801 30.5 Q 215.601 30.9 216.101 31.6 A 2.688 2.688 0 0 1 216.51 32.437 A 2.439 2.439 0 0 1 216.601 33.1 A 1.351 1.351 0 0 1 216.587 33.305 Q 216.51 33.805 216.01 33.641 A 1.325 1.325 0 0 1 215.901 33.6 Q 215.101 32.4 213.751 32.05 Q 212.401 31.7 211.001 31.7 Q 207.675 31.7 203.796 33.498 A 28.595 28.595 0 0 0 202.201 34.3 A 42.604 42.604 0 0 0 193.84 40.182 A 39.904 39.904 0 0 0 193.601 40.4 Q 192.401 41.4 190.351 43.85 Q 188.301 46.3 186.601 49.2 Q 185.354 51.327 185.022 53.185 A 7.463 7.463 0 0 0 184.901 54.5 A 4.095 4.095 0 0 0 185.161 55.973 A 3.804 3.804 0 0 0 185.601 56.8 A 1.314 1.314 0 0 0 186.544 57.469 A 1.956 1.956 0 0 0 186.901 57.5 A 3.63 3.63 0 0 0 187.842 57.361 Q 188.752 57.115 189.937 56.434 A 17.968 17.968 0 0 0 190.651 56 A 38.414 38.414 0 0 0 193.342 54.107 A 49.415 49.415 0 0 0 195.501 52.35 Q 198.001 50.2 200.051 48.2 Q 201.939 46.358 202.851 45.449 A 105.882 105.882 0 0 0 203.001 45.3 A 25.395 25.395 0 0 0 203.265 45.031 Q 203.689 44.595 204.452 43.782 A 316.244 316.244 0 0 0 204.951 43.25 Q 206.401 41.7 208.101 39.9 A 116.971 116.971 0 0 1 209.522 38.421 Q 210.392 37.531 211.151 36.8 A 19.73 19.73 0 0 1 211.624 36.358 Q 212.557 35.517 212.888 35.5 A 0.261 0.261 0 0 1 212.901 35.5 Q 213.397 35.5 214.532 35.746 A 25.735 25.735 0 0 1 214.551 35.75 Q 215.701 36 216.501 36.5 Q 217.246 36.965 216.864 37.691 A 1.702 1.702 0 0 1 216.801 37.8 Q 214.201 41.6 212.651 45.75 A 57.222 57.222 0 0 0 211.878 47.946 Q 211.176 50.087 210.903 51.629 A 13.325 13.325 0 0 0 210.801 52.3 A 3.473 3.473 0 0 0 210.722 52.723 A 2.713 2.713 0 0 0 210.701 53.05 L 210.701 53.8 A 8.462 8.462 0 0 0 210.808 55.21 Q 211.233 57.712 213.35 57.797 A 3.763 3.763 0 0 0 213.501 57.8 A 3.457 3.457 0 0 0 214.48 57.641 Q 215.398 57.368 216.577 56.626 A 18.104 18.104 0 0 0 217.501 56 A 42.593 42.593 0 0 0 220.345 53.754 A 53.976 53.976 0 0 0 222.601 51.7 A 114.022 114.022 0 0 0 225.675 48.634 A 94.536 94.536 0 0 0 227.351 46.85 Q 229.501 44.5 230.301 43.3 Q 230.502 43.099 230.702 43.033 A 0.629 0.629 0 0 1 230.901 43 Q 231.301 43 231.601 43.35 A 0.634 0.634 0 0 1 231.716 43.54 Q 231.81 43.792 231.652 44.107 A 1.399 1.399 0 0 1 231.601 44.2 A 23.692 23.692 0 0 1 230.727 45.52 Q 229.779 46.859 228.401 48.5 A 62.115 62.115 0 0 1 225.047 52.172 A 72.15 72.15 0 0 1 223.701 53.5 A 52.411 52.411 0 0 1 220.808 56.091 A 41.342 41.342 0 0 1 218.601 57.8 A 10.297 10.297 0 0 1 217.228 58.683 Q 216.364 59.152 215.301 59.55 A 11.527 11.527 0 0 1 212.051 60.274 A 10.69 10.69 0 0 1 211.301 60.3 Z M 134.701 55.9 L 134.901 55.9 Q 135.387 55.9 135.401 56.231 A 0.47 0.47 0 0 1 135.401 56.25 Q 135.401 56.543 135.12 56.801 A 1.551 1.551 0 0 1 135.001 56.9 A 9.56 9.56 0 0 0 133.579 57.764 A 6.927 6.927 0 0 0 132.201 59.1 A 3.12 3.12 0 0 0 131.754 59.753 A 2.308 2.308 0 0 0 131.501 60.8 A 1.914 1.914 0 0 0 131.612 61.481 Q 131.961 62.4 133.401 62.4 Q 135.501 62.4 137.951 61.15 Q 140.401 59.9 142.651 57.85 A 21.439 21.439 0 0 0 145.105 55.224 A 17.886 17.886 0 0 0 146.301 53.5 Q 147.534 51.474 147.681 49.603 A 6.425 6.425 0 0 0 147.701 49.1 A 2.663 2.663 0 0 0 147.186 47.545 Q 146.913 47.156 146.496 46.791 A 5.907 5.907 0 0 0 146.201 46.55 Q 144.701 45.4 142.901 44.45 Q 141.417 43.667 140.545 43.122 A 14.027 14.027 0 0 1 140.201 42.9 A 21.03 21.03 0 0 1 138.678 41.685 A 18.277 18.277 0 0 1 138.201 41.25 Q 137.301 40.4 136.801 39.4 A 55.758 55.758 0 0 1 136.138 40.527 Q 135.835 41.029 135.488 41.585 A 112.933 112.933 0 0 1 134.751 42.75 A 41.148 41.148 0 0 1 133.202 44.991 A 51.824 51.824 0 0 1 131.801 46.8 Q 131.4 47.201 130.999 47.334 A 1.258 1.258 0 0 1 130.601 47.4 A 1.052 1.052 0 0 1 130.378 47.379 Q 130.057 47.309 130.009 47.01 A 0.702 0.702 0 0 1 130.001 46.9 Q 130.001 46.622 130.43 46.001 A 7.834 7.834 0 0 1 130.501 45.9 Q 132.568 43.45 133.815 41.293 A 19.462 19.462 0 0 0 134.501 40 A 94.004 94.004 0 0 0 135.101 38.731 Q 135.926 36.95 136.301 35.9 A 9.54 9.54 0 0 1 137.67 32.181 A 12.886 12.886 0 0 1 139.001 30.4 A 22.249 22.249 0 0 1 143.109 26.8 A 26.239 26.239 0 0 1 144.601 25.85 A 33.065 33.065 0 0 1 150.92 22.941 A 30.752 30.752 0 0 1 151.351 22.8 Q 154.225 21.884 156.578 21.731 A 14.224 14.224 0 0 1 157.501 21.7 Q 160.201 21.7 162.301 22.7 Q 164.306 23.655 164.397 25.703 A 4.444 4.444 0 0 1 164.401 25.9 A 4.791 4.791 0 0 1 164.231 27.13 Q 164.057 27.789 163.701 28.5 Q 162.801 30.4 160.701 31.9 Q 160.618 31.983 160.467 31.997 A 0.703 0.703 0 0 1 160.401 32 A 1.33 1.33 0 0 1 160.099 31.969 Q 159.687 31.873 159.616 31.478 A 1.002 1.002 0 0 1 159.601 31.3 Q 159.601 30.886 159.944 30.472 A 2.487 2.487 0 0 1 160.101 30.3 Q 160.901 29.6 161.401 28.6 Q 161.892 27.618 161.901 26.732 A 3.249 3.249 0 0 0 161.901 26.7 A 2.189 2.189 0 0 0 161.778 25.935 Q 161.393 24.9 159.801 24.9 A 10.031 10.031 0 0 0 158.5 24.991 Q 157.489 25.123 156.301 25.45 Q 154.301 26 152.451 26.75 Q 150.601 27.5 149.401 28.1 Q 146.901 29.3 144.801 31.05 A 21.748 21.748 0 0 0 142.502 33.288 A 27.896 27.896 0 0 0 140.801 35.4 A 8.097 8.097 0 0 0 140.091 36.488 Q 139.764 37.099 139.618 37.682 A 3.776 3.776 0 0 0 139.501 38.6 A 2.869 2.869 0 0 0 140.064 40.273 Q 140.392 40.74 140.911 41.183 A 8.297 8.297 0 0 0 141.901 41.9 Q 144.401 43.3 146.851 44.6 A 24.998 24.998 0 0 1 149.097 45.939 A 18.438 18.438 0 0 1 151.001 47.4 A 5.287 5.287 0 0 1 152.129 48.766 A 4.477 4.477 0 0 1 152.701 51 Q 152.701 53.3 149.801 56.5 A 16.365 16.365 0 0 1 147.876 58.301 Q 146.595 59.33 144.951 60.3 Q 141.901 62.1 138.501 63.2 A 25.073 25.073 0 0 1 135.641 63.952 Q 134.152 64.246 132.798 64.292 A 14.668 14.668 0 0 1 132.301 64.3 Q 131.201 64.3 130.101 64 A 2.874 2.874 0 0 1 129.281 63.641 A 2.35 2.35 0 0 1 128.501 62.8 Q 128.101 62 128.601 60.85 Q 129.101 59.7 130.001 58.8 Q 130.801 58 132.051 57.2 Q 133.301 56.4 134.701 55.9 Z M 175.501 30.2 L 176.701 30.1 A 86.758 86.758 0 0 0 179.883 29.778 A 74.18 74.18 0 0 0 181.251 29.6 A 22.551 22.551 0 0 1 182.955 29.431 Q 184.451 29.338 186.201 29.4 A 3.729 3.729 0 0 1 186.879 29.465 A 4.572 4.572 0 0 1 187.251 29.55 A 1.713 1.713 0 0 1 187.452 29.617 Q 187.662 29.704 187.746 29.825 A 0.302 0.302 0 0 1 187.801 30 Q 187.801 30.359 185.711 30.959 A 32.201 32.201 0 0 1 185.201 31.1 A 5.137 5.137 0 0 1 184.651 31.277 Q 183.734 31.526 181.954 31.794 A 71.866 71.866 0 0 1 180.851 31.95 Q 177.501 32.4 174.001 32.8 Q 173.314 34.106 172.721 35.105 A 29.563 29.563 0 0 1 172.201 35.95 A 50.206 50.206 0 0 0 171.832 36.534 Q 171.351 37.309 171.124 37.754 A 6.149 6.149 0 0 0 171.101 37.8 Q 168.901 42.4 167.151 46.15 A 33.154 33.154 0 0 0 166.229 48.31 Q 165.434 50.386 165.239 51.941 A 8.661 8.661 0 0 0 165.201 52.3 A 3.473 3.473 0 0 0 165.122 52.723 A 2.713 2.713 0 0 0 165.101 53.05 L 165.101 53.8 A 9.213 9.213 0 0 0 165.192 55.159 Q 165.589 57.8 167.701 57.8 Q 169.079 57.8 171.125 56.502 A 17.991 17.991 0 0 0 171.801 56.05 A 36.109 36.109 0 0 0 174.605 53.862 A 47.099 47.099 0 0 0 176.901 51.75 A 136.374 136.374 0 0 0 179.975 48.641 A 111.425 111.425 0 0 0 181.651 46.85 Q 183.801 44.5 184.601 43.3 Q 184.802 43.099 185.002 43.033 A 0.629 0.629 0 0 1 185.201 43 A 0.864 0.864 0 0 1 185.54 43.065 A 0.815 0.815 0 0 1 185.851 43.3 A 0.598 0.598 0 0 1 185.99 43.695 Q 185.99 43.878 185.901 44.1 A 14.286 14.286 0 0 1 185.216 45.246 Q 184.329 46.597 182.851 48.35 A 64.863 64.863 0 0 1 179.384 52.135 A 75.121 75.121 0 0 1 178.051 53.45 A 53.998 53.998 0 0 1 175.278 55.948 A 41.372 41.372 0 0 1 172.901 57.8 A 10.702 10.702 0 0 1 171.489 58.71 Q 170.761 59.107 169.9 59.452 A 18.262 18.262 0 0 1 169.651 59.55 Q 167.701 60.3 165.701 60.3 Q 163.901 60.3 162.451 59.5 Q 161.233 58.828 160.544 57.169 A 8.343 8.343 0 0 1 160.301 56.5 Q 160.201 56.2 160.151 55.9 A 3.407 3.407 0 0 1 160.117 55.618 Q 160.105 55.473 160.102 55.311 A 6.069 6.069 0 0 1 160.101 55.2 A 11.462 11.462 0 0 1 160.207 53.707 Q 160.309 52.938 160.507 52.061 A 28.041 28.041 0 0 1 161.001 50.2 Q 161.901 47.2 163.201 44.4 A 49.639 49.639 0 0 0 162.723 45.049 Q 162.512 45.34 162.282 45.665 A 95.797 95.797 0 0 0 161.801 46.35 Q 161.038 47.447 159.637 49.137 A 87.849 87.849 0 0 1 159.501 49.3 A 1.474 1.474 0 0 1 159.16 49.559 A 1.16 1.16 0 0 1 158.601 49.7 Q 157.901 49.7 157.901 48.9 A 1.479 1.479 0 0 1 157.992 48.374 A 1.329 1.329 0 0 1 158.301 47.9 Q 160.901 44.6 162.951 42 Q 164.956 39.458 165.956 37.68 A 16.315 16.315 0 0 0 166.001 37.6 Q 166.001 37.429 166.44 36.636 A 24.318 24.318 0 0 1 166.601 36.35 Q 167.201 35.3 168.201 33.4 A 58.142 58.142 0 0 1 167.636 33.468 Q 167.415 33.493 167.219 33.514 A 27.618 27.618 0 0 1 166.851 33.55 A 14.333 14.333 0 0 1 166.46 33.58 Q 166.151 33.6 165.901 33.6 Q 165.201 33.6 164.701 33 Q 164.201 32.4 164.601 31.5 Q 165.101 30.1 166.801 29.9 Q 168.262 29.728 169.428 29.63 A 52.56 52.56 0 0 1 169.801 29.6 Q 169.894 29.414 170.16 29.401 A 0.839 0.839 0 0 1 170.201 29.4 A 290.614 290.614 0 0 0 172.432 25.231 A 267.327 267.327 0 0 0 172.501 25.1 A 670.55 670.55 0 0 1 173.029 24.094 Q 173.789 22.65 174.351 21.6 A 88.914 88.914 0 0 0 174.527 21.27 Q 175.079 20.23 175.1 20.108 A 0.049 0.049 0 0 0 175.101 20.1 A 472.743 472.743 0 0 0 175.909 18.803 Q 177.232 16.67 177.701 15.85 A 3.045 3.045 0 0 1 178.178 15.211 A 2.146 2.146 0 0 1 179.301 14.6 A 8.282 8.282 0 0 1 180.051 14.567 Q 180.625 14.567 181.235 14.641 A 11.315 11.315 0 0 1 181.651 14.7 A 4.007 4.007 0 0 1 182.255 14.842 Q 182.561 14.941 182.791 15.085 A 1.469 1.469 0 0 1 183.301 15.6 A 1.47 1.47 0 0 1 183.566 16.211 A 2.039 2.039 0 0 1 183.601 16.6 Q 183.601 17.5 183.201 18.35 A 9.825 9.825 0 0 1 182.914 18.916 Q 182.769 19.177 182.625 19.392 A 4.476 4.476 0 0 1 182.401 19.7 A 2.44 2.44 0 0 1 182.019 20.211 A 1.885 1.885 0 0 1 181.351 20.65 Q 180.701 20.9 180.201 21.9 Q 179.201 23.8 178.001 26 Q 176.801 28.2 175.501 30.2 Z M 79.379 62.359 A 3.468 3.468 0 0 0 80.401 62.5 Q 80.554 62.5 80.883 62.383 A 6.137 6.137 0 0 0 81.101 62.3 A 1.051 1.051 0 0 0 81.267 62.217 Q 81.457 62.098 81.539 61.914 A 0.765 0.765 0 0 0 81.601 61.6 Q 81.801 59.9 83.751 56.7 A 60.276 60.276 0 0 1 84.726 55.156 Q 85.588 53.833 86.618 52.388 A 111.826 111.826 0 0 1 88.751 49.5 A 117.151 117.151 0 0 1 89.522 48.5 A 129.581 129.581 0 0 1 95.401 41.5 A 129.256 129.256 0 0 1 96.753 40.021 A 115.301 115.301 0 0 1 102.651 34.1 Q 104.704 32.188 106.599 30.686 A 43.233 43.233 0 0 1 109.451 28.6 A 22.727 22.727 0 0 1 110.055 28.211 Q 112.806 26.5 114.701 26.5 L 116.601 26.5 A 3.517 3.517 0 0 1 116.93 26.515 Q 117.687 26.586 118.101 27 A 7.602 7.602 0 0 0 118.298 27.128 Q 118.736 27.4 118.901 27.4 Q 119.701 27.4 119.701 26.2 A 2.504 2.504 0 0 0 119.674 25.82 Q 119.598 25.323 119.301 25.1 Q 118.901 24.3 117.701 23.7 A 5.481 5.481 0 0 0 116.313 23.232 A 7.225 7.225 0 0 0 114.901 23.1 A 4.935 4.935 0 0 0 114.745 23.102 Q 114.197 23.12 113.6 23.258 A 8.283 8.283 0 0 0 112.501 23.6 Q 109.501 24.8 107.101 26.75 Q 104.701 28.7 102.401 31 Q 96.701 36.3 91.801 42.5 Q 86.901 48.7 82.201 54.9 Q 82.051 53.545 82.58 51.284 A 29.306 29.306 0 0 1 83.001 49.7 Q 84.001 46.3 85.001 43.5 A 2.687 2.687 0 0 1 85.037 43.347 Q 85.177 42.815 85.651 41.65 A 109.7 109.7 0 0 0 85.687 41.563 Q 86.222 40.245 86.851 38.6 Q 87.501 36.9 88.051 35.45 Q 88.601 34 88.601 33.4 Q 88.704 32.99 88.675 32.58 A 2.767 2.767 0 0 0 88.501 31.8 A 4.292 4.292 0 0 0 88.212 31.178 A 3.185 3.185 0 0 0 87.701 30.5 A 4.014 4.014 0 0 0 87.676 30.469 A 3.154 3.154 0 0 0 85.701 29.3 Q 84.501 29.1 83.101 29.1 A 1.309 1.309 0 0 0 83.058 29.101 Q 82.862 29.107 82.248 29.166 A 80.158 80.158 0 0 0 81.901 29.2 A 53.008 53.008 0 0 0 81.331 29.26 A 61.618 61.618 0 0 0 79.801 29.45 Q 79.008 29.558 78.579 29.744 A 1.375 1.375 0 0 0 78.301 29.9 Q 77.842 30.513 77.734 30.832 A 0.541 0.541 0 0 0 77.701 31 A 0.442 0.442 0 0 0 77.714 31.111 Q 77.749 31.247 77.882 31.285 A 0.432 0.432 0 0 0 78.001 31.3 A 0.352 0.352 0 0 0 78.034 31.299 Q 78.11 31.291 78.151 31.25 A 0.148 0.148 0 0 1 78.19 31.222 Q 78.214 31.21 78.245 31.205 A 0.319 0.319 0 0 1 78.301 31.2 Q 78.701 31.1 79.001 31.05 Q 79.301 31 79.601 31 Q 81.301 31 81.951 32.35 Q 82.488 33.464 82.445 35.021 A 9.407 9.407 0 0 1 82.401 35.7 Q 81.901 37.2 80.601 39.65 Q 79.789 41.181 78.585 43.005 A 69.626 69.626 0 0 1 77.001 45.3 A 1.688 1.688 0 0 0 76.921 45.408 Q 76.734 45.684 76.734 45.944 A 0.746 0.746 0 0 0 76.801 46.25 A 1.019 1.019 0 0 0 76.923 46.46 A 0.577 0.577 0 0 0 77.401 46.7 Q 77.745 46.7 78.041 46.464 A 1.664 1.664 0 0 0 78.301 46.2 Q 79.201 44.9 80.051 43.7 Q 80.901 42.5 81.601 41.5 Q 81.301 42.8 81.001 43.9 A 280.067 280.067 0 0 1 80.939 44.128 Q 80.68 45.074 80.501 45.7 Q 79.601 48.7 78.651 51.75 A 51.736 51.736 0 0 0 78.311 52.888 A 45.642 45.642 0 0 0 77.201 57.7 Q 77.158 58.381 77.261 59.063 A 7.276 7.276 0 0 0 77.801 60.9 Q 78.293 62.025 79.379 62.359 Z M 59.501 60.3 Q 57.701 60.3 56.251 59.5 Q 55.033 58.828 54.344 57.169 A 8.343 8.343 0 0 1 54.101 56.5 Q 54.001 56.2 53.951 55.9 A 3.407 3.407 0 0 1 53.917 55.618 Q 53.905 55.473 53.902 55.311 A 6.069 6.069 0 0 1 53.901 55.2 A 11.462 11.462 0 0 1 54.007 53.707 Q 54.109 52.938 54.307 52.061 A 28.041 28.041 0 0 1 54.801 50.2 Q 55.701 47.2 57.001 44.4 A 49.639 49.639 0 0 0 56.523 45.049 Q 56.312 45.34 56.082 45.665 A 95.797 95.797 0 0 0 55.601 46.35 Q 54.838 47.447 53.437 49.137 A 87.849 87.849 0 0 1 53.301 49.3 A 1.474 1.474 0 0 1 52.96 49.559 A 1.16 1.16 0 0 1 52.401 49.7 Q 51.701 49.7 51.701 48.9 A 1.479 1.479 0 0 1 51.792 48.374 A 1.329 1.329 0 0 1 52.101 47.9 Q 54.701 44.6 56.751 42 Q 58.756 39.458 59.756 37.68 A 16.315 16.315 0 0 0 59.801 37.6 A 0.319 0.319 0 0 0 59.796 37.544 Q 59.791 37.513 59.779 37.489 A 0.148 0.148 0 0 0 59.751 37.45 Q 59.71 37.409 59.703 37.333 A 0.352 0.352 0 0 1 59.701 37.3 Q 59.701 37 60.001 36.4 Q 60.653 34.445 61.337 32.988 A 19.54 19.54 0 0 1 61.651 32.35 A 6.737 6.737 0 0 1 62.078 31.626 Q 62.591 30.878 63.154 30.615 A 1.524 1.524 0 0 1 63.501 30.5 Q 63.701 30.5 63.901 30.45 Q 64.101 30.4 64.301 30.4 A 4.185 4.185 0 0 1 65.719 30.636 A 3.892 3.892 0 0 1 66.301 30.9 A 1.897 1.897 0 0 1 66.823 31.313 Q 67.166 31.71 67.198 32.28 A 2.125 2.125 0 0 1 67.201 32.4 A 3.21 3.21 0 0 1 67.117 33.099 Q 66.967 33.767 66.551 34.6 Q 65.909 35.885 64.925 37.755 A 295.348 295.348 0 0 1 64.901 37.8 Q 62.701 42.4 60.951 46.15 A 33.154 33.154 0 0 0 60.029 48.31 Q 59.234 50.386 59.039 51.941 A 8.661 8.661 0 0 0 59.001 52.3 A 3.473 3.473 0 0 0 58.922 52.723 A 2.713 2.713 0 0 0 58.901 53.05 L 58.901 53.8 A 9.213 9.213 0 0 0 58.992 55.159 Q 59.389 57.8 61.501 57.8 Q 62.879 57.8 64.925 56.502 A 17.991 17.991 0 0 0 65.601 56.05 A 36.109 36.109 0 0 0 68.405 53.862 A 47.099 47.099 0 0 0 70.701 51.75 A 136.374 136.374 0 0 0 73.775 48.641 A 111.425 111.425 0 0 0 75.451 46.85 Q 77.601 44.5 78.401 43.3 Q 78.602 43.099 78.802 43.033 A 0.629 0.629 0 0 1 79.001 43 A 0.864 0.864 0 0 1 79.34 43.065 A 0.815 0.815 0 0 1 79.651 43.3 A 0.598 0.598 0 0 1 79.79 43.695 Q 79.79 43.878 79.701 44.1 A 14.286 14.286 0 0 1 79.016 45.246 Q 78.129 46.597 76.651 48.35 A 64.863 64.863 0 0 1 73.184 52.135 A 75.121 75.121 0 0 1 71.851 53.45 A 53.998 53.998 0 0 1 69.078 55.948 A 41.372 41.372 0 0 1 66.701 57.8 A 10.702 10.702 0 0 1 65.289 58.71 Q 64.561 59.107 63.7 59.452 A 18.262 18.262 0 0 1 63.451 59.55 Q 61.501 60.3 59.501 60.3 Z M 113.501 60.3 Q 111.701 60.3 110.251 59.5 Q 109.033 58.828 108.344 57.169 A 8.343 8.343 0 0 1 108.101 56.5 Q 108.001 56.2 107.951 55.9 A 3.407 3.407 0 0 1 107.917 55.618 Q 107.905 55.473 107.902 55.311 A 6.069 6.069 0 0 1 107.901 55.2 A 11.462 11.462 0 0 1 108.007 53.707 Q 108.109 52.938 108.307 52.061 A 28.041 28.041 0 0 1 108.801 50.2 Q 109.701 47.2 111.001 44.4 A 49.639 49.639 0 0 0 110.523 45.049 Q 110.312 45.34 110.082 45.665 A 95.797 95.797 0 0 0 109.601 46.35 Q 108.838 47.447 107.437 49.137 A 87.849 87.849 0 0 1 107.301 49.3 A 1.474 1.474 0 0 1 106.96 49.559 A 1.16 1.16 0 0 1 106.401 49.7 Q 105.701 49.7 105.701 48.9 A 1.479 1.479 0 0 1 105.792 48.374 A 1.329 1.329 0 0 1 106.101 47.9 Q 108.701 44.6 110.751 42 Q 112.756 39.458 113.756 37.68 A 16.315 16.315 0 0 0 113.801 37.6 A 0.319 0.319 0 0 0 113.796 37.544 Q 113.791 37.513 113.779 37.489 A 0.148 0.148 0 0 0 113.751 37.45 Q 113.71 37.409 113.703 37.333 A 0.352 0.352 0 0 1 113.701 37.3 Q 113.701 37 114.001 36.4 Q 114.653 34.445 115.337 32.988 A 19.54 19.54 0 0 1 115.651 32.35 A 6.737 6.737 0 0 1 116.078 31.626 Q 116.591 30.878 117.154 30.615 A 1.524 1.524 0 0 1 117.501 30.5 Q 117.701 30.5 117.901 30.45 Q 118.101 30.4 118.301 30.4 A 4.185 4.185 0 0 1 119.719 30.636 A 3.892 3.892 0 0 1 120.301 30.9 A 1.897 1.897 0 0 1 120.823 31.313 Q 121.166 31.71 121.198 32.28 A 2.125 2.125 0 0 1 121.201 32.4 A 3.21 3.21 0 0 1 121.117 33.099 Q 120.967 33.767 120.551 34.6 Q 119.909 35.885 118.925 37.755 A 295.348 295.348 0 0 1 118.901 37.8 Q 116.701 42.4 114.951 46.15 A 33.154 33.154 0 0 0 114.029 48.31 Q 113.234 50.386 113.039 51.941 A 8.661 8.661 0 0 0 113.001 52.3 A 3.473 3.473 0 0 0 112.922 52.723 A 2.713 2.713 0 0 0 112.901 53.05 L 112.901 53.8 A 9.213 9.213 0 0 0 112.992 55.159 Q 113.389 57.8 115.501 57.8 Q 116.879 57.8 118.925 56.502 A 17.991 17.991 0 0 0 119.601 56.05 A 36.109 36.109 0 0 0 122.405 53.862 A 47.099 47.099 0 0 0 124.701 51.75 A 136.374 136.374 0 0 0 127.775 48.641 A 111.425 111.425 0 0 0 129.451 46.85 Q 131.601 44.5 132.401 43.3 Q 132.602 43.099 132.802 43.033 A 0.629 0.629 0 0 1 133.001 43 A 0.864 0.864 0 0 1 133.34 43.065 A 0.815 0.815 0 0 1 133.651 43.3 A 0.598 0.598 0 0 1 133.79 43.695 Q 133.79 43.878 133.701 44.1 A 14.286 14.286 0 0 1 133.016 45.246 Q 132.129 46.597 130.651 48.35 A 64.863 64.863 0 0 1 127.184 52.135 A 75.121 75.121 0 0 1 125.851 53.45 A 53.998 53.998 0 0 1 123.078 55.948 A 41.372 41.372 0 0 1 120.701 57.8 A 10.702 10.702 0 0 1 119.289 58.71 Q 118.561 59.107 117.7 59.452 A 18.262 18.262 0 0 1 117.451 59.55 Q 115.501 60.3 113.501 60.3 Z M 68.309 24.347 A 14.908 14.908 0 0 0 70.401 24.5 A 0.897 0.897 0 0 0 70.756 24.42 Q 71.083 24.28 71.461 23.89 A 5.508 5.508 0 0 0 71.801 23.5 Q 72.601 22.5 73.201 21.3 A 14.961 14.961 0 0 0 73.285 21.13 Q 73.801 20.064 73.801 19.6 A 4.46 4.46 0 0 1 73.829 19.115 Q 73.874 18.697 73.996 18.233 A 8.958 8.958 0 0 1 74.301 17.3 Q 74.801 16 74.301 16 A 0.3 0.3 0 0 0 74.252 16.004 Q 73.895 16.063 72.793 16.924 A 29.596 29.596 0 0 0 72.201 17.4 A 2.824 2.824 0 0 0 72.138 17.444 Q 71.846 17.65 70.954 18.352 A 181.793 181.793 0 0 0 70.451 18.75 A 295.01 295.01 0 0 0 70.09 19.037 A 269.479 269.479 0 0 0 67.651 21 A 23.289 23.289 0 0 0 67.437 21.177 Q 66.553 21.915 66.357 22.245 A 0.326 0.326 0 0 0 66.301 22.4 A 2.846 2.846 0 0 0 66.301 22.402 Q 66.302 23.55 67.024 24.003 A 1.89 1.89 0 0 0 67.701 24.25 A 17.134 17.134 0 0 0 68.309 24.347 Z M 122.309 24.347 A 14.908 14.908 0 0 0 124.401 24.5 A 0.897 0.897 0 0 0 124.756 24.42 Q 125.083 24.28 125.461 23.89 A 5.508 5.508 0 0 0 125.801 23.5 Q 126.601 22.5 127.201 21.3 A 14.961 14.961 0 0 0 127.285 21.13 Q 127.801 20.064 127.801 19.6 A 4.46 4.46 0 0 1 127.829 19.115 Q 127.874 18.697 127.996 18.233 A 8.958 8.958 0 0 1 128.301 17.3 Q 128.801 16 128.301 16 A 0.3 0.3 0 0 0 128.252 16.004 Q 127.895 16.063 126.793 16.924 A 29.596 29.596 0 0 0 126.201 17.4 A 2.824 2.824 0 0 0 126.138 17.444 Q 125.846 17.65 124.954 18.352 A 181.793 181.793 0 0 0 124.451 18.75 A 295.01 295.01 0 0 0 124.09 19.037 A 269.479 269.479 0 0 0 121.651 21 A 23.289 23.289 0 0 0 121.437 21.177 Q 120.553 21.915 120.357 22.245 A 0.326 0.326 0 0 0 120.301 22.4 A 2.846 2.846 0 0 0 120.301 22.402 Q 120.302 23.55 121.024 24.003 A 1.89 1.89 0 0 0 121.701 24.25 A 17.134 17.134 0 0 0 122.309 24.347 Z M 237.401 59.3 Q 236.401 59.3 235.251 59.1 A 1.699 1.699 0 0 1 234.728 58.927 Q 234.243 58.663 234.133 58.073 A 2.041 2.041 0 0 1 234.101 57.7 A 0.731 0.731 0 0 1 234.17 57.416 Q 234.376 56.938 235.201 56.15 A 23.712 23.712 0 0 1 237.439 54.269 A 25.931 25.931 0 0 1 237.601 54.15 A 11.531 11.531 0 0 1 238.136 53.78 Q 238.936 53.262 239.395 53.207 A 0.88 0.88 0 0 1 239.501 53.2 A 1.01 1.01 0 0 1 239.756 53.229 Q 240.182 53.341 240.152 53.877 A 1.373 1.373 0 0 1 240.151 53.9 A 19.61 19.61 0 0 0 240.108 54.814 A 23.845 23.845 0 0 0 240.101 55.4 Q 240.101 55.771 239.671 56.615 A 11.493 11.493 0 0 1 239.601 56.75 A 13.22 13.22 0 0 1 238.686 58.246 A 11.935 11.935 0 0 1 238.501 58.5 A 3.879 3.879 0 0 1 238.225 58.831 Q 237.784 59.3 237.401 59.3 Z" vector-effect="non-scaling-stroke"/></g></svg>
                </div>

                <div class="mt-8 bg-white dark:bg-gray-800 overflow-hidden shadow sm:rounded-lg">
                    <div class="grid grid-cols-1 md:grid-cols-2">
                        <div class="p-6">
                            <div class="flex items-center">
                                <svg fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" class="w-8 h-8 text-gray-500"><path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg>
                                <div class="ml-4 text-lg leading-7 font-semibold"><a href="https://api-rivista.bahi.ovh/docs" class="underline text-gray-900 dark:text-white">Documentation</a></div>
                            </div>

                            <div class="ml-12">
                                <div class="mt-2 text-gray-600 dark:text-gray-400 text-sm">
                                    Check out the documentation for the API.
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="flex justify-center mt-4 sm:items-center sm:justify-between">
                    <div class="ml-4 text-center text-sm text-gray-500 sm:text-right sm:ml-0">
                        Laravel v{{ Illuminate\Foundation\Application::VERSION }} (PHP v{{ PHP_VERSION }})
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
