/// A slice containing all glyph names.
///
/// This can be used to do reverse lookups/find out if a search term maps to a glyph.
///
/// **Note:** Only named glyphs are present in this slice, names like uniABCD and uABCDEF are
/// omitted.
pub static GLYPH_NAME_PAIRS: &[(char, &str)] = &[
    ('\u{0020}', "space"),
    ('\u{0021}', "exclam"),
    ('\u{0022}', "quotedbl"),
    ('\u{0023}', "numbersign"),
    ('\u{0024}', "dollar"),
    ('\u{0025}', "percent"),
    ('\u{0026}', "ampersand"),
    ('\u{0027}', "quotesingle"),
    ('\u{0028}', "parenleft"),
    ('\u{0029}', "parenright"),
    ('\u{002A}', "asterisk"),
    ('\u{002B}', "plus"),
    ('\u{002C}', "comma"),
    ('\u{002D}', "hyphen"),
    ('\u{002E}', "period"),
    ('\u{002F}', "slash"),
    ('\u{0030}', "zero"),
    ('\u{0031}', "one"),
    ('\u{0032}', "two"),
    ('\u{0033}', "three"),
    ('\u{0034}', "four"),
    ('\u{0035}', "five"),
    ('\u{0036}', "six"),
    ('\u{0037}', "seven"),
    ('\u{0038}', "eight"),
    ('\u{0039}', "nine"),
    ('\u{003A}', "colon"),
    ('\u{003B}', "semicolon"),
    ('\u{003C}', "less"),
    ('\u{003D}', "equal"),
    ('\u{003E}', "greater"),
    ('\u{003F}', "question"),
    ('\u{0040}', "at"),
    ('\u{0041}', "A"),
    ('\u{0042}', "B"),
    ('\u{0043}', "C"),
    ('\u{0044}', "D"),
    ('\u{0045}', "E"),
    ('\u{0046}', "F"),
    ('\u{0047}', "G"),
    ('\u{0048}', "H"),
    ('\u{0049}', "I"),
    ('\u{004A}', "J"),
    ('\u{004B}', "K"),
    ('\u{004C}', "L"),
    ('\u{004D}', "M"),
    ('\u{004E}', "N"),
    ('\u{004F}', "O"),
    ('\u{0050}', "P"),
    ('\u{0051}', "Q"),
    ('\u{0052}', "R"),
    ('\u{0053}', "S"),
    ('\u{0054}', "T"),
    ('\u{0055}', "U"),
    ('\u{0056}', "V"),
    ('\u{0057}', "W"),
    ('\u{0058}', "X"),
    ('\u{0059}', "Y"),
    ('\u{005A}', "Z"),
    ('\u{005B}', "bracketleft"),
    ('\u{005C}', "backslash"),
    ('\u{005D}', "bracketright"),
    ('\u{005E}', "asciicircum"),
    ('\u{005F}', "underscore"),
    ('\u{0060}', "grave"),
    ('\u{0061}', "a"),
    ('\u{0062}', "b"),
    ('\u{0063}', "c"),
    ('\u{0064}', "d"),
    ('\u{0065}', "e"),
    ('\u{0066}', "f"),
    ('\u{0067}', "g"),
    ('\u{0068}', "h"),
    ('\u{0069}', "i"),
    ('\u{006A}', "j"),
    ('\u{006B}', "k"),
    ('\u{006C}', "l"),
    ('\u{006D}', "m"),
    ('\u{006E}', "n"),
    ('\u{006F}', "o"),
    ('\u{0070}', "p"),
    ('\u{0071}', "q"),
    ('\u{0072}', "r"),
    ('\u{0073}', "s"),
    ('\u{0074}', "t"),
    ('\u{0075}', "u"),
    ('\u{0076}', "v"),
    ('\u{0077}', "w"),
    ('\u{0078}', "x"),
    ('\u{0079}', "y"),
    ('\u{007A}', "z"),
    ('\u{007B}', "braceleft"),
    ('\u{007C}', "bar"),
    ('\u{007D}', "braceright"),
    ('\u{007E}', "asciitilde"),
    ('\u{00A1}', "exclamdown"),
    ('\u{00A2}', "cent"),
    ('\u{00A3}', "sterling"),
    ('\u{00A4}', "currency"),
    ('\u{00A5}', "yen"),
    ('\u{00A6}', "brokenbar"),
    ('\u{00A7}', "section"),
    ('\u{00A8}', "dieresis"),
    ('\u{00A9}', "copyright"),
    ('\u{00AA}', "ordfeminine"),
    ('\u{00AB}', "guillemotleft"),
    ('\u{00AC}', "logicalnot"),
    ('\u{00AE}', "registered"),
    ('\u{00AF}', "macron"),
    ('\u{00B0}', "degree"),
    ('\u{00B1}', "plusminus"),
    ('\u{00B4}', "acute"),
    ('\u{00B5}', "mu"),
    ('\u{00B6}', "paragraph"),
    ('\u{00B7}', "periodcentered"),
    ('\u{00B8}', "cedilla"),
    ('\u{00BA}', "ordmasculine"),
    ('\u{00BB}', "guillemotright"),
    ('\u{00BC}', "onequarter"),
    ('\u{00BD}', "onehalf"),
    ('\u{00BE}', "threequarters"),
    ('\u{00BF}', "questiondown"),
    ('\u{00C0}', "Agrave"),
    ('\u{00C1}', "Aacute"),
    ('\u{00C2}', "Acircumflex"),
    ('\u{00C3}', "Atilde"),
    ('\u{00C4}', "Adieresis"),
    ('\u{00C5}', "Aring"),
    ('\u{00C6}', "AE"),
    ('\u{00C7}', "Ccedilla"),
    ('\u{00C8}', "Egrave"),
    ('\u{00C9}', "Eacute"),
    ('\u{00CA}', "Ecircumflex"),
    ('\u{00CB}', "Edieresis"),
    ('\u{00CC}', "Igrave"),
    ('\u{00CD}', "Iacute"),
    ('\u{00CE}', "Icircumflex"),
    ('\u{00CF}', "Idieresis"),
    ('\u{00D0}', "Eth"),
    ('\u{00D1}', "Ntilde"),
    ('\u{00D2}', "Ograve"),
    ('\u{00D3}', "Oacute"),
    ('\u{00D4}', "Ocircumflex"),
    ('\u{00D5}', "Otilde"),
    ('\u{00D6}', "Odieresis"),
    ('\u{00D7}', "multiply"),
    ('\u{00D8}', "Oslash"),
    ('\u{00D9}', "Ugrave"),
    ('\u{00DA}', "Uacute"),
    ('\u{00DB}', "Ucircumflex"),
    ('\u{00DC}', "Udieresis"),
    ('\u{00DD}', "Yacute"),
    ('\u{00DE}', "Thorn"),
    ('\u{00DF}', "germandbls"),
    ('\u{00E0}', "agrave"),
    ('\u{00E1}', "aacute"),
    ('\u{00E2}', "acircumflex"),
    ('\u{00E3}', "atilde"),
    ('\u{00E4}', "adieresis"),
    ('\u{00E5}', "aring"),
    ('\u{00E6}', "ae"),
    ('\u{00E7}', "ccedilla"),
    ('\u{00E8}', "egrave"),
    ('\u{00E9}', "eacute"),
    ('\u{00EA}', "ecircumflex"),
    ('\u{00EB}', "edieresis"),
    ('\u{00EC}', "igrave"),
    ('\u{00ED}', "iacute"),
    ('\u{00EE}', "icircumflex"),
    ('\u{00EF}', "idieresis"),
    ('\u{00F0}', "eth"),
    ('\u{00F1}', "ntilde"),
    ('\u{00F2}', "ograve"),
    ('\u{00F3}', "oacute"),
    ('\u{00F4}', "ocircumflex"),
    ('\u{00F5}', "otilde"),
    ('\u{00F6}', "odieresis"),
    ('\u{00F7}', "divide"),
    ('\u{00F8}', "oslash"),
    ('\u{00F9}', "ugrave"),
    ('\u{00FA}', "uacute"),
    ('\u{00FB}', "ucircumflex"),
    ('\u{00FC}', "udieresis"),
    ('\u{00FD}', "yacute"),
    ('\u{00FE}', "thorn"),
    ('\u{00FF}', "ydieresis"),
    ('\u{0100}', "Amacron"),
    ('\u{0101}', "amacron"),
    ('\u{0102}', "Abreve"),
    ('\u{0103}', "abreve"),
    ('\u{0104}', "Aogonek"),
    ('\u{0105}', "aogonek"),
    ('\u{0106}', "Cacute"),
    ('\u{0107}', "cacute"),
    ('\u{0108}', "Ccircumflex"),
    ('\u{0109}', "ccircumflex"),
    ('\u{010A}', "Cdotaccent"),
    ('\u{010B}', "cdotaccent"),
    ('\u{010C}', "Ccaron"),
    ('\u{010D}', "ccaron"),
    ('\u{010E}', "Dcaron"),
    ('\u{010F}', "dcaron"),
    ('\u{0110}', "Dcroat"),
    ('\u{0111}', "dcroat"),
    ('\u{0112}', "Emacron"),
    ('\u{0113}', "emacron"),
    ('\u{0114}', "Ebreve"),
    ('\u{0115}', "ebreve"),
    ('\u{0116}', "Edotaccent"),
    ('\u{0117}', "edotaccent"),
    ('\u{0118}', "Eogonek"),
    ('\u{0119}', "eogonek"),
    ('\u{011A}', "Ecaron"),
    ('\u{011B}', "ecaron"),
    ('\u{011C}', "Gcircumflex"),
    ('\u{011D}', "gcircumflex"),
    ('\u{011E}', "Gbreve"),
    ('\u{011F}', "gbreve"),
    ('\u{0120}', "Gdotaccent"),
    ('\u{0121}', "gdotaccent"),
    ('\u{0124}', "Hcircumflex"),
    ('\u{0125}', "hcircumflex"),
    ('\u{0126}', "Hbar"),
    ('\u{0127}', "hbar"),
    ('\u{0128}', "Itilde"),
    ('\u{0129}', "itilde"),
    ('\u{012A}', "Imacron"),
    ('\u{012B}', "imacron"),
    ('\u{012C}', "Ibreve"),
    ('\u{012D}', "ibreve"),
    ('\u{012E}', "Iogonek"),
    ('\u{012F}', "iogonek"),
    ('\u{0130}', "Idotaccent"),
    ('\u{0131}', "dotlessi"),
    ('\u{0132}', "IJ"),
    ('\u{0133}', "ij"),
    ('\u{0134}', "Jcircumflex"),
    ('\u{0135}', "jcircumflex"),
    ('\u{0138}', "kgreenlandic"),
    ('\u{0139}', "Lacute"),
    ('\u{013A}', "lacute"),
    ('\u{013D}', "Lcaron"),
    ('\u{013E}', "lcaron"),
    ('\u{013F}', "Ldot"),
    ('\u{0140}', "ldot"),
    ('\u{0141}', "Lslash"),
    ('\u{0142}', "lslash"),
    ('\u{0143}', "Nacute"),
    ('\u{0144}', "nacute"),
    ('\u{0147}', "Ncaron"),
    ('\u{0148}', "ncaron"),
    ('\u{0149}', "napostrophe"),
    ('\u{014A}', "Eng"),
    ('\u{014B}', "eng"),
    ('\u{014C}', "Omacron"),
    ('\u{014D}', "omacron"),
    ('\u{014E}', "Obreve"),
    ('\u{014F}', "obreve"),
    ('\u{0150}', "Ohungarumlaut"),
    ('\u{0151}', "ohungarumlaut"),
    ('\u{0152}', "OE"),
    ('\u{0153}', "oe"),
    ('\u{0154}', "Racute"),
    ('\u{0155}', "racute"),
    ('\u{0158}', "Rcaron"),
    ('\u{0159}', "rcaron"),
    ('\u{015A}', "Sacute"),
    ('\u{015B}', "sacute"),
    ('\u{015C}', "Scircumflex"),
    ('\u{015D}', "scircumflex"),
    ('\u{015E}', "Scedilla"),
    ('\u{015F}', "scedilla"),
    ('\u{0160}', "Scaron"),
    ('\u{0161}', "scaron"),
    ('\u{0164}', "Tcaron"),
    ('\u{0165}', "tcaron"),
    ('\u{0166}', "Tbar"),
    ('\u{0167}', "tbar"),
    ('\u{0168}', "Utilde"),
    ('\u{0169}', "utilde"),
    ('\u{016A}', "Umacron"),
    ('\u{016B}', "umacron"),
    ('\u{016C}', "Ubreve"),
    ('\u{016D}', "ubreve"),
    ('\u{016E}', "Uring"),
    ('\u{016F}', "uring"),
    ('\u{0170}', "Uhungarumlaut"),
    ('\u{0171}', "uhungarumlaut"),
    ('\u{0172}', "Uogonek"),
    ('\u{0173}', "uogonek"),
    ('\u{0174}', "Wcircumflex"),
    ('\u{0175}', "wcircumflex"),
    ('\u{0176}', "Ycircumflex"),
    ('\u{0177}', "ycircumflex"),
    ('\u{0178}', "Ydieresis"),
    ('\u{0179}', "Zacute"),
    ('\u{017A}', "zacute"),
    ('\u{017B}', "Zdotaccent"),
    ('\u{017C}', "zdotaccent"),
    ('\u{017D}', "Zcaron"),
    ('\u{017E}', "zcaron"),
    ('\u{017F}', "longs"),
    ('\u{0192}', "florin"),
    ('\u{01A0}', "Ohorn"),
    ('\u{01A1}', "ohorn"),
    ('\u{01AF}', "Uhorn"),
    ('\u{01B0}', "uhorn"),
    ('\u{01E6}', "Gcaron"),
    ('\u{01E7}', "gcaron"),
    ('\u{01FA}', "Aringacute"),
    ('\u{01FB}', "aringacute"),
    ('\u{01FC}', "AEacute"),
    ('\u{01FD}', "aeacute"),
    ('\u{01FE}', "Oslashacute"),
    ('\u{01FF}', "oslashacute"),
    ('\u{02C6}', "circumflex"),
    ('\u{02C7}', "caron"),
    ('\u{02D8}', "breve"),
    ('\u{02D9}', "dotaccent"),
    ('\u{02DA}', "ring"),
    ('\u{02DB}', "ogonek"),
    ('\u{02DC}', "tilde"),
    ('\u{02DD}', "hungarumlaut"),
    ('\u{0300}', "gravecomb"),
    ('\u{0301}', "acutecomb"),
    ('\u{0303}', "tildecomb"),
    ('\u{0309}', "hookabovecomb"),
    ('\u{0323}', "dotbelowcomb"),
    ('\u{0384}', "tonos"),
    ('\u{0385}', "dieresistonos"),
    ('\u{0386}', "Alphatonos"),
    ('\u{0387}', "anoteleia"),
    ('\u{0388}', "Epsilontonos"),
    ('\u{0389}', "Etatonos"),
    ('\u{038A}', "Iotatonos"),
    ('\u{038C}', "Omicrontonos"),
    ('\u{038E}', "Upsilontonos"),
    ('\u{038F}', "Omegatonos"),
    ('\u{0390}', "iotadieresistonos"),
    ('\u{0391}', "Alpha"),
    ('\u{0392}', "Beta"),
    ('\u{0393}', "Gamma"),
    ('\u{0395}', "Epsilon"),
    ('\u{0396}', "Zeta"),
    ('\u{0397}', "Eta"),
    ('\u{0398}', "Theta"),
    ('\u{0399}', "Iota"),
    ('\u{039A}', "Kappa"),
    ('\u{039B}', "Lambda"),
    ('\u{039C}', "Mu"),
    ('\u{039D}', "Nu"),
    ('\u{039E}', "Xi"),
    ('\u{039F}', "Omicron"),
    ('\u{03A0}', "Pi"),
    ('\u{03A1}', "Rho"),
    ('\u{03A3}', "Sigma"),
    ('\u{03A4}', "Tau"),
    ('\u{03A5}', "Upsilon"),
    ('\u{03A6}', "Phi"),
    ('\u{03A7}', "Chi"),
    ('\u{03A8}', "Psi"),
    ('\u{03AA}', "Iotadieresis"),
    ('\u{03AB}', "Upsilondieresis"),
    ('\u{03AC}', "alphatonos"),
    ('\u{03AD}', "epsilontonos"),
    ('\u{03AE}', "etatonos"),
    ('\u{03AF}', "iotatonos"),
    ('\u{03B0}', "upsilondieresistonos"),
    ('\u{03B1}', "alpha"),
    ('\u{03B2}', "beta"),
    ('\u{03B3}', "gamma"),
    ('\u{03B4}', "delta"),
    ('\u{03B5}', "epsilon"),
    ('\u{03B6}', "zeta"),
    ('\u{03B7}', "eta"),
    ('\u{03B8}', "theta"),
    ('\u{03B9}', "iota"),
    ('\u{03BA}', "kappa"),
    ('\u{03BB}', "lambda"),
    ('\u{03BD}', "nu"),
    ('\u{03BE}', "xi"),
    ('\u{03BF}', "omicron"),
    ('\u{03C0}', "pi"),
    ('\u{03C1}', "rho"),
    ('\u{03C2}', "sigma1"),
    ('\u{03C3}', "sigma"),
    ('\u{03C4}', "tau"),
    ('\u{03C5}', "upsilon"),
    ('\u{03C6}', "phi"),
    ('\u{03C7}', "chi"),
    ('\u{03C8}', "psi"),
    ('\u{03C9}', "omega"),
    ('\u{03CA}', "iotadieresis"),
    ('\u{03CB}', "upsilondieresis"),
    ('\u{03CC}', "omicrontonos"),
    ('\u{03CD}', "upsilontonos"),
    ('\u{03CE}', "omegatonos"),
    ('\u{03D1}', "theta1"),
    ('\u{03D2}', "Upsilon1"),
    ('\u{03D5}', "phi1"),
    ('\u{03D6}', "omega1"),
    ('\u{1E80}', "Wgrave"),
    ('\u{1E81}', "wgrave"),
    ('\u{1E82}', "Wacute"),
    ('\u{1E83}', "wacute"),
    ('\u{1E84}', "Wdieresis"),
    ('\u{1E85}', "wdieresis"),
    ('\u{1EF2}', "Ygrave"),
    ('\u{1EF3}', "ygrave"),
    ('\u{2012}', "figuredash"),
    ('\u{2013}', "endash"),
    ('\u{2014}', "emdash"),
    ('\u{2017}', "underscoredbl"),
    ('\u{2018}', "quoteleft"),
    ('\u{2019}', "quoteright"),
    ('\u{201A}', "quotesinglbase"),
    ('\u{201B}', "quotereversed"),
    ('\u{201C}', "quotedblleft"),
    ('\u{201D}', "quotedblright"),
    ('\u{201E}', "quotedblbase"),
    ('\u{2020}', "dagger"),
    ('\u{2021}', "daggerdbl"),
    ('\u{2022}', "bullet"),
    ('\u{2024}', "onedotenleader"),
    ('\u{2025}', "twodotenleader"),
    ('\u{2026}', "ellipsis"),
    ('\u{2030}', "perthousand"),
    ('\u{2032}', "minute"),
    ('\u{2033}', "second"),
    ('\u{2039}', "guilsinglleft"),
    ('\u{203A}', "guilsinglright"),
    ('\u{203C}', "exclamdbl"),
    ('\u{2044}', "fraction"),
    ('\u{20A1}', "colonmonetary"),
    ('\u{20A3}', "franc"),
    ('\u{20A4}', "lira"),
    ('\u{20A7}', "peseta"),
    ('\u{20AB}', "dong"),
    ('\u{20AC}', "Euro"),
    ('\u{2111}', "Ifraktur"),
    ('\u{2118}', "weierstrass"),
    ('\u{211C}', "Rfraktur"),
    ('\u{211E}', "prescription"),
    ('\u{2122}', "trademark"),
    ('\u{2126}', "Omega"),
    ('\u{212E}', "estimated"),
    ('\u{2135}', "aleph"),
    ('\u{2153}', "onethird"),
    ('\u{2154}', "twothirds"),
    ('\u{215B}', "oneeighth"),
    ('\u{215C}', "threeeighths"),
    ('\u{215D}', "fiveeighths"),
    ('\u{215E}', "seveneighths"),
    ('\u{2190}', "arrowleft"),
    ('\u{2191}', "arrowup"),
    ('\u{2192}', "arrowright"),
    ('\u{2193}', "arrowdown"),
    ('\u{2194}', "arrowboth"),
    ('\u{2195}', "arrowupdn"),
    ('\u{21A8}', "arrowupdnbse"),
    ('\u{21B5}', "carriagereturn"),
    ('\u{21D0}', "arrowdblleft"),
    ('\u{21D1}', "arrowdblup"),
    ('\u{21D2}', "arrowdblright"),
    ('\u{21D3}', "arrowdbldown"),
    ('\u{21D4}', "arrowdblboth"),
    ('\u{2200}', "universal"),
    ('\u{2202}', "partialdiff"),
    ('\u{2203}', "existential"),
    ('\u{2205}', "emptyset"),
    ('\u{2206}', "Delta"),
    ('\u{2207}', "gradient"),
    ('\u{2208}', "element"),
    ('\u{2209}', "notelement"),
    ('\u{220B}', "suchthat"),
    ('\u{220F}', "product"),
    ('\u{2211}', "summation"),
    ('\u{2212}', "minus"),
    ('\u{2217}', "asteriskmath"),
    ('\u{221A}', "radical"),
    ('\u{221D}', "proportional"),
    ('\u{221E}', "infinity"),
    ('\u{221F}', "orthogonal"),
    ('\u{2220}', "angle"),
    ('\u{2227}', "logicaland"),
    ('\u{2228}', "logicalor"),
    ('\u{2229}', "intersection"),
    ('\u{222A}', "union"),
    ('\u{222B}', "integral"),
    ('\u{2234}', "therefore"),
    ('\u{223C}', "similar"),
    ('\u{2245}', "congruent"),
    ('\u{2248}', "approxequal"),
    ('\u{2260}', "notequal"),
    ('\u{2261}', "equivalence"),
    ('\u{2264}', "lessequal"),
    ('\u{2265}', "greaterequal"),
    ('\u{2282}', "propersubset"),
    ('\u{2283}', "propersuperset"),
    ('\u{2284}', "notsubset"),
    ('\u{2286}', "reflexsubset"),
    ('\u{2287}', "reflexsuperset"),
    ('\u{2295}', "circleplus"),
    ('\u{2297}', "circlemultiply"),
    ('\u{22A5}', "perpendicular"),
    ('\u{22C5}', "dotmath"),
    ('\u{2302}', "house"),
    ('\u{2310}', "revlogicalnot"),
    ('\u{2320}', "integraltp"),
    ('\u{2321}', "integralbt"),
    ('\u{2329}', "angleleft"),
    ('\u{232A}', "angleright"),
    ('\u{2500}', "SF100000"),
    ('\u{2502}', "SF110000"),
    ('\u{250C}', "SF010000"),
    ('\u{2510}', "SF030000"),
    ('\u{2514}', "SF020000"),
    ('\u{2518}', "SF040000"),
    ('\u{251C}', "SF080000"),
    ('\u{2524}', "SF090000"),
    ('\u{252C}', "SF060000"),
    ('\u{2534}', "SF070000"),
    ('\u{253C}', "SF050000"),
    ('\u{2550}', "SF430000"),
    ('\u{2551}', "SF240000"),
    ('\u{2552}', "SF510000"),
    ('\u{2553}', "SF520000"),
    ('\u{2554}', "SF390000"),
    ('\u{2555}', "SF220000"),
    ('\u{2556}', "SF210000"),
    ('\u{2557}', "SF250000"),
    ('\u{2558}', "SF500000"),
    ('\u{2559}', "SF490000"),
    ('\u{255A}', "SF380000"),
    ('\u{255B}', "SF280000"),
    ('\u{255C}', "SF270000"),
    ('\u{255D}', "SF260000"),
    ('\u{255E}', "SF360000"),
    ('\u{255F}', "SF370000"),
    ('\u{2560}', "SF420000"),
    ('\u{2561}', "SF190000"),
    ('\u{2562}', "SF200000"),
    ('\u{2563}', "SF230000"),
    ('\u{2564}', "SF470000"),
    ('\u{2565}', "SF480000"),
    ('\u{2566}', "SF410000"),
    ('\u{2567}', "SF450000"),
    ('\u{2568}', "SF460000"),
    ('\u{2569}', "SF400000"),
    ('\u{256A}', "SF540000"),
    ('\u{256B}', "SF530000"),
    ('\u{256C}', "SF440000"),
    ('\u{2580}', "upblock"),
    ('\u{2584}', "dnblock"),
    ('\u{2588}', "block"),
    ('\u{258C}', "lfblock"),
    ('\u{2590}', "rtblock"),
    ('\u{2591}', "ltshade"),
    ('\u{2592}', "shade"),
    ('\u{2593}', "dkshade"),
    ('\u{25A0}', "filledbox"),
    ('\u{25A1}', "H22073"),
    ('\u{25AA}', "H18543"),
    ('\u{25AB}', "H18551"),
    ('\u{25AC}', "filledrect"),
    ('\u{25B2}', "triagup"),
    ('\u{25BA}', "triagrt"),
    ('\u{25BC}', "triagdn"),
    ('\u{25C4}', "triaglf"),
    ('\u{25CA}', "lozenge"),
    ('\u{25CB}', "circle"),
    ('\u{25CF}', "H18533"),
    ('\u{25D8}', "invbullet"),
    ('\u{25D9}', "invcircle"),
    ('\u{25E6}', "openbullet"),
    ('\u{263A}', "smileface"),
    ('\u{263B}', "invsmileface"),
    ('\u{263C}', "sun"),
    ('\u{2640}', "female"),
    ('\u{2642}', "male"),
    ('\u{2660}', "spade"),
    ('\u{2663}', "club"),
    ('\u{2665}', "heart"),
    ('\u{2666}', "diamond"),
    ('\u{266A}', "musicalnote"),
    ('\u{266B}', "musicalnotedbl"),
];
