use crate::GLYPH_NAME_PAIRS;
pub fn glyph_name(c: char) -> Option<&'static str> {
    match c as u32 {
        0x0020 => Some(GLYPH_NAME_PAIRS[0].1),   // SPACE
        0x0021 => Some(GLYPH_NAME_PAIRS[1].1),   // EXCLAMATION MARK
        0x0022 => Some(GLYPH_NAME_PAIRS[2].1),   // QUOTATION MARK
        0x0023 => Some(GLYPH_NAME_PAIRS[3].1),   // NUMBER SIGN
        0x0024 => Some(GLYPH_NAME_PAIRS[4].1),   // DOLLAR SIGN
        0x0025 => Some(GLYPH_NAME_PAIRS[5].1),   // PERCENT SIGN
        0x0026 => Some(GLYPH_NAME_PAIRS[6].1),   // AMPERSAND
        0x0027 => Some(GLYPH_NAME_PAIRS[7].1),   // APOSTROPHE
        0x0028 => Some(GLYPH_NAME_PAIRS[8].1),   // LEFT PARENTHESIS
        0x0029 => Some(GLYPH_NAME_PAIRS[9].1),   // RIGHT PARENTHESIS
        0x002A => Some(GLYPH_NAME_PAIRS[10].1),  // ASTERISK
        0x002B => Some(GLYPH_NAME_PAIRS[11].1),  // PLUS SIGN
        0x002C => Some(GLYPH_NAME_PAIRS[12].1),  // COMMA
        0x002D => Some(GLYPH_NAME_PAIRS[13].1),  // HYPHEN-MINUS
        0x002E => Some(GLYPH_NAME_PAIRS[14].1),  // FULL STOP
        0x002F => Some(GLYPH_NAME_PAIRS[15].1),  // SOLIDUS
        0x0030 => Some(GLYPH_NAME_PAIRS[16].1),  // DIGIT ZERO
        0x0031 => Some(GLYPH_NAME_PAIRS[17].1),  // DIGIT ONE
        0x0032 => Some(GLYPH_NAME_PAIRS[18].1),  // DIGIT TWO
        0x0033 => Some(GLYPH_NAME_PAIRS[19].1),  // DIGIT THREE
        0x0034 => Some(GLYPH_NAME_PAIRS[20].1),  // DIGIT FOUR
        0x0035 => Some(GLYPH_NAME_PAIRS[21].1),  // DIGIT FIVE
        0x0036 => Some(GLYPH_NAME_PAIRS[22].1),  // DIGIT SIX
        0x0037 => Some(GLYPH_NAME_PAIRS[23].1),  // DIGIT SEVEN
        0x0038 => Some(GLYPH_NAME_PAIRS[24].1),  // DIGIT EIGHT
        0x0039 => Some(GLYPH_NAME_PAIRS[25].1),  // DIGIT NINE
        0x003A => Some(GLYPH_NAME_PAIRS[26].1),  // COLON
        0x003B => Some(GLYPH_NAME_PAIRS[27].1),  // SEMICOLON
        0x003C => Some(GLYPH_NAME_PAIRS[28].1),  // LESS-THAN SIGN
        0x003D => Some(GLYPH_NAME_PAIRS[29].1),  // EQUALS SIGN
        0x003E => Some(GLYPH_NAME_PAIRS[30].1),  // GREATER-THAN SIGN
        0x003F => Some(GLYPH_NAME_PAIRS[31].1),  // QUESTION MARK
        0x0040 => Some(GLYPH_NAME_PAIRS[32].1),  // COMMERCIAL AT
        0x0041 => Some(GLYPH_NAME_PAIRS[33].1),  // LATIN CAPITAL LETTER A
        0x0042 => Some(GLYPH_NAME_PAIRS[34].1),  // LATIN CAPITAL LETTER B
        0x0043 => Some(GLYPH_NAME_PAIRS[35].1),  // LATIN CAPITAL LETTER C
        0x0044 => Some(GLYPH_NAME_PAIRS[36].1),  // LATIN CAPITAL LETTER D
        0x0045 => Some(GLYPH_NAME_PAIRS[37].1),  // LATIN CAPITAL LETTER E
        0x0046 => Some(GLYPH_NAME_PAIRS[38].1),  // LATIN CAPITAL LETTER F
        0x0047 => Some(GLYPH_NAME_PAIRS[39].1),  // LATIN CAPITAL LETTER G
        0x0048 => Some(GLYPH_NAME_PAIRS[40].1),  // LATIN CAPITAL LETTER H
        0x0049 => Some(GLYPH_NAME_PAIRS[41].1),  // LATIN CAPITAL LETTER I
        0x004A => Some(GLYPH_NAME_PAIRS[42].1),  // LATIN CAPITAL LETTER J
        0x004B => Some(GLYPH_NAME_PAIRS[43].1),  // LATIN CAPITAL LETTER K
        0x004C => Some(GLYPH_NAME_PAIRS[44].1),  // LATIN CAPITAL LETTER L
        0x004D => Some(GLYPH_NAME_PAIRS[45].1),  // LATIN CAPITAL LETTER M
        0x004E => Some(GLYPH_NAME_PAIRS[46].1),  // LATIN CAPITAL LETTER N
        0x004F => Some(GLYPH_NAME_PAIRS[47].1),  // LATIN CAPITAL LETTER O
        0x0050 => Some(GLYPH_NAME_PAIRS[48].1),  // LATIN CAPITAL LETTER P
        0x0051 => Some(GLYPH_NAME_PAIRS[49].1),  // LATIN CAPITAL LETTER Q
        0x0052 => Some(GLYPH_NAME_PAIRS[50].1),  // LATIN CAPITAL LETTER R
        0x0053 => Some(GLYPH_NAME_PAIRS[51].1),  // LATIN CAPITAL LETTER S
        0x0054 => Some(GLYPH_NAME_PAIRS[52].1),  // LATIN CAPITAL LETTER T
        0x0055 => Some(GLYPH_NAME_PAIRS[53].1),  // LATIN CAPITAL LETTER U
        0x0056 => Some(GLYPH_NAME_PAIRS[54].1),  // LATIN CAPITAL LETTER V
        0x0057 => Some(GLYPH_NAME_PAIRS[55].1),  // LATIN CAPITAL LETTER W
        0x0058 => Some(GLYPH_NAME_PAIRS[56].1),  // LATIN CAPITAL LETTER X
        0x0059 => Some(GLYPH_NAME_PAIRS[57].1),  // LATIN CAPITAL LETTER Y
        0x005A => Some(GLYPH_NAME_PAIRS[58].1),  // LATIN CAPITAL LETTER Z
        0x005B => Some(GLYPH_NAME_PAIRS[59].1),  // LEFT SQUARE BRACKET
        0x005C => Some(GLYPH_NAME_PAIRS[60].1),  // REVERSE SOLIDUS
        0x005D => Some(GLYPH_NAME_PAIRS[61].1),  // RIGHT SQUARE BRACKET
        0x005E => Some(GLYPH_NAME_PAIRS[62].1),  // CIRCUMFLEX ACCENT
        0x005F => Some(GLYPH_NAME_PAIRS[63].1),  // LOW LINE
        0x0060 => Some(GLYPH_NAME_PAIRS[64].1),  // GRAVE ACCENT
        0x0061 => Some(GLYPH_NAME_PAIRS[65].1),  // LATIN SMALL LETTER A
        0x0062 => Some(GLYPH_NAME_PAIRS[66].1),  // LATIN SMALL LETTER B
        0x0063 => Some(GLYPH_NAME_PAIRS[67].1),  // LATIN SMALL LETTER C
        0x0064 => Some(GLYPH_NAME_PAIRS[68].1),  // LATIN SMALL LETTER D
        0x0065 => Some(GLYPH_NAME_PAIRS[69].1),  // LATIN SMALL LETTER E
        0x0066 => Some(GLYPH_NAME_PAIRS[70].1),  // LATIN SMALL LETTER F
        0x0067 => Some(GLYPH_NAME_PAIRS[71].1),  // LATIN SMALL LETTER G
        0x0068 => Some(GLYPH_NAME_PAIRS[72].1),  // LATIN SMALL LETTER H
        0x0069 => Some(GLYPH_NAME_PAIRS[73].1),  // LATIN SMALL LETTER I
        0x006A => Some(GLYPH_NAME_PAIRS[74].1),  // LATIN SMALL LETTER J
        0x006B => Some(GLYPH_NAME_PAIRS[75].1),  // LATIN SMALL LETTER K
        0x006C => Some(GLYPH_NAME_PAIRS[76].1),  // LATIN SMALL LETTER L
        0x006D => Some(GLYPH_NAME_PAIRS[77].1),  // LATIN SMALL LETTER M
        0x006E => Some(GLYPH_NAME_PAIRS[78].1),  // LATIN SMALL LETTER N
        0x006F => Some(GLYPH_NAME_PAIRS[79].1),  // LATIN SMALL LETTER O
        0x0070 => Some(GLYPH_NAME_PAIRS[80].1),  // LATIN SMALL LETTER P
        0x0071 => Some(GLYPH_NAME_PAIRS[81].1),  // LATIN SMALL LETTER Q
        0x0072 => Some(GLYPH_NAME_PAIRS[82].1),  // LATIN SMALL LETTER R
        0x0073 => Some(GLYPH_NAME_PAIRS[83].1),  // LATIN SMALL LETTER S
        0x0074 => Some(GLYPH_NAME_PAIRS[84].1),  // LATIN SMALL LETTER T
        0x0075 => Some(GLYPH_NAME_PAIRS[85].1),  // LATIN SMALL LETTER U
        0x0076 => Some(GLYPH_NAME_PAIRS[86].1),  // LATIN SMALL LETTER V
        0x0077 => Some(GLYPH_NAME_PAIRS[87].1),  // LATIN SMALL LETTER W
        0x0078 => Some(GLYPH_NAME_PAIRS[88].1),  // LATIN SMALL LETTER X
        0x0079 => Some(GLYPH_NAME_PAIRS[89].1),  // LATIN SMALL LETTER Y
        0x007A => Some(GLYPH_NAME_PAIRS[90].1),  // LATIN SMALL LETTER Z
        0x007B => Some(GLYPH_NAME_PAIRS[91].1),  // LEFT CURLY BRACKET
        0x007C => Some(GLYPH_NAME_PAIRS[92].1),  // VERTICAL LINE
        0x007D => Some(GLYPH_NAME_PAIRS[93].1),  // RIGHT CURLY BRACKET
        0x007E => Some(GLYPH_NAME_PAIRS[94].1),  // TILDE
        0x00A1 => Some(GLYPH_NAME_PAIRS[95].1),  // INVERTED EXCLAMATION MARK
        0x00A2 => Some(GLYPH_NAME_PAIRS[96].1),  // CENT SIGN
        0x00A3 => Some(GLYPH_NAME_PAIRS[97].1),  // POUND SIGN
        0x00A4 => Some(GLYPH_NAME_PAIRS[98].1),  // CURRENCY SIGN
        0x00A5 => Some(GLYPH_NAME_PAIRS[99].1),  // YEN SIGN
        0x00A6 => Some(GLYPH_NAME_PAIRS[100].1), // BROKEN BAR
        0x00A7 => Some(GLYPH_NAME_PAIRS[101].1), // SECTION SIGN
        0x00A8 => Some(GLYPH_NAME_PAIRS[102].1), // DIAERESIS
        0x00A9 => Some(GLYPH_NAME_PAIRS[103].1), // COPYRIGHT SIGN
        0x00AA => Some(GLYPH_NAME_PAIRS[104].1), // FEMININE ORDINAL INDICATOR
        0x00AB => Some(GLYPH_NAME_PAIRS[105].1), // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        0x00AC => Some(GLYPH_NAME_PAIRS[106].1), // NOT SIGN
        0x00AE => Some(GLYPH_NAME_PAIRS[107].1), // REGISTERED SIGN
        0x00AF => Some(GLYPH_NAME_PAIRS[108].1), // MACRON
        0x00B0 => Some(GLYPH_NAME_PAIRS[109].1), // DEGREE SIGN
        0x00B1 => Some(GLYPH_NAME_PAIRS[110].1), // PLUS-MINUS SIGN
        0x00B4 => Some(GLYPH_NAME_PAIRS[111].1), // ACUTE ACCENT
        0x00B5 => Some(GLYPH_NAME_PAIRS[112].1), // MICRO SIGN
        0x00B6 => Some(GLYPH_NAME_PAIRS[113].1), // PILCROW SIGN
        0x00B7 => Some(GLYPH_NAME_PAIRS[114].1), // MIDDLE DOT
        0x00B8 => Some(GLYPH_NAME_PAIRS[115].1), // CEDILLA
        0x00BA => Some(GLYPH_NAME_PAIRS[116].1), // MASCULINE ORDINAL INDICATOR
        0x00BB => Some(GLYPH_NAME_PAIRS[117].1), // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        0x00BC => Some(GLYPH_NAME_PAIRS[118].1), // VULGAR FRACTION ONE QUARTER
        0x00BD => Some(GLYPH_NAME_PAIRS[119].1), // VULGAR FRACTION ONE HALF
        0x00BE => Some(GLYPH_NAME_PAIRS[120].1), // VULGAR FRACTION THREE QUARTERS
        0x00BF => Some(GLYPH_NAME_PAIRS[121].1), // INVERTED QUESTION MARK
        0x00C0 => Some(GLYPH_NAME_PAIRS[122].1), // LATIN CAPITAL LETTER A WITH GRAVE
        0x00C1 => Some(GLYPH_NAME_PAIRS[123].1), // LATIN CAPITAL LETTER A WITH ACUTE
        0x00C2 => Some(GLYPH_NAME_PAIRS[124].1), // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
        0x00C3 => Some(GLYPH_NAME_PAIRS[125].1), // LATIN CAPITAL LETTER A WITH TILDE
        0x00C4 => Some(GLYPH_NAME_PAIRS[126].1), // LATIN CAPITAL LETTER A WITH DIAERESIS
        0x00C5 => Some(GLYPH_NAME_PAIRS[127].1), // LATIN CAPITAL LETTER A WITH RING ABOVE
        0x00C6 => Some(GLYPH_NAME_PAIRS[128].1), // LATIN CAPITAL LETTER AE
        0x00C7 => Some(GLYPH_NAME_PAIRS[129].1), // LATIN CAPITAL LETTER C WITH CEDILLA
        0x00C8 => Some(GLYPH_NAME_PAIRS[130].1), // LATIN CAPITAL LETTER E WITH GRAVE
        0x00C9 => Some(GLYPH_NAME_PAIRS[131].1), // LATIN CAPITAL LETTER E WITH ACUTE
        0x00CA => Some(GLYPH_NAME_PAIRS[132].1), // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
        0x00CB => Some(GLYPH_NAME_PAIRS[133].1), // LATIN CAPITAL LETTER E WITH DIAERESIS
        0x00CC => Some(GLYPH_NAME_PAIRS[134].1), // LATIN CAPITAL LETTER I WITH GRAVE
        0x00CD => Some(GLYPH_NAME_PAIRS[135].1), // LATIN CAPITAL LETTER I WITH ACUTE
        0x00CE => Some(GLYPH_NAME_PAIRS[136].1), // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
        0x00CF => Some(GLYPH_NAME_PAIRS[137].1), // LATIN CAPITAL LETTER I WITH DIAERESIS
        0x00D0 => Some(GLYPH_NAME_PAIRS[138].1), // LATIN CAPITAL LETTER ETH
        0x00D1 => Some(GLYPH_NAME_PAIRS[139].1), // LATIN CAPITAL LETTER N WITH TILDE
        0x00D2 => Some(GLYPH_NAME_PAIRS[140].1), // LATIN CAPITAL LETTER O WITH GRAVE
        0x00D3 => Some(GLYPH_NAME_PAIRS[141].1), // LATIN CAPITAL LETTER O WITH ACUTE
        0x00D4 => Some(GLYPH_NAME_PAIRS[142].1), // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
        0x00D5 => Some(GLYPH_NAME_PAIRS[143].1), // LATIN CAPITAL LETTER O WITH TILDE
        0x00D6 => Some(GLYPH_NAME_PAIRS[144].1), // LATIN CAPITAL LETTER O WITH DIAERESIS
        0x00D7 => Some(GLYPH_NAME_PAIRS[145].1), // MULTIPLICATION SIGN
        0x00D8 => Some(GLYPH_NAME_PAIRS[146].1), // LATIN CAPITAL LETTER O WITH STROKE
        0x00D9 => Some(GLYPH_NAME_PAIRS[147].1), // LATIN CAPITAL LETTER U WITH GRAVE
        0x00DA => Some(GLYPH_NAME_PAIRS[148].1), // LATIN CAPITAL LETTER U WITH ACUTE
        0x00DB => Some(GLYPH_NAME_PAIRS[149].1), // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
        0x00DC => Some(GLYPH_NAME_PAIRS[150].1), // LATIN CAPITAL LETTER U WITH DIAERESIS
        0x00DD => Some(GLYPH_NAME_PAIRS[151].1), // LATIN CAPITAL LETTER Y WITH ACUTE
        0x00DE => Some(GLYPH_NAME_PAIRS[152].1), // LATIN CAPITAL LETTER THORN
        0x00DF => Some(GLYPH_NAME_PAIRS[153].1), // LATIN SMALL LETTER SHARP S
        0x00E0 => Some(GLYPH_NAME_PAIRS[154].1), // LATIN SMALL LETTER A WITH GRAVE
        0x00E1 => Some(GLYPH_NAME_PAIRS[155].1), // LATIN SMALL LETTER A WITH ACUTE
        0x00E2 => Some(GLYPH_NAME_PAIRS[156].1), // LATIN SMALL LETTER A WITH CIRCUMFLEX
        0x00E3 => Some(GLYPH_NAME_PAIRS[157].1), // LATIN SMALL LETTER A WITH TILDE
        0x00E4 => Some(GLYPH_NAME_PAIRS[158].1), // LATIN SMALL LETTER A WITH DIAERESIS
        0x00E5 => Some(GLYPH_NAME_PAIRS[159].1), // LATIN SMALL LETTER A WITH RING ABOVE
        0x00E6 => Some(GLYPH_NAME_PAIRS[160].1), // LATIN SMALL LETTER AE
        0x00E7 => Some(GLYPH_NAME_PAIRS[161].1), // LATIN SMALL LETTER C WITH CEDILLA
        0x00E8 => Some(GLYPH_NAME_PAIRS[162].1), // LATIN SMALL LETTER E WITH GRAVE
        0x00E9 => Some(GLYPH_NAME_PAIRS[163].1), // LATIN SMALL LETTER E WITH ACUTE
        0x00EA => Some(GLYPH_NAME_PAIRS[164].1), // LATIN SMALL LETTER E WITH CIRCUMFLEX
        0x00EB => Some(GLYPH_NAME_PAIRS[165].1), // LATIN SMALL LETTER E WITH DIAERESIS
        0x00EC => Some(GLYPH_NAME_PAIRS[166].1), // LATIN SMALL LETTER I WITH GRAVE
        0x00ED => Some(GLYPH_NAME_PAIRS[167].1), // LATIN SMALL LETTER I WITH ACUTE
        0x00EE => Some(GLYPH_NAME_PAIRS[168].1), // LATIN SMALL LETTER I WITH CIRCUMFLEX
        0x00EF => Some(GLYPH_NAME_PAIRS[169].1), // LATIN SMALL LETTER I WITH DIAERESIS
        0x00F0 => Some(GLYPH_NAME_PAIRS[170].1), // LATIN SMALL LETTER ETH
        0x00F1 => Some(GLYPH_NAME_PAIRS[171].1), // LATIN SMALL LETTER N WITH TILDE
        0x00F2 => Some(GLYPH_NAME_PAIRS[172].1), // LATIN SMALL LETTER O WITH GRAVE
        0x00F3 => Some(GLYPH_NAME_PAIRS[173].1), // LATIN SMALL LETTER O WITH ACUTE
        0x00F4 => Some(GLYPH_NAME_PAIRS[174].1), // LATIN SMALL LETTER O WITH CIRCUMFLEX
        0x00F5 => Some(GLYPH_NAME_PAIRS[175].1), // LATIN SMALL LETTER O WITH TILDE
        0x00F6 => Some(GLYPH_NAME_PAIRS[176].1), // LATIN SMALL LETTER O WITH DIAERESIS
        0x00F7 => Some(GLYPH_NAME_PAIRS[177].1), // DIVISION SIGN
        0x00F8 => Some(GLYPH_NAME_PAIRS[178].1), // LATIN SMALL LETTER O WITH STROKE
        0x00F9 => Some(GLYPH_NAME_PAIRS[179].1), // LATIN SMALL LETTER U WITH GRAVE
        0x00FA => Some(GLYPH_NAME_PAIRS[180].1), // LATIN SMALL LETTER U WITH ACUTE
        0x00FB => Some(GLYPH_NAME_PAIRS[181].1), // LATIN SMALL LETTER U WITH CIRCUMFLEX
        0x00FC => Some(GLYPH_NAME_PAIRS[182].1), // LATIN SMALL LETTER U WITH DIAERESIS
        0x00FD => Some(GLYPH_NAME_PAIRS[183].1), // LATIN SMALL LETTER Y WITH ACUTE
        0x00FE => Some(GLYPH_NAME_PAIRS[184].1), // LATIN SMALL LETTER THORN
        0x00FF => Some(GLYPH_NAME_PAIRS[185].1), // LATIN SMALL LETTER Y WITH DIAERESIS
        0x0100 => Some(GLYPH_NAME_PAIRS[186].1), // LATIN CAPITAL LETTER A WITH MACRON
        0x0101 => Some(GLYPH_NAME_PAIRS[187].1), // LATIN SMALL LETTER A WITH MACRON
        0x0102 => Some(GLYPH_NAME_PAIRS[188].1), // LATIN CAPITAL LETTER A WITH BREVE
        0x0103 => Some(GLYPH_NAME_PAIRS[189].1), // LATIN SMALL LETTER A WITH BREVE
        0x0104 => Some(GLYPH_NAME_PAIRS[190].1), // LATIN CAPITAL LETTER A WITH OGONEK
        0x0105 => Some(GLYPH_NAME_PAIRS[191].1), // LATIN SMALL LETTER A WITH OGONEK
        0x0106 => Some(GLYPH_NAME_PAIRS[192].1), // LATIN CAPITAL LETTER C WITH ACUTE
        0x0107 => Some(GLYPH_NAME_PAIRS[193].1), // LATIN SMALL LETTER C WITH ACUTE
        0x0108 => Some(GLYPH_NAME_PAIRS[194].1), // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
        0x0109 => Some(GLYPH_NAME_PAIRS[195].1), // LATIN SMALL LETTER C WITH CIRCUMFLEX
        0x010A => Some(GLYPH_NAME_PAIRS[196].1), // LATIN CAPITAL LETTER C WITH DOT ABOVE
        0x010B => Some(GLYPH_NAME_PAIRS[197].1), // LATIN SMALL LETTER C WITH DOT ABOVE
        0x010C => Some(GLYPH_NAME_PAIRS[198].1), // LATIN CAPITAL LETTER C WITH CARON
        0x010D => Some(GLYPH_NAME_PAIRS[199].1), // LATIN SMALL LETTER C WITH CARON
        0x010E => Some(GLYPH_NAME_PAIRS[200].1), // LATIN CAPITAL LETTER D WITH CARON
        0x010F => Some(GLYPH_NAME_PAIRS[201].1), // LATIN SMALL LETTER D WITH CARON
        0x0110 => Some(GLYPH_NAME_PAIRS[202].1), // LATIN CAPITAL LETTER D WITH STROKE
        0x0111 => Some(GLYPH_NAME_PAIRS[203].1), // LATIN SMALL LETTER D WITH STROKE
        0x0112 => Some(GLYPH_NAME_PAIRS[204].1), // LATIN CAPITAL LETTER E WITH MACRON
        0x0113 => Some(GLYPH_NAME_PAIRS[205].1), // LATIN SMALL LETTER E WITH MACRON
        0x0114 => Some(GLYPH_NAME_PAIRS[206].1), // LATIN CAPITAL LETTER E WITH BREVE
        0x0115 => Some(GLYPH_NAME_PAIRS[207].1), // LATIN SMALL LETTER E WITH BREVE
        0x0116 => Some(GLYPH_NAME_PAIRS[208].1), // LATIN CAPITAL LETTER E WITH DOT ABOVE
        0x0117 => Some(GLYPH_NAME_PAIRS[209].1), // LATIN SMALL LETTER E WITH DOT ABOVE
        0x0118 => Some(GLYPH_NAME_PAIRS[210].1), // LATIN CAPITAL LETTER E WITH OGONEK
        0x0119 => Some(GLYPH_NAME_PAIRS[211].1), // LATIN SMALL LETTER E WITH OGONEK
        0x011A => Some(GLYPH_NAME_PAIRS[212].1), // LATIN CAPITAL LETTER E WITH CARON
        0x011B => Some(GLYPH_NAME_PAIRS[213].1), // LATIN SMALL LETTER E WITH CARON
        0x011C => Some(GLYPH_NAME_PAIRS[214].1), // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
        0x011D => Some(GLYPH_NAME_PAIRS[215].1), // LATIN SMALL LETTER G WITH CIRCUMFLEX
        0x011E => Some(GLYPH_NAME_PAIRS[216].1), // LATIN CAPITAL LETTER G WITH BREVE
        0x011F => Some(GLYPH_NAME_PAIRS[217].1), // LATIN SMALL LETTER G WITH BREVE
        0x0120 => Some(GLYPH_NAME_PAIRS[218].1), // LATIN CAPITAL LETTER G WITH DOT ABOVE
        0x0121 => Some(GLYPH_NAME_PAIRS[219].1), // LATIN SMALL LETTER G WITH DOT ABOVE
        0x0124 => Some(GLYPH_NAME_PAIRS[220].1), // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
        0x0125 => Some(GLYPH_NAME_PAIRS[221].1), // LATIN SMALL LETTER H WITH CIRCUMFLEX
        0x0126 => Some(GLYPH_NAME_PAIRS[222].1), // LATIN CAPITAL LETTER H WITH STROKE
        0x0127 => Some(GLYPH_NAME_PAIRS[223].1), // LATIN SMALL LETTER H WITH STROKE
        0x0128 => Some(GLYPH_NAME_PAIRS[224].1), // LATIN CAPITAL LETTER I WITH TILDE
        0x0129 => Some(GLYPH_NAME_PAIRS[225].1), // LATIN SMALL LETTER I WITH TILDE
        0x012A => Some(GLYPH_NAME_PAIRS[226].1), // LATIN CAPITAL LETTER I WITH MACRON
        0x012B => Some(GLYPH_NAME_PAIRS[227].1), // LATIN SMALL LETTER I WITH MACRON
        0x012C => Some(GLYPH_NAME_PAIRS[228].1), // LATIN CAPITAL LETTER I WITH BREVE
        0x012D => Some(GLYPH_NAME_PAIRS[229].1), // LATIN SMALL LETTER I WITH BREVE
        0x012E => Some(GLYPH_NAME_PAIRS[230].1), // LATIN CAPITAL LETTER I WITH OGONEK
        0x012F => Some(GLYPH_NAME_PAIRS[231].1), // LATIN SMALL LETTER I WITH OGONEK
        0x0130 => Some(GLYPH_NAME_PAIRS[232].1), // LATIN CAPITAL LETTER I WITH DOT ABOVE
        0x0131 => Some(GLYPH_NAME_PAIRS[233].1), // LATIN SMALL LETTER DOTLESS I
        0x0132 => Some(GLYPH_NAME_PAIRS[234].1), // LATIN CAPITAL LIGATURE IJ
        0x0133 => Some(GLYPH_NAME_PAIRS[235].1), // LATIN SMALL LIGATURE IJ
        0x0134 => Some(GLYPH_NAME_PAIRS[236].1), // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
        0x0135 => Some(GLYPH_NAME_PAIRS[237].1), // LATIN SMALL LETTER J WITH CIRCUMFLEX
        0x0138 => Some(GLYPH_NAME_PAIRS[238].1), // LATIN SMALL LETTER KRA
        0x0139 => Some(GLYPH_NAME_PAIRS[239].1), // LATIN CAPITAL LETTER L WITH ACUTE
        0x013A => Some(GLYPH_NAME_PAIRS[240].1), // LATIN SMALL LETTER L WITH ACUTE
        0x013D => Some(GLYPH_NAME_PAIRS[241].1), // LATIN CAPITAL LETTER L WITH CARON
        0x013E => Some(GLYPH_NAME_PAIRS[242].1), // LATIN SMALL LETTER L WITH CARON
        0x013F => Some(GLYPH_NAME_PAIRS[243].1), // LATIN CAPITAL LETTER L WITH MIDDLE DOT
        0x0140 => Some(GLYPH_NAME_PAIRS[244].1), // LATIN SMALL LETTER L WITH MIDDLE DOT
        0x0141 => Some(GLYPH_NAME_PAIRS[245].1), // LATIN CAPITAL LETTER L WITH STROKE
        0x0142 => Some(GLYPH_NAME_PAIRS[246].1), // LATIN SMALL LETTER L WITH STROKE
        0x0143 => Some(GLYPH_NAME_PAIRS[247].1), // LATIN CAPITAL LETTER N WITH ACUTE
        0x0144 => Some(GLYPH_NAME_PAIRS[248].1), // LATIN SMALL LETTER N WITH ACUTE
        0x0147 => Some(GLYPH_NAME_PAIRS[249].1), // LATIN CAPITAL LETTER N WITH CARON
        0x0148 => Some(GLYPH_NAME_PAIRS[250].1), // LATIN SMALL LETTER N WITH CARON
        0x0149 => Some(GLYPH_NAME_PAIRS[251].1), // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
        0x014A => Some(GLYPH_NAME_PAIRS[252].1), // LATIN CAPITAL LETTER ENG
        0x014B => Some(GLYPH_NAME_PAIRS[253].1), // LATIN SMALL LETTER ENG
        0x014C => Some(GLYPH_NAME_PAIRS[254].1), // LATIN CAPITAL LETTER O WITH MACRON
        0x014D => Some(GLYPH_NAME_PAIRS[255].1), // LATIN SMALL LETTER O WITH MACRON
        0x014E => Some(GLYPH_NAME_PAIRS[256].1), // LATIN CAPITAL LETTER O WITH BREVE
        0x014F => Some(GLYPH_NAME_PAIRS[257].1), // LATIN SMALL LETTER O WITH BREVE
        0x0150 => Some(GLYPH_NAME_PAIRS[258].1), // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
        0x0151 => Some(GLYPH_NAME_PAIRS[259].1), // LATIN SMALL LETTER O WITH DOUBLE ACUTE
        0x0152 => Some(GLYPH_NAME_PAIRS[260].1), // LATIN CAPITAL LIGATURE OE
        0x0153 => Some(GLYPH_NAME_PAIRS[261].1), // LATIN SMALL LIGATURE OE
        0x0154 => Some(GLYPH_NAME_PAIRS[262].1), // LATIN CAPITAL LETTER R WITH ACUTE
        0x0155 => Some(GLYPH_NAME_PAIRS[263].1), // LATIN SMALL LETTER R WITH ACUTE
        0x0158 => Some(GLYPH_NAME_PAIRS[264].1), // LATIN CAPITAL LETTER R WITH CARON
        0x0159 => Some(GLYPH_NAME_PAIRS[265].1), // LATIN SMALL LETTER R WITH CARON
        0x015A => Some(GLYPH_NAME_PAIRS[266].1), // LATIN CAPITAL LETTER S WITH ACUTE
        0x015B => Some(GLYPH_NAME_PAIRS[267].1), // LATIN SMALL LETTER S WITH ACUTE
        0x015C => Some(GLYPH_NAME_PAIRS[268].1), // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
        0x015D => Some(GLYPH_NAME_PAIRS[269].1), // LATIN SMALL LETTER S WITH CIRCUMFLEX
        0x015E => Some(GLYPH_NAME_PAIRS[270].1), // LATIN CAPITAL LETTER S WITH CEDILLA
        0x015F => Some(GLYPH_NAME_PAIRS[271].1), // LATIN SMALL LETTER S WITH CEDILLA
        0x0160 => Some(GLYPH_NAME_PAIRS[272].1), // LATIN CAPITAL LETTER S WITH CARON
        0x0161 => Some(GLYPH_NAME_PAIRS[273].1), // LATIN SMALL LETTER S WITH CARON
        0x0164 => Some(GLYPH_NAME_PAIRS[274].1), // LATIN CAPITAL LETTER T WITH CARON
        0x0165 => Some(GLYPH_NAME_PAIRS[275].1), // LATIN SMALL LETTER T WITH CARON
        0x0166 => Some(GLYPH_NAME_PAIRS[276].1), // LATIN CAPITAL LETTER T WITH STROKE
        0x0167 => Some(GLYPH_NAME_PAIRS[277].1), // LATIN SMALL LETTER T WITH STROKE
        0x0168 => Some(GLYPH_NAME_PAIRS[278].1), // LATIN CAPITAL LETTER U WITH TILDE
        0x0169 => Some(GLYPH_NAME_PAIRS[279].1), // LATIN SMALL LETTER U WITH TILDE
        0x016A => Some(GLYPH_NAME_PAIRS[280].1), // LATIN CAPITAL LETTER U WITH MACRON
        0x016B => Some(GLYPH_NAME_PAIRS[281].1), // LATIN SMALL LETTER U WITH MACRON
        0x016C => Some(GLYPH_NAME_PAIRS[282].1), // LATIN CAPITAL LETTER U WITH BREVE
        0x016D => Some(GLYPH_NAME_PAIRS[283].1), // LATIN SMALL LETTER U WITH BREVE
        0x016E => Some(GLYPH_NAME_PAIRS[284].1), // LATIN CAPITAL LETTER U WITH RING ABOVE
        0x016F => Some(GLYPH_NAME_PAIRS[285].1), // LATIN SMALL LETTER U WITH RING ABOVE
        0x0170 => Some(GLYPH_NAME_PAIRS[286].1), // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
        0x0171 => Some(GLYPH_NAME_PAIRS[287].1), // LATIN SMALL LETTER U WITH DOUBLE ACUTE
        0x0172 => Some(GLYPH_NAME_PAIRS[288].1), // LATIN CAPITAL LETTER U WITH OGONEK
        0x0173 => Some(GLYPH_NAME_PAIRS[289].1), // LATIN SMALL LETTER U WITH OGONEK
        0x0174 => Some(GLYPH_NAME_PAIRS[290].1), // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
        0x0175 => Some(GLYPH_NAME_PAIRS[291].1), // LATIN SMALL LETTER W WITH CIRCUMFLEX
        0x0176 => Some(GLYPH_NAME_PAIRS[292].1), // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
        0x0177 => Some(GLYPH_NAME_PAIRS[293].1), // LATIN SMALL LETTER Y WITH CIRCUMFLEX
        0x0178 => Some(GLYPH_NAME_PAIRS[294].1), // LATIN CAPITAL LETTER Y WITH DIAERESIS
        0x0179 => Some(GLYPH_NAME_PAIRS[295].1), // LATIN CAPITAL LETTER Z WITH ACUTE
        0x017A => Some(GLYPH_NAME_PAIRS[296].1), // LATIN SMALL LETTER Z WITH ACUTE
        0x017B => Some(GLYPH_NAME_PAIRS[297].1), // LATIN CAPITAL LETTER Z WITH DOT ABOVE
        0x017C => Some(GLYPH_NAME_PAIRS[298].1), // LATIN SMALL LETTER Z WITH DOT ABOVE
        0x017D => Some(GLYPH_NAME_PAIRS[299].1), // LATIN CAPITAL LETTER Z WITH CARON
        0x017E => Some(GLYPH_NAME_PAIRS[300].1), // LATIN SMALL LETTER Z WITH CARON
        0x017F => Some(GLYPH_NAME_PAIRS[301].1), // LATIN SMALL LETTER LONG S
        0x0192 => Some(GLYPH_NAME_PAIRS[302].1), // LATIN SMALL LETTER F WITH HOOK
        0x01A0 => Some(GLYPH_NAME_PAIRS[303].1), // LATIN CAPITAL LETTER O WITH HORN
        0x01A1 => Some(GLYPH_NAME_PAIRS[304].1), // LATIN SMALL LETTER O WITH HORN
        0x01AF => Some(GLYPH_NAME_PAIRS[305].1), // LATIN CAPITAL LETTER U WITH HORN
        0x01B0 => Some(GLYPH_NAME_PAIRS[306].1), // LATIN SMALL LETTER U WITH HORN
        0x01E6 => Some(GLYPH_NAME_PAIRS[307].1), // LATIN CAPITAL LETTER G WITH CARON
        0x01E7 => Some(GLYPH_NAME_PAIRS[308].1), // LATIN SMALL LETTER G WITH CARON
        0x01FA => Some(GLYPH_NAME_PAIRS[309].1), // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
        0x01FB => Some(GLYPH_NAME_PAIRS[310].1), // LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
        0x01FC => Some(GLYPH_NAME_PAIRS[311].1), // LATIN CAPITAL LETTER AE WITH ACUTE
        0x01FD => Some(GLYPH_NAME_PAIRS[312].1), // LATIN SMALL LETTER AE WITH ACUTE
        0x01FE => Some(GLYPH_NAME_PAIRS[313].1), // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
        0x01FF => Some(GLYPH_NAME_PAIRS[314].1), // LATIN SMALL LETTER O WITH STROKE AND ACUTE
        0x02C6 => Some(GLYPH_NAME_PAIRS[315].1), // MODIFIER LETTER CIRCUMFLEX ACCENT
        0x02C7 => Some(GLYPH_NAME_PAIRS[316].1), // CARON
        0x02D8 => Some(GLYPH_NAME_PAIRS[317].1), // BREVE
        0x02D9 => Some(GLYPH_NAME_PAIRS[318].1), // DOT ABOVE
        0x02DA => Some(GLYPH_NAME_PAIRS[319].1), // RING ABOVE
        0x02DB => Some(GLYPH_NAME_PAIRS[320].1), // OGONEK
        0x02DC => Some(GLYPH_NAME_PAIRS[321].1), // SMALL TILDE
        0x02DD => Some(GLYPH_NAME_PAIRS[322].1), // DOUBLE ACUTE ACCENT
        0x0300 => Some(GLYPH_NAME_PAIRS[323].1), // COMBINING GRAVE ACCENT
        0x0301 => Some(GLYPH_NAME_PAIRS[324].1), // COMBINING ACUTE ACCENT
        0x0303 => Some(GLYPH_NAME_PAIRS[325].1), // COMBINING TILDE
        0x0309 => Some(GLYPH_NAME_PAIRS[326].1), // COMBINING HOOK ABOVE
        0x0323 => Some(GLYPH_NAME_PAIRS[327].1), // COMBINING DOT BELOW
        0x0384 => Some(GLYPH_NAME_PAIRS[328].1), // GREEK TONOS
        0x0385 => Some(GLYPH_NAME_PAIRS[329].1), // GREEK DIALYTIKA TONOS
        0x0386 => Some(GLYPH_NAME_PAIRS[330].1), // GREEK CAPITAL LETTER ALPHA WITH TONOS
        0x0387 => Some(GLYPH_NAME_PAIRS[331].1), // GREEK ANO TELEIA
        0x0388 => Some(GLYPH_NAME_PAIRS[332].1), // GREEK CAPITAL LETTER EPSILON WITH TONOS
        0x0389 => Some(GLYPH_NAME_PAIRS[333].1), // GREEK CAPITAL LETTER ETA WITH TONOS
        0x038A => Some(GLYPH_NAME_PAIRS[334].1), // GREEK CAPITAL LETTER IOTA WITH TONOS
        0x038C => Some(GLYPH_NAME_PAIRS[335].1), // GREEK CAPITAL LETTER OMICRON WITH TONOS
        0x038E => Some(GLYPH_NAME_PAIRS[336].1), // GREEK CAPITAL LETTER UPSILON WITH TONOS
        0x038F => Some(GLYPH_NAME_PAIRS[337].1), // GREEK CAPITAL LETTER OMEGA WITH TONOS
        0x0390 => Some(GLYPH_NAME_PAIRS[338].1), // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
        0x0391 => Some(GLYPH_NAME_PAIRS[339].1), // GREEK CAPITAL LETTER ALPHA
        0x0392 => Some(GLYPH_NAME_PAIRS[340].1), // GREEK CAPITAL LETTER BETA
        0x0393 => Some(GLYPH_NAME_PAIRS[341].1), // GREEK CAPITAL LETTER GAMMA
        0x0395 => Some(GLYPH_NAME_PAIRS[342].1), // GREEK CAPITAL LETTER EPSILON
        0x0396 => Some(GLYPH_NAME_PAIRS[343].1), // GREEK CAPITAL LETTER ZETA
        0x0397 => Some(GLYPH_NAME_PAIRS[344].1), // GREEK CAPITAL LETTER ETA
        0x0398 => Some(GLYPH_NAME_PAIRS[345].1), // GREEK CAPITAL LETTER THETA
        0x0399 => Some(GLYPH_NAME_PAIRS[346].1), // GREEK CAPITAL LETTER IOTA
        0x039A => Some(GLYPH_NAME_PAIRS[347].1), // GREEK CAPITAL LETTER KAPPA
        0x039B => Some(GLYPH_NAME_PAIRS[348].1), // GREEK CAPITAL LETTER LAMDA
        0x039C => Some(GLYPH_NAME_PAIRS[349].1), // GREEK CAPITAL LETTER MU
        0x039D => Some(GLYPH_NAME_PAIRS[350].1), // GREEK CAPITAL LETTER NU
        0x039E => Some(GLYPH_NAME_PAIRS[351].1), // GREEK CAPITAL LETTER XI
        0x039F => Some(GLYPH_NAME_PAIRS[352].1), // GREEK CAPITAL LETTER OMICRON
        0x03A0 => Some(GLYPH_NAME_PAIRS[353].1), // GREEK CAPITAL LETTER PI
        0x03A1 => Some(GLYPH_NAME_PAIRS[354].1), // GREEK CAPITAL LETTER RHO
        0x03A3 => Some(GLYPH_NAME_PAIRS[355].1), // GREEK CAPITAL LETTER SIGMA
        0x03A4 => Some(GLYPH_NAME_PAIRS[356].1), // GREEK CAPITAL LETTER TAU
        0x03A5 => Some(GLYPH_NAME_PAIRS[357].1), // GREEK CAPITAL LETTER UPSILON
        0x03A6 => Some(GLYPH_NAME_PAIRS[358].1), // GREEK CAPITAL LETTER PHI
        0x03A7 => Some(GLYPH_NAME_PAIRS[359].1), // GREEK CAPITAL LETTER CHI
        0x03A8 => Some(GLYPH_NAME_PAIRS[360].1), // GREEK CAPITAL LETTER PSI
        0x03AA => Some(GLYPH_NAME_PAIRS[361].1), // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
        0x03AB => Some(GLYPH_NAME_PAIRS[362].1), // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
        0x03AC => Some(GLYPH_NAME_PAIRS[363].1), // GREEK SMALL LETTER ALPHA WITH TONOS
        0x03AD => Some(GLYPH_NAME_PAIRS[364].1), // GREEK SMALL LETTER EPSILON WITH TONOS
        0x03AE => Some(GLYPH_NAME_PAIRS[365].1), // GREEK SMALL LETTER ETA WITH TONOS
        0x03AF => Some(GLYPH_NAME_PAIRS[366].1), // GREEK SMALL LETTER IOTA WITH TONOS
        0x03B0 => Some(GLYPH_NAME_PAIRS[367].1), // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
        0x03B1 => Some(GLYPH_NAME_PAIRS[368].1), // GREEK SMALL LETTER ALPHA
        0x03B2 => Some(GLYPH_NAME_PAIRS[369].1), // GREEK SMALL LETTER BETA
        0x03B3 => Some(GLYPH_NAME_PAIRS[370].1), // GREEK SMALL LETTER GAMMA
        0x03B4 => Some(GLYPH_NAME_PAIRS[371].1), // GREEK SMALL LETTER DELTA
        0x03B5 => Some(GLYPH_NAME_PAIRS[372].1), // GREEK SMALL LETTER EPSILON
        0x03B6 => Some(GLYPH_NAME_PAIRS[373].1), // GREEK SMALL LETTER ZETA
        0x03B7 => Some(GLYPH_NAME_PAIRS[374].1), // GREEK SMALL LETTER ETA
        0x03B8 => Some(GLYPH_NAME_PAIRS[375].1), // GREEK SMALL LETTER THETA
        0x03B9 => Some(GLYPH_NAME_PAIRS[376].1), // GREEK SMALL LETTER IOTA
        0x03BA => Some(GLYPH_NAME_PAIRS[377].1), // GREEK SMALL LETTER KAPPA
        0x03BB => Some(GLYPH_NAME_PAIRS[378].1), // GREEK SMALL LETTER LAMDA
        0x03BD => Some(GLYPH_NAME_PAIRS[379].1), // GREEK SMALL LETTER NU
        0x03BE => Some(GLYPH_NAME_PAIRS[380].1), // GREEK SMALL LETTER XI
        0x03BF => Some(GLYPH_NAME_PAIRS[381].1), // GREEK SMALL LETTER OMICRON
        0x03C0 => Some(GLYPH_NAME_PAIRS[382].1), // GREEK SMALL LETTER PI
        0x03C1 => Some(GLYPH_NAME_PAIRS[383].1), // GREEK SMALL LETTER RHO
        0x03C2 => Some(GLYPH_NAME_PAIRS[384].1), // GREEK SMALL LETTER FINAL SIGMA
        0x03C3 => Some(GLYPH_NAME_PAIRS[385].1), // GREEK SMALL LETTER SIGMA
        0x03C4 => Some(GLYPH_NAME_PAIRS[386].1), // GREEK SMALL LETTER TAU
        0x03C5 => Some(GLYPH_NAME_PAIRS[387].1), // GREEK SMALL LETTER UPSILON
        0x03C6 => Some(GLYPH_NAME_PAIRS[388].1), // GREEK SMALL LETTER PHI
        0x03C7 => Some(GLYPH_NAME_PAIRS[389].1), // GREEK SMALL LETTER CHI
        0x03C8 => Some(GLYPH_NAME_PAIRS[390].1), // GREEK SMALL LETTER PSI
        0x03C9 => Some(GLYPH_NAME_PAIRS[391].1), // GREEK SMALL LETTER OMEGA
        0x03CA => Some(GLYPH_NAME_PAIRS[392].1), // GREEK SMALL LETTER IOTA WITH DIALYTIKA
        0x03CB => Some(GLYPH_NAME_PAIRS[393].1), // GREEK SMALL LETTER UPSILON WITH DIALYTIKA
        0x03CC => Some(GLYPH_NAME_PAIRS[394].1), // GREEK SMALL LETTER OMICRON WITH TONOS
        0x03CD => Some(GLYPH_NAME_PAIRS[395].1), // GREEK SMALL LETTER UPSILON WITH TONOS
        0x03CE => Some(GLYPH_NAME_PAIRS[396].1), // GREEK SMALL LETTER OMEGA WITH TONOS
        0x03D1 => Some(GLYPH_NAME_PAIRS[397].1), // GREEK THETA SYMBOL
        0x03D2 => Some(GLYPH_NAME_PAIRS[398].1), // GREEK UPSILON WITH HOOK SYMBOL
        0x03D5 => Some(GLYPH_NAME_PAIRS[399].1), // GREEK PHI SYMBOL
        0x03D6 => Some(GLYPH_NAME_PAIRS[400].1), // GREEK PI SYMBOL
        0x1E80 => Some(GLYPH_NAME_PAIRS[401].1), // LATIN CAPITAL LETTER W WITH GRAVE
        0x1E81 => Some(GLYPH_NAME_PAIRS[402].1), // LATIN SMALL LETTER W WITH GRAVE
        0x1E82 => Some(GLYPH_NAME_PAIRS[403].1), // LATIN CAPITAL LETTER W WITH ACUTE
        0x1E83 => Some(GLYPH_NAME_PAIRS[404].1), // LATIN SMALL LETTER W WITH ACUTE
        0x1E84 => Some(GLYPH_NAME_PAIRS[405].1), // LATIN CAPITAL LETTER W WITH DIAERESIS
        0x1E85 => Some(GLYPH_NAME_PAIRS[406].1), // LATIN SMALL LETTER W WITH DIAERESIS
        0x1EF2 => Some(GLYPH_NAME_PAIRS[407].1), // LATIN CAPITAL LETTER Y WITH GRAVE
        0x1EF3 => Some(GLYPH_NAME_PAIRS[408].1), // LATIN SMALL LETTER Y WITH GRAVE
        0x2012 => Some(GLYPH_NAME_PAIRS[409].1), // FIGURE DASH
        0x2013 => Some(GLYPH_NAME_PAIRS[410].1), // EN DASH
        0x2014 => Some(GLYPH_NAME_PAIRS[411].1), // EM DASH
        0x2017 => Some(GLYPH_NAME_PAIRS[412].1), // DOUBLE LOW LINE
        0x2018 => Some(GLYPH_NAME_PAIRS[413].1), // LEFT SINGLE QUOTATION MARK
        0x2019 => Some(GLYPH_NAME_PAIRS[414].1), // RIGHT SINGLE QUOTATION MARK
        0x201A => Some(GLYPH_NAME_PAIRS[415].1), // SINGLE LOW-9 QUOTATION MARK
        0x201B => Some(GLYPH_NAME_PAIRS[416].1), // SINGLE HIGH-REVERSED-9 QUOTATION MARK
        0x201C => Some(GLYPH_NAME_PAIRS[417].1), // LEFT DOUBLE QUOTATION MARK
        0x201D => Some(GLYPH_NAME_PAIRS[418].1), // RIGHT DOUBLE QUOTATION MARK
        0x201E => Some(GLYPH_NAME_PAIRS[419].1), // DOUBLE LOW-9 QUOTATION MARK
        0x2020 => Some(GLYPH_NAME_PAIRS[420].1), // DAGGER
        0x2021 => Some(GLYPH_NAME_PAIRS[421].1), // DOUBLE DAGGER
        0x2022 => Some(GLYPH_NAME_PAIRS[422].1), // BULLET
        0x2024 => Some(GLYPH_NAME_PAIRS[423].1), // ONE DOT LEADER
        0x2025 => Some(GLYPH_NAME_PAIRS[424].1), // TWO DOT LEADER
        0x2026 => Some(GLYPH_NAME_PAIRS[425].1), // HORIZONTAL ELLIPSIS
        0x2030 => Some(GLYPH_NAME_PAIRS[426].1), // PER MILLE SIGN
        0x2032 => Some(GLYPH_NAME_PAIRS[427].1), // PRIME
        0x2033 => Some(GLYPH_NAME_PAIRS[428].1), // DOUBLE PRIME
        0x2039 => Some(GLYPH_NAME_PAIRS[429].1), // SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        0x203A => Some(GLYPH_NAME_PAIRS[430].1), // SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        0x203C => Some(GLYPH_NAME_PAIRS[431].1), // DOUBLE EXCLAMATION MARK
        0x2044 => Some(GLYPH_NAME_PAIRS[432].1), // FRACTION SLASH
        0x20A1 => Some(GLYPH_NAME_PAIRS[433].1), // COLON SIGN
        0x20A3 => Some(GLYPH_NAME_PAIRS[434].1), // FRENCH FRANC SIGN
        0x20A4 => Some(GLYPH_NAME_PAIRS[435].1), // LIRA SIGN
        0x20A7 => Some(GLYPH_NAME_PAIRS[436].1), // PESETA SIGN
        0x20AB => Some(GLYPH_NAME_PAIRS[437].1), // DONG SIGN
        0x20AC => Some(GLYPH_NAME_PAIRS[438].1), // EURO SIGN
        0x2111 => Some(GLYPH_NAME_PAIRS[439].1), // BLACK-LETTER CAPITAL I
        0x2118 => Some(GLYPH_NAME_PAIRS[440].1), // SCRIPT CAPITAL P
        0x211C => Some(GLYPH_NAME_PAIRS[441].1), // BLACK-LETTER CAPITAL R
        0x211E => Some(GLYPH_NAME_PAIRS[442].1), // PRESCRIPTION TAKE
        0x2122 => Some(GLYPH_NAME_PAIRS[443].1), // TRADE MARK SIGN
        0x2126 => Some(GLYPH_NAME_PAIRS[444].1), // OHM SIGN
        0x212E => Some(GLYPH_NAME_PAIRS[445].1), // ESTIMATED SYMBOL
        0x2135 => Some(GLYPH_NAME_PAIRS[446].1), // ALEF SYMBOL
        0x2153 => Some(GLYPH_NAME_PAIRS[447].1), // VULGAR FRACTION ONE THIRD
        0x2154 => Some(GLYPH_NAME_PAIRS[448].1), // VULGAR FRACTION TWO THIRDS
        0x215B => Some(GLYPH_NAME_PAIRS[449].1), // VULGAR FRACTION ONE EIGHTH
        0x215C => Some(GLYPH_NAME_PAIRS[450].1), // VULGAR FRACTION THREE EIGHTHS
        0x215D => Some(GLYPH_NAME_PAIRS[451].1), // VULGAR FRACTION FIVE EIGHTHS
        0x215E => Some(GLYPH_NAME_PAIRS[452].1), // VULGAR FRACTION SEVEN EIGHTHS
        0x2190 => Some(GLYPH_NAME_PAIRS[453].1), // LEFTWARDS ARROW
        0x2191 => Some(GLYPH_NAME_PAIRS[454].1), // UPWARDS ARROW
        0x2192 => Some(GLYPH_NAME_PAIRS[455].1), // RIGHTWARDS ARROW
        0x2193 => Some(GLYPH_NAME_PAIRS[456].1), // DOWNWARDS ARROW
        0x2194 => Some(GLYPH_NAME_PAIRS[457].1), // LEFT RIGHT ARROW
        0x2195 => Some(GLYPH_NAME_PAIRS[458].1), // UP DOWN ARROW
        0x21A8 => Some(GLYPH_NAME_PAIRS[459].1), // UP DOWN ARROW WITH BASE
        0x21B5 => Some(GLYPH_NAME_PAIRS[460].1), // DOWNWARDS ARROW WITH CORNER LEFTWARDS
        0x21D0 => Some(GLYPH_NAME_PAIRS[461].1), // LEFTWARDS DOUBLE ARROW
        0x21D1 => Some(GLYPH_NAME_PAIRS[462].1), // UPWARDS DOUBLE ARROW
        0x21D2 => Some(GLYPH_NAME_PAIRS[463].1), // RIGHTWARDS DOUBLE ARROW
        0x21D3 => Some(GLYPH_NAME_PAIRS[464].1), // DOWNWARDS DOUBLE ARROW
        0x21D4 => Some(GLYPH_NAME_PAIRS[465].1), // LEFT RIGHT DOUBLE ARROW
        0x2200 => Some(GLYPH_NAME_PAIRS[466].1), // FOR ALL
        0x2202 => Some(GLYPH_NAME_PAIRS[467].1), // PARTIAL DIFFERENTIAL
        0x2203 => Some(GLYPH_NAME_PAIRS[468].1), // THERE EXISTS
        0x2205 => Some(GLYPH_NAME_PAIRS[469].1), // EMPTY SET
        0x2206 => Some(GLYPH_NAME_PAIRS[470].1), // INCREMENT
        0x2207 => Some(GLYPH_NAME_PAIRS[471].1), // NABLA
        0x2208 => Some(GLYPH_NAME_PAIRS[472].1), // ELEMENT OF
        0x2209 => Some(GLYPH_NAME_PAIRS[473].1), // NOT AN ELEMENT OF
        0x220B => Some(GLYPH_NAME_PAIRS[474].1), // CONTAINS AS MEMBER
        0x220F => Some(GLYPH_NAME_PAIRS[475].1), // N-ARY PRODUCT
        0x2211 => Some(GLYPH_NAME_PAIRS[476].1), // N-ARY SUMMATION
        0x2212 => Some(GLYPH_NAME_PAIRS[477].1), // MINUS SIGN
        0x2217 => Some(GLYPH_NAME_PAIRS[478].1), // ASTERISK OPERATOR
        0x221A => Some(GLYPH_NAME_PAIRS[479].1), // SQUARE ROOT
        0x221D => Some(GLYPH_NAME_PAIRS[480].1), // PROPORTIONAL TO
        0x221E => Some(GLYPH_NAME_PAIRS[481].1), // INFINITY
        0x221F => Some(GLYPH_NAME_PAIRS[482].1), // RIGHT ANGLE
        0x2220 => Some(GLYPH_NAME_PAIRS[483].1), // ANGLE
        0x2227 => Some(GLYPH_NAME_PAIRS[484].1), // LOGICAL AND
        0x2228 => Some(GLYPH_NAME_PAIRS[485].1), // LOGICAL OR
        0x2229 => Some(GLYPH_NAME_PAIRS[486].1), // INTERSECTION
        0x222A => Some(GLYPH_NAME_PAIRS[487].1), // UNION
        0x222B => Some(GLYPH_NAME_PAIRS[488].1), // INTEGRAL
        0x2234 => Some(GLYPH_NAME_PAIRS[489].1), // THEREFORE
        0x223C => Some(GLYPH_NAME_PAIRS[490].1), // TILDE OPERATOR
        0x2245 => Some(GLYPH_NAME_PAIRS[491].1), // APPROXIMATELY EQUAL TO
        0x2248 => Some(GLYPH_NAME_PAIRS[492].1), // ALMOST EQUAL TO
        0x2260 => Some(GLYPH_NAME_PAIRS[493].1), // NOT EQUAL TO
        0x2261 => Some(GLYPH_NAME_PAIRS[494].1), // IDENTICAL TO
        0x2264 => Some(GLYPH_NAME_PAIRS[495].1), // LESS-THAN OR EQUAL TO
        0x2265 => Some(GLYPH_NAME_PAIRS[496].1), // GREATER-THAN OR EQUAL TO
        0x2282 => Some(GLYPH_NAME_PAIRS[497].1), // SUBSET OF
        0x2283 => Some(GLYPH_NAME_PAIRS[498].1), // SUPERSET OF
        0x2284 => Some(GLYPH_NAME_PAIRS[499].1), // NOT A SUBSET OF
        0x2286 => Some(GLYPH_NAME_PAIRS[500].1), // SUBSET OF OR EQUAL TO
        0x2287 => Some(GLYPH_NAME_PAIRS[501].1), // SUPERSET OF OR EQUAL TO
        0x2295 => Some(GLYPH_NAME_PAIRS[502].1), // CIRCLED PLUS
        0x2297 => Some(GLYPH_NAME_PAIRS[503].1), // CIRCLED TIMES
        0x22A5 => Some(GLYPH_NAME_PAIRS[504].1), // UP TACK
        0x22C5 => Some(GLYPH_NAME_PAIRS[505].1), // DOT OPERATOR
        0x2302 => Some(GLYPH_NAME_PAIRS[506].1), // HOUSE
        0x2310 => Some(GLYPH_NAME_PAIRS[507].1), // REVERSED NOT SIGN
        0x2320 => Some(GLYPH_NAME_PAIRS[508].1), // TOP HALF INTEGRAL
        0x2321 => Some(GLYPH_NAME_PAIRS[509].1), // BOTTOM HALF INTEGRAL
        0x2329 => Some(GLYPH_NAME_PAIRS[510].1), // LEFT-POINTING ANGLE BRACKET
        0x232A => Some(GLYPH_NAME_PAIRS[511].1), // RIGHT-POINTING ANGLE BRACKET
        0x2500 => Some(GLYPH_NAME_PAIRS[512].1), // BOX DRAWINGS LIGHT HORIZONTAL
        0x2502 => Some(GLYPH_NAME_PAIRS[513].1), // BOX DRAWINGS LIGHT VERTICAL
        0x250C => Some(GLYPH_NAME_PAIRS[514].1), // BOX DRAWINGS LIGHT DOWN AND RIGHT
        0x2510 => Some(GLYPH_NAME_PAIRS[515].1), // BOX DRAWINGS LIGHT DOWN AND LEFT
        0x2514 => Some(GLYPH_NAME_PAIRS[516].1), // BOX DRAWINGS LIGHT UP AND RIGHT
        0x2518 => Some(GLYPH_NAME_PAIRS[517].1), // BOX DRAWINGS LIGHT UP AND LEFT
        0x251C => Some(GLYPH_NAME_PAIRS[518].1), // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
        0x2524 => Some(GLYPH_NAME_PAIRS[519].1), // BOX DRAWINGS LIGHT VERTICAL AND LEFT
        0x252C => Some(GLYPH_NAME_PAIRS[520].1), // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
        0x2534 => Some(GLYPH_NAME_PAIRS[521].1), // BOX DRAWINGS LIGHT UP AND HORIZONTAL
        0x253C => Some(GLYPH_NAME_PAIRS[522].1), // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
        0x2550 => Some(GLYPH_NAME_PAIRS[523].1), // BOX DRAWINGS DOUBLE HORIZONTAL
        0x2551 => Some(GLYPH_NAME_PAIRS[524].1), // BOX DRAWINGS DOUBLE VERTICAL
        0x2552 => Some(GLYPH_NAME_PAIRS[525].1), // BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
        0x2553 => Some(GLYPH_NAME_PAIRS[526].1), // BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
        0x2554 => Some(GLYPH_NAME_PAIRS[527].1), // BOX DRAWINGS DOUBLE DOWN AND RIGHT
        0x2555 => Some(GLYPH_NAME_PAIRS[528].1), // BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
        0x2556 => Some(GLYPH_NAME_PAIRS[529].1), // BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
        0x2557 => Some(GLYPH_NAME_PAIRS[530].1), // BOX DRAWINGS DOUBLE DOWN AND LEFT
        0x2558 => Some(GLYPH_NAME_PAIRS[531].1), // BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
        0x2559 => Some(GLYPH_NAME_PAIRS[532].1), // BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
        0x255A => Some(GLYPH_NAME_PAIRS[533].1), // BOX DRAWINGS DOUBLE UP AND RIGHT
        0x255B => Some(GLYPH_NAME_PAIRS[534].1), // BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
        0x255C => Some(GLYPH_NAME_PAIRS[535].1), // BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
        0x255D => Some(GLYPH_NAME_PAIRS[536].1), // BOX DRAWINGS DOUBLE UP AND LEFT
        0x255E => Some(GLYPH_NAME_PAIRS[537].1), // BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
        0x255F => Some(GLYPH_NAME_PAIRS[538].1), // BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
        0x2560 => Some(GLYPH_NAME_PAIRS[539].1), // BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
        0x2561 => Some(GLYPH_NAME_PAIRS[540].1), // BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
        0x2562 => Some(GLYPH_NAME_PAIRS[541].1), // BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
        0x2563 => Some(GLYPH_NAME_PAIRS[542].1), // BOX DRAWINGS DOUBLE VERTICAL AND LEFT
        0x2564 => Some(GLYPH_NAME_PAIRS[543].1), // BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
        0x2565 => Some(GLYPH_NAME_PAIRS[544].1), // BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
        0x2566 => Some(GLYPH_NAME_PAIRS[545].1), // BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
        0x2567 => Some(GLYPH_NAME_PAIRS[546].1), // BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
        0x2568 => Some(GLYPH_NAME_PAIRS[547].1), // BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
        0x2569 => Some(GLYPH_NAME_PAIRS[548].1), // BOX DRAWINGS DOUBLE UP AND HORIZONTAL
        0x256A => Some(GLYPH_NAME_PAIRS[549].1), // BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
        0x256B => Some(GLYPH_NAME_PAIRS[550].1), // BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
        0x256C => Some(GLYPH_NAME_PAIRS[551].1), // BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
        0x2580 => Some(GLYPH_NAME_PAIRS[552].1), // UPPER HALF BLOCK
        0x2584 => Some(GLYPH_NAME_PAIRS[553].1), // LOWER HALF BLOCK
        0x2588 => Some(GLYPH_NAME_PAIRS[554].1), // FULL BLOCK
        0x258C => Some(GLYPH_NAME_PAIRS[555].1), // LEFT HALF BLOCK
        0x2590 => Some(GLYPH_NAME_PAIRS[556].1), // RIGHT HALF BLOCK
        0x2591 => Some(GLYPH_NAME_PAIRS[557].1), // LIGHT SHADE
        0x2592 => Some(GLYPH_NAME_PAIRS[558].1), // MEDIUM SHADE
        0x2593 => Some(GLYPH_NAME_PAIRS[559].1), // DARK SHADE
        0x25A0 => Some(GLYPH_NAME_PAIRS[560].1), // BLACK SQUARE
        0x25A1 => Some(GLYPH_NAME_PAIRS[561].1), // WHITE SQUARE
        0x25AA => Some(GLYPH_NAME_PAIRS[562].1), // BLACK SMALL SQUARE
        0x25AB => Some(GLYPH_NAME_PAIRS[563].1), // WHITE SMALL SQUARE
        0x25AC => Some(GLYPH_NAME_PAIRS[564].1), // BLACK RECTANGLE
        0x25B2 => Some(GLYPH_NAME_PAIRS[565].1), // BLACK UP-POINTING TRIANGLE
        0x25BA => Some(GLYPH_NAME_PAIRS[566].1), // BLACK RIGHT-POINTING POINTER
        0x25BC => Some(GLYPH_NAME_PAIRS[567].1), // BLACK DOWN-POINTING TRIANGLE
        0x25C4 => Some(GLYPH_NAME_PAIRS[568].1), // BLACK LEFT-POINTING POINTER
        0x25CA => Some(GLYPH_NAME_PAIRS[569].1), // LOZENGE
        0x25CB => Some(GLYPH_NAME_PAIRS[570].1), // WHITE CIRCLE
        0x25CF => Some(GLYPH_NAME_PAIRS[571].1), // BLACK CIRCLE
        0x25D8 => Some(GLYPH_NAME_PAIRS[572].1), // INVERSE BULLET
        0x25D9 => Some(GLYPH_NAME_PAIRS[573].1), // INVERSE WHITE CIRCLE
        0x25E6 => Some(GLYPH_NAME_PAIRS[574].1), // WHITE BULLET
        0x263A => Some(GLYPH_NAME_PAIRS[575].1), // WHITE SMILING FACE
        0x263B => Some(GLYPH_NAME_PAIRS[576].1), // BLACK SMILING FACE
        0x263C => Some(GLYPH_NAME_PAIRS[577].1), // WHITE SUN WITH RAYS
        0x2640 => Some(GLYPH_NAME_PAIRS[578].1), // FEMALE SIGN
        0x2642 => Some(GLYPH_NAME_PAIRS[579].1), // MALE SIGN
        0x2660 => Some(GLYPH_NAME_PAIRS[580].1), // BLACK SPADE SUIT
        0x2663 => Some(GLYPH_NAME_PAIRS[581].1), // BLACK CLUB SUIT
        0x2665 => Some(GLYPH_NAME_PAIRS[582].1), // BLACK HEART SUIT
        0x2666 => Some(GLYPH_NAME_PAIRS[583].1), // BLACK DIAMOND SUIT
        0x266A => Some(GLYPH_NAME_PAIRS[584].1), // EIGHTH NOTE
        0x266B => Some(GLYPH_NAME_PAIRS[585].1), // BEAMED EIGHTH NOTES
        _ => None,
    }
}
