<section align="center">
<h3>
  <img src="/public/vite.svg" width="100"  style="border-radius:1rem"  alt="Logo"/><br/>
  Minime
</h3>
Streamlined. Stylish. Simple.

<https://yashchaudhari008.github.io/minime/>

</section>
<br />
<section align="center">
  <a href="https://github.com/yashchaudhari008/minime/stargazers">
    <img src="https://img.shields.io/github/stars/yashchaudhari008/minime?style=for-the-badge&logo=starship&color=1f1f1f&logoColor=white&labelColor=171717">
  </a>
  <a href="https://github.com/yashchaudhari008/minime/issues">
    <img src="https://img.shields.io/github/issues/yashchaudhari008/minime?style=for-the-badge&logo=gitbook&color=1f1f1f&logoColor=white&labelColor=171717">
  </a>
  <a href="https://github.com/yashchaudhari008/minime/contributors">
    <img src="https://img.shields.io/github/contributors/yashchaudhari008/minime?style=for-the-badge&logo=github&color=1f1f1f&logoColor=white&labelColor=171717">
  </a>
  <a href="https://github.com/yashchaudhari008/minime/license">
    <img src="https://img.shields.io/github/license/yashchaudhari008/minime?style=for-the-badge&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAACXBIWXMAAAsTAAALEwEAmpwYAAABRUlEQVR4nO3WoU4DQRCA4ZEVJHV9iTPUoREQEp6B4IrjMTCAoQLJC6AwoAqhWEDwCCg0Daj+mGk4LqRZstu7mTBfcqJ72b37b3O5ioQQsgAPdG9aIsQEiRCFEZILIyRCFEZILoyQCFEYIbkwQiJErfQpNdDVjhS5+7auhRESIQojJBf/IUQKI0ISYITkwgiJEIURkgsjJELUHx/cK7AJbABvHnfkDFgDBrV5Ax0bewrZWjJ/20vICdBbMr8HnHoI6Ses0fcQMkpY48BDyFHCGsceQsYJa5x7CJkDV8Dwl7nrem7uIWThWr8du8COvuCXFCIthqyUtBhyo39LHoEX4BOYuAuR/AcRIcV3BKiAJz0qazsyTbzWPjCr/Z7pWAn32SEJoU0Xevwg1vHtAzisje8B755C7oDnxTvROFfpudtu7k78+QK6QD2RYgiOwwAAAABJRU5ErkJggg==&color=1f1f1f&labelColor=171717">
  </a>  
</section>

---

### ✨ Overview

Experience a clean and modern design that enhances your browsing experience. This web-app is your gateway to the web, keeping everything simple yet functional. Minime is tailored for those who value minimalism and efficiency in their online interactions.

#### Key Features

- **Clean Aesthetic**: Enjoy a minimalist layout that focuses on what matters most—your content.
- **Quick Links**: Easily access your favorite sites with customizable shortcuts.
  <!-- - **Dynamic Backgrounds**: Choose from a selection of beautiful, calming backgrounds that change throughout the day. -->
  <!-- - **Weather Updates**: Stay informed with real-time weather updates right on your homepage. -->
  <!-- - **Search Bar**: Quickly find what you need with a powerful search feature at your fingertips. -->

#### Join the Minimalist Revolution!

Embrace simplicity and focus on what truly matters. Start your browsing journey here, where less is truly more!

---

### How to Use Minime

#### Option 1: Set as New Tab (Recommended)

**For Chrome:**

1. Install the [Custom New Tab URL](https://chromewebstore.google.com/detail/custom-new-tab-url/mmjbdbjnoablegbkcklggeknkfcjkjia?hl=en) extension from the Chrome Web Store.
2. Set the Custom New Tab URL to open Minime app using link: https://yashchaudhari008.github.io/minime/.

**For Firefox:**

1. Install the [Custom New Tab Page](https://addons.mozilla.org/en-US/firefox/addon/custom-new-tab-page/) extension.
2. In the extension settings, enable **Force links to open in the top frame (experimental)**.
3. Enter Minime app link: https://yashchaudhari008.github.io/minime/ in the New Tab URL box.

#### Option 2: Set as Home Page

**For Chrome:**

1. Open Chrome’s **Settings**.
2. Scroll to the **On startup** section.
3. Select **Open a specific page or set of pages**.
4. Click **Add a new page** and enter minime app link ( `https://yashchaudhari008.github.io/minime/`).

**For Firefox:**

1. Open **Settings**.
2. Navigate to the **Home** section.
3. Under **Homepage and new windows**, select **Custom URLs** from the dropdown menu.
4. Enter your GitHub Pages link. Done! 💻

---

### 🏃‍ Running Locally (For Developers)

Make sure you have [node.js](http://nodejs.org/) (v20 recommended) and [yarn](https://yarnpkg.com/) installed.

1. Clone the repository and open the project folder:

   ```sh
   git clone https://github.com/yashchaudhari008/minime.git
   ```

2. Install the node packages using `yarn`:

   ```sh
   yarn install
   ```

3. Run the development server:

   ```sh
   yarn dev
   ```

4. Open your browser and go to [http://localhost:5173/minime/](http://localhost:5173/minime/) to view the app.

#### Recommended VS Code Extensions

- [Prettier - Code formatter](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode)
- [Auto Rename Tag](https://marketplace.visualstudio.com/items?itemName=formulahendry.auto-rename-tag)

---

### 🤝 Contributing

Explore open issues to work on [here](https://github.com/yashchaudhari008/minime/issues).  
If you found a bug or have a suggestion, [create a new issue](https://github.com/yashchaudhari008/minime/issues/new).

#### 🔼 Instructions

1. Find or create an [issue](https://github.com/yashchaudhari008/minime/issues) to work on.
2. Fork the repository.
3. Create a new branch from the `main` branch using one of the following formats:
   - For new features: `feat-[feature-name]` (e.g., `feat-add-login`)
   - For bug fixes: `fix-[bug-name]` (e.g., `fix-header-crash`)
4. Make and test your changes.
5. Commit your changes.
6. Submit a PR with a clear title and link the issue in the PR description.
7. Wait for your PR to be reviewed ✔.

#### ✅ Guidelines

- Ensure you are assigned to an issue or bug before starting development.
- Follow naming standards for issues, pull requests (PRs), and commits.
- Feel free to ask follow-up questions if you're unsure about something!

#### ❌ Please Note: Bad Pull Requests Will Not Be Accepted!

- Changes that do not address the stated issue or bug will be rejected.
- PRs containing unnecessary indentation changes will not be accepted.
- Do not submit duplicate PRs.

---

<section align="center">

#### Contributors

<a href="https://github.com/yashchaudhari008/minime/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=yashchaudhari008/minime" />
</a>
</section>
<br />
<p align="center">Thanks for being awesome! Keep contributing. ✌</p>
