/*
 * Copyright 2018 Zhenjie Yan.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yanzhenjie.andserver.sample;

import android.app.Application;

import androidx.annotation.NonNull;

import com.yanzhenjie.andserver.util.IOUtils;

import java.io.File;

/**
 * Created by Zhenjie Yan on 2018/6/9.
 */
public class App extends Application {

    private static App mInstance;

    private File mRootDir;

    @Override
    public void onCreate() {
        super.onCreate();

        if (mInstance == null) {
            mInstance = this;
            initRootPath();
        }
    }

    @NonNull
    public static App getInstance() {
        return mInstance;
    }

    @NonNull
    public File getRootDir() {
        return mRootDir;
    }

    private void initRootPath() {
        if (mRootDir != null) {
            return;
        }

        mRootDir = new File(getFilesDir(), "AndServer");
        IOUtils.createFolder(mRootDir);
    }
}