/*
 * Copyright 2018 Zhenjie Yan
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yanzhenjie.andserver.processor.util;

/**
 * Created by Zhenjie Yan on 2018/2/6.
 */
public interface Constants {

    String DOC_EDIT_WARN = "This file was generated by AndServer automatically and you should NOT edit it.";

    String CONTEXT_TYPE = "android.content.Context";
    String LOG_TYPE = "android.util.Log";
    String TEXT_UTILS_TYPE = "android.text.TextUtils";
    String PACKAGE_NAME = "com.yanzhenjie.andserver";
    String ANDSERVER_TYPE = PACKAGE_NAME + ".AndServer";
    String TYPE_WRAPPER_TYPE = PACKAGE_NAME + ".util.TypeWrapper";
    String MEDIA_TYPE = PACKAGE_NAME + ".util.MediaType";
    String ON_REGISTER_TYPE = PACKAGE_NAME + ".register.OnRegister";
    String REGISTER_TYPE = PACKAGE_NAME + ".register.Register";

    String BODY_MISSING = PACKAGE_NAME + ".error.BodyMissingException";
    String COOKIE_MISSING = PACKAGE_NAME + ".error.CookieMissingException";
    String PARAM_MISSING = PACKAGE_NAME + ".error.ParamMissingException";
    String HEADER_MISSING = PACKAGE_NAME + ".error.HeaderMissingException";
    String PATH_MISSING = PACKAGE_NAME + ".error.PathMissingException";
    String PARAM_ERROR = PACKAGE_NAME + ".error.ParamValidateException";

    String ADAPTER_TYPE = PACKAGE_NAME + ".framework.handler.HandlerAdapter";
    String MAPPING_ADAPTER_TYPE = PACKAGE_NAME + ".framework.handler.MappingAdapter";
    String HANDLER_TYPE = PACKAGE_NAME + ".framework.handler.RequestHandler";
    String MAPPING_HANDLER_TYPE = PACKAGE_NAME + ".framework.handler.MappingHandler";
    String VIEW_TYPE = PACKAGE_NAME + ".framework.view.View";
    String VIEW_TYPE_OBJECT = PACKAGE_NAME + ".framework.view.ObjectView";
    String CONVERTER_TYPE = PACKAGE_NAME + ".framework.MessageConverter";
    String RESOLVER_TYPE = PACKAGE_NAME + ".framework.ExceptionResolver";
    String INTERCEPTOR_TYPE = PACKAGE_NAME + ".framework.HandlerInterceptor";
    String WEBSITE_TYPE = PACKAGE_NAME + ".framework.website.Website";
    String CONFIG_TYPE = PACKAGE_NAME + ".framework.config.WebConfig";
    String CONFIG_DELEGATE_TYPE = PACKAGE_NAME + ".framework.config.Delegate";
    String CONFIG_MULTIPART_TYPE = PACKAGE_NAME + ".framework.config.Multipart";

    String REQUEST_TYPE = PACKAGE_NAME + ".http.HttpRequest";
    String MULTIPART_REQUEST_TYPE = PACKAGE_NAME + ".http.multipart.MultipartRequest";
    String RESPONSE_TYPE = PACKAGE_NAME + ".http.HttpResponse";
    String HTTP_METHOD_TYPE = PACKAGE_NAME + ".http.HttpMethod";
    String HTTP_HEADERS_TYPE = PACKAGE_NAME + ".http.HttpHeaders";
    String SESSION_TYPE = PACKAGE_NAME + ".http.session.Session";
    String REQUEST_BODY_TYPE = PACKAGE_NAME + ".http.RequestBody";
    String MULTIPART_FILE_TYPE = PACKAGE_NAME + ".http.multipart.MultipartFile";

    String ADDITION_TYPE = PACKAGE_NAME + ".framework.mapping.Addition";
    String CROSS_ORIGIN_TYPE = PACKAGE_NAME + ".framework.cross.CrossOrigin";
    String MAPPING_TYPE = PACKAGE_NAME + ".framework.mapping.Mapping";
    String MIME_MAPPING_TYPE = PACKAGE_NAME + ".framework.mapping.Mime";
    String METHOD_MAPPING_TYPE = PACKAGE_NAME + ".framework.mapping.Method";
    String PAIR_MAPPING_TYPE = PACKAGE_NAME + ".framework.mapping.Pair";
    String PATH_MAPPING_TYPE = PACKAGE_NAME + ".framework.mapping.Path";
}