﻿package ptolemy
{
	public class Maths
	{
		
		public static const phi:Number = 1.6180339887;
		
		public static const toRadians:Number = Math.PI/180;
		public static const toDegrees:Number = 180/Math.PI;
		
		public static const root3:Number = Math.sqrt(3);
		public static const root3over2:Number = root3/2;
		public static const root3over3:Number = root3/3;
		
		public static const root2:Number = Math.SQRT2;
		public static const root2over2:Number = root2/2;
		
		public static const pi:Number = Math.PI;
		
		public static const sin30:Number = 0.5;
		public static const cos30:Number = root3over2;
		public static const tan30:Number = root3over3;
		public static const sin60:Number = root3over2;
		public static const cos60:Number = 0.5;
		public static const tan60:Number = root3;
		public static const sin45:Number = root2over2;
		public static const cos45:Number = root2over2;
		public static const tan45:Number = 1;
		
		public static function mod(a:Number, n:Number):Number
		{
			var i:Number;
			
			while (a<0) { a += n; }
			i = a % n;
			return i;
		}
		
		public static function normal(x:Number, mean:Number = 0, variance:Number = 1):Number
		{
			var coefficient:Number = 1/Math.sqrt(variance*2*Math.PI);
			var power:Number = -((x-mean)*(x-mean))/(2*variance);
			return coefficient * Math.pow(Math.E,power);
		}
		
		public static function sum(values:Array):Number
		{
			var i:int;
			var n:Number;
			
			n = 0;
			for (i=0;i<values.length;i++) { n += values[i]; }
			return n;
		}
		
		public static function range(values:Array):Number
		{
			var arr:Array = values.sort(Array.NUMERIC | Array.DESCENDING);
			return arr[0] - arr[arr.length-1];
		}
		
		public static function standardDeviation(values:Array):Number
		{
			var i:int;
			var mean:Number;
			var difference:Number;
			var differences:Number;
		
			mean = 0;
			for (i=0;i<values.length;i++) { mean += values[i]; }
			mean /= values.length;
			
			differences = 0;
			for (i=0;i<values.length;i++) 
			{
				difference = values[i] - mean;
				difference *= difference;
				differences += difference;
			}
			
			if (differences==0) return 0;
			return Math.sqrt(differences);
		}
		
		public static function hypotenuse(x:Number,y:Number):Number
		{
			return Math.sqrt(x*x+y*y);
		}
		
	}
}