﻿package playerio{
	/**
	 * Class that describes a room instance. Instances of this class is returned by client.multiplayer.listRooms requests 
	 * @see Multiplayer.listRooms
	 * 
	 */
	public interface RoomInfo{
		/**
		 * The id of the room.
		 * @return String id
		 * 
		 */
		function get id():String;
		/**
		 * The server type.
		 * @return String serverType
		 * 
		 */
		function get serverType():String;
		/**
		 * The room type.
		 * @return String roomType
		 * 
		 */
		function get roomType():String;
		/**
		 * How many users are online in this room.
		 * @return int onlineUsers
		 * 
		 */
		function get onlineUsers():int;
		/**
		 * Data object for the room. These are values that can be defined when the room is created. These values can also be changed on the server.
		 * @return Object data
		 * @see Multiplayer.createRoom#data
		 */
		function get data():Object;
		/**
		 * Returns a formatted overview of the room.
		 * @return String info
		 * 
		 */
		function toString():String;
	}
}