﻿package playerio{
	import flash.display.Stage;
	/**
	 * Used to authenticate users towards 3rd party user bases.
	 * 
	 * This class must be accessed via PlayerIO.quickConnect
	 */
	public class QuickConnect{
		private var _proxy:Function
		/**
		 * @private 
		 */		
		function QuickConnect(proxy:Function){
			_proxy = proxy;
		}
		/**
		 * Authenticate a user towards the Player.IO simple user database
		 * @param stage A reference to the base stage of your project.
		 * @param gameid Unique ID that identifies which game the client will try to connect to
		 * @param usernameOrEmail Username or email of the user you wish to authenticate
		 * @param password Password of the user you wish to authenticate
		 * @param callback Function executed on successful connect: function(client:Client):void{...}
		 * @param errorhandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * @example Example of how to connect to Player.IO using simpleConnect
		 * <listing version="3.0">
		 * PlayerIO.quickConnect.simpleConnect(stage, "[game-id]", "Username", "Password", function(client:Client):void{
		 * 		trace("Connected", client);																					  
		 * },function(e:PlayerIOError):void{
		 * 		trace("Got", e)
		 * });
		 * </listing>
		 */
		public function simpleConnect(stage:Stage, gameid:String, usernameOrEmail:String, password:String, callback:Function=null, errorhandler:Function=null):void{
			_proxy("quickConnect.simpleConnect", arguments);
		}
		/**
		 * Creates a user in the Player.IO simple user database 
		 * @param stage A reference to the base stage of your project.
		 * @param gameid Unique ID that identifies which game the client will try to connect to
		 * @param username Username of the user you wish to create
		 * @param password Password of the user you wish to create
		 * @param email Email of the user you wish to create (This field can be optional)(
		 * @param captchaKey Used if CAPTCHA is enabled. This value is the key returned from simpleGetCaptcha
		 * @param captchaValue Used if CAPTCHA is enabled. Should be what the users sees on the CAPTCHA image.
		 * @param extraData Extra data attached to the user on creation
		 * @param partnerId String that identifies a possible affiliate partner.
		 * @param callback Function executed on successful connect: function(client:Client):void{...}
		 * @param errorhandler Function executed if the request failed: function(error:PlayerIORegistrationError):void{...}
		 * 
		 */
		public function simpleRegister(stage:Stage, gameid:String, username:String, password:String, email:String, captchaKey:String="", captchaValue:String="", extraData:Object = null, partnerId:String = "", callback:Function=null, errorhandler:Function=null):void{
			_proxy("quickConnect.simpleRegister", arguments);
		}
		/**
		 * 
		 * @param gameId Unique ID that identifies which game the client will try to connect to
		 * @param width the width of the generated CAPTCHA
		 * @param height the height of the generated CAPTCHA
		 * @param callback Function executed when a CAPTCHA has been successfully generated: function(captchaKey:String, captchaImageUrl:String):void{...}
		 * @param errorHandler Function executed if the request failed: function(error:PlayerIORegistrationError):void{...}
		 * 
		 */
		public function simpleGetCaptcha(gameId:String, width:int, height:int, callback:Function=null, errorHandler:Function=null):void{
			_proxy("quickConnect.simpleGetCaptcha", arguments);
		}
		/**
		 * Sends an recover password email to a user stored using the Player.IO simple user database. 
		 * @param gameId Unique ID that identifies which game the client will try to connect to
		 * @param usernameOrEmail Username or email of the user that wishes to recover their passsword
		 * @param callback Function executed on successful sending of recover email: function():void{...}
		 * @param errorHandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		public function simpleRecoverPassword(gameId:String, usernameOrEmail:String, callback:Function=null, errorHandler:Function=null):void{
			_proxy("quickConnect.simpleRecoverPassword", arguments);
		}
		/**
		 * Authenticate a user towards Kongreate
		 * @see http://www.kongregate.com/developer_center/docs/authentication-web-service-api
		 * To use this feature Kongreate must be enabled under QuickConnect in the admin pannel.
		 * @param stage A reference to the base stage of your project.
		 * @param gameid Unique ID that identifies which game the client will try to connect to
		 * @param userid Kongregate userid
		 * @param gameauthtoken Kongreate gameauthtoken
		 * @param callback Function executed on successful connect: function(client:Client):void{...}
		 * @param errorhandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		public function kongregateConnect(stage:Stage, gameid:String, userid:String, gameauthtoken:String, callback:Function=null, errorhandler:Function=null):void{
			_proxy("quickConnect.kongregateConnect", arguments);
		}
		/**
		 * Authenticate a user towards Facebook 
		 * @see http://www.adobe.com/devnet/facebook/
		 * To use this feature Facebook must be enabled under QuickConnect in the admin pannel.
		 * @param stage A reference to the base stage of your project.
		 * @param gameId Unique ID that identifies which game the client will try to connect to
		 * @param uid Faceboook userid of the user you wish to authenticate.
		 * @param sessionKey Session key of the user you wish to authenticate
		 * @param partnerId String that identifies a possible affiliate partner.
		 * @param callback Function executed on successful connect: function(client:Client):void{...}
		 * @param errorHandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		public function facebookConnect(stage:Stage,gameId:String, uid:String, sessionKey:String, partnerId:String = "", callback:Function=null, errorHandler:Function=null):void{
			_proxy("quickConnect.facebookConnect", arguments);
		}
		
		/**
		 * Connects the user to Player.IO via Facebook, by opening a Facebook login window where the user can enter his Facebook credentials to login to your game. 
		 * @param stage A reference to the base stage of your project.
		 * @param gameId Unique ID that identifies which game the client will try to connect to
		 * @param window The browser window or HTML frame in which to display the document indicated by the request parameter. You can enter the name of a specific window or use one of the following values: _self, _blank, _parent, _top 
		 * @param permissions What extended facebook permissions do you want access to? see: http://developers.facebook.com/docs/authentication/permissions for more info
		 * @param partnerId String that identifies a possible affiliate partner.
		 * @param callback Function executed on successful connect: function(client:Client, api_key:String, uid:String, session_key:String, secret:String):void{...}
		 * @param errorHandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		public function facebookConnectPopup(stage:Stage, gameId:String, window:String, permissions:Array, partnerId:String = "", callback:Function=null, errorHandler:Function=null):void{
			_proxy("quickConnect.facebookConnectPopup", arguments);
		}
		
		/**
		 * 
		 * @param stage A reference to the base stage of your project.
		 * @param gameId Unique ID that identifies which game the client will try to connect to
		 * @param accessToken Facebook OAuth access token
		 * @param callback Function executed on successful connect: function(client:Client, facebookuserid:String):void{...}
		 * @param errorHandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */		
		public function facebookOAuthConnect(stage:Stage, gameId:String, accessToken:String, partnerId:String = "", callback:Function=null, errorHandler:Function=null):void{
			_proxy("quickConnect.facebookOAuthConnect", arguments);
		}
		
		/**
		 * 
		 * @param stage A reference to the base stage of your project.
		 * @param gameId Unique ID that identifies which game the client will try to connect to
		 * @param window The browser window or HTML frame in which to display the document indicated by the request parameter. You can enter the name of a specific window or use one of the following values: _self, _blank, _parent, _top
		 * @param permissions What extended facebook permissions do you want access to? see: http://developers.facebook.com/docs/authentication/permissions for more info
		 * @param partnerId String that identifies a possible affiliate partner.
		 * @param callback Function executed on successful connect: function(client:Client, access_token:String, facebookuserid:String):void{...}
		 * @param errorHandler Function executed if the request failed: function(error:PlayerIOError):void{...}
 		 * @example Using facebookOAuthConnectPopup to connect to Player.IO
		 * <listing version="3.0">
		 * PlayerIO.quickConnect.facebookOAuthConnectPopup(stage, "[YOUR-GAME-ID]", "_blank", [], function(client:Client, access_token:String, facebookuserid:String):void{
		 * 		trace("Connected", client, access_token, facebookuserid);																					  
		 * },function(e:PlayerIOError):void{
		 * 		trace("Got", e)
		 * });
		 * </listing>		 
		 */		
		public function facebookOAuthConnectPopup(stage:Stage, gameId:String, window:String, permissions:Array, partnerId:String = "", callback:Function=null, errorHandler:Function=null):void{
			_proxy("quickConnect.facebookOAuthConnectPopup", arguments);
		}
		
	}	
}