﻿package playerio{
	/**
	 * Entry in the users pay vault history 
	 * 
	 */
	public class PayVaultHistoryEntry{
		/**
		 * The amount of coins in the entry 
		 * @return the amount of coins in the entry
		 * 
		 */
		public function get amount():int{return 0;}
		/**
		 * The type of the entry: 'credit', 'debit','use'.... 
		 * @return the type of entry as a string
		 * 
		 */
		public function get type():String{return "";}
		/**
		 * The timestamp of the event
		 * @return timestamp of the event 
		 * 
		 */
		public function get timestamp():Date{return new Date();}
		/**
		 * The item keys relating to the entry
		 * @return the key relating to the entry
		 * 
		 */
		public function get itemKeys():Array{return [];}
		/**
		 * The user-specified reason for creating the entry (used by debit/credit)
		 * @return option reason attached to the transaction
		 * 
		 */
		public function get reason():String{return "";}
		/**
		 * The provider transaction id relating to this entry
		 * @return transaction if of the entry
		 * 
		 */
		public function get providerTransactionId():String{return "";}
		/**
		 * The price paid by the user as a formatted currency string (e.g, $20.00 USD) 
		 * @return the price paid by the user as formatted currency string
		 * 
		 */
		public function get providerPrice():String{return "";}
	}
}