﻿package playerio{
	/**
	 * Provides access to the PartnerPay services provided by Player.IO.
	 * 
	 */
	public interface PartnerPay{
		/**
		 * Triggers a PartnerPay action
		 * @key The key of the action to trigger
		 * @count The number of actions to trigger, default should be 1
		 * @param callback Function executed if the request is successful: function():void{...}
		 * @param errorhandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		function trigger(key:String, count:uint, callback:Function=null, errorHandler:Function=null):void
		/**
		 * Sets (or changes) the partner id of the connected user
		 * @partnerId String that identifies a possible affiliate partner.
		 * @param callback Function executed if the request is successful: function():void{...}
		 * @param errorhandler Function executed if the request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		function setTag(partnerId:String, callback:Function=null, errorHandler:Function=null):void
		/**
		 * Get the current partner
		 * @return A string identifying the partner
		 * 
		 */
		function get currentPartner():String
		
	}	
}

