﻿package playerio{
	/**
	 * Provides access to the Multiplayer services provided by Player.IO.
	 * 
	 */
	public interface Multiplayer{
		/**
		 * Creates a room of the specified server type.
		 * @param roomId The id of the room, if set to null the room is assigned a random id
		 * @param roomType The type of room we should start
		 * @param visible If the room should be returned when doing a listRooms request
		 * @param roomData Init data, this init data can be read by server: {Name:"MyRoom", Level:3}
		 * @param callback Method executed when the createRoom call executed successfully, returns the id of the created room: function(roomId:String):void{...}
		 * @param errorHandler Method executed if the joinRoom request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		function createRoom(roomId:String, roomType:String, visible:Boolean, roomData:Object, callback:Function=null, errorHandler:Function=null):void;
		/**
		 * Creates or joins a room of the specified server type.
		 * @param roomId The id of the room, if set to null the room is assigned a random id
		 * @param roomType The type of room we should start
		 * @param visible If the room should be returned when doing a listRooms request
		 * @param roomData Init data, this init data can be read on by server: {Name:"MyRoom", Level:3}
		 * @param joinData User join data, this join data can be read by the server: {Name:"Chris", Type:"Sniper"}
		 * @param callback Method executed when the createJoinRoom call executed successfully: function(connection:Connection):void{...}
		 * @param errorHandler Method executed if the createJoinRoom request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		function createJoinRoom(roomId:String, roomType:String, visible:Boolean, roomData:Object, joinData:Object, callback:Function=null, errorHandler:Function=null):void		
		/**
		 * Joins an already existing room 
		 * @param roomId The id of the room we wish to join
		 * @param joinData User join data, this join data can be read by the server: {Name:"Chris", Type:"Sniper"}
		 * @param callback Method executed when the joinRoom call executed successfully: function(connection:Connection):void{...}
		 * @param errorHandler Method executed if the joinRoom request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		function joinRoom(roomId:String, joinData:Object, callback:Function=null, errorHandler:Function=null):void;
		/**
		 * List all room instances of a specific server type 
		 * @param roomType The type of room we should list
		 * @param searchCriteria Compares the properties of the parsed object to properties on the roomData object and returns only perfect matches. Passing the object {level:"3"} returns only rooms which have level defined as 3 on the roomData object. To use search criteria you must first define what properties are searchable under the Multiplayer menu option for your game.
		 * @param resultLimit How many room instances should we load from the server
		 * @param resultOffset At what offset should we list from
		 * @param callback Method executed when the listRooms call executed successfully: function(rooms:Array&#60;RoomInfo&#62;):void{...}
		 * @param errorHandler Method executed if the listRooms request failed: function(error:PlayerIOError):void{...}
		 * 
		 */
		function listRooms(roomType:String, searchCriteria:Object, resultLimit:int, resultOffset:int, callback:Function=null, errorHandler:Function=null):void
		/**
		 * If defined the system will connect to a local development server instead of a live server.
		 * @param serverPort formatted as [server]:[port]
		 * @example The following example connects to a development server running on localhost on port 8184
		 * <listing version="3.0">
		 * client.multiplayer.developmentServer = "127.0.0.1:8184";
		 * </listing>
		 */
		function set developmentServer(serverPort:String):void;
		/**
		 * If defined the system will connect to a local development server instead of a live server.
		 * @param serverPort formatted as [server]:[port]
		 * @example The following example connects to a development server running on localhost on port 8184
		 * <listing version="3.0">
		 * client.multiplayer.developmentServer = "127.0.0.1:8184";
		 * </listing>
		 */
		 function get developmentServer():String;
	}	
}

