﻿package playerio{
	/**
	 * Allows developers to access files stores in GameFS 
	 */
	public interface GameFS{
		/**
		 * Get a url of a specific file 
		 * @param The absolute path to the file you wish to load.
		 * @return 
		 * 
		 * @example Example of how to request the file game.swf from your games GameFS via PlayerIO
		 * <listing version="3.0">
		 * 	var url:String = PlayerIO.gameFS("game-id").getURL("game.swf")
		 * </listing>
		 * 
		 * @example Example of how to request the file game.swf from your games GameFS via client
		 * <listing version="3.0">
		 * 	var url:String = client.gameFS.getURL("game.swf")
		 * </listing>
		 */
		function getURL(path:String):String;
	}	
}
