﻿package playerio{
	/**
	 * Allows the client to connect to the Multiplayer servers
	 * 
	 */
	public interface Connection{
		/**
		 * Add listener for messages of a specified type 
		 * @param type String that defines what type to listen to. If sat to "*" the listener will listen to all message types
		 * @param handler Callback method executed when a message of the type specified is recived: function(m:Message):void{...} or function(m:Message, messageValye1:Type, messageValye1:Typ, ... ):void{...} 
		 * @example Shows how to define a message listener
		 * <listing version="3.0">
		 * connection.addMessageHandler("move", function(m:Message):void{
		 * 	trace("Moved to", m.getInt(0), m.getInt(1))
		 * })
		 * </listing> 
		 * 
		 * @example Shows how to define a message listener with inline arguments
		 * <listing version="3.0">
		 * connection.addMessageHandler("move", function(m:Message, x:int, y:int):void{
		 * 	trace("Moved to", x, y)
		 * })
		 * </listing>
		 */
		function addMessageHandler(type:String, handler:Function):void
		/**
		 * Removes a message handler previously attached with addMessageHandler 
		 * @param type String that defines what type we wish to stop listening to
		 * @param handler Callback we wish to remove the listener for
		 * 
		 */
		function removeMessageHandler(type:String, handler:Function):void
		/**
		 * Listen to server disconnects. This method is only called if we are disconnected by the server. A call to connection.disconnect will not trigger this method. 
		 * @param handler Callback to execute if disconnected from the server.
		 * 
		 */
		function addDisconnectHandler(handler:Function):void
		/**
		 * Removes a handler previously attached with addDisconnectHandler 
		 * @param handler Callback we wish to remove the listener for.
		 * 
		 */
		function removeDisconnectHandler(handler:Function):void
		/**
		 * Returns the connection's connected status
		 * @return Boolean that shows if we are connected to the server
		 * 
		 */
		function get connected():Boolean
		/**
		 * Creates a Message instance 
		 * @param type The type of the message
		 * @param args Data entries we should add to the message when we create it
		 * @return A Message instance
		 * 
		 */
		function createMessage(type:String, ...args:Array):Message
		/**
		 * Quick way to send messages to the server
		 * @param type The type of the message we want to send
		 * @param args Data entries that should be added to the message
		 * 
		 */
		function send(type:String, ...args:Array ):void
		/**
		 * Sends a message to the server
		 * @param message Message to send to the server
		 * 
		 */
		function sendMessage(message:Message):void
		/**
		 * Disconnects from the server 
		 * 
		 */
		function disconnect():void
	}	
}

