﻿package playerio{
	import flash.display.Stage;
	/**
	 * An instance of this class is returned to the callback function when successfully connecting to the PlayerIO webservice.
	 * Contains references to all APIs currently exposed by the PlayerIO ActionScript API 
	 * 
	 * @see PlayerIO#connect PlayerIO.connect
	 * 
	 */	
	public interface Client{
		/**
		 * User id of the currently connected user 
		 * @return The userid of the user.
		 * 
		 */
		function get connectUserId():String;
		/**
		 * Collection used to access the PartnerPay service. 
		 * @return An instance of PartnerPay
		 * 
		 */
		function get partnerPay():PartnerPay;
		/**
		 * Collection used to access the PayVault service. 
		 * @return An instance of PayVault
		 * 
		 */
		function get payVault():PayVault;
		/**
		 * Collection used to access the GameFS service. 
		 * @return An instance of GameFS
		 * 
		 */
		function get gameFS():GameFS;
		/**
		 * Collection used to access the BigDB service.  
		 * @return An instance of BigDB
		 * @example Example of how to request the file game.swf from your games GameFS via client
		 * <listing version="3.0">
		 * 	var url:String = client.gameFS.getURL("game.swf")
		 * </listing>
		 */
		function get bigDB():BigDB;
		/**
		 * Collection used to access the Error log
		 * @return An instance of ErrorLog
		 * 
		 */
		function get errorLog():ErrorLog;
		/**
		 * Collection used for Multiplayer games
		 * @return An instance of Multiplayer
		 * 
		 */
		function get multiplayer():Multiplayer;
		/**
		 * Reference to the stage the Client is connected to
		 * @return An instance of Stage
		 * 
		 */
		 function get stage():Stage;
	}	
}

