﻿/****
	Hi guys, I am an API wrapper class!
	Copyright (C)2008 Odpy ApS
	
	Please do not change this file.
****/
package Nonoba.api{
	import flash.system.Security
	import flash.display.Loader
	import flash.net.URLRequest
	import flash.events.Event
	import flash.events.IOErrorEvent
	import flash.display.Stage
	import flash.display.LoaderInfo
	import flash.display.StageAlign
	import flash.display.Graphics
	import flash.display.Sprite
	import flash.display.StageScaleMode
	import Nonoba.api.Connection
	public class NonobaAPI {
		public static const SUCCESS:String = "success";
		public static const NOT_LOGGED_IN:String = "user not logged in";
		public static const ERROR:String = "error";
		
		private static var isInited:Boolean = false;
		private static var loading:Boolean = false;
		private static var cachedRequests:Array = [];
		private static var api:Object; 
		private static var failed:Boolean = false
		private static var connection:Connection
		private static var loaderObject:Sprite
		private static var server:String
		private static var port:Number

		function NonobaAPI(){
			throw new Error("You cannot create an instance of the NonobaAPI class!")
		}
		
				
		public static function Login(stage:Stage, callback:Function):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR)
				return
			}

			//Depending on state login or cache call
			if(api.content && api.content.SubmitScore){
				api.content.Login(stage,callback)
			}else{
				cachedRequests.push(function():void{ Login(stage,callback) })
			}
		}
		
		public static function ShowShop(stage:Stage, item:String, callback:Function):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR, false)
				return
			}

			//Depending on state submit score or cache call
			if(api.content && api.content.SubmitScore){
				api.content.ShowShop(stage,item,callback)
			}else{
				cachedRequests.push(function():void{ ShowShop(stage,item,callback) })
			}
		}

		public static function GetShopItemKeys(stage:Stage, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR, null)
				return
			}

			//Depending on state submit score or cache call
			if(api.content && api.content.SubmitScore){
				api.content.GetShopItemKeys(stage,callback)
			}else{
				cachedRequests.push(function():void{ GetShopItemKeys(stage,callback) })
			}
		}

		public static function HasShopItem(stage:Stage, key:*, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR, false,null)
				return
			}

			//Depending on state submit score or cache call
			if(api.content && api.content.SubmitScore){
				api.content.HasShopItem(stage,key,callback)
			}else{
				cachedRequests.push(function():void{ HasShopItem(stage,key,callback) })
			}
		}		

		public static function SubmitScore(stage:Stage, key:String, score:Number, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR)
				return
			}

			//Depending on state submit score or cache call
			if(api.content && api.content.SubmitScore){
				api.content.SubmitScore(stage,key,score,callback)
			}else{
				cachedRequests.push(function():void{ SubmitScore(stage,key,score,callback) })
			}

		}
			
		public static function AwardAchievement(stage:Stage, key:String, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR,0)
				return
			}
			
			//Depending on state award achievement or cache call
			if(api.content && api.content.AwardAchievement){
				api.content.AwardAchievement(stage,key,callback)
			}else{
				cachedRequests.push(function():void{ AwardAchievement(stage,key,callback) })
			}
		}
		
		public static function SetUserData(stage:Stage, key:String, value:String, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR)
				return
			}
			
			//Depending on state award achievement or cache call
			if(api.content && api.content.SetUserData){
				api.content.SetUserData(stage,key,value,callback)
			}else{
				cachedRequests.push(function():void{ SetUserData(stage,key,value,callback) })
			}
		}
		
		public static function GetUserData(stage:Stage, key:String, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR)
				return
			}
			
			//Depending on state award achievement or cache call
			if(api.content && api.content.GetUserData){
				api.content.GetUserData(stage,key,callback)
			}else{
				cachedRequests.push(function():void{ GetUserData(stage,key,callback) })
			}
		}
		
		public static function GetUsername(stage:Stage, callback:Function = null):void{
			if(!isInited)init(stage)

			//Return error if API has entered ERROR state
			if(failed){
				if(callback != null)callback(ERROR,"")
				return
			}
			
			//Depending on state award achievement or cache call
			if(api.content && api.content.GetUsername){
				api.content.GetUsername(stage,callback)
			}else{
				cachedRequests.push(function():void{ GetUsername(stage,callback) })
			}
		}
		
		public static function DisableChat(m:String):void{
			if(!isInited)return
			//Depending on state disable chat
			if(api.content && api.content.DisableChat){
				api.content.DisableChat(m)
			}else{
				cachedRequests.push(function():void{ DisableChat(m) })
			}
		}
		public static function EnableChat():void{
			if(!isInited)return
			
			//Depending on state disable chat
			if(api.content && api.content.EnableChat){
				api.content.EnableChat()
			}else{
				cachedRequests.push(function():void{ EnableChat() })
			}
		}
		
		public static function AddChildToChat(s:Sprite):void{
			if(!isInited)return
			//Depending on state disable chat
			if(api.content && api.content.AddChildToChat){
				api.content.AddChildToChat(s)
			}else{
				cachedRequests.push(function():void{ AddChildToChat(s) })
			}
		}
		
		public static function MakeMultiplayer(stage:Stage, s:String = "localhost", p:Number = 8184):Connection{
			if(isInited) throw new Error("You cannot initalize the game as multiplayer more than once, nor initalize the API after any other API requests.")
			
			server = s
			port = p
			
			stage.align = StageAlign.TOP_LEFT
			stage.scaleMode = StageScaleMode.NO_SCALE
			
			loaderObject = new Sprite()
			stage.addChild(loaderObject)
			stage.addEventListener(Event.ENTER_FRAME, handleLoad)			
			drawLoader(stage, 0);
			
			var parms:Object = LoaderInfo(stage.root.loaderInfo).parameters
			
			loadAPI(stage, parms.nonoba$apicodeas3mp || "http://nonoba.com/M/SWF/apias3mp.swf")
			stage.addChild(api as Loader)
			connection = new Connection();
			return connection
		}
		

		// Helper Methods
		private static function handleLoad(e:Event):void{
			var parms:LoaderInfo = api.loaderInfo
			var apiState:LoaderInfo = api.contentLoaderInfo
			drawLoader(e.target as Stage, ( ( parms.bytesLoaded + apiState.bytesLoaded )  / ( parms.bytesTotal + apiState.bytesTotal ) ) / 3 )
		}
		
		private static function drawLoader(stage:Stage, p:Number):void{
			var hc:int = stage.stageWidth / 2
			var vc:int = stage.stageHeight / 2
			var g:Graphics = loaderObject.graphics
			g.clear()
			g.beginFill(0xFFFFFF)
			g.drawRect(0,0,hc*2,vc*2)
			g.lineStyle(0,0x555555,1)
			g.beginFill(0xAAAAAA)
			g.drawRect(hc-100, vc-5, 200,10)
			g.beginFill(0xFFFFFF)
			g.drawRect(hc-100, vc-5, 200*p,10)
		}

		private static function init(stage:Stage):void{
			var parms:Object = LoaderInfo(stage.root.loaderInfo).parameters
			loadAPI(stage,parms.nonoba$apicodeas3 || "RemoteNonobaAPI.swf" )
		}
		
		private static function loadAPI(stage:Stage, p:String):void{
			isInited = true
			
			//Do we know where to load the api from?
			if(!p){
				enterErrorState()
				return
			}
			//Important to get callbacks to work
			Security.allowDomain("*");
			Security.allowInsecureDomain("*");
			
			//Load the external API
			api = new Loader()
			var request:URLRequest = new URLRequest(p);

			//Attach Listeners
			api.contentLoaderInfo.addEventListener(Event.COMPLETE, handleLoadCompleate)
			api.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, enterErrorState)
			api.load(request)
			
			stage.addChild(api as Loader)
		}
		
		
		private static function handleLoadCompleate(e:Event):void{
			emptyQueue()
			if(loaderObject != null){
				api.parent.removeEventListener(Event.ENTER_FRAME, handleLoad)
				api.content.ContinueLoad(loaderObject,connection,server,port);
			}
		}
		
		private static function emptyQueue():void{

			//Execute all elements in the queue
			for( var i:int=0;i<cachedRequests.length;i++){
				cachedRequests[i]();
			}
			
			//Reset queue
			cachedRequests = [];
		}
		
		//Handle errors
		private static function enterErrorState(e:Event = null):void{
			failed = true;
			emptyQueue()
		}
	}	
}