﻿ /*
	Nonoba Multiplayer API Message Class
	Copyright (C)2008 Odpy ApS
	Please do not modify this class
*/
package Nonoba.api{
	import flash.utils.ByteArray
	import Nonoba.api.Message
	public class Message {
		private var content:Array = [];
		public var Type:String;
		function Message(type:String, ...args:*){
			this.Type = type
			for(var a:int=0;a<args.length;a++)
				add(args[a])
		}
		
		/* Data setters */
		public function Add(...args:*):void{
			for(var a:int=0;a<args.length;a++)
				add(args[a])
		}

		/* Data Getters */
		public function GetNumber(index:int):Number{
			return parseFloat(content[index])		
		}
		public function GetInt(index:int):int{
			return parseInt(content[index])		
		}
		public function GetString(index:int):String{
			return content[index].toString();
		}
		public function GetBoolean(index:int):Boolean{
			return content[index] as Boolean
		}
		public function GetByteArray(index:int):ByteArray{
			return content[index] as ByteArray
		}
		
		public function Clone(to:Object):void{
			for( var a:int=0;a<content.length;a++){
				to.Add(content[a])
			}
		}

		/* Misc */
		public function get length():int{
			return content.length;
		}
		
		public function toString():String{
			var ret:String = "Nonoba.api.Message\n"
			ret += "Type:\t\t" + Type + "\n"
			ret += "Length:\t\t" + length + "\n"
			ret += "Content:\tId\tType\t\tValue\n"
			ret += "\t\t\t---------------------\n"
			for( var a:int=0;a<content.length;a++){
				var ce:* = content[a]
				if(ce === undefined){
					ret += "\t\t\t"+a+"\tundefined\t\t" + ce + "\n"
				}else if(ce is String){
					ret += "\t\t\t"+a+"\tString\t\t" + ce + "\n"
				}else if(ce is Boolean){
					ret += "\t\t\t"+a+"\tBoolean\t\t" + ce + "\n"
				}else{ 					
					var ta:ByteArray = new ByteArray();
					ta.writeInt(ce)
					ta.position = 0
					if(ta.readInt() === ce){
						ret += "\t\t\t"+a+"\tInt\t\t\t" + ce + "\n"
						continue;
					}
					ret += "\t\t\t"+a+"\tNumber\t\t" + ce + "\n"
				}
			}
			return ret
		}
		
		/*Helper methods*/
		private function add(o:*):void{
			if(o is Number || o is Boolean || o is String || o is ByteArray){
				content.push(o)
			}else{
				throw new Error(typeof o + " is not yet supported")
			}
		}
	}
}