/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.cpd;

import com.adobe.ac.pmd.files.IMxmlFile;
import com.adobe.ac.pmd.files.impl.AbstractFlexFile;
import com.adobe.ac.pmd.files.impl.FileUtils;
import com.adobe.ac.pmd.parser.KeyWords;
import com.adobe.ac.pmd.parser.Operators;
import de.bokelberg.flex.parser.AS3Scanner;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;

public class FlexTokenizer
implements Tokenizer {
    public static final int DEFAULT_MINIMUM_TOKENS = 25;
    private static final Set<String> IGNORED_TOKENS = new HashSet<String>();
    private static final Set<String> IGNORING_LINE_TOKENS;

    private static boolean isTokenIgnored(String tokenText) {
        return IGNORED_TOKENS.contains(tokenText) || tokenText.startsWith("/*") || tokenText.startsWith("//");
    }

    private static boolean isTokenIgnoringLine(String tokenText) {
        return IGNORING_LINE_TOKENS.contains(tokenText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenize(SourceCode tokens, Tokens tokenEntries) {
        try {
            AS3Scanner scanner = this.initializeScanner(tokens);
            AS3Scanner.Token currentToken = scanner.moveToNextToken();
            int inImportLine = 0;
            while (currentToken != null && currentToken.getText().compareTo(KeyWords.EOF.toString()) != 0) {
                String currentTokenText = currentToken.getText();
                int currentTokenLine = currentToken.getLine();
                if (!FlexTokenizer.isTokenIgnored(currentTokenText)) {
                    if (FlexTokenizer.isTokenIgnoringLine(currentTokenText)) {
                        inImportLine = currentTokenLine;
                    } else if (inImportLine == 0 || inImportLine != currentTokenLine) {
                        inImportLine = 0;
                        tokenEntries.add(new TokenEntry(currentTokenText, tokens.getFileName(), currentTokenLine));
                    }
                }
                currentToken = scanner.moveToNextToken();
            }
        }
        catch (Exception exception) {
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }

    private AS3Scanner initializeScanner(SourceCode tokens) {
        AS3Scanner scanner = new AS3Scanner();
        AbstractFlexFile flexFile = FileUtils.create((File)new File(tokens.getFileName()), (File)new File(""));
        if (flexFile instanceof IMxmlFile) {
            IMxmlFile mxml = (IMxmlFile)flexFile;
            scanner.setLines(mxml.getScriptBlock());
        } else {
            scanner.setLines(tokens.getCode().toArray(new String[tokens.getCode().size()]));
        }
        return scanner;
    }

    static {
        IGNORED_TOKENS.add(Operators.SEMI_COLUMN.toString());
        IGNORED_TOKENS.add(Operators.LEFT_CURLY_BRACKET.toString());
        IGNORED_TOKENS.add(Operators.RIGHT_CURLY_BRACKET.toString());
        IGNORED_TOKENS.add("\n");
        IGNORING_LINE_TOKENS = new HashSet<String>();
        IGNORING_LINE_TOKENS.add(KeyWords.IMPORT.toString());
        IGNORING_LINE_TOKENS.add(KeyWords.PACKAGE.toString());
    }
}

