/*
 * Decompiled with CFR 0.152.
 */
package de.bokelberg.flex.parser;

import com.adobe.ac.utils.StackTraceUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AS3Scanner {
    private static final String END = "__END__";
    private static final Logger LOGGER = Logger.getLogger(AS3Scanner.class.getName());
    private int column;
    private boolean inVector;
    private int line;
    private String[] lines = null;

    protected static boolean isDecimalChar(char currentCharacter) {
        return currentCharacter >= '0' && currentCharacter <= '9';
    }

    public Token moveToNextToken() {
        return this.nextToken();
    }

    public void setLines(String[] linesToBeSet) {
        this.lines = linesToBeSet;
        this.line = 0;
        this.column = -1;
    }

    boolean isHexChar(char currentCharacter) {
        boolean isNum = currentCharacter >= '0' && currentCharacter <= '9';
        boolean isLower = currentCharacter >= 'A' && currentCharacter <= 'Z';
        boolean isUpper = currentCharacter >= 'a' && currentCharacter <= 'z';
        return isNum || isLower || isUpper;
    }

    protected Token nextToken() {
        if (this.lines == null || this.line >= this.lines.length) {
            return new Token(END, this.line, this.column);
        }
        char currentCharacter = this.nextNonWhitespaceCharacter();
        if (currentCharacter == '\n') {
            return new Token("\n", this.line, this.column);
        }
        if (currentCharacter == '/') {
            return this.scanCommentRegExpOrOperator();
        }
        if (currentCharacter == '\"') {
            return this.scanString(currentCharacter);
        }
        if (currentCharacter == '\'') {
            return this.scanString(currentCharacter);
        }
        if (currentCharacter == '<') {
            return this.scanXMLOrOperator(currentCharacter);
        }
        if (currentCharacter >= '0' && currentCharacter <= '9' || currentCharacter == '.') {
            return this.scanNumberOrDots(currentCharacter);
        }
        if (currentCharacter == '{' || currentCharacter == '}' || currentCharacter == '(' || currentCharacter == ')' || currentCharacter == '[' || currentCharacter == ']' || currentCharacter == ';' || currentCharacter == ',' || currentCharacter == '?' || currentCharacter == '~') {
            return this.scanSingleCharacterToken(currentCharacter);
        }
        if (currentCharacter == ':') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"::"});
        }
        if (currentCharacter == '*') {
            return this.scanCharacterSequence(currentCharacter, new String[0]);
        }
        if (currentCharacter == '+') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"++", "+="});
        }
        if (currentCharacter == '-') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"--", "-="});
        }
        if (currentCharacter == '%') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"%="});
        }
        if (currentCharacter == '&') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"&&", "&="});
        }
        if (currentCharacter == '|') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"||", "|="});
        }
        if (currentCharacter == '^') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"^="});
        }
        if (currentCharacter == '>') {
            if (this.inVector) {
                this.inVector = false;
            } else {
                return this.scanCharacterSequence(currentCharacter, new String[]{">>>=", ">>>", ">>=", ">>", ">="});
            }
        }
        if (currentCharacter == '=') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"===", "=="});
        }
        if (currentCharacter == '!') {
            return this.scanCharacterSequence(currentCharacter, new String[]{"!==", "!="});
        }
        return this.scanWord(currentCharacter);
    }

    private int computePossibleMatchesMaxLength(String[] possibleMatches) {
        int max = 0;
        for (String possibleMatch : possibleMatches) {
            max = Math.max(max, possibleMatch.length());
        }
        return max;
    }

    private char getPreviousCharacter() {
        char currentChar;
        int currentIndex = -1;
        while ((currentChar = this.peekChar(currentIndex--)) == ' ') {
        }
        return currentChar;
    }

    private boolean isIdentifierCharacter(char currentCharacter) {
        return currentCharacter >= 'A' && currentCharacter <= 'Z' || currentCharacter >= 'a' && currentCharacter <= 'z' || currentCharacter >= '0' && currentCharacter <= '9' || currentCharacter == '_' || currentCharacter == '$';
    }

    private boolean isProcessingInstruction(String text) {
        return text.startsWith("<?");
    }

    private boolean isValidRegExp(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException t) {
            return false;
        }
        return true;
    }

    private boolean isValidXML(String text) {
        return XMLVerifier.verify(text);
    }

    private char nextChar() {
        String currentLine = this.lines[this.line];
        ++this.column;
        if (currentLine.length() <= this.column) {
            this.column = -1;
            ++this.line;
            return '\n';
        }
        char currentChar = currentLine.charAt(this.column);
        while (currentChar == '\ufeff') {
            ++this.column;
            currentChar = currentLine.charAt(this.column);
        }
        return currentChar;
    }

    private char nextNonWhitespaceCharacter() {
        char result;
        while ((result = this.nextChar()) == ' ' || result == '\t') {
        }
        return result;
    }

    private char peekChar(int offset) {
        String currentLine = this.lines[this.line];
        int index = this.column + offset;
        if (index == -1) {
            return '\u0000';
        }
        if (index >= currentLine.length()) {
            return '\n';
        }
        return currentLine.charAt(index);
    }

    private Token scanCharacterSequence(char currentCharacter, String[] possibleMatches) {
        int peekPos = 1;
        StringBuffer buffer = new StringBuffer();
        int maxLength = this.computePossibleMatchesMaxLength(possibleMatches);
        buffer.append(currentCharacter);
        String found = buffer.toString();
        while (peekPos < maxLength) {
            buffer.append(this.peekChar(peekPos));
            ++peekPos;
            for (String possibleMatche : possibleMatches) {
                if (!buffer.toString().equals(possibleMatche)) continue;
                found = buffer.toString();
            }
        }
        Token result = new Token(found, this.line, this.column);
        this.skipChars(found.length() - 1);
        return result;
    }

    private Token scanCommentRegExpOrOperator() {
        Token result;
        char firstCharacter = this.peekChar(1);
        if (firstCharacter == '/') {
            return this.scanSingleLineComment();
        }
        if (firstCharacter == '*') {
            return this.scanMultiLineComment();
        }
        if ((this.getPreviousCharacter() == '=' || this.getPreviousCharacter() == '(' || this.getPreviousCharacter() == ',') && (result = this.scanRegExp()) != null) {
            return result;
        }
        if (firstCharacter == '=') {
            result = new Token("/=", this.line, this.column);
            this.skipChars(1);
            return result;
        }
        result = new Token("/", this.line, this.column);
        return result;
    }

    private Token scanDecimal(char currentCharacter) {
        char currentChar = currentCharacter;
        StringBuffer buffer = new StringBuffer();
        int peekPos = 1;
        while (AS3Scanner.isDecimalChar(currentChar)) {
            buffer.append(currentChar);
            currentChar = this.peekChar(peekPos++);
        }
        if (currentChar == '.') {
            buffer.append(currentChar);
            currentChar = this.peekChar(peekPos++);
            while (AS3Scanner.isDecimalChar(currentChar)) {
                buffer.append(currentChar);
                currentChar = this.peekChar(peekPos++);
            }
            if (currentChar == 'E') {
                buffer.append(currentChar);
                currentChar = this.peekChar(peekPos++);
                while (AS3Scanner.isDecimalChar(currentChar)) {
                    buffer.append(currentChar);
                    currentChar = this.peekChar(peekPos++);
                }
            }
        }
        Token result = new Token(buffer.toString(), this.line, this.column, true);
        this.skipChars(result.text.length() - 1);
        return result;
    }

    private Token scanDots() {
        char secondCharacter = this.peekChar(1);
        if (secondCharacter == '.') {
            char thirdCharacter = this.peekChar(2);
            String text = thirdCharacter == '.' ? "..." : "..";
            Token result = new Token(text, this.line, this.column);
            this.skipChars(text.length() - 1);
            return result;
        }
        if (secondCharacter == '<') {
            Token result = new Token(".<", this.line, this.column);
            this.skipChars(1);
            this.inVector = true;
            return result;
        }
        return null;
    }

    private Token scanHex() {
        char character;
        StringBuffer buffer = new StringBuffer();
        buffer.append("0x");
        int peekPos = 2;
        while (this.isHexChar(character = this.peekChar(peekPos++))) {
            buffer.append(character);
        }
        Token result = new Token(buffer.toString(), this.line, this.column, true);
        this.skipChars(result.text.length() - 1);
        return result;
    }

    private Token scanMultiLineComment() {
        StringBuffer buffer = new StringBuffer();
        char currentCharacter = ' ';
        char previousCharacter = ' ';
        buffer.append("/*");
        this.skipChar();
        do {
            previousCharacter = currentCharacter;
            currentCharacter = this.nextChar();
            buffer.append(currentCharacter);
        } while (currentCharacter != '\u0000' && (currentCharacter != 47 || previousCharacter != 42));
        return new Token(buffer.toString(), this.line, this.column);
    }

    private Token scanNumberOrDots(char characterToBeScanned) {
        char firstCharacter;
        if (characterToBeScanned == '.') {
            Token result = this.scanDots();
            if (result != null) {
                return result;
            }
            char firstCharacter2 = this.peekChar(1);
            if (!AS3Scanner.isDecimalChar(firstCharacter2)) {
                return new Token(".", this.line, this.column);
            }
        }
        if (characterToBeScanned == '0' && (firstCharacter = this.peekChar(1)) == 'x') {
            return this.scanHex();
        }
        return this.scanDecimal(characterToBeScanned);
    }

    private Token scanRegExp() {
        Token token = this.scanUntilDelimiter('/');
        if (token != null && this.isValidRegExp(token.text)) {
            return token;
        }
        return null;
    }

    private Token scanSingleCharacterToken(char character) {
        return new Token(String.valueOf(character), this.line, this.column);
    }

    private Token scanSingleLineComment() {
        Token result = new Token(this.lines[this.line].substring(this.column), this.line, this.column);
        this.skipChars(result.text.length() - 1);
        return result;
    }

    private Token scanString(char startingCharacter) {
        return this.scanUntilDelimiter(startingCharacter);
    }

    private Token scanUntilDelimiter(char delimiter) {
        return this.scanUntilDelimiter(delimiter, delimiter);
    }

    private Token scanUntilDelimiter(char start, char delimiter) {
        StringBuffer buffer = new StringBuffer();
        int peekPos = 1;
        int numberOfBackslashes = 0;
        buffer.append(start);
        char currentCharacter;
        while ((currentCharacter = this.peekChar(peekPos++)) != '\n') {
            buffer.append(currentCharacter);
            if (currentCharacter == delimiter && numberOfBackslashes == 0) {
                Token result = Token.create(buffer.toString(), this.line, this.column);
                this.skipChars(buffer.toString().length() - 1);
                return result;
            }
            numberOfBackslashes = currentCharacter == '\\' ? (numberOfBackslashes + 1) % 2 : 0;
        }
        return null;
    }

    private Token scanWord(char startingCharacter) {
        char currentChar = startingCharacter;
        StringBuffer buffer = new StringBuffer();
        buffer.append(currentChar);
        int peekPos = 1;
        while (this.isIdentifierCharacter(currentChar = this.peekChar(peekPos++))) {
            buffer.append(currentChar);
        }
        Token result = new Token(buffer.toString(), this.line, this.column);
        this.skipChars(buffer.toString().length() - 1);
        return result;
    }

    private Token scanXML() {
        int currentLine = this.line;
        int currentColumn = this.column;
        int level = 0;
        StringBuffer buffer = new StringBuffer();
        char currentCharacter = '<';
        block0: while (true) {
            Token currentToken = null;
            do {
                if ((currentToken = this.scanUntilDelimiter('<', '>')) == null) {
                    this.line = currentLine;
                    this.column = currentColumn;
                    return null;
                }
                buffer.append(currentToken.text);
                if (!this.isProcessingInstruction(currentToken.text)) continue;
                currentCharacter = this.nextChar();
                if (currentCharacter == '\n') {
                    buffer.append('\n');
                    this.skipChar();
                }
                currentToken = null;
            } while (currentToken == null);
            if (currentToken.text.startsWith("</")) {
                --level;
            } else if (!currentToken.text.endsWith("/>")) {
                ++level;
            }
            if (level <= 0) {
                return new Token(buffer.toString(), this.line, this.column);
            }
            while (true) {
                if ((currentCharacter = (char)this.nextChar()) == '<') continue block0;
                buffer.append(currentCharacter);
            }
            break;
        }
    }

    private Token scanXMLOrOperator(char startingCharacterc) {
        Token xmlToken = this.scanXML();
        if (xmlToken != null && this.isValidXML(xmlToken.text)) {
            return xmlToken;
        }
        return this.scanCharacterSequence(startingCharacterc, new String[]{"<<<=", "<<<", "<<=", "<<", "<="});
    }

    private void skipChar() {
        this.nextChar();
    }

    private void skipChars(int count) {
        int decrementCount = count;
        while (decrementCount-- > 0) {
            this.nextChar();
        }
    }

    private static class XMLVerifier {
        private static DefaultHandler handler;
        private static SAXParser saxParser;

        private XMLVerifier() {
        }

        public static boolean verify(String text) {
            try {
                saxParser.parse(new InputSource(new StringReader(text)), handler);
                return true;
            }
            catch (SAXException e) {
                LOGGER.warning(StackTraceUtils.print((Exception)e));
                return false;
            }
            catch (IOException e) {
                LOGGER.warning(StackTraceUtils.print((Exception)e));
                return false;
            }
        }

        static {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            handler = new DefaultHandler();
            factory.setNamespaceAware(false);
            try {
                saxParser = factory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                LOGGER.warning(StackTraceUtils.print((Exception)e));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public static final class Token {
        private final int column;
        private final boolean isNumeric;
        private final int line;
        private final String text;

        private static Token create(String textContent, int tokenLine, int tokenColumn) {
            return new Token(textContent, tokenLine, tokenColumn);
        }

        protected Token(String textContent, int tokenLine, int tokenColumn) {
            this(textContent, tokenLine, tokenColumn, false);
        }

        protected Token(String textContent, int tokenLine, int tokenColumn, boolean isNumToSet) {
            this.text = textContent;
            this.line = tokenLine + 1;
            this.column = tokenColumn + 1;
            this.isNumeric = isNumToSet;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        public String getText() {
            return this.text;
        }

        public boolean isNum() {
            return this.isNumeric;
        }
    }
}

