/*
 * Decompiled with CFR 0.152.
 */
package de.bokelberg.flex.parser;

import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import de.bokelberg.flex.parser.NestedNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Node
extends NestedNode
implements IParserNode {
    private final int column;
    private final int line;
    private final String stringValue;

    protected static Node create(NodeKind idToBeSet, int lineToBeSet, int columnToBeSet) {
        return new Node(idToBeSet, lineToBeSet, columnToBeSet);
    }

    protected static Node create(NodeKind idToBeSet, int lineToBeSet, int columnToBeSet, IParserNode childToBeSet) {
        return new Node(idToBeSet, lineToBeSet, columnToBeSet, childToBeSet);
    }

    protected static Node create(NodeKind idToBeSet, int lineToBeSet, int columnToBeSet, String valueToBeSet) {
        return new Node(idToBeSet, lineToBeSet, columnToBeSet, valueToBeSet);
    }

    private static boolean isNameInArray(String[] strings, String string) {
        for (String currentName : strings) {
            if (!currentName.equals(string)) continue;
            return true;
        }
        return false;
    }

    private Node(NodeKind idToBeSet, int lineToBeSet, int columnToBeSet) {
        super(idToBeSet);
        this.line = lineToBeSet;
        this.column = columnToBeSet;
        this.stringValue = null;
    }

    private Node(NodeKind idToBeSet, int lineToBeSet, int columnToBeSet, IParserNode childToBeSet) {
        super(idToBeSet, childToBeSet);
        this.line = lineToBeSet;
        this.column = columnToBeSet;
        this.stringValue = null;
    }

    private Node(NodeKind idToBeSet, int lineToBeSet, int columnToBeSet, String valueToBeSet) {
        super(idToBeSet);
        this.line = lineToBeSet;
        this.column = columnToBeSet;
        this.stringValue = valueToBeSet;
    }

    public List<IParserNode> findPrimaryStatementsFromNameInChildren(String[] names) {
        ArrayList<IParserNode> foundNode = new ArrayList<IParserNode>();
        if (this.getStringValue() != null && Node.isNameInArray(names, this.getStringValue())) {
            foundNode.add(this);
        } else if (this.numChildren() != 0) {
            for (IParserNode child : this.getChildren()) {
                foundNode.addAll(child.findPrimaryStatementsFromNameInChildren(names));
            }
        }
        return foundNode;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getStringValue() == null) {
            buffer.append(this.getId());
        } else {
            buffer.append(this.getStringValue());
        }
        buffer.append(' ');
        if (this.getChildren() != null) {
            for (IParserNode child : this.getChildren()) {
                buffer.append(child.toString());
                buffer.append(' ');
            }
        }
        return buffer.toString();
    }
}

