/*
 * Decompiled with CFR 0.152.
 */
package de.bokelberg.flex.parser;

import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import de.bokelberg.flex.parser.Node;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NestedNode {
    private List<IParserNode> children;
    private NodeKind nodeId;

    protected NestedNode(NodeKind idToBeSet) {
        this.nodeId = idToBeSet;
    }

    protected NestedNode(NodeKind idToBeSet, IParserNode childToBeSet) {
        this(idToBeSet);
        this.addChild(childToBeSet);
    }

    public final int computeCyclomaticComplexity() {
        int cyclomaticComplexity = 0;
        if (this.is(NodeKind.FOREACH) || this.is(NodeKind.FORIN) || this.is(NodeKind.CASE) || this.is(NodeKind.DEFAULT)) {
            ++cyclomaticComplexity;
        } else if (this.is(NodeKind.IF) || this.is(NodeKind.WHILE) || this.is(NodeKind.FOR)) {
            ++cyclomaticComplexity;
            cyclomaticComplexity += this.getChild(0).countNodeFromType(NodeKind.AND);
            cyclomaticComplexity += this.getChild(0).countNodeFromType(NodeKind.OR);
        }
        if (this.numChildren() > 0) {
            for (IParserNode child : this.getChildren()) {
                cyclomaticComplexity += child.computeCyclomaticComplexity();
            }
        }
        return cyclomaticComplexity;
    }

    public final int countNodeFromType(NodeKind type) {
        int count = 0;
        if (this.is(type)) {
            ++count;
        }
        if (this.numChildren() > 0) {
            for (IParserNode child : this.getChildren()) {
                count += child.countNodeFromType(type);
            }
        }
        return count;
    }

    public final IParserNode getChild(int index) {
        return this.getChildren() == null || this.getChildren().size() <= index ? null : this.getChildren().get(index);
    }

    public List<IParserNode> getChildren() {
        return this.children;
    }

    public NodeKind getId() {
        return this.nodeId;
    }

    public IParserNode getLastChild() {
        IParserNode lastChild = this.getChild(this.numChildren() - 1);
        return lastChild != null && lastChild.numChildren() > 0 ? lastChild.getLastChild() : lastChild;
    }

    public final boolean is(NodeKind expectedType) {
        return this.getId() == null && expectedType == null || this.getId().equals((Object)expectedType);
    }

    public final int numChildren() {
        return this.getChildren() == null ? 0 : this.getChildren().size();
    }

    final IParserNode addChild(IParserNode child) {
        if (child == null) {
            return child;
        }
        if (this.children == null) {
            this.children = new ArrayList<IParserNode>();
        }
        this.children.add(child);
        return child;
    }

    final IParserNode addChild(NodeKind childId, int childLine, int childColumn, IParserNode nephew) {
        return this.addChild(Node.create(childId, childLine, childColumn, nephew));
    }

    final IParserNode addChild(NodeKind childId, int childLine, int childColumn, String value) {
        return this.addChild(Node.create(childId, childLine, childColumn, value));
    }

    final void setId(NodeKind idToBeSet) {
        this.nodeId = idToBeSet;
    }
}

