/*
 * Decompiled with CFR 0.152.
 */
package de.bokelberg.flex.parser;

import com.adobe.ac.pmd.files.impl.FileUtils;
import com.adobe.ac.pmd.parser.IAS3Parser;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.KeyWords;
import com.adobe.ac.pmd.parser.NodeKind;
import com.adobe.ac.pmd.parser.Operators;
import com.adobe.ac.pmd.parser.exceptions.NullTokenException;
import com.adobe.ac.pmd.parser.exceptions.TokenException;
import com.adobe.ac.pmd.parser.exceptions.UnExpectedTokenException;
import de.bokelberg.flex.parser.AS3Scanner;
import de.bokelberg.flex.parser.Node;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AS3Parser
implements IAS3Parser {
    public static final String ASDOC_COMMENT = "/**";
    public static final String MULTIPLE_LINES_COMMENT = "/*";
    public static final String NEW_LINE = "\n";
    public static final String SINGLE_LINE_COMMENT = "//";
    private static final String VECTOR = "Vector";
    private Node currentAsDoc;
    private Node currentFunctionNode;
    private Node currentMultiLineComment;
    private String fileName;
    private boolean isInFor = false;
    private AS3Scanner scn = new AS3Scanner();
    private AS3Scanner.Token tok;

    public final IParserNode buildAst(String filePath) throws IOException, TokenException {
        return this.parseLines(filePath, FileUtils.readLines((File)new File(filePath)));
    }

    public final IParserNode buildAst(String filePath, String[] scriptBlockLines) throws TokenException {
        return this.parseLines(filePath, scriptBlockLines);
    }

    final AS3Scanner getScn() {
        return this.scn;
    }

    final void nextToken() throws TokenException {
        do {
            this.nextTokenAllowNewLine();
        } while (this.tok.getText().equals(NEW_LINE));
    }

    final Node parseClassContent() throws TokenException {
        Node result = Node.create(NodeKind.CONTENT, this.tok.getLine(), this.tok.getColumn());
        ArrayList<AS3Scanner.Token> modifiers = new ArrayList<AS3Scanner.Token>();
        ArrayList<Node> meta = new ArrayList<Node>();
        while (!this.tokIs(Operators.RIGHT_CURLY_BRACKET)) {
            if (this.tokIs(Operators.LEFT_CURLY_BRACKET)) {
                result.addChild(this.parseBlock());
            }
            if (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
                meta.add(this.parseMetaData());
                continue;
            }
            if (this.tokIs(KeyWords.VAR)) {
                this.parseClassField(result, modifiers, meta);
                continue;
            }
            if (this.tokIs(KeyWords.CONST)) {
                this.parseClassConstant(result, modifiers, meta);
                continue;
            }
            if (this.tokIs(KeyWords.IMPORT)) {
                result.addChild(this.parseImport());
                continue;
            }
            if (this.tokIs(KeyWords.FUNCTION)) {
                this.parseClassFunctions(result, modifiers, meta);
                continue;
            }
            this.tryToParseCommentNode(result, modifiers);
        }
        return result;
    }

    final Node parseCompilationUnit() throws TokenException {
        Node result = Node.create(NodeKind.COMPILATION_UNIT, -1, -1);
        this.nextTokenIgnoringDocumentation();
        if (this.tokIs(KeyWords.PACKAGE)) {
            result.addChild(this.parsePackage());
        }
        result.addChild(this.parsePackageContent());
        return result;
    }

    final IParserNode parseExpression() throws TokenException {
        return this.parseAssignmentExpression();
    }

    final Node parseInterfaceContent() throws TokenException {
        Node result = Node.create(NodeKind.CONTENT, this.tok.getLine(), this.tok.getColumn());
        while (!this.tokIs(Operators.RIGHT_CURLY_BRACKET)) {
            if (this.tokIs(KeyWords.IMPORT)) {
                result.addChild(this.parseImport());
                continue;
            }
            if (this.tokIs(KeyWords.FUNCTION)) {
                result.addChild(this.parseFunctionSignature());
                continue;
            }
            if (this.tokIs(KeyWords.INCLUDE)) {
                result.addChild(this.parseIncludeExpression());
                continue;
            }
            if (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
                while (!this.tokIs(Operators.RIGHT_SQUARE_BRACKET)) {
                    this.nextToken();
                }
                this.nextToken();
                continue;
            }
            this.tryToParseCommentNode(result, null);
        }
        return result;
    }

    final Node parsePackageContent() throws TokenException {
        Node result = Node.create(NodeKind.CONTENT, this.tok.getLine(), this.tok.getColumn());
        ArrayList<AS3Scanner.Token> modifiers = new ArrayList<AS3Scanner.Token>();
        ArrayList<Node> meta = new ArrayList<Node>();
        while (!this.tokIs(Operators.RIGHT_CURLY_BRACKET) && !this.tokIs(KeyWords.EOF)) {
            if (this.tokIs(KeyWords.IMPORT)) {
                result.addChild(this.parseImport());
                continue;
            }
            if (this.tokIs(KeyWords.USE)) {
                result.addChild(this.parseUse());
                continue;
            }
            if (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
                meta.add(this.parseMetaData());
                continue;
            }
            if (this.tokIs(KeyWords.CLASS)) {
                result.addChild(this.parseClass(meta, modifiers));
                modifiers.clear();
                meta.clear();
                continue;
            }
            if (this.tokIs(KeyWords.INTERFACE)) {
                result.addChild(this.parseInterface(meta, modifiers));
                modifiers.clear();
                meta.clear();
                continue;
            }
            if (this.tokIs(KeyWords.FUNCTION)) {
                this.parseClassFunctions(result, modifiers, meta);
                continue;
            }
            if (this.tok.getText().startsWith(ASDOC_COMMENT)) {
                this.currentAsDoc = Node.create(NodeKind.AS_DOC, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
                this.nextToken();
                continue;
            }
            if (this.tok.getText().startsWith(MULTIPLE_LINES_COMMENT)) {
                this.currentMultiLineComment = Node.create(NodeKind.MULTI_LINE_COMMENT, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
                this.nextToken();
                continue;
            }
            modifiers.add(this.tok);
            this.nextTokenIgnoringDocumentation();
        }
        return result;
    }

    final Node parsePrimaryExpression() throws TokenException {
        Node result = Node.create(NodeKind.PRIMARY, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
        if (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
            result.addChild(this.parseArrayLiteral());
        } else if (this.tokIs(Operators.LEFT_CURLY_BRACKET)) {
            result.addChild(this.parseObjectLiteral());
        } else if (this.tokIs(KeyWords.FUNCTION)) {
            result.addChild(this.parseLambdaExpression());
        } else if (this.tokIs(KeyWords.NEW)) {
            result = this.parseNewExpression();
        } else if (this.tokIs(Operators.LEFT_PARENTHESIS)) {
            result.addChild(this.parseEncapsulatedExpression());
        } else {
            this.nextToken();
        }
        return result;
    }

    final IParserNode parseStatement() throws TokenException {
        Node result;
        if (this.tokIs(KeyWords.FOR)) {
            result = this.parseFor();
        } else if (this.tokIs(KeyWords.IF)) {
            result = this.parseIf();
        } else if (this.tokIs(KeyWords.SWITCH)) {
            result = this.parseSwitch();
        } else if (this.tokIs(KeyWords.DO)) {
            result = this.parseDo();
        } else if (this.tokIs(KeyWords.WHILE)) {
            result = this.parseWhile();
        } else if (this.tokIs(KeyWords.TRY)) {
            result = this.parseTry();
        } else if (this.tokIs(KeyWords.CATCH)) {
            result = this.parseCatch();
        } else if (this.tokIs(KeyWords.FINALLY)) {
            result = this.parseFinally();
        } else if (this.tokIs(Operators.LEFT_CURLY_BRACKET)) {
            result = this.parseBlock();
        } else if (this.tokIs(KeyWords.VAR)) {
            result = this.parseVar();
        } else if (this.tokIs(KeyWords.CONST)) {
            result = this.parseConst();
        } else if (this.tokIs(KeyWords.RETURN)) {
            result = this.parseReturnStatement();
        } else if (this.tokIs(Operators.SEMI_COLUMN)) {
            result = this.parseEmptyStatement();
        } else {
            result = this.parseExpressionList();
            this.skip(Operators.SEMI_COLUMN);
        }
        return result;
    }

    final Node parseUnaryExpression() throws TokenException {
        Node result;
        if (this.tokIs(Operators.INCREMENT)) {
            this.nextToken();
            result = Node.create(NodeKind.PRE_INC, this.tok.getLine(), this.tok.getColumn(), this.parseUnaryExpression());
        } else if (this.tokIs(Operators.DECREMENT)) {
            this.nextToken();
            result = Node.create(NodeKind.PRE_DEC, this.tok.getLine(), this.tok.getColumn(), this.parseUnaryExpression());
        } else if (this.tokIs(Operators.MINUS)) {
            this.nextToken();
            result = Node.create(NodeKind.MINUS, this.tok.getLine(), this.tok.getColumn(), this.parseUnaryExpression());
        } else if (this.tokIs(Operators.PLUS)) {
            this.nextToken();
            result = Node.create(NodeKind.PLUS, this.tok.getLine(), this.tok.getColumn(), this.parseUnaryExpression());
        } else {
            result = this.parseUnaryExpressionNotPlusMinus();
        }
        return result;
    }

    private IParserNode collectVarListContent(Node result) throws TokenException {
        result.addChild(this.parseNameTypeInit());
        while (this.tokIs(Operators.COMMA)) {
            this.nextToken();
            result.addChild(this.parseNameTypeInit());
        }
        return result;
    }

    private void consume(KeyWords keyword) throws TokenException {
        this.consume(keyword.toString());
    }

    private void consume(Operators operator) throws TokenException {
        this.consume(operator.toString());
    }

    private void consume(String text) throws TokenException {
        while (this.tok.getText().startsWith(SINGLE_LINE_COMMENT)) {
            this.nextToken();
        }
        if (!this.tokIs(text)) {
            throw new UnExpectedTokenException(this.tok.getText(), new UnExpectedTokenException.Position(this.tok.getLine(), this.tok.getColumn()), this.fileName, text);
        }
        this.nextToken();
    }

    private Node convertMeta(List<Node> metadataList) {
        if (metadataList == null || metadataList.isEmpty()) {
            return null;
        }
        Node result = Node.create(NodeKind.META_LIST, this.tok.getLine(), this.tok.getColumn());
        for (Node metadataNode : metadataList) {
            result.addChild(metadataNode);
        }
        return result;
    }

    private Node convertModifiers(List<AS3Scanner.Token> modifierList) {
        if (modifierList == null) {
            return null;
        }
        Node result = Node.create(NodeKind.MOD_LIST, this.tok.getLine(), this.tok.getColumn());
        for (AS3Scanner.Token modifierToken : modifierList) {
            result.addChild(NodeKind.MODIFIER, this.tok.getLine(), this.tok.getColumn(), modifierToken.getText());
        }
        return result;
    }

    private Node[] doParseSignature() throws TokenException {
        this.consume(KeyWords.FUNCTION);
        Node type = Node.create(NodeKind.TYPE, this.tok.getLine(), this.tok.getColumn(), KeyWords.FUNCTION.toString());
        if (this.tokIs(KeyWords.SET) || this.tokIs(KeyWords.GET)) {
            type = Node.create(NodeKind.TYPE, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
            this.nextToken();
        }
        Node name = Node.create(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
        this.nextToken();
        Node params = this.parseParameterList();
        Node returnType = this.parseOptionalType();
        return new Node[]{type, name, params, returnType};
    }

    private NodeKind findFunctionTypeFromSignature(Node[] signature) {
        for (Node node : signature) {
            if (!node.is(NodeKind.TYPE)) continue;
            if (node.getStringValue().equals("set")) {
                return NodeKind.SET;
            }
            if (node.getStringValue().equals("get")) {
                return NodeKind.GET;
            }
            return NodeKind.FUNCTION;
        }
        return NodeKind.FUNCTION;
    }

    private void nextTokenAllowNewLine() throws TokenException {
        do {
            this.tok = this.scn.nextToken();
            if (this.tok == null) {
                throw new NullTokenException(this.fileName);
            }
            if (this.tok.getText() != null) continue;
            throw new NullTokenException(this.fileName);
        } while (this.tok.getText().startsWith(SINGLE_LINE_COMMENT));
    }

    private void nextTokenIgnoringDocumentation() throws TokenException {
        do {
            this.nextToken();
        } while (this.tok.getText().startsWith(MULTIPLE_LINES_COMMENT));
    }

    private IParserNode parseAdditiveExpression() throws TokenException {
        Node result = Node.create(NodeKind.ADD, this.tok.getLine(), this.tok.getColumn(), this.parseMultiplicativeExpression());
        while (this.tokIs(Operators.PLUS) || this.tokIs(Operators.MINUS)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseMultiplicativeExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private IParserNode parseAndExpression() throws TokenException {
        Node result = Node.create(NodeKind.AND, this.tok.getLine(), this.tok.getColumn(), this.parseBitwiseOrExpression());
        while (this.tokIs(Operators.AND)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseBitwiseOrExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private Node parseArgumentList() throws TokenException {
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.ARGUMENTS, this.tok.getLine(), this.tok.getColumn());
        while (!this.tokIs(Operators.RIGHT_PARENTHESIS)) {
            result.addChild(this.parseExpression());
            this.skip(Operators.COMMA);
        }
        this.consume(Operators.RIGHT_PARENTHESIS);
        return result;
    }

    private Node parseArrayAccessor(Node node) throws TokenException {
        Node result = Node.create(NodeKind.ARRAY_ACCESSOR, this.tok.getLine(), this.tok.getColumn());
        result.addChild(node);
        while (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
            this.nextToken();
            result.addChild(this.parseExpression());
            this.consume(Operators.RIGHT_SQUARE_BRACKET);
        }
        return result;
    }

    private IParserNode parseArrayLiteral() throws TokenException {
        Node result = Node.create(NodeKind.ARRAY, this.tok.getLine(), this.tok.getColumn());
        this.consume(Operators.LEFT_SQUARE_BRACKET);
        while (!this.tokIs(Operators.RIGHT_SQUARE_BRACKET)) {
            result.addChild(this.parseExpression());
            this.skip(Operators.COMMA);
        }
        this.consume(Operators.RIGHT_SQUARE_BRACKET);
        return result;
    }

    private IParserNode parseAssignmentExpression() throws TokenException {
        Node result = Node.create(NodeKind.ASSIGN, this.tok.getLine(), this.tok.getColumn(), this.parseConditionalExpression());
        while (this.tokIs(Operators.EQUAL) || this.tokIs(Operators.PLUS_EQUAL) || this.tokIs(Operators.MINUS_EQUAL) || this.tokIs(Operators.TIMES_EQUAL) || this.tokIs(Operators.DIVIDED_EQUAL) || this.tokIs(Operators.MODULO_EQUAL) || this.tokIs(Operators.AND_EQUAL) || this.tokIs(Operators.OR_EQUAL) || this.tokIs(Operators.XOR_EQUAL)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private IParserNode parseBitwiseAndExpression() throws TokenException {
        Node result = Node.create(NodeKind.B_AND, this.tok.getLine(), this.tok.getColumn(), this.parseEqualityExpression());
        while (this.tokIs(Operators.B_AND)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseEqualityExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private IParserNode parseBitwiseOrExpression() throws TokenException {
        Node result = Node.create(NodeKind.B_OR, this.tok.getLine(), this.tok.getColumn(), this.parseBitwiseXorExpression());
        while (this.tokIs(Operators.B_OR)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseBitwiseXorExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private IParserNode parseBitwiseXorExpression() throws TokenException {
        Node result = Node.create(NodeKind.B_XOR, this.tok.getLine(), this.tok.getColumn(), this.parseBitwiseAndExpression());
        while (this.tokIs(Operators.B_XOR)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseBitwiseAndExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private Node parseBlock() throws TokenException {
        return this.parseBlock(Node.create(NodeKind.BLOCK, this.tok.getLine(), this.tok.getColumn()));
    }

    private Node parseBlock(Node result) throws TokenException {
        this.consume(Operators.LEFT_CURLY_BRACKET);
        while (!this.tokIs(Operators.RIGHT_CURLY_BRACKET)) {
            if (this.tok.getText().startsWith(MULTIPLE_LINES_COMMENT)) {
                this.currentFunctionNode.addChild(Node.create(NodeKind.MULTI_LINE_COMMENT, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
                this.nextToken();
                continue;
            }
            result.addChild(this.parseStatement());
        }
        this.consume(Operators.RIGHT_CURLY_BRACKET);
        return result;
    }

    private Node parseCatch() throws TokenException {
        this.consume(KeyWords.CATCH);
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.CATCH, this.tok.getLine(), this.tok.getColumn(), Node.create(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
        this.nextToken();
        if (this.tokIs(Operators.COLUMN)) {
            this.nextToken();
            result.addChild(Node.create(NodeKind.TYPE, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
        }
        this.consume(Operators.RIGHT_PARENTHESIS);
        result.addChild(this.parseBlock());
        return result;
    }

    private Node parseClass(List<Node> meta, List<AS3Scanner.Token> modifier) throws TokenException {
        this.consume(KeyWords.CLASS);
        Node result = Node.create(NodeKind.CLASS, this.tok.getLine(), this.tok.getColumn());
        if (this.currentAsDoc != null) {
            result.addChild(this.currentAsDoc);
            this.currentAsDoc = null;
        }
        if (this.currentMultiLineComment != null) {
            result.addChild(this.currentMultiLineComment);
            this.currentMultiLineComment = null;
        }
        result.addChild(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
        this.nextToken();
        result.addChild(this.convertMeta(meta));
        result.addChild(this.convertModifiers(modifier));
        do {
            if (this.tokIs(KeyWords.EXTENDS)) {
                this.nextToken();
                result.addChild(NodeKind.EXTENDS, this.tok.getLine(), this.tok.getColumn(), this.parseQualifiedName());
                continue;
            }
            if (!this.tokIs(KeyWords.IMPLEMENTS)) continue;
            result.addChild(this.parseImplementsList());
        } while (!this.tokIs(Operators.LEFT_CURLY_BRACKET));
        this.consume(Operators.LEFT_CURLY_BRACKET);
        result.addChild(this.parseClassContent());
        this.consume(Operators.RIGHT_CURLY_BRACKET);
        return result;
    }

    private void parseClassConstant(Node result, List<AS3Scanner.Token> modifiers, List<Node> meta) throws TokenException {
        result.addChild(this.parseConstList(meta, modifiers));
        if (this.tokIs(Operators.SEMI_COLUMN)) {
            this.nextToken();
        }
        meta.clear();
        modifiers.clear();
    }

    private void parseClassField(Node result, List<AS3Scanner.Token> modifiers, List<Node> meta) throws TokenException {
        Node varList = this.parseVarList(meta, modifiers);
        result.addChild(varList);
        if (this.currentAsDoc != null) {
            varList.addChild(this.currentAsDoc);
            this.currentAsDoc = null;
        }
        if (this.currentMultiLineComment != null) {
            result.addChild(this.currentMultiLineComment);
            this.currentMultiLineComment = null;
        }
        if (this.tokIs(Operators.SEMI_COLUMN)) {
            this.nextToken();
        }
        meta.clear();
        modifiers.clear();
    }

    private void parseClassFunctions(Node result, List<AS3Scanner.Token> modifiers, List<Node> meta) throws TokenException {
        result.addChild(this.parseFunction(meta, modifiers));
        meta.clear();
        modifiers.clear();
    }

    private Node parseCondition() throws TokenException {
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.CONDITION, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        this.consume(Operators.RIGHT_PARENTHESIS);
        return result;
    }

    private IParserNode parseConditionalExpression() throws TokenException {
        IParserNode result = this.parseOrExpression();
        if (this.tokIs(Operators.QUESTION_MARK)) {
            Node conditional = Node.create(NodeKind.CONDITIONAL, this.tok.getLine(), this.tok.getColumn(), result);
            this.nextToken();
            conditional.addChild(this.parseExpression());
            this.nextToken();
            conditional.addChild(this.parseExpression());
            return conditional;
        }
        return result;
    }

    private Node parseConst() throws TokenException {
        Node result = this.parseConstList(null, null);
        this.skip(Operators.SEMI_COLUMN);
        return result;
    }

    private Node parseConstList(List<Node> meta, List<AS3Scanner.Token> modifiers) throws TokenException {
        this.consume(KeyWords.CONST);
        Node result = Node.create(NodeKind.CONST_LIST, this.tok.getLine(), this.tok.getColumn());
        result.addChild(this.convertMeta(meta));
        result.addChild(this.convertModifiers(modifiers));
        this.collectVarListContent(result);
        return result;
    }

    private Node parseDecrement(Node node) throws TokenException {
        this.nextToken();
        Node result = Node.create(NodeKind.POST_DEC, this.tok.getLine(), this.tok.getColumn());
        result.addChild(node);
        return result;
    }

    private Node parseDo() throws TokenException {
        this.consume(KeyWords.DO);
        Node result = Node.create(NodeKind.DO, this.tok.getLine(), this.tok.getColumn(), this.parseStatement());
        this.consume(KeyWords.WHILE);
        result.addChild(this.parseCondition());
        if (this.tokIs(Operators.SEMI_COLUMN)) {
            this.nextToken();
        }
        return result;
    }

    private Node parseDot(Node node) throws TokenException {
        this.nextToken();
        if (this.tokIs(Operators.LEFT_PARENTHESIS)) {
            this.nextToken();
            Node result = Node.create(NodeKind.E4X_FILTER, this.tok.getLine(), this.tok.getColumn());
            result.addChild(node);
            result.addChild(this.parseExpression());
            this.consume(Operators.RIGHT_PARENTHESIS);
            return result;
        }
        if (this.tokIs(Operators.TIMES)) {
            Node result = Node.create(NodeKind.E4X_STAR, this.tok.getLine(), this.tok.getColumn());
            result.addChild(node);
            return result;
        }
        Node result = Node.create(NodeKind.DOT, this.tok.getLine(), this.tok.getColumn());
        result.addChild(node);
        result.addChild(this.parseExpression());
        return result;
    }

    private Node parseEmptyStatement() throws TokenException {
        Node result = Node.create(NodeKind.STMT_EMPTY, this.tok.getLine(), this.tok.getColumn(), Operators.SEMI_COLUMN.toString());
        this.nextToken();
        return result;
    }

    private Node parseEncapsulatedExpression() throws TokenException {
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.ENCAPSULATED, this.tok.getLine(), this.tok.getColumn());
        result.addChild(this.parseExpressionList());
        this.consume(Operators.RIGHT_PARENTHESIS);
        return result;
    }

    private IParserNode parseEqualityExpression() throws TokenException {
        Node result = Node.create(NodeKind.EQUALITY, this.tok.getLine(), this.tok.getColumn(), this.parseRelationalExpression());
        while (this.tokIs(Operators.DOUBLE_EQUAL) || this.tokIs(Operators.STRICTLY_EQUAL) || this.tokIs(Operators.NON_EQUAL) || this.tokIs(Operators.NON_STRICTLY_EQUAL)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseRelationalExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private IParserNode parseExpressionList() throws TokenException {
        Node result = Node.create(NodeKind.EXPR_LIST, this.tok.getLine(), this.tok.getColumn(), this.parseAssignmentExpression());
        while (this.tokIs(Operators.COMMA)) {
            this.nextToken();
            result.addChild(this.parseAssignmentExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private Node parseFinally() throws TokenException {
        this.nextToken();
        Node result = Node.create(NodeKind.FINALLY, this.tok.getLine(), this.tok.getColumn(), this.parseBlock());
        return result;
    }

    private Node parseFor() throws TokenException {
        this.consume(KeyWords.FOR);
        if (this.tokIs(KeyWords.EACH)) {
            this.nextToken();
            return this.parseForEach();
        }
        return this.parseTraditionalFor();
    }

    private Node parseForEach() throws TokenException {
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.FOREACH, this.tok.getLine(), this.tok.getColumn());
        if (this.tokIs(KeyWords.VAR)) {
            Node var = Node.create(NodeKind.VAR, this.tok.getLine(), this.tok.getColumn());
            this.nextToken();
            var.addChild(this.parseNameTypeInit());
            result.addChild(var);
        } else {
            result.addChild(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
            this.nextToken();
        }
        this.nextToken();
        result.addChild(NodeKind.IN, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        this.consume(Operators.RIGHT_PARENTHESIS);
        result.addChild(this.parseStatement());
        return result;
    }

    private Node parseForIn(Node result) throws TokenException {
        this.nextToken();
        result.addChild(NodeKind.IN, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        result.setId(NodeKind.FORIN);
        return result;
    }

    private Node parseFunction(List<Node> meta, List<AS3Scanner.Token> modifiers) throws TokenException {
        Node[] signature = this.doParseSignature();
        Node result = Node.create(this.findFunctionTypeFromSignature(signature), this.tok.getLine(), this.tok.getColumn(), signature[0].getStringValue());
        if (this.currentAsDoc != null) {
            result.addChild(this.currentAsDoc);
            this.currentAsDoc = null;
        }
        if (this.currentMultiLineComment != null) {
            result.addChild(this.currentMultiLineComment);
            this.currentMultiLineComment = null;
        }
        result.addChild(this.convertMeta(meta));
        result.addChild(this.convertModifiers(modifiers));
        result.addChild(signature[1]);
        result.addChild(signature[2]);
        result.addChild(signature[3]);
        result.addChild(this.parseFunctionBlock());
        this.currentFunctionNode = null;
        return result;
    }

    private Node parseFunctionBlock() throws TokenException {
        Node block;
        this.currentFunctionNode = block = Node.create(NodeKind.BLOCK, this.tok.getLine(), this.tok.getColumn());
        this.parseBlock(block);
        return block;
    }

    private Node parseFunctionCall(Node node) throws TokenException {
        Node result = Node.create(NodeKind.CALL, this.tok.getLine(), this.tok.getColumn());
        result.addChild(node);
        while (this.tokIs(Operators.LEFT_PARENTHESIS)) {
            result.addChild(this.parseArgumentList());
        }
        while (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
            result.addChild(this.parseArrayLiteral());
        }
        return result;
    }

    private Node parseFunctionSignature() throws TokenException {
        Node[] signature = this.doParseSignature();
        this.skip(Operators.SEMI_COLUMN);
        Node result = Node.create(this.findFunctionTypeFromSignature(signature), this.tok.getLine(), this.tok.getColumn(), signature[0].getStringValue());
        result.addChild(signature[1]);
        result.addChild(signature[2]);
        result.addChild(signature[3]);
        return result;
    }

    private Node parseIf() throws TokenException {
        this.consume(KeyWords.IF);
        Node result = Node.create(NodeKind.IF, this.tok.getLine(), this.tok.getColumn(), this.parseCondition());
        result.addChild(this.parseStatement());
        if (this.tokIs(KeyWords.ELSE)) {
            this.nextToken();
            result.addChild(this.parseStatement());
        }
        return result;
    }

    private Node parseImplementsList() throws TokenException {
        this.consume(KeyWords.IMPLEMENTS);
        Node result = Node.create(NodeKind.IMPLEMENTS_LIST, this.tok.getLine(), this.tok.getColumn());
        result.addChild(NodeKind.IMPLEMENTS, this.tok.getLine(), this.tok.getColumn(), this.parseQualifiedName());
        while (this.tokIs(Operators.COMMA)) {
            this.nextToken();
            result.addChild(NodeKind.IMPLEMENTS, this.tok.getLine(), this.tok.getColumn(), this.parseQualifiedName());
        }
        return result;
    }

    private Node parseImport() throws TokenException {
        this.consume(KeyWords.IMPORT);
        Node result = Node.create(NodeKind.IMPORT, this.tok.getLine(), this.tok.getColumn(), this.parseImportName());
        this.skip(Operators.SEMI_COLUMN);
        return result;
    }

    private String parseImportName() throws TokenException {
        StringBuffer result = new StringBuffer();
        result.append(this.tok.getText());
        this.nextToken();
        while (this.tokIs(Operators.DOT)) {
            result.append(Operators.DOT);
            this.nextToken();
            result.append(this.tok.getText());
            this.nextToken();
        }
        return result.toString();
    }

    private IParserNode parseIncludeExpression() throws TokenException {
        Node result = Node.create(NodeKind.INCLUDE, this.tok.getLine(), this.tok.getColumn());
        this.consume(KeyWords.INCLUDE);
        result.addChild(this.parseExpression());
        return result;
    }

    private Node parseIncrement(Node node) throws TokenException {
        this.nextToken();
        Node result = Node.create(NodeKind.POST_INC, this.tok.getLine(), this.tok.getColumn());
        result.addChild(node);
        return result;
    }

    private Node parseInterface(List<Node> meta, List<AS3Scanner.Token> modifier) throws TokenException {
        this.consume(KeyWords.INTERFACE);
        Node result = Node.create(NodeKind.INTERFACE, this.tok.getLine(), this.tok.getColumn());
        if (this.currentAsDoc != null) {
            result.addChild(this.currentAsDoc);
            this.currentAsDoc = null;
        }
        if (this.currentMultiLineComment != null) {
            result.addChild(this.currentMultiLineComment);
            this.currentMultiLineComment = null;
        }
        result.addChild(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
        this.nextToken();
        result.addChild(this.convertMeta(meta));
        result.addChild(this.convertModifiers(modifier));
        if (this.tokIs(KeyWords.EXTENDS)) {
            this.nextToken();
            result.addChild(NodeKind.EXTENDS, this.tok.getLine(), this.tok.getColumn(), this.parseQualifiedName());
        }
        while (this.tokIs(Operators.COMMA)) {
            this.nextToken();
            result.addChild(NodeKind.EXTENDS, this.tok.getLine(), this.tok.getColumn(), this.parseQualifiedName());
        }
        this.consume(Operators.LEFT_CURLY_BRACKET);
        result.addChild(this.parseInterfaceContent());
        this.consume(Operators.RIGHT_CURLY_BRACKET);
        return result;
    }

    private Node parseLambdaExpression() throws TokenException {
        this.consume(KeyWords.FUNCTION);
        Node result = Node.create(NodeKind.LAMBDA, this.tok.getLine(), this.tok.getColumn());
        result.addChild(this.parseParameterList());
        result.addChild(this.parseOptionalType());
        result.addChild(this.parseBlock());
        return result;
    }

    private IParserNode parseLines(String filePath, String[] lines) throws TokenException {
        this.setFileName(filePath);
        this.scn = new AS3Scanner();
        this.scn.setLines(lines);
        return this.parseCompilationUnit();
    }

    private Node parseMetaData() throws TokenException {
        StringBuffer buffer = new StringBuffer();
        int line = this.tok.getLine();
        int column = this.tok.getColumn();
        this.consume(Operators.LEFT_SQUARE_BRACKET);
        while (!this.tokIs(Operators.RIGHT_SQUARE_BRACKET)) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(this.tok.getText());
            this.nextToken();
        }
        this.skip(Operators.RIGHT_SQUARE_BRACKET);
        Node metaDataNode = Node.create(NodeKind.META, line, column, buffer.toString());
        if (this.currentAsDoc != null) {
            metaDataNode.addChild(this.currentAsDoc);
            this.currentAsDoc = null;
        }
        return metaDataNode;
    }

    private IParserNode parseMultiplicativeExpression() throws TokenException {
        Node result = Node.create(NodeKind.MULTIPLICATION, this.tok.getLine(), this.tok.getColumn(), this.parseUnaryExpression());
        while (this.tokIs(Operators.TIMES) || this.tokIs(Operators.SLASH) || this.tokIs(Operators.MODULO)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseUnaryExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private String parseNamespaceName() throws TokenException {
        String name = this.tok.getText();
        this.nextToken();
        return name;
    }

    private Node parseNameTypeInit() throws TokenException {
        Node result = Node.create(NodeKind.NAME_TYPE_INIT, this.tok.getLine(), this.tok.getColumn());
        result.addChild(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
        this.nextToken();
        result.addChild(this.parseOptionalType());
        result.addChild(this.parseOptionalInit());
        return result;
    }

    private Node parseNewExpression() throws TokenException {
        this.consume(KeyWords.NEW);
        Node result = Node.create(NodeKind.NEW, this.tok.getLine(), this.tok.getColumn());
        result.addChild(this.parseExpression());
        if (this.tokIs(Operators.LEFT_PARENTHESIS)) {
            result.addChild(this.parseArgumentList());
        }
        return result;
    }

    private Node parseObjectLiteral() throws TokenException {
        Node result = Node.create(NodeKind.OBJECT, this.tok.getLine(), this.tok.getColumn());
        this.consume(Operators.LEFT_CURLY_BRACKET);
        while (!this.tokIs(Operators.RIGHT_CURLY_BRACKET)) {
            result.addChild(this.parseObjectLiteralPropertyDeclaration());
            this.skip(Operators.COMMA);
        }
        this.consume(Operators.RIGHT_CURLY_BRACKET);
        return result;
    }

    private Node parseObjectLiteralPropertyDeclaration() throws TokenException {
        Node result = Node.create(NodeKind.PROP, this.tok.getLine(), this.tok.getColumn());
        Node name = Node.create(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
        result.addChild(name);
        this.nextToken();
        this.consume(Operators.COLUMN);
        result.addChild(NodeKind.VALUE, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        return result;
    }

    private Node parseOptionalInit() throws TokenException {
        Node result = null;
        if (this.tokIs(Operators.EQUAL)) {
            this.nextToken();
            result = Node.create(NodeKind.INIT, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        }
        return result;
    }

    private Node parseOptionalType() throws TokenException {
        Node result = Node.create(NodeKind.TYPE, this.tok.getLine(), this.tok.getColumn(), "");
        if (this.tokIs(Operators.COLUMN)) {
            this.nextToken();
            result = this.parseType();
        }
        return result;
    }

    private IParserNode parseOrExpression() throws TokenException {
        Node result = Node.create(NodeKind.OR, this.tok.getLine(), this.tok.getColumn(), this.parseAndExpression());
        while (this.tokIs(Operators.LOGICAL_OR)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseAndExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private Node parsePackage() throws TokenException {
        this.consume(KeyWords.PACKAGE);
        Node result = Node.create(NodeKind.PACKAGE, this.tok.getLine(), this.tok.getColumn());
        StringBuffer nameBuffer = new StringBuffer();
        while (!this.tokIs(Operators.LEFT_CURLY_BRACKET)) {
            nameBuffer.append(this.tok.getText());
            this.nextToken();
        }
        result.addChild(NodeKind.NAME, this.tok.getLine(), this.tok.getColumn(), nameBuffer.toString());
        this.consume(Operators.LEFT_CURLY_BRACKET);
        result.addChild(this.parsePackageContent());
        this.consume(Operators.RIGHT_CURLY_BRACKET);
        return result;
    }

    private Node parseParameter() throws TokenException {
        Node result = Node.create(NodeKind.PARAMETER, this.tok.getLine(), this.tok.getColumn());
        if (this.tokIs(Operators.REST_PARAMETERS)) {
            this.nextToken();
            Node rest = Node.create(NodeKind.REST, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
            this.nextToken();
            result.addChild(rest);
        } else {
            result.addChild(this.parseNameTypeInit());
        }
        return result;
    }

    private Node parseParameterList() throws TokenException {
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.PARAMETER_LIST, this.tok.getLine(), this.tok.getColumn());
        while (!this.tokIs(Operators.RIGHT_PARENTHESIS)) {
            result.addChild(this.parseParameter());
            if (!this.tokIs(Operators.COMMA)) break;
            this.nextToken();
        }
        this.consume(Operators.RIGHT_PARENTHESIS);
        return result;
    }

    private String parseQualifiedName() throws TokenException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tok.getText());
        this.nextToken();
        while (this.tokIs(Operators.DOT) || this.tokIs(Operators.DOUBLE_COLUMN)) {
            buffer.append(this.tok.getText());
            this.nextToken();
            buffer.append(this.tok.getText());
            this.nextToken();
        }
        return buffer.toString();
    }

    private IParserNode parseRelationalExpression() throws TokenException {
        Node result = Node.create(NodeKind.RELATION, this.tok.getLine(), this.tok.getColumn(), this.parseShiftExpression());
        while (this.tokIs(Operators.INFERIOR) || this.tokIs(Operators.INFERIOR_OR_EQUAL) || this.tokIs(Operators.SUPERIOR) || this.tokIs(Operators.SUPERIOR_OR_EQUAL) || this.tokIs(KeyWords.IS) || this.tokIs(KeyWords.IN) && !this.isInFor || this.tokIs(KeyWords.AS) || this.tokIs(KeyWords.INSTANCE_OF)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseShiftExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private IParserNode parseReturnStatement() throws TokenException {
        Node result;
        this.nextTokenAllowNewLine();
        if (this.tokIs(NEW_LINE) || this.tokIs(Operators.SEMI_COLUMN)) {
            this.nextToken();
            result = Node.create(NodeKind.RETURN, this.tok.getLine(), this.tok.getColumn(), "");
        } else {
            result = Node.create(NodeKind.RETURN, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
            this.skip(Operators.SEMI_COLUMN);
        }
        return result;
    }

    private IParserNode parseShiftExpression() throws TokenException {
        Node result = Node.create(NodeKind.SHIFT, this.tok.getLine(), this.tok.getColumn(), this.parseAdditiveExpression());
        while (this.tokIs(Operators.DOUBLE_SHIFT_LEFT) || this.tokIs(Operators.TRIPLE_SHIFT_LEFT) || this.tokIs(Operators.DOUBLE_SHIFT_RIGHT) || this.tokIs(Operators.TRIPLE_SHIFT_RIGHT)) {
            result.addChild(Node.create(NodeKind.OP, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
            result.addChild(this.parseAdditiveExpression());
        }
        return result.numChildren() > 1 ? result : result.getChild(0);
    }

    private Node parseSwitch() throws TokenException {
        this.consume(KeyWords.SWITCH);
        Node result = Node.create(NodeKind.SWITCH, this.tok.getLine(), this.tok.getColumn(), this.parseCondition());
        if (this.tokIs(Operators.LEFT_CURLY_BRACKET)) {
            this.nextToken();
            result.addChild(this.parseSwitchCases());
            this.consume(Operators.RIGHT_CURLY_BRACKET);
        }
        return result;
    }

    private Node parseSwitchBlock() throws TokenException {
        Node result = Node.create(NodeKind.SWITCH_BLOCK, this.tok.getLine(), this.tok.getColumn());
        while (!(this.tokIs(KeyWords.CASE) || this.tokIs(KeyWords.DEFAULT) || this.tokIs(Operators.RIGHT_CURLY_BRACKET))) {
            result.addChild(this.parseStatement());
        }
        return result;
    }

    private Node parseSwitchCases() throws TokenException {
        Node result = Node.create(NodeKind.CASES, this.tok.getLine(), this.tok.getColumn());
        while (!this.tokIs(Operators.RIGHT_CURLY_BRACKET)) {
            Node caseNode;
            if (this.tokIs(KeyWords.CASE)) {
                this.nextToken();
                caseNode = Node.create(NodeKind.CASE, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
                this.consume(Operators.COLUMN);
                caseNode.addChild(this.parseSwitchBlock());
                result.addChild(caseNode);
                continue;
            }
            if (!this.tokIs(KeyWords.DEFAULT)) continue;
            this.nextToken();
            this.consume(Operators.COLUMN);
            caseNode = Node.create(NodeKind.CASE, this.tok.getLine(), this.tok.getColumn(), Node.create(NodeKind.DEFAULT, this.tok.getLine(), this.tok.getColumn(), KeyWords.DEFAULT.toString()));
            caseNode.addChild(this.parseSwitchBlock());
            result.addChild(caseNode);
        }
        return result;
    }

    private Node parseTraditionalFor() throws TokenException {
        this.consume(Operators.LEFT_PARENTHESIS);
        Node result = Node.create(NodeKind.FOR, this.tok.getLine(), this.tok.getColumn());
        if (!this.tokIs(Operators.SEMI_COLUMN)) {
            if (this.tokIs(KeyWords.VAR)) {
                result.addChild(NodeKind.INIT, this.tok.getLine(), this.tok.getColumn(), this.parseVarList(null, null));
            } else {
                this.isInFor = true;
                result.addChild(NodeKind.INIT, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
                this.isInFor = false;
            }
            if (this.tokIs(NodeKind.IN.toString())) {
                return this.parseForIn(result);
            }
        }
        this.consume(Operators.SEMI_COLUMN);
        if (!this.tokIs(Operators.SEMI_COLUMN)) {
            result.addChild(NodeKind.COND, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        }
        this.consume(Operators.SEMI_COLUMN);
        if (!this.tokIs(Operators.RIGHT_PARENTHESIS)) {
            result.addChild(NodeKind.ITER, this.tok.getLine(), this.tok.getColumn(), this.parseExpressionList());
        }
        this.consume(Operators.RIGHT_PARENTHESIS);
        result.addChild(this.parseStatement());
        return result;
    }

    private Node parseTry() throws TokenException {
        this.nextToken();
        Node result = Node.create(NodeKind.TRY, this.tok.getLine(), this.tok.getColumn(), this.parseBlock());
        return result;
    }

    private Node parseType() throws TokenException {
        Node result;
        if (this.tok.getText().equals(VECTOR)) {
            result = this.parseVector();
        } else {
            result = Node.create(NodeKind.TYPE, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
            this.nextToken();
        }
        return result;
    }

    private Node parseUnaryExpressionNotPlusMinus() throws TokenException {
        Node result;
        if (this.tokIs(KeyWords.DELETE)) {
            this.nextToken();
            result = Node.create(NodeKind.DELETE, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        } else if (this.tokIs(KeyWords.VOID)) {
            this.nextToken();
            result = Node.create(NodeKind.VOID, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        } else if (this.tokIs(KeyWords.TYPEOF)) {
            this.nextToken();
            result = Node.create(NodeKind.TYPEOF, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        } else if (this.tokIs("!")) {
            this.nextToken();
            result = Node.create(NodeKind.NOT, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        } else if (this.tokIs("~")) {
            this.nextToken();
            result = Node.create(NodeKind.B_NOT, this.tok.getLine(), this.tok.getColumn(), this.parseExpression());
        } else {
            result = this.parseUnaryPostfixExpression();
        }
        return result;
    }

    private Node parseUnaryPostfixExpression() throws TokenException {
        Node node = this.parsePrimaryExpression();
        if (this.tokIs(Operators.LEFT_SQUARE_BRACKET)) {
            node = this.parseArrayAccessor(node);
        } else if (this.tokIs(Operators.LEFT_PARENTHESIS)) {
            node = this.parseFunctionCall(node);
        }
        if (this.tokIs(Operators.INCREMENT)) {
            node = this.parseIncrement(node);
        } else if (this.tokIs(Operators.DECREMENT)) {
            node = this.parseDecrement(node);
        } else if (this.tokIs(Operators.DOT) || this.tokIs(Operators.DOUBLE_COLUMN)) {
            node = this.parseDot(node);
        }
        return node;
    }

    private Node parseUse() throws TokenException {
        this.consume(KeyWords.USE);
        this.consume(KeyWords.NAMESPACE);
        Node result = Node.create(NodeKind.USE, this.tok.getLine(), this.tok.getColumn(), this.parseNamespaceName());
        this.skip(Operators.SEMI_COLUMN);
        return result;
    }

    private Node parseVar() throws TokenException {
        Node result = this.parseVarList(null, null);
        this.skip(Operators.SEMI_COLUMN);
        return result;
    }

    private Node parseVarList(List<Node> meta, List<AS3Scanner.Token> modifiers) throws TokenException {
        this.consume(KeyWords.VAR);
        Node result = Node.create(NodeKind.VAR_LIST, this.tok.getLine(), this.tok.getColumn());
        result.addChild(this.convertMeta(meta));
        result.addChild(this.convertModifiers(modifiers));
        this.collectVarListContent(result);
        return result;
    }

    private Node parseVector() throws TokenException {
        Node result = Node.create(NodeKind.VECTOR, this.tok.getLine(), this.tok.getColumn(), "");
        this.nextToken();
        this.consume(Operators.VECTOR_START);
        result.addChild(this.parseType());
        this.consume(Operators.SUPERIOR);
        return result;
    }

    private Node parseWhile() throws TokenException {
        this.consume(KeyWords.WHILE);
        Node result = Node.create(NodeKind.WHILE, this.tok.getLine(), this.tok.getColumn());
        result.addChild(this.parseCondition());
        result.addChild(this.parseStatement());
        return result;
    }

    private void setFileName(String fileNameToParse) {
        this.fileName = fileNameToParse;
    }

    private void skip(Operators operator) throws TokenException {
        this.skip(operator.toString());
    }

    private void skip(String text) throws TokenException {
        if (this.tokIs(text)) {
            this.nextToken();
        }
    }

    private boolean tokIs(KeyWords keyword) {
        return this.tok.getText().compareTo(keyword.toString()) == 0;
    }

    private boolean tokIs(Operators operator) {
        return this.tok.getText().compareTo(operator.toString()) == 0;
    }

    private boolean tokIs(String text) {
        return this.tok.getText().equals(text);
    }

    private void tryToParseCommentNode(Node result, List<AS3Scanner.Token> modifiers) throws TokenException {
        if (this.tok.getText().startsWith(ASDOC_COMMENT)) {
            this.currentAsDoc = Node.create(NodeKind.AS_DOC, this.tok.getLine(), this.tok.getColumn(), this.tok.getText());
            this.nextToken();
        } else if (this.tok.getText().startsWith(MULTIPLE_LINES_COMMENT)) {
            result.addChild(Node.create(NodeKind.MULTI_LINE_COMMENT, this.tok.getLine(), this.tok.getColumn(), this.tok.getText()));
            this.nextToken();
        } else {
            if (modifiers != null) {
                modifiers.add(this.tok);
            }
            this.nextTokenIgnoringDocumentation();
        }
    }
}

