/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.nodes.impl;

import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IIdentifierNode;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.IParameter;
import com.adobe.ac.pmd.nodes.MetaData;
import com.adobe.ac.pmd.nodes.Modifier;
import com.adobe.ac.pmd.nodes.impl.AbstractNode;
import com.adobe.ac.pmd.nodes.impl.FormalNode;
import com.adobe.ac.pmd.nodes.impl.IdentifierNode;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.KeyWords;
import com.adobe.ac.pmd.parser.NodeKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionNode
extends AbstractNode
implements IFunction {
    private IParserNode asDoc;
    private IParserNode body;
    private int cyclomaticComplexity;
    private final Map<String, IParserNode> localVariables;
    private final Map<MetaData, List<IMetaData>> metaDataList;
    private final Set<Modifier> modifiers = new HashSet<Modifier>();
    private final List<IParserNode> multiLinesComments;
    private IdentifierNode name = null;
    private final List<IParameter> parameters;
    private IIdentifierNode returnType;

    protected FunctionNode(IParserNode node) {
        super(node);
        this.metaDataList = new LinkedHashMap<MetaData, List<IMetaData>>();
        this.localVariables = new LinkedHashMap<String, IParserNode>();
        this.parameters = new ArrayList<IParameter>();
        this.multiLinesComments = new ArrayList<IParserNode>();
    }

    @Override
    public void add(IMetaData metaData) {
        MetaData metaDataImpl = MetaData.create(metaData.getName());
        if (!this.metaDataList.containsKey((Object)metaDataImpl)) {
            this.metaDataList.put(metaDataImpl, new ArrayList());
        }
        this.metaDataList.get((Object)metaDataImpl).add(metaData);
    }

    @Override
    public void add(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public FunctionNode compute() {
        if (this.getInternalNode().numChildren() != 0) {
            for (IParserNode node : this.getInternalNode().getChildren()) {
                if (node.is(NodeKind.BLOCK)) {
                    this.computeFunctionContent(node);
                    continue;
                }
                if (node.is(NodeKind.NAME)) {
                    this.name = IdentifierNode.create(node);
                    continue;
                }
                if (node.is(NodeKind.MOD_LIST)) {
                    FunctionNode.computeModifierList(this, node);
                    continue;
                }
                if (node.is(NodeKind.PARAMETER_LIST)) {
                    this.computeParameterList(node);
                    continue;
                }
                if (node.is(NodeKind.TYPE)) {
                    this.returnType = IdentifierNode.create(node);
                    continue;
                }
                if (node.is(NodeKind.META_LIST)) {
                    FunctionNode.computeMetaDataList(this, node);
                    continue;
                }
                if (!node.is(NodeKind.AS_DOC)) continue;
                this.asDoc = node;
            }
        }
        return this;
    }

    @Override
    public List<IParserNode> findPrimaryStatementInBody(String[] primaryNames) {
        return this.body == null ? null : this.body.findPrimaryStatementsFromNameInChildren(primaryNames);
    }

    @Override
    public List<IParserNode> findPrimaryStatementsInBody(String primaryName) {
        return this.body == null ? new ArrayList<IParserNode>() : this.body.findPrimaryStatementsFromNameInChildren(new String[]{primaryName});
    }

    @Override
    public List<IMetaData> getAllMetaData() {
        ArrayList<IMetaData> list = new ArrayList<IMetaData>();
        for (Map.Entry<MetaData, List<IMetaData>> entry : this.metaDataList.entrySet()) {
            list.addAll((Collection<IMetaData>)entry.getValue());
        }
        return list;
    }

    @Override
    public IParserNode getAsDoc() {
        return this.asDoc;
    }

    @Override
    public IParserNode getBody() {
        return this.body;
    }

    @Override
    public int getCyclomaticComplexity() {
        return this.cyclomaticComplexity;
    }

    @Override
    public Map<String, IParserNode> getLocalVariables() {
        return this.localVariables;
    }

    @Override
    public List<IMetaData> getMetaData(MetaData metaDataName) {
        if (this.metaDataList.containsKey((Object)metaDataName)) {
            return this.metaDataList.get((Object)metaDataName);
        }
        return new ArrayList<IMetaData>();
    }

    @Override
    public int getMetaDataCount() {
        return this.metaDataList.size();
    }

    @Override
    public List<IParserNode> getMultiLinesComment() {
        return this.multiLinesComments;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public List<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public IIdentifierNode getReturnType() {
        return this.returnType;
    }

    @Override
    public int getStatementNbInBody() {
        return 1 + this.getStatementInNode(this.body);
    }

    @Override
    public IParserNode getSuperCall() {
        if (this.body != null && this.body.numChildren() != 0) {
            for (IParserNode childContent : this.body.getChildren()) {
                if (!NodeKind.CALL.equals((Object)childContent.getId()) && !NodeKind.DOT.equals((Object)childContent.getId())) continue;
                for (IParserNode childCall : childContent.getChildren()) {
                    if (!KeyWords.SUPER.toString().equals(childCall.getStringValue())) continue;
                    return childContent;
                }
            }
        }
        return null;
    }

    @Override
    public boolean is(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    @Override
    public boolean isGetter() {
        return this.getInternalNode().is(NodeKind.GET);
    }

    @Override
    public boolean isOverriden() {
        return this.is(Modifier.OVERRIDE);
    }

    @Override
    public boolean isPublic() {
        return this.is(Modifier.PUBLIC);
    }

    @Override
    public boolean isSetter() {
        return this.getInternalNode().is(NodeKind.SET);
    }

    private void computeCyclomaticComplexity() {
        this.cyclomaticComplexity = 1 + this.body.computeCyclomaticComplexity();
    }

    private void computeFunctionContent(IParserNode functionBodyNode) {
        this.body = functionBodyNode;
        this.computeCyclomaticComplexity();
        if (this.body.numChildren() > 0) {
            for (IParserNode node : this.body.getChildren()) {
                if (!node.is(NodeKind.MULTI_LINE_COMMENT)) continue;
                this.multiLinesComments.add(node);
            }
        }
        this.computeVariableList(this.body);
    }

    private void computeParameterList(IParserNode node) {
        if (node.numChildren() != 0) {
            for (IParserNode parameterNode : node.getChildren()) {
                this.parameters.add(FormalNode.create(parameterNode));
            }
        }
    }

    private void computeVariableList(IParserNode node) {
        if (node.is(NodeKind.VAR_LIST)) {
            this.localVariables.put(node.getChild(0).getChild(0).getStringValue(), node);
        } else if (node.numChildren() > 0) {
            for (IParserNode child : node.getChildren()) {
                this.computeVariableList(child);
            }
        }
    }

    private int getStatementInNode(IParserNode node) {
        int statementNb = 0;
        if (node != null && node.numChildren() != 0) {
            int lastLine = node.getChild(0).getLine();
            for (IParserNode childContent : node.getChildren()) {
                if (childContent.getLine() != lastLine) {
                    lastLine = childContent.getLine();
                    ++statementNb;
                }
                statementNb += this.getStatementInNode(childContent);
            }
        }
        return statementNb;
    }
}

