/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.unused;

import com.adobe.ac.pmd.files.IAs3File;
import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IVariable;
import com.adobe.ac.pmd.nodes.Modifier;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedPrivateMethodRule
extends AbstractAstFlexRule {
    private Map<String, IFunction> privateFunctions = null;

    protected final void findViolations(IClass classNode) {
        this.fillPrivateFunctions(classNode.getFunctions());
        this.findUnusedFunction(classNode.getBlock());
        super.findViolations(classNode);
        this.addViolations();
    }

    protected final void findViolations(List<IFunction> functions) {
        super.findViolations(functions);
        for (IFunction function : functions) {
            this.findUnusedFunction(function.getBody());
        }
    }

    protected void findViolationsFromAttributes(List<IAttribute> variables) {
        super.findViolationsFromAttributes(variables);
        this.findViolationsFromVariables(variables);
    }

    protected void findViolationsFromConstants(List<IConstant> constants) {
        super.findViolationsFromConstants(constants);
        this.findViolationsFromVariables(constants);
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void addViolations() {
        HashSet<Integer> ignoredLines = new HashSet<Integer>();
        for (String functionName : this.privateFunctions.keySet()) {
            IFunction function = this.privateFunctions.get(functionName);
            ignoredLines.clear();
            ignoredLines.add(UnusedPrivateMethodRule.getNameFromFunctionDeclaration((IParserNode)function.getInternalNode()).getLine());
            if (!(this.getCurrentFile() instanceof IAs3File) && this.getCurrentFile().contains(functionName, ignoredLines)) continue;
            this.addViolation(function);
        }
    }

    private void fillPrivateFunctions(List<IFunction> functions) {
        this.privateFunctions = new LinkedHashMap<String, IFunction>();
        for (IFunction function : functions) {
            if (!function.is(Modifier.PRIVATE)) continue;
            this.privateFunctions.put(function.getName(), function);
        }
    }

    private void findUnusedFunction(IParserNode body) {
        if (body != null) {
            if (body.getStringValue() != null) {
                for (String functionName : this.privateFunctions.keySet()) {
                    if (!body.getStringValue().equals(functionName)) continue;
                    this.privateFunctions.remove(functionName);
                    break;
                }
            }
            if (body.numChildren() != 0) {
                for (IParserNode child : body.getChildren()) {
                    this.findUnusedFunction(child);
                }
            }
        }
    }

    private void findViolationsFromVariables(List<? extends IVariable> variables) {
        for (IVariable iVariable : variables) {
            if (iVariable.getInitializationExpression() == null) continue;
            this.findUnusedFunction(iVariable.getInitializationExpression().getInternalNode());
        }
    }
}

