/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.unused;

import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.KeyWords;
import com.adobe.ac.pmd.parser.NodeKind;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.unused.AbstractUnusedVariableRule;
import java.util.LinkedHashMap;

public class UnusedParameterRule
extends AbstractUnusedVariableRule {
    private static final String DATA_GRID_COLUMN = "DataGridColumn";
    private static final String FAULT_FUNCTION_NAME = "fault";
    private static final String RESPONDER_INTERFACE_NAME = "Responder";
    private static final String RESULT_FUNCTION_NAME = "result";
    private IParserNode currentClass;

    private static String computeFunctionName(IParserNode functionAst) {
        String functionName = "";
        for (IParserNode node : functionAst.getChildren()) {
            if (!node.is(NodeKind.NAME)) continue;
            functionName = node.getStringValue();
            break;
        }
        return functionName;
    }

    private static boolean isClassImplementingIResponder(IParserNode currentClass2) {
        for (IParserNode node : currentClass2.getChildren()) {
            if (!node.is(NodeKind.IMPLEMENTS_LIST)) continue;
            for (IParserNode implementation : node.getChildren()) {
                if (implementation.getStringValue() == null || !implementation.getStringValue().contains(RESPONDER_INTERFACE_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isResponderImplementation(IParserNode currentClass, IParserNode functionAst) {
        if (!UnusedParameterRule.isClassImplementingIResponder(currentClass)) {
            return false;
        }
        String functionName = UnusedParameterRule.computeFunctionName(functionAst);
        return RESULT_FUNCTION_NAME.compareTo(functionName) == 0 || FAULT_FUNCTION_NAME.compareTo(functionName) == 0;
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.HIGH;
    }

    protected final void visitClass(IParserNode classNode) {
        this.currentClass = classNode;
        super.visitClass(classNode);
    }

    protected final void visitFunction(IParserNode functionAst, AbstractAstFlexRule.FunctionType type) {
        this.setVariablesUnused(new LinkedHashMap<String, IParserNode>());
        boolean isOverriden = this.isFunctionOverriden(functionAst);
        if (!isOverriden && !UnusedParameterRule.isResponderImplementation(this.currentClass, functionAst)) {
            super.visitFunction(functionAst, type);
            if (!this.functionIsEventHandler(functionAst)) {
                for (String variableName : this.getVariablesUnused().keySet()) {
                    IParserNode variable = this.getVariablesUnused().get(variableName);
                    this.addViolation(variable, variable, new String[]{variableName});
                }
            }
        }
    }

    protected final void visitParameters(IParserNode ast) {
        super.visitParameters(ast);
        if (ast.numChildren() != 0) {
            for (IParserNode parameterNode : ast.getChildren()) {
                if (this.isParameterAnEvent(parameterNode) || parameterNode.numChildren() <= 0 || parameterNode.getChild(0).numChildren() <= 1 || parameterNode.getChild(0).getChild(1).getStringValue().compareTo(DATA_GRID_COLUMN) == 0) continue;
                this.addVariable(parameterNode.getChild(0).getChild(0).getStringValue(), parameterNode);
            }
        }
    }

    private String extractFunctionName(IParserNode ast) {
        if (ast.numChildren() != 0) {
            for (IParserNode node : ast.getChildren()) {
                if (!node.is(NodeKind.NAME)) continue;
                return node.getStringValue();
            }
        }
        return "";
    }

    private boolean functionIsEventHandler(IParserNode ast) {
        String functionName = this.extractFunctionName(ast);
        return functionName.startsWith("on") || functionName.startsWith("handle") || functionName.endsWith("handler");
    }

    private boolean isFunctionOverriden(IParserNode ast) {
        for (IParserNode child : ast.getChildren()) {
            if (!child.is(NodeKind.MOD_LIST)) continue;
            for (IParserNode mod : child.getChildren()) {
                if (!mod.getStringValue().equals(KeyWords.OVERRIDE.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isParameterAnEvent(IParserNode parameterNode) {
        IParserNode parameterType = UnusedParameterRule.getTypeFromFieldDeclaration((IParserNode)parameterNode);
        return parameterType != null && parameterType.getStringValue() != null && parameterType.getStringValue().contains("Event");
    }
}

