/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.style;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.core.thresholded.AbstractMaximizedFlexRule;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverLongLineRule
extends AbstractMaximizedFlexRule {
    private int currentLineLength;

    public final List<IFlexViolation> findViolationsInCurrentFile() {
        ArrayList<IFlexViolation> violations = new ArrayList<IFlexViolation>();
        if (this.isConcernedByTheCurrentFile()) {
            IFlexFile currentFile = this.getCurrentFile();
            for (int i = 1; i <= currentFile.getLinesNb(); ++i) {
                String line = currentFile.getLineAt(i);
                if (line.trim().startsWith("import") || line.length() <= this.getThreshold()) continue;
                this.currentLineLength = line.length();
                ViolationPosition position = ViolationPosition.create((int)i, (int)i, (int)0, (int)this.currentLineLength);
                this.addViolation(violations, position);
            }
        }
        return violations;
    }

    public final int getActualValueForTheCurrentViolation() {
        return this.currentLineLength;
    }

    public final int getDefaultThreshold() {
        return 120;
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.LOW;
    }

    protected boolean isConcernedByTheCurrentFile() {
        return true;
    }
}

