/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.style;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IAs3File;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.files.IMxmlFile;
import com.adobe.ac.pmd.rules.core.AbstractFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyrightMissingRule
extends AbstractFlexRule {
    public final boolean isConcernedByTheCurrentFile() {
        return true;
    }

    protected final List<IFlexViolation> findViolationsInCurrentFile() {
        ArrayList<IFlexViolation> violations = new ArrayList<IFlexViolation>();
        IFlexFile currentFile = this.getCurrentFile();
        if (currentFile.getLinesNb() == 1) {
            this.addViolation(violations);
        } else if (currentFile.getLinesNb() > 1) {
            String commentOpeningTag = currentFile.getCommentOpeningTag();
            String firstLine = currentFile.getLineAt(1);
            String secondLine = currentFile.getLineAt(2);
            if (!(firstLine.startsWith(commentOpeningTag) || currentFile instanceof IMxmlFile && secondLine.contains(commentOpeningTag) || currentFile instanceof IAs3File && firstLine.contains(currentFile.getSingleLineComment()))) {
                this.addViolation(violations);
            }
        }
        return violations;
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void addViolation(List<IFlexViolation> violations) {
        this.addViolation(violations, new ViolationPosition(-1));
    }
}

