/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.style;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;

public class BadFormatLoggerRule
extends AbstractAstFlexRule {
    private static final String CORRECT_LOGGER_NAME = "LOG";
    private static final String LOGGER_INTERFACE = "ILogger";
    private static final String MESSAGE_LOGGER_NAME_IS_NOT_LOG = "The logger name is not LOG";
    private static final String MESSAGE_NOT_INITIALIZED = "The logger is not initialized";
    private static final String MESSAGE_SHOULD_BE_CONSTANT = "A logger should be constant";

    protected final void findViolations(IClass classNode) {
        for (IAttribute field : classNode.getAttributes()) {
            if (!field.getType().toString().equals(LOGGER_INTERFACE)) continue;
            this.addViolation(field.getInternalNode(), field.getInternalNode(), new String[]{MESSAGE_SHOULD_BE_CONSTANT});
        }
        for (IAttribute field : classNode.getConstants()) {
            if (!field.getType().toString().equals(LOGGER_INTERFACE)) continue;
            if (!field.getName().equals(CORRECT_LOGGER_NAME)) {
                this.addViolation(field.getInternalNode(), field.getInternalNode(), new String[]{MESSAGE_LOGGER_NAME_IS_NOT_LOG});
            }
            if (field.getInitializationExpression() != null) continue;
            this.addViolation(field.getInternalNode(), field.getInternalNode(), new String[]{MESSAGE_NOT_INITIALIZED});
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.LOW;
    }
}

