/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.sizing;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.core.thresholded.AbstractMaximizedAstFlexRule;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooManyPublicRule
extends AbstractMaximizedAstFlexRule {
    public static final int DEFAULT_THRESHOLD = 10;
    private IFunction constructor;
    private int publicCount;

    public final int getActualValueForTheCurrentViolation() {
        return this.publicCount;
    }

    public final int getDefaultThreshold() {
        return 10;
    }

    protected final void findViolations(IClass classNode) {
        this.publicCount = 0;
        this.constructor = classNode.getConstructor();
        super.findViolations(classNode);
        if (this.publicCount > this.getThreshold()) {
            this.addViolation((INode)classNode);
        }
    }

    protected final void findViolations(IFunction function) {
        if (function.isPublic() && !function.equals(this.constructor) && !function.isGetter() && !function.isSetter()) {
            ++this.publicCount;
        }
    }

    protected final void findViolationsFromAttributes(List<IAttribute> variables) {
        for (IAttribute variable : variables) {
            if (!variable.isPublic()) continue;
            ++this.publicCount;
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }
}

