/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.sizing;

import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.nodes.utils.FunctionUtils;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.core.thresholded.AbstractMaximizedAstFlexRule;

public class TooLongFunctionRule
extends AbstractMaximizedAstFlexRule {
    public static final int DEFAULT_THRESHOLD = 20;
    private int functionLength;

    public final int getActualValueForTheCurrentViolation() {
        return this.functionLength;
    }

    public final int getDefaultThreshold() {
        return 20;
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    protected final void visitFunction(IParserNode functionNode, AbstractAstFlexRule.FunctionType type) {
        super.visitFunction(functionNode, type);
        IParserNode block = functionNode.getChild(functionNode.numChildren() - 1);
        if (block != null && block.numChildren() != 0) {
            this.functionLength = FunctionUtils.computeFunctionLength((IFlexFile)this.getCurrentFile(), (IParserNode)block);
            if (this.functionLength > this.getThreshold()) {
                this.addViolation(TooLongFunctionRule.getNameFromFunctionDeclaration((IParserNode)functionNode));
            }
        }
    }
}

