/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.performance;

import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;

public class AvoidInstanciationInLoopRule
extends AbstractAstFlexRule {
    private int loopLevel = 0;

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    protected final void visitFor(IParserNode ast) {
        ++this.loopLevel;
        super.visitFor(ast);
        --this.loopLevel;
    }

    protected final void visitForEach(IParserNode ast) {
        ++this.loopLevel;
        super.visitForEach(ast);
        --this.loopLevel;
    }

    protected final void visitStatement(IParserNode ast) {
        super.visitStatement(ast);
        if (!(ast == null || ast.is(NodeKind.WHILE) || ast.is(NodeKind.FOR) || ast.is(NodeKind.FOREACH) || ast.is(NodeKind.FOR))) {
            this.searchNewNode(ast);
        }
    }

    protected final void visitWhile(IParserNode ast) {
        ++this.loopLevel;
        super.visitWhile(ast);
        --this.loopLevel;
    }

    private void searchNewNode(IParserNode ast) {
        if (ast.numChildren() > 0) {
            for (IParserNode child : ast.getChildren()) {
                this.searchNewNode(child);
            }
        }
        if (ast.getId() != null && ast.is(NodeKind.NEW) && this.loopLevel != 0) {
            this.addViolation(ast);
        }
    }
}

