/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.parsley.utils;

import com.adobe.ac.pmd.rules.parsley.utils.MetaDataTag;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ParsleyMetaData {
    private static final String KEY = "key";
    private static final String BUNDLE = "bundle";
    private static final String ORDER = "order";
    private static final String SINGLETON = "singleton";
    private static final String LAZY = "lazy";
    private static final String MESSAGE_PROPERTIES = "messageProperties";
    private static final String PROPERTY = "property";
    private static final String TARGET_PROPERTY = "targetProperty";
    private static final String SCOPE = "scope";
    private static final String REQUIRED = "required";
    private static final String ERROR_EVENT = "errorEvent";
    private static final String COMPLETE_EVENT = "completeEvent";
    private static final String SELECTOR2 = "selector";
    private static final String MESSAGE_PROPERTY = "messageProperty";
    private static final String TYPE = "type";
    private static final String NAMES = "names";
    private static final String ID_PROPERTY = "id";
    private static final String METHOD = "method";
    private static final MetaDataTag.Location[] CLASS_LOCATION = new MetaDataTag.Location[]{MetaDataTag.Location.CLASS_DECLARATION};
    private static final MetaDataTag.Location[] FUNCTION_LOCATION = new MetaDataTag.Location[]{MetaDataTag.Location.FUNCTION};
    private static final MetaDataTag.Location[] ATTR_FCTION_LOCATION = new MetaDataTag.Location[]{MetaDataTag.Location.ATTRIBUTE, MetaDataTag.Location.FUNCTION};
    private static final MetaDataTag.Location[] ATTRIBUTE_LOCATION = new MetaDataTag.Location[]{MetaDataTag.Location.ATTRIBUTE};
    public static final MetaDataTag ASYNC_INIT = new MetaDataTag("AsyncInit", new String[]{"completeEvent", "errorEvent"}, CLASS_LOCATION);
    public static final MetaDataTag DESTROY = new MetaDataTag("Destroy", new String[]{"method"}, FUNCTION_LOCATION);
    public static final MetaDataTag FACTORY = new MetaDataTag("Factory", new String[]{"method"}, FUNCTION_LOCATION);
    public static final MetaDataTag INIT = new MetaDataTag("Init", new String[]{"method"}, FUNCTION_LOCATION);
    public static final MetaDataTag INJECT = new MetaDataTag("Inject", new String[]{"id", "required"}, ATTR_FCTION_LOCATION);
    public static final MetaDataTag INJECT_CONSTRUCTOR = new MetaDataTag("InjectConstructor", new String[0], CLASS_LOCATION);
    public static final MetaDataTag INTERNAL = new MetaDataTag("Internal", new String[0], ATTRIBUTE_LOCATION);
    public static final MetaDataTag MANAGED_EVENTS = new MetaDataTag("ManagedEvents", new String[]{"names", "scope"}, CLASS_LOCATION);
    public static final MetaDataTag MESSAGE_BINDING = new MetaDataTag("MessageBinding", new String[]{"type", "messageProperty", "selector", "scope", "targetProperty"}, ATTRIBUTE_LOCATION);
    public static final MetaDataTag MESSAGE_DISPATCHER = new MetaDataTag("MessageDispatcher", new String[]{"property", "scope"}, ATTRIBUTE_LOCATION);
    public static final MetaDataTag MESSAGE_ERROR = new MetaDataTag("MessageError", new String[]{"type", "selector", "scope", "method"}, FUNCTION_LOCATION);
    public static final MetaDataTag MESSAGE_HANDLER = new MetaDataTag("MessageHandler", new String[]{"type", "messageProperties", "selector", "scope", "method"}, FUNCTION_LOCATION);
    public static final MetaDataTag MESSAGE_INTERCEPTOR = new MetaDataTag("MessageInterceptor", new String[]{"type", "selector", "scope", "method"}, FUNCTION_LOCATION);
    public static final MetaDataTag OBJECT_DEFINITION = new MetaDataTag("ObjectDefinition", new String[]{"lazy", "singleton", "id", "order"}, ATTRIBUTE_LOCATION);
    public static final MetaDataTag RESOURCE_BINDING = new MetaDataTag("ResourceBinding", new String[]{"bundle", "key", "property"}, ATTRIBUTE_LOCATION);
    public static final MetaDataTag SELECTOR = new MetaDataTag("Selector", new String[0], ATTRIBUTE_LOCATION);
    public static final MetaDataTag TARGET = new MetaDataTag("Target", new String[0], ATTRIBUTE_LOCATION);
    public static final MetaDataTag[] ALL_TAGS = new MetaDataTag[]{INJECT, INJECT_CONSTRUCTOR, MANAGED_EVENTS, MESSAGE_BINDING, MESSAGE_DISPATCHER, MESSAGE_ERROR, MESSAGE_HANDLER, MESSAGE_INTERCEPTOR, ASYNC_INIT, INIT, DESTROY, RESOURCE_BINDING, FACTORY, OBJECT_DEFINITION, TARGET, INTERNAL};
    private static final Map<String, MetaDataTag> TAG_MAP = new LinkedHashMap<String, MetaDataTag>();

    private ParsleyMetaData() {
    }

    public static MetaDataTag getTag(String name) {
        return TAG_MAP.get(name);
    }

    public static boolean isParsleyMetaData(String name) {
        return TAG_MAP.containsKey(name);
    }

    static {
        TAG_MAP.put(INJECT.getName(), INJECT);
        TAG_MAP.put(INJECT_CONSTRUCTOR.getName(), INJECT_CONSTRUCTOR);
        TAG_MAP.put(MANAGED_EVENTS.getName(), MANAGED_EVENTS);
        TAG_MAP.put(MESSAGE_BINDING.getName(), MESSAGE_BINDING);
        TAG_MAP.put(MESSAGE_DISPATCHER.getName(), MESSAGE_DISPATCHER);
        TAG_MAP.put(MESSAGE_ERROR.getName(), MESSAGE_ERROR);
        TAG_MAP.put(MESSAGE_HANDLER.getName(), MESSAGE_HANDLER);
        TAG_MAP.put(MESSAGE_INTERCEPTOR.getName(), MESSAGE_INTERCEPTOR);
        TAG_MAP.put(ASYNC_INIT.getName(), ASYNC_INIT);
        TAG_MAP.put(INIT.getName(), INIT);
        TAG_MAP.put(DESTROY.getName(), DESTROY);
        TAG_MAP.put(RESOURCE_BINDING.getName(), RESOURCE_BINDING);
        TAG_MAP.put(FACTORY.getName(), FACTORY);
        TAG_MAP.put(OBJECT_DEFINITION.getName(), OBJECT_DEFINITION);
        TAG_MAP.put(TARGET.getName(), TARGET);
        TAG_MAP.put(INTERNAL.getName(), INTERNAL);
    }
}

