/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.parsley;

import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IIdentifierNode;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.IMetaDataListHolder;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.IParameter;
import com.adobe.ac.pmd.rules.core.AbstractFlexMetaDataRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.parsley.utils.ParsleyMetaData;
import java.util.List;

public final class RedundantMessageHandlerTypeAttributeRule
extends AbstractFlexMetaDataRule {
    protected void findViolationsFromFunctionMetaData(IFunction function) {
        List params = function.getParameters();
        if (params.size() == 1) {
            IIdentifierNode parameterType = ((IParameter)params.get(0)).getType();
            this.findMessageHandlersContainingType(function, parameterType);
        }
    }

    protected ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void findMessageHandlersContainingType(IFunction function, IIdentifierNode type) {
        List<IMetaData> handlers = ParsleyMetaData.MESSAGE_HANDLER.getMetaDataList((IMetaDataListHolder)function);
        for (IMetaData handler : handlers) {
            String parameterType = type.toString();
            String metaDataType = this.getMessageHandlerType(handler);
            if (metaDataType == null || !metaDataType.equals(parameterType)) continue;
            this.addViolation((INode)handler);
        }
    }

    private String getMessageHandlerType(IMetaData handler) {
        int index;
        String[] types = handler.getProperty("type");
        String type = "";
        if (types.length > 0 && types[0].contains(".") && (index = (type = types[0]).lastIndexOf(46) + 1) < type.length()) {
            type = type.substring(index);
        }
        return type;
    }
}

