/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.parsley;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.IMetaDataListHolder;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.MetaData;
import com.adobe.ac.pmd.rules.core.AbstractFlexMetaDataRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.parsley.utils.MetaDataTag;
import com.adobe.ac.pmd.rules.parsley.utils.ParsleyMetaData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MisplacedMetaDataRule
extends AbstractFlexMetaDataRule {
    protected void findViolationsFromAttributeMetaData(IAttribute attribute) {
        this.findDisallowedMetaData((IMetaDataListHolder)attribute, MetaDataTag.Location.ATTRIBUTE);
    }

    protected void findViolationsFromClassMetaData(IClass classNode) {
        this.findDisallowedMetaData((IMetaDataListHolder)classNode, MetaDataTag.Location.CLASS_DECLARATION);
    }

    protected void findViolationsFromFunctionMetaData(IFunction function) {
        this.findDisallowedMetaData((IMetaDataListHolder)function, MetaDataTag.Location.FUNCTION);
    }

    protected ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void findDisallowedMetaData(IMetaDataListHolder holder, MetaDataTag.Location location) {
        List<String> tags = this.getDisallowedTags(location);
        List otherMetadata = holder.getMetaData(MetaData.OTHER);
        if (otherMetadata == null) {
            return;
        }
        for (IMetaData metaData : otherMetadata) {
            if (!tags.contains(metaData.getName())) continue;
            this.addViolation((INode)metaData, new String[]{metaData.getName()});
        }
    }

    private List<String> getDisallowedTags(MetaDataTag.Location location) {
        ArrayList<String> tags = new ArrayList<String>();
        for (MetaDataTag tag : ParsleyMetaData.ALL_TAGS) {
            if (tag.getPlacedOn().contains((Object)location)) continue;
            tags.add(tag.getName());
        }
        return tags;
    }
}

