/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.parsley;

import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.IMetaDataListHolder;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.MetaData;
import com.adobe.ac.pmd.rules.core.AbstractFlexMetaDataRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.parsley.utils.ParsleyMetaData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MismatchedManagedEventRule
extends AbstractFlexMetaDataRule {
    protected void findViolationsFromClassMetaData(IClass classNode) {
        List<IMetaData> managedEvents = ParsleyMetaData.MANAGED_EVENTS.getMetaDataList((IMetaDataListHolder)classNode);
        List<String> eventTypes = this.getEventTypes(classNode);
        for (IMetaData data : managedEvents) {
            List types = data.getPropertyAsList("names");
            for (String type : types) {
                if (eventTypes.contains(type)) continue;
                this.addViolation((INode)data, new String[]{type});
            }
        }
    }

    protected ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private List<String> getEventTypes(IClass classNode) {
        ArrayList<String> types = new ArrayList<String>();
        for (IMetaData data : classNode.getMetaData(MetaData.EVENT)) {
            String[] name = data.getProperty("name");
            String eventName = name.length == 0 ? data.getDefaultValue() : name[0];
            types.add(eventName);
        }
        return types;
    }
}

