/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.parsley;

import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.IMetaDataListHolder;
import com.adobe.ac.pmd.nodes.IParameter;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractFlexMetaDataRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.parsley.utils.ParsleyMetaData;
import java.util.List;

public final class MessageInterceptorSignatureRule
extends AbstractFlexMetaDataRule {
    protected void findViolationsFromFunctionMetaData(IFunction function) {
        List<IMetaData> interceptors = ParsleyMetaData.MESSAGE_INTERCEPTOR.getMetaDataList((IMetaDataListHolder)function);
        IParserNode name = MessageInterceptorSignatureRule.getNameFromFunctionDeclaration((IParserNode)function.getInternalNode());
        if (!interceptors.isEmpty()) {
            if (!function.isPublic()) {
                this.addViolation(name, name, new String[]{name.getStringValue(), "It is not public"});
            }
            if (function.getParameters().size() == 1) {
                if (!this.hasMessageProcessorParameter(function)) {
                    this.addViolation(name, name, new String[]{name.getStringValue(), "The argument type should be MessageProcessor"});
                }
            } else {
                this.addViolation(name, name, new String[]{name.getStringValue(), "Its argument number is not 1"});
            }
        }
    }

    protected ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private boolean hasMessageProcessorParameter(IFunction function) {
        IParameter param = (IParameter)function.getParameters().get(0);
        String type = param.getType().toString();
        return "MessageProcessor".equals(type);
    }
}

